"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "_rsc_lib_auth_ts";
exports.ids = ["_rsc_lib_auth_ts"];
exports.modules = {

/***/ "(rsc)/./lib/auth.ts":
/*!*********************!*\
  !*** ./lib/auth.ts ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   assertRole: () => (/* binding */ assertRole),\n/* harmony export */   authOptions: () => (/* binding */ authOptions),\n/* harmony export */   getCurrentUser: () => (/* binding */ getCurrentUser)\n/* harmony export */ });\n/* harmony import */ var _auth_prisma_adapter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @auth/prisma-adapter */ \"(rsc)/./node_modules/@auth/prisma-adapter/index.js\");\n/* harmony import */ var next_auth_providers_google__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! next-auth/providers/google */ \"(rsc)/./node_modules/next-auth/providers/google.js\");\n/* harmony import */ var _lib_prisma__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/lib/prisma */ \"(rsc)/./lib/prisma.ts\");\n/* harmony import */ var next_auth_next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! next-auth/next */ \"(rsc)/./node_modules/next-auth/next/index.js\");\n/* harmony import */ var next_navigation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! next/navigation */ \"(rsc)/./node_modules/next/dist/api/navigation.react-server.js\");\n\n\n\n\n\n// Environment sanitization helper\nfunction clean(v) {\n    return (v ?? \"\").trim().replace(/^\"|\"$/g, \"\");\n}\n// Support both naming conventions for Google OAuth credentials\nconst GOOGLE_CLIENT_ID = clean(process.env.GOOGLE_CLIENT_ID || process.env.GOOGLE_ID);\nconst GOOGLE_CLIENT_SECRET = clean(process.env.GOOGLE_CLIENT_SECRET || process.env.GOOGLE_SECRET);\nconst NEXTAUTH_SECRET = clean(process.env.NEXTAUTH_SECRET);\n// Enable debug mode in development\nconst isDev = \"development\" === \"development\";\n// Determine if we're in a secure context (production is always HTTPS)\nconst isSecureContext =  false || process.env.NEXTAUTH_URL?.startsWith(\"https://\") === true;\n// OAuth callback URL is automatically handled by NextAuth.js\nconst authOptions = {\n    debug: isDev || process.env.DEBUG === \"next-auth\",\n    adapter: (0,_auth_prisma_adapter__WEBPACK_IMPORTED_MODULE_0__.PrismaAdapter)(_lib_prisma__WEBPACK_IMPORTED_MODULE_2__.prisma),\n    providers: [\n        (0,next_auth_providers_google__WEBPACK_IMPORTED_MODULE_1__[\"default\"])({\n            clientId: GOOGLE_CLIENT_ID,\n            clientSecret: GOOGLE_CLIENT_SECRET,\n            authorization: {\n                params: {\n                    scope: \"openid email profile\",\n                    // CRITICAL PRODUCTION FIX: Force user to select account every time, never auto-login\n                    prompt: \"select_account consent\",\n                    access_type: \"offline\",\n                    include_granted_scopes: true,\n                    // Completely prevent auto-login with cached Google accounts\n                    hd: undefined,\n                    login_hint: undefined,\n                    // Force fresh authentication\n                    max_age: 0\n                }\n            },\n            // Optimized for mobile performance\n            httpOptions: {\n                timeout: 15000\n            }\n        })\n    ],\n    callbacks: {\n        async signIn ({ user, account, profile }) {\n            try {\n                console.log(\"[AUTH] SignIn callback started:\", {\n                    email: user?.email,\n                    provider: account?.provider,\n                    hasProfile: !!profile,\n                    // PRODUCTION DEBUG: Log to track auto-login issue\n                    userId: user?.id,\n                    accountId: account?.providerAccountId\n                });\n                // Add proper type guard for email validation\n                if (!user?.email || typeof user.email !== \"string\") {\n                    console.log(\"[SIGNIN] No email provided\");\n                    return false;\n                }\n                // PRODUCTION SAFETY: Extra validation to prevent auto-login issues\n                console.log(\"[AUTH] PRODUCTION SAFETY CHECK:\", {\n                    userEmail: user.email,\n                    isProduction: \"development\" === \"production\",\n                    provider: account?.provider,\n                    accountId: account?.providerAccountId\n                });\n                // Add timeout to database operations to prevent hanging (increased from 10s to 20s)\n                const timeoutPromise = new Promise((_, reject)=>setTimeout(()=>reject(new Error(\"Database timeout\")), 20000));\n                // CRITICAL DEBUG: Log the exact email being looked up\n                console.log(\"[AUTH] CRITICAL DEBUG - Looking up user by email:\", user.email);\n                // Wrap database call with timeout and retry logic\n                const dbUser = await Promise.race([\n                    (0,_lib_prisma__WEBPACK_IMPORTED_MODULE_2__.withPrismaRetry)(async ()=>{\n                        return await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__.prisma.user.findUnique({\n                            where: {\n                                email: user.email\n                            }\n                        });\n                    }),\n                    timeoutPromise\n                ]).catch((error)=>{\n                    console.error(\"[SIGNIN] Database error:\", error);\n                    return null;\n                });\n                console.log(\"[AUTH] CRITICAL DEBUG - Database lookup result:\", {\n                    searchedEmail: user.email,\n                    foundUser: dbUser ? {\n                        id: dbUser.id,\n                        email: dbUser.email,\n                        name: dbUser.name,\n                        role: dbUser.role\n                    } : null\n                });\n                if (!dbUser) {\n                    console.error(\"[SIGNIN] REJECTING LOGIN - User not found in database:\", user.email);\n                    console.error(\"[SIGNIN] Available users are: cynthia@cynthiagardens.com, leasing@cynthiagardens.com, vipaymanshalaby@gmail.com\");\n                    // CRITICAL: Clear any existing JWT token to prevent session reuse\n                    await new Promise((resolve)=>setTimeout(resolve, 100)) // Brief delay for logging\n                    ;\n                    return false;\n                }\n                // For OAuth providers, ensure account is linked to existing user\n                if (account && account.provider === \"google\") {\n                    // Check if account already exists with timeout protection\n                    const existingAccount = await Promise.race([\n                        (0,_lib_prisma__WEBPACK_IMPORTED_MODULE_2__.withPrismaRetry)(async ()=>{\n                            return await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__.prisma.account.findUnique({\n                                where: {\n                                    provider_providerAccountId: {\n                                        provider: account.provider,\n                                        providerAccountId: account.providerAccountId\n                                    }\n                                }\n                            });\n                        }),\n                        timeoutPromise\n                    ]).catch((error)=>{\n                        console.error(\"[SIGNIN] Account lookup error:\", error);\n                        return null;\n                    });\n                    // CRITICAL: If account exists but belongs to different user, reject sign-in\n                    if (existingAccount && existingAccount.userId !== dbUser.id) {\n                        console.error(\"[SIGNIN] SECURITY ALERT: OAuth account mismatch!\", {\n                            requestedEmail: user.email,\n                            dbUserId: dbUser.id,\n                            existingAccountUserId: existingAccount.userId,\n                            provider: account.provider,\n                            providerAccountId: account.providerAccountId\n                        });\n                        console.error(\"[SIGNIN] This Google account is linked to a different user!\");\n                        return false // Reject sign-in to prevent cross-user authentication\n                        ;\n                    }\n                    // If no account exists, create it and link to the existing user\n                    if (!existingAccount && dbUser) {\n                        console.log(\"[SIGNIN] Creating OAuth account link for existing user:\", user.email);\n                        try {\n                            await Promise.race([\n                                _lib_prisma__WEBPACK_IMPORTED_MODULE_2__.prisma.account.create({\n                                    data: {\n                                        userId: dbUser.id,\n                                        type: account.type || \"oauth\",\n                                        provider: account.provider,\n                                        providerAccountId: account.providerAccountId,\n                                        access_token: account.access_token,\n                                        expires_at: account.expires_at,\n                                        id_token: account.id_token,\n                                        refresh_token: account.refresh_token,\n                                        scope: account.scope,\n                                        session_state: account.session_state,\n                                        token_type: account.token_type\n                                    }\n                                }),\n                                timeoutPromise\n                            ]);\n                            console.log(\"[SIGNIN] OAuth account linked successfully\");\n                        } catch (linkError) {\n                            console.error(\"[SIGNIN] Failed to link account:\", linkError);\n                            // Still allow sign in if account link fails (user exists)\n                            return true;\n                        }\n                    }\n                }\n                console.log(\"[SIGNIN] User authorized:\", user.email, \"Role:\", dbUser.role);\n                return true;\n            } catch (error) {\n                console.error(\"[AUTH] SignIn callback error:\", {\n                    error: error instanceof Error ? error.message : String(error),\n                    stack: error instanceof Error ? error.stack : undefined,\n                    user: user?.email,\n                    provider: account?.provider\n                });\n                return false;\n            }\n        },\n        async session ({ session, token }) {\n            try {\n                if (session?.user?.email) {\n                    console.log(\"[AUTH] Session callback - processing for email:\", session.user.email, \"token.id:\", token.id);\n                    // Add timeout to prevent hanging (increased from 5s to 15s)\n                    const timeoutPromise = new Promise((_, reject)=>setTimeout(()=>reject(new Error(\"Session lookup timeout\")), 15000));\n                    // CRITICAL: Use token ID as primary lookup to prevent identity mixups\n                    const userId = token.id || token.sub;\n                    let user = null;\n                    if (userId) {\n                        // Lookup by stable user ID first (most secure)\n                        user = await Promise.race([\n                            (0,_lib_prisma__WEBPACK_IMPORTED_MODULE_2__.withPrismaRetry)(async ()=>{\n                                return await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__.prisma.user.findUnique({\n                                    where: {\n                                        id: userId\n                                    }\n                                });\n                            }),\n                            timeoutPromise\n                        ]).catch((error)=>{\n                            console.error(\"[AUTH] Session user lookup by ID error for\", userId, \":\", error);\n                            return null;\n                        });\n                    }\n                    // Fallback to email lookup only if ID lookup fails\n                    if (!user && session.user.email) {\n                        user = await Promise.race([\n                            (0,_lib_prisma__WEBPACK_IMPORTED_MODULE_2__.withPrismaRetry)(async ()=>{\n                                return await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__.prisma.user.findUnique({\n                                    where: {\n                                        email: session.user.email\n                                    }\n                                });\n                            }),\n                            timeoutPromise\n                        ]).catch((error)=>{\n                            console.error(\"[AUTH] Session user lookup by email error for\", session.user.email, \":\", error);\n                            return null;\n                        });\n                    }\n                    if (user) {\n                        console.log(\"[AUTH] Session callback - found user:\", {\n                            requestedEmail: session.user.email,\n                            lookupMethod: userId ? \"by-id\" : \"by-email\",\n                            foundUserId: user.id,\n                            foundUserEmail: user.email,\n                            foundUserName: user.name,\n                            foundUserRole: user.role\n                        });\n                        session.user.role = user.role;\n                        session.user.id = user.id;\n                        // IMPORTANT: Ensure we're setting the correct user data from DB\n                        session.user.name = user.name;\n                        session.user.email = user.email;\n                    } else {\n                        console.log(\"[AUTH] Session callback - no user found for email/id:\", session.user.email, userId);\n                        // No fallback - user must exist in database for valid session\n                        console.warn(\"[AUTH] User not found in database, session may be invalid\");\n                    }\n                }\n            } catch (error) {\n                console.error(\"[AUTH] Session callback error:\", error);\n            // Don't throw, just continue with session\n            }\n            return session;\n        },\n        async jwt ({ token, user }) {\n            try {\n                console.log(\"[AUTH] JWT callback called with:\", {\n                    hasUser: !!user,\n                    userEmail: user?.email,\n                    tokenSub: token.sub,\n                    tokenEmail: token.email,\n                    existingTokenId: token.id\n                });\n                if (user) {\n                    console.log(\"[AUTH] JWT callback - processing user:\", {\n                        userId: user.id,\n                        userEmail: user.email,\n                        userName: user.name,\n                        userRole: user.role\n                    });\n                    token.role = user.role;\n                    token.id = user.id;\n                    // Ensure JWT token contains the correct user data\n                    token.email = user.email;\n                    token.name = user.name;\n                } else {\n                    console.log(\"[AUTH] JWT callback - no user provided, token email:\", token.email);\n                }\n            } catch (error) {\n                console.error(\"[AUTH] JWT callback error:\", error);\n            // Don't throw, just continue with token\n            }\n            return token;\n        },\n        async redirect ({ url, baseUrl }) {\n            // After successful login, redirect to overview\n            if (url === baseUrl || url === baseUrl + \"/\") {\n                return `${baseUrl}/overview`;\n            }\n            if (url.startsWith(\"/\")) {\n                return `${baseUrl}${url}`;\n            }\n            return url;\n        }\n    },\n    pages: {\n        signIn: \"/login\",\n        error: \"/login\"\n    },\n    logger: {\n        error (code, metadata) {\n            console.error(\"[NextAuth Error]\", code, metadata);\n        },\n        warn (code) {\n            console.warn(\"[NextAuth Warning]\", code);\n        },\n        debug (code, metadata) {\n            if (isDev) {\n                console.log(\"[NextAuth Debug]\", code, metadata);\n            }\n        }\n    },\n    session: {\n        strategy: \"jwt\",\n        maxAge: 24 * 60 * 60,\n        // CRITICAL: Force JWT refresh to prevent cached session reuse\n        updateAge: 0\n    },\n    cookies: {\n        sessionToken: {\n            name: isSecureContext ? `__Secure-next-auth.session-token` : `next-auth.session-token`,\n            options: {\n                httpOnly: true,\n                sameSite: \"lax\",\n                path: \"/\",\n                secure: isSecureContext,\n                // Set domain for production to ensure cookies work across subdomains\n                ... false ? 0 : {}\n            }\n        },\n        state: {\n            name: `next-auth.state`,\n            options: {\n                httpOnly: true,\n                sameSite: isSecureContext ? \"none\" : \"lax\",\n                path: \"/\",\n                secure: isSecureContext\n            }\n        },\n        pkceCodeVerifier: {\n            name: `next-auth.pkce.code_verifier`,\n            options: {\n                httpOnly: true,\n                sameSite: isSecureContext ? \"none\" : \"lax\",\n                path: \"/\",\n                secure: isSecureContext\n            }\n        }\n    },\n    useSecureCookies: isSecureContext,\n    events: {\n        async signIn ({ user, account, profile }) {\n            if (isDev) {\n                console.log(\"[AUTH] Sign in event:\", {\n                    user: user?.email,\n                    account: account?.provider\n                });\n            }\n        },\n        async signOut ({ session, token }) {\n            console.log(\"[AUTH] Sign out event - clearing session:\", {\n                user: session?.user?.email\n            });\n            // Force complete token cleanup\n            if (token) {\n                // Clear all token properties to prevent cached data\n                Object.keys(token).forEach((key)=>{\n                    delete token[key];\n                });\n                // Explicitly set critical fields to undefined\n                token.role = undefined;\n                token.id = undefined;\n                token.email = undefined;\n                token.name = undefined;\n                token.sub = undefined;\n                token.iat = undefined;\n                token.exp = undefined;\n                token.jti = undefined;\n            }\n            console.log(\"[AUTH] Complete session data cleared successfully\");\n        }\n    }\n};\nasync function getCurrentUser() {\n    // PRODUCTION SAFETY: Only use dev session when explicitly enabled AND not in production\n    const explicitlyEnabled = \"true\" === \"true\";\n    const notProduction = \"development\" !== \"production\";\n    if (explicitlyEnabled && notProduction) {\n        const { getDevSession } = await __webpack_require__.e(/*! import() */ \"_rsc_lib_dev-session_ts\").then(__webpack_require__.bind(__webpack_require__, /*! ./dev-session */ \"(rsc)/./lib/dev-session.ts\"));\n        const devSession = getDevSession();\n        console.log(\"[AUTH] Using DEV session override:\", devSession?.user?.email);\n        return devSession?.user || null;\n    }\n    // Always use real authentication in production or when dev session disabled\n    const session = await (0,next_auth_next__WEBPACK_IMPORTED_MODULE_3__.getServerSession)(authOptions);\n    console.log(\"[AUTH] Using real session:\", session?.user?.email || \"not authenticated\");\n    return session?.user || null;\n}\nasync function assertRole(...allowedRoles) {\n    const user = await getCurrentUser();\n    // PRODUCTION SAFETY: Only use dev user bypass when explicitly enabled AND not in production\n    const explicitlyEnabled = \"true\" === \"true\";\n    const notProduction = \"development\" !== \"production\";\n    if (explicitlyEnabled && notProduction) {\n        if (!user || !user.id) {\n            throw new Error(\"Development user configuration error\");\n        }\n        return user;\n    }\n    // Redirect to login if user is not authenticated\n    if (!user || !user.id) {\n        (0,next_navigation__WEBPACK_IMPORTED_MODULE_4__.redirect)(\"/login\");\n    }\n    // Redirect to login with error if user doesn't have the required role\n    if (!user.role || !allowedRoles.includes(user.role)) {\n        (0,next_navigation__WEBPACK_IMPORTED_MODULE_4__.redirect)(\"/login?error=AccessDenied\");\n    }\n    return user;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./lib/auth.ts\n");

/***/ })

};
;