/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/openid-client";
exports.ids = ["vendor-chunks/openid-client"];
exports.modules = {

/***/ "(ssr)/./node_modules/openid-client/lib/client.js":
/*!**************************************************!*\
  !*** ./node_modules/openid-client/lib/client.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
eval("\nconst { inspect } = __webpack_require__(/*! util */ \"util\");\nconst stdhttp = __webpack_require__(/*! http */ \"http\");\nconst crypto = __webpack_require__(/*! crypto */ \"crypto\");\nconst { strict: assert } = __webpack_require__(/*! assert */ \"assert\");\nconst querystring = __webpack_require__(/*! querystring */ \"querystring\");\nconst url = __webpack_require__(/*! url */ \"url\");\nconst { URL, URLSearchParams } = __webpack_require__(/*! url */ \"url\");\nconst jose = __webpack_require__(/*! jose */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/index.js\");\nconst tokenHash = __webpack_require__(/*! oidc-token-hash */ \"(ssr)/./node_modules/openid-client/node_modules/oidc-token-hash/lib/index.js\");\nconst isKeyObject = __webpack_require__(/*! ./helpers/is_key_object */ \"(ssr)/./node_modules/openid-client/lib/helpers/is_key_object.js\");\nconst decodeJWT = __webpack_require__(/*! ./helpers/decode_jwt */ \"(ssr)/./node_modules/openid-client/lib/helpers/decode_jwt.js\");\nconst base64url = __webpack_require__(/*! ./helpers/base64url */ \"(ssr)/./node_modules/openid-client/lib/helpers/base64url.js\");\nconst defaults = __webpack_require__(/*! ./helpers/defaults */ \"(ssr)/./node_modules/openid-client/lib/helpers/defaults.js\");\nconst parseWwwAuthenticate = __webpack_require__(/*! ./helpers/www_authenticate_parser */ \"(ssr)/./node_modules/openid-client/lib/helpers/www_authenticate_parser.js\");\nconst { assertSigningAlgValuesSupport, assertIssuerConfiguration } = __webpack_require__(/*! ./helpers/assert */ \"(ssr)/./node_modules/openid-client/lib/helpers/assert.js\");\nconst pick = __webpack_require__(/*! ./helpers/pick */ \"(ssr)/./node_modules/openid-client/lib/helpers/pick.js\");\nconst isPlainObject = __webpack_require__(/*! ./helpers/is_plain_object */ \"(ssr)/./node_modules/openid-client/lib/helpers/is_plain_object.js\");\nconst processResponse = __webpack_require__(/*! ./helpers/process_response */ \"(ssr)/./node_modules/openid-client/lib/helpers/process_response.js\");\nconst TokenSet = __webpack_require__(/*! ./token_set */ \"(ssr)/./node_modules/openid-client/lib/token_set.js\");\nconst { OPError, RPError } = __webpack_require__(/*! ./errors */ \"(ssr)/./node_modules/openid-client/lib/errors.js\");\nconst now = __webpack_require__(/*! ./helpers/unix_timestamp */ \"(ssr)/./node_modules/openid-client/lib/helpers/unix_timestamp.js\");\nconst { random } = __webpack_require__(/*! ./helpers/generators */ \"(ssr)/./node_modules/openid-client/lib/helpers/generators.js\");\nconst request = __webpack_require__(/*! ./helpers/request */ \"(ssr)/./node_modules/openid-client/lib/helpers/request.js\");\nconst { CLOCK_TOLERANCE } = __webpack_require__(/*! ./helpers/consts */ \"(ssr)/./node_modules/openid-client/lib/helpers/consts.js\");\nconst { keystores } = __webpack_require__(/*! ./helpers/weak_cache */ \"(ssr)/./node_modules/openid-client/lib/helpers/weak_cache.js\");\nconst KeyStore = __webpack_require__(/*! ./helpers/keystore */ \"(ssr)/./node_modules/openid-client/lib/helpers/keystore.js\");\nconst clone = __webpack_require__(/*! ./helpers/deep_clone */ \"(ssr)/./node_modules/openid-client/lib/helpers/deep_clone.js\");\nconst { authenticatedPost, resolveResponseType, resolveRedirectUri } = __webpack_require__(/*! ./helpers/client */ \"(ssr)/./node_modules/openid-client/lib/helpers/client.js\");\nconst { queryKeyStore } = __webpack_require__(/*! ./helpers/issuer */ \"(ssr)/./node_modules/openid-client/lib/helpers/issuer.js\");\nconst DeviceFlowHandle = __webpack_require__(/*! ./device_flow_handle */ \"(ssr)/./node_modules/openid-client/lib/device_flow_handle.js\");\nconst [major, minor] = process.version.slice(1).split(\".\").map((str)=>parseInt(str, 10));\nconst rsaPssParams = major >= 17 || major === 16 && minor >= 9;\nconst retryAttempt = Symbol();\nconst skipNonceCheck = Symbol();\nconst skipMaxAgeCheck = Symbol();\nfunction pickCb(input) {\n    return pick(input, \"access_token\", \"code\", \"error_description\", \"error_uri\", \"error\", \"expires_in\", \"id_token\", \"iss\", \"response\", \"session_state\", \"state\", \"token_type\");\n}\nfunction authorizationHeaderValue(token, tokenType = \"Bearer\") {\n    return `${tokenType} ${token}`;\n}\nfunction getSearchParams(input) {\n    const parsed = url.parse(input);\n    if (!parsed.search) return {};\n    return querystring.parse(parsed.search.substring(1));\n}\nfunction verifyPresence(payload, jwt, prop) {\n    if (payload[prop] === undefined) {\n        throw new RPError({\n            message: `missing required JWT property ${prop}`,\n            jwt\n        });\n    }\n}\nfunction authorizationParams(params) {\n    const authParams = {\n        client_id: this.client_id,\n        scope: \"openid\",\n        response_type: resolveResponseType.call(this),\n        redirect_uri: resolveRedirectUri.call(this),\n        ...params\n    };\n    Object.entries(authParams).forEach(([key, value])=>{\n        if (value === null || value === undefined) {\n            delete authParams[key];\n        } else if (key === \"claims\" && typeof value === \"object\") {\n            authParams[key] = JSON.stringify(value);\n        } else if (key === \"resource\" && Array.isArray(value)) {\n            authParams[key] = value;\n        } else if (typeof value !== \"string\") {\n            authParams[key] = String(value);\n        }\n    });\n    return authParams;\n}\nfunction getKeystore(jwks) {\n    if (!isPlainObject(jwks) || !Array.isArray(jwks.keys) || jwks.keys.some((k)=>!isPlainObject(k) || !(\"kty\" in k))) {\n        throw new TypeError(\"jwks must be a JSON Web Key Set formatted object\");\n    }\n    return KeyStore.fromJWKS(jwks, {\n        onlyPrivate: true\n    });\n}\n// if an OP doesnt support client_secret_basic but supports client_secret_post, use it instead\n// this is in place to take care of most common pitfalls when first using discovered Issuers without\n// the support for default values defined by Discovery 1.0\nfunction checkBasicSupport(client, properties) {\n    try {\n        const supported = client.issuer.token_endpoint_auth_methods_supported;\n        if (!supported.includes(properties.token_endpoint_auth_method)) {\n            if (supported.includes(\"client_secret_post\")) {\n                properties.token_endpoint_auth_method = \"client_secret_post\";\n            }\n        }\n    } catch (err) {}\n}\nfunction handleCommonMistakes(client, metadata, properties) {\n    if (!metadata.token_endpoint_auth_method) {\n        // if no explicit value was provided\n        checkBasicSupport(client, properties);\n    }\n    // :fp: c'mon people... RTFM\n    if (metadata.redirect_uri) {\n        if (metadata.redirect_uris) {\n            throw new TypeError(\"provide a redirect_uri or redirect_uris, not both\");\n        }\n        properties.redirect_uris = [\n            metadata.redirect_uri\n        ];\n        delete properties.redirect_uri;\n    }\n    if (metadata.response_type) {\n        if (metadata.response_types) {\n            throw new TypeError(\"provide a response_type or response_types, not both\");\n        }\n        properties.response_types = [\n            metadata.response_type\n        ];\n        delete properties.response_type;\n    }\n}\nfunction getDefaultsForEndpoint(endpoint, issuer, properties) {\n    if (!issuer[`${endpoint}_endpoint`]) return;\n    const tokenEndpointAuthMethod = properties.token_endpoint_auth_method;\n    const tokenEndpointAuthSigningAlg = properties.token_endpoint_auth_signing_alg;\n    const eam = `${endpoint}_endpoint_auth_method`;\n    const easa = `${endpoint}_endpoint_auth_signing_alg`;\n    if (properties[eam] === undefined && properties[easa] === undefined) {\n        if (tokenEndpointAuthMethod !== undefined) {\n            properties[eam] = tokenEndpointAuthMethod;\n        }\n        if (tokenEndpointAuthSigningAlg !== undefined) {\n            properties[easa] = tokenEndpointAuthSigningAlg;\n        }\n    }\n}\nclass BaseClient {\n    #metadata;\n    #issuer;\n    #aadIssValidation;\n    #additionalAuthorizedParties;\n    constructor(issuer, aadIssValidation, metadata = {}, jwks, options){\n        this.#metadata = new Map();\n        this.#issuer = issuer;\n        this.#aadIssValidation = aadIssValidation;\n        if (typeof metadata.client_id !== \"string\" || !metadata.client_id) {\n            throw new TypeError(\"client_id is required\");\n        }\n        const properties = {\n            grant_types: [\n                \"authorization_code\"\n            ],\n            id_token_signed_response_alg: \"RS256\",\n            authorization_signed_response_alg: \"RS256\",\n            response_types: [\n                \"code\"\n            ],\n            token_endpoint_auth_method: \"client_secret_basic\",\n            ...this.fapi1() ? {\n                grant_types: [\n                    \"authorization_code\",\n                    \"implicit\"\n                ],\n                id_token_signed_response_alg: \"PS256\",\n                authorization_signed_response_alg: \"PS256\",\n                response_types: [\n                    \"code id_token\"\n                ],\n                tls_client_certificate_bound_access_tokens: true,\n                token_endpoint_auth_method: undefined\n            } : undefined,\n            ...this.fapi2() ? {\n                id_token_signed_response_alg: \"PS256\",\n                authorization_signed_response_alg: \"PS256\",\n                token_endpoint_auth_method: undefined\n            } : undefined,\n            ...metadata\n        };\n        if (this.fapi()) {\n            switch(properties.token_endpoint_auth_method){\n                case \"self_signed_tls_client_auth\":\n                case \"tls_client_auth\":\n                    break;\n                case \"private_key_jwt\":\n                    if (!jwks) {\n                        throw new TypeError(\"jwks is required\");\n                    }\n                    break;\n                case undefined:\n                    throw new TypeError(\"token_endpoint_auth_method is required\");\n                default:\n                    throw new TypeError(\"invalid or unsupported token_endpoint_auth_method\");\n            }\n        }\n        if (this.fapi2()) {\n            if (properties.tls_client_certificate_bound_access_tokens && properties.dpop_bound_access_tokens) {\n                throw new TypeError(\"either tls_client_certificate_bound_access_tokens or dpop_bound_access_tokens must be set to true\");\n            }\n            if (!properties.tls_client_certificate_bound_access_tokens && !properties.dpop_bound_access_tokens) {\n                throw new TypeError(\"either tls_client_certificate_bound_access_tokens or dpop_bound_access_tokens must be set to true\");\n            }\n        }\n        handleCommonMistakes(this, metadata, properties);\n        assertSigningAlgValuesSupport(\"token\", this.issuer, properties);\n        [\n            \"introspection\",\n            \"revocation\"\n        ].forEach((endpoint)=>{\n            getDefaultsForEndpoint(endpoint, this.issuer, properties);\n            assertSigningAlgValuesSupport(endpoint, this.issuer, properties);\n        });\n        Object.entries(properties).forEach(([key, value])=>{\n            this.#metadata.set(key, value);\n            if (!this[key]) {\n                Object.defineProperty(this, key, {\n                    get () {\n                        return this.#metadata.get(key);\n                    },\n                    enumerable: true\n                });\n            }\n        });\n        if (jwks !== undefined) {\n            const keystore = getKeystore.call(this, jwks);\n            keystores.set(this, keystore);\n        }\n        if (options != null && options.additionalAuthorizedParties) {\n            this.#additionalAuthorizedParties = clone(options.additionalAuthorizedParties);\n        }\n        this[CLOCK_TOLERANCE] = 0;\n    }\n    authorizationUrl(params = {}) {\n        if (!isPlainObject(params)) {\n            throw new TypeError(\"params must be a plain object\");\n        }\n        assertIssuerConfiguration(this.issuer, \"authorization_endpoint\");\n        const target = new URL(this.issuer.authorization_endpoint);\n        for (const [name, value] of Object.entries(authorizationParams.call(this, params))){\n            if (Array.isArray(value)) {\n                target.searchParams.delete(name);\n                for (const member of value){\n                    target.searchParams.append(name, member);\n                }\n            } else {\n                target.searchParams.set(name, value);\n            }\n        }\n        // TODO: is the replace needed?\n        return target.href.replace(/\\+/g, \"%20\");\n    }\n    authorizationPost(params = {}) {\n        if (!isPlainObject(params)) {\n            throw new TypeError(\"params must be a plain object\");\n        }\n        const inputs = authorizationParams.call(this, params);\n        const formInputs = Object.keys(inputs).map((name)=>`<input type=\"hidden\" name=\"${name}\" value=\"${inputs[name]}\"/>`).join(\"\\n\");\n        return `<!DOCTYPE html>\n<head>\n<title>Requesting Authorization</title>\n</head>\n<body onload=\"javascript:document.forms[0].submit()\">\n<form method=\"post\" action=\"${this.issuer.authorization_endpoint}\">\n  ${formInputs}\n</form>\n</body>\n</html>`;\n    }\n    endSessionUrl(params = {}) {\n        assertIssuerConfiguration(this.issuer, \"end_session_endpoint\");\n        const { 0: postLogout, length } = this.post_logout_redirect_uris || [];\n        const { post_logout_redirect_uri = length === 1 ? postLogout : undefined } = params;\n        let id_token_hint;\n        ({ id_token_hint, ...params } = params);\n        if (id_token_hint instanceof TokenSet) {\n            if (!id_token_hint.id_token) {\n                throw new TypeError(\"id_token not present in TokenSet\");\n            }\n            id_token_hint = id_token_hint.id_token;\n        }\n        const target = url.parse(this.issuer.end_session_endpoint);\n        const query = defaults(getSearchParams(this.issuer.end_session_endpoint), params, {\n            post_logout_redirect_uri,\n            client_id: this.client_id\n        }, {\n            id_token_hint\n        });\n        Object.entries(query).forEach(([key, value])=>{\n            if (value === null || value === undefined) {\n                delete query[key];\n            }\n        });\n        target.search = null;\n        target.query = query;\n        return url.format(target);\n    }\n    callbackParams(input) {\n        const isIncomingMessage = input instanceof stdhttp.IncomingMessage || input && input.method && input.url;\n        const isString = typeof input === \"string\";\n        if (!isString && !isIncomingMessage) {\n            throw new TypeError(\"#callbackParams only accepts string urls, http.IncomingMessage or a lookalike\");\n        }\n        if (isIncomingMessage) {\n            switch(input.method){\n                case \"GET\":\n                    return pickCb(getSearchParams(input.url));\n                case \"POST\":\n                    if (input.body === undefined) {\n                        throw new TypeError(\"incoming message body missing, include a body parser prior to this method call\");\n                    }\n                    switch(typeof input.body){\n                        case \"object\":\n                        case \"string\":\n                            if (Buffer.isBuffer(input.body)) {\n                                return pickCb(querystring.parse(input.body.toString(\"utf-8\")));\n                            }\n                            if (typeof input.body === \"string\") {\n                                return pickCb(querystring.parse(input.body));\n                            }\n                            return pickCb(input.body);\n                        default:\n                            throw new TypeError(\"invalid IncomingMessage body object\");\n                    }\n                default:\n                    throw new TypeError(\"invalid IncomingMessage method\");\n            }\n        } else {\n            return pickCb(getSearchParams(input));\n        }\n    }\n    async callback(redirectUri, parameters, checks = {}, { exchangeBody, clientAssertionPayload, DPoP } = {}) {\n        let params = pickCb(parameters);\n        if (checks.jarm && !(\"response\" in parameters)) {\n            throw new RPError({\n                message: \"expected a JARM response\",\n                checks,\n                params\n            });\n        } else if (\"response\" in parameters) {\n            const decrypted = await this.decryptJARM(params.response);\n            params = await this.validateJARM(decrypted);\n        }\n        if (this.default_max_age && !checks.max_age) {\n            checks.max_age = this.default_max_age;\n        }\n        if (params.state && !checks.state) {\n            throw new TypeError(\"checks.state argument is missing\");\n        }\n        if (!params.state && checks.state) {\n            throw new RPError({\n                message: \"state missing from the response\",\n                checks,\n                params\n            });\n        }\n        if (checks.state !== params.state) {\n            throw new RPError({\n                printf: [\n                    \"state mismatch, expected %s, got: %s\",\n                    checks.state,\n                    params.state\n                ],\n                checks,\n                params\n            });\n        }\n        if (\"iss\" in params) {\n            assertIssuerConfiguration(this.issuer, \"issuer\");\n            if (params.iss !== this.issuer.issuer) {\n                throw new RPError({\n                    printf: [\n                        \"iss mismatch, expected %s, got: %s\",\n                        this.issuer.issuer,\n                        params.iss\n                    ],\n                    params\n                });\n            }\n        } else if (this.issuer.authorization_response_iss_parameter_supported && !(\"id_token\" in params) && !(\"response\" in parameters)) {\n            throw new RPError({\n                message: \"iss missing from the response\",\n                params\n            });\n        }\n        if (params.error) {\n            throw new OPError(params);\n        }\n        const RESPONSE_TYPE_REQUIRED_PARAMS = {\n            code: [\n                \"code\"\n            ],\n            id_token: [\n                \"id_token\"\n            ],\n            token: [\n                \"access_token\",\n                \"token_type\"\n            ]\n        };\n        if (checks.response_type) {\n            for (const type of checks.response_type.split(\" \")){\n                if (type === \"none\") {\n                    if (params.code || params.id_token || params.access_token) {\n                        throw new RPError({\n                            message: 'unexpected params encountered for \"none\" response',\n                            checks,\n                            params\n                        });\n                    }\n                } else {\n                    for (const param of RESPONSE_TYPE_REQUIRED_PARAMS[type]){\n                        if (!params[param]) {\n                            throw new RPError({\n                                message: `${param} missing from response`,\n                                checks,\n                                params\n                            });\n                        }\n                    }\n                }\n            }\n        }\n        if (params.id_token) {\n            const tokenset = new TokenSet(params);\n            await this.decryptIdToken(tokenset);\n            await this.validateIdToken(tokenset, checks.nonce, \"authorization\", checks.max_age, checks.state);\n            if (!params.code) {\n                return tokenset;\n            }\n        }\n        if (params.code) {\n            const tokenset = await this.grant({\n                ...exchangeBody,\n                grant_type: \"authorization_code\",\n                code: params.code,\n                redirect_uri: redirectUri,\n                code_verifier: checks.code_verifier\n            }, {\n                clientAssertionPayload,\n                DPoP\n            });\n            await this.decryptIdToken(tokenset);\n            await this.validateIdToken(tokenset, checks.nonce, \"token\", checks.max_age);\n            if (params.session_state) {\n                tokenset.session_state = params.session_state;\n            }\n            return tokenset;\n        }\n        return new TokenSet(params);\n    }\n    async oauthCallback(redirectUri, parameters, checks = {}, { exchangeBody, clientAssertionPayload, DPoP } = {}) {\n        let params = pickCb(parameters);\n        if (checks.jarm && !(\"response\" in parameters)) {\n            throw new RPError({\n                message: \"expected a JARM response\",\n                checks,\n                params\n            });\n        } else if (\"response\" in parameters) {\n            const decrypted = await this.decryptJARM(params.response);\n            params = await this.validateJARM(decrypted);\n        }\n        if (params.state && !checks.state) {\n            throw new TypeError(\"checks.state argument is missing\");\n        }\n        if (!params.state && checks.state) {\n            throw new RPError({\n                message: \"state missing from the response\",\n                checks,\n                params\n            });\n        }\n        if (checks.state !== params.state) {\n            throw new RPError({\n                printf: [\n                    \"state mismatch, expected %s, got: %s\",\n                    checks.state,\n                    params.state\n                ],\n                checks,\n                params\n            });\n        }\n        if (\"iss\" in params) {\n            assertIssuerConfiguration(this.issuer, \"issuer\");\n            if (params.iss !== this.issuer.issuer) {\n                throw new RPError({\n                    printf: [\n                        \"iss mismatch, expected %s, got: %s\",\n                        this.issuer.issuer,\n                        params.iss\n                    ],\n                    params\n                });\n            }\n        } else if (this.issuer.authorization_response_iss_parameter_supported && !(\"id_token\" in params) && !(\"response\" in parameters)) {\n            throw new RPError({\n                message: \"iss missing from the response\",\n                params\n            });\n        }\n        if (params.error) {\n            throw new OPError(params);\n        }\n        if (typeof params.id_token === \"string\" && params.id_token.length) {\n            throw new RPError({\n                message: \"id_token detected in the response, you must use client.callback() instead of client.oauthCallback()\",\n                params\n            });\n        }\n        delete params.id_token;\n        const RESPONSE_TYPE_REQUIRED_PARAMS = {\n            code: [\n                \"code\"\n            ],\n            token: [\n                \"access_token\",\n                \"token_type\"\n            ]\n        };\n        if (checks.response_type) {\n            for (const type of checks.response_type.split(\" \")){\n                if (type === \"none\") {\n                    if (params.code || params.id_token || params.access_token) {\n                        throw new RPError({\n                            message: 'unexpected params encountered for \"none\" response',\n                            checks,\n                            params\n                        });\n                    }\n                }\n                if (RESPONSE_TYPE_REQUIRED_PARAMS[type]) {\n                    for (const param of RESPONSE_TYPE_REQUIRED_PARAMS[type]){\n                        if (!params[param]) {\n                            throw new RPError({\n                                message: `${param} missing from response`,\n                                checks,\n                                params\n                            });\n                        }\n                    }\n                }\n            }\n        }\n        if (params.code) {\n            const tokenset = await this.grant({\n                ...exchangeBody,\n                grant_type: \"authorization_code\",\n                code: params.code,\n                redirect_uri: redirectUri,\n                code_verifier: checks.code_verifier\n            }, {\n                clientAssertionPayload,\n                DPoP\n            });\n            if (typeof tokenset.id_token === \"string\" && tokenset.id_token.length) {\n                throw new RPError({\n                    message: \"id_token detected in the response, you must use client.callback() instead of client.oauthCallback()\",\n                    params\n                });\n            }\n            delete tokenset.id_token;\n            return tokenset;\n        }\n        return new TokenSet(params);\n    }\n    async decryptIdToken(token) {\n        if (!this.id_token_encrypted_response_alg) {\n            return token;\n        }\n        let idToken = token;\n        if (idToken instanceof TokenSet) {\n            if (!idToken.id_token) {\n                throw new TypeError(\"id_token not present in TokenSet\");\n            }\n            idToken = idToken.id_token;\n        }\n        const expectedAlg = this.id_token_encrypted_response_alg;\n        const expectedEnc = this.id_token_encrypted_response_enc;\n        const result = await this.decryptJWE(idToken, expectedAlg, expectedEnc);\n        if (token instanceof TokenSet) {\n            token.id_token = result;\n            return token;\n        }\n        return result;\n    }\n    async validateJWTUserinfo(body) {\n        const expectedAlg = this.userinfo_signed_response_alg;\n        return this.validateJWT(body, expectedAlg, []);\n    }\n    async decryptJARM(response) {\n        if (!this.authorization_encrypted_response_alg) {\n            return response;\n        }\n        const expectedAlg = this.authorization_encrypted_response_alg;\n        const expectedEnc = this.authorization_encrypted_response_enc;\n        return this.decryptJWE(response, expectedAlg, expectedEnc);\n    }\n    async decryptJWTUserinfo(body) {\n        if (!this.userinfo_encrypted_response_alg) {\n            return body;\n        }\n        const expectedAlg = this.userinfo_encrypted_response_alg;\n        const expectedEnc = this.userinfo_encrypted_response_enc;\n        return this.decryptJWE(body, expectedAlg, expectedEnc);\n    }\n    async decryptJWE(jwe, expectedAlg, expectedEnc = \"A128CBC-HS256\") {\n        const header = JSON.parse(base64url.decode(jwe.split(\".\")[0]));\n        if (header.alg !== expectedAlg) {\n            throw new RPError({\n                printf: [\n                    \"unexpected JWE alg received, expected %s, got: %s\",\n                    expectedAlg,\n                    header.alg\n                ],\n                jwt: jwe\n            });\n        }\n        if (header.enc !== expectedEnc) {\n            throw new RPError({\n                printf: [\n                    \"unexpected JWE enc received, expected %s, got: %s\",\n                    expectedEnc,\n                    header.enc\n                ],\n                jwt: jwe\n            });\n        }\n        const getPlaintext = (result)=>new TextDecoder().decode(result.plaintext);\n        let plaintext;\n        if (expectedAlg.match(/^(?:RSA|ECDH)/)) {\n            const keystore = await keystores.get(this);\n            const protectedHeader = jose.decodeProtectedHeader(jwe);\n            for (const key of keystore.all({\n                ...protectedHeader,\n                use: \"enc\"\n            })){\n                plaintext = await jose.compactDecrypt(jwe, await key.keyObject(protectedHeader.alg)).then(getPlaintext, ()=>{});\n                if (plaintext) break;\n            }\n        } else {\n            plaintext = await jose.compactDecrypt(jwe, this.secretForAlg(expectedAlg === \"dir\" ? expectedEnc : expectedAlg)).then(getPlaintext, ()=>{});\n        }\n        if (!plaintext) {\n            throw new RPError({\n                message: \"failed to decrypt JWE\",\n                jwt: jwe\n            });\n        }\n        return plaintext;\n    }\n    async validateIdToken(tokenSet, nonce, returnedBy, maxAge, state) {\n        let idToken = tokenSet;\n        const expectedAlg = this.id_token_signed_response_alg;\n        const isTokenSet = idToken instanceof TokenSet;\n        if (isTokenSet) {\n            if (!idToken.id_token) {\n                throw new TypeError(\"id_token not present in TokenSet\");\n            }\n            idToken = idToken.id_token;\n        }\n        idToken = String(idToken);\n        const timestamp = now();\n        const { protected: header, payload, key } = await this.validateJWT(idToken, expectedAlg);\n        if (typeof maxAge === \"number\" || maxAge !== skipMaxAgeCheck && this.require_auth_time) {\n            if (!payload.auth_time) {\n                throw new RPError({\n                    message: \"missing required JWT property auth_time\",\n                    jwt: idToken\n                });\n            }\n            if (typeof payload.auth_time !== \"number\") {\n                throw new RPError({\n                    message: \"JWT auth_time claim must be a JSON numeric value\",\n                    jwt: idToken\n                });\n            }\n        }\n        if (typeof maxAge === \"number\" && payload.auth_time + maxAge < timestamp - this[CLOCK_TOLERANCE]) {\n            throw new RPError({\n                printf: [\n                    \"too much time has elapsed since the last End-User authentication, max_age %i, auth_time: %i, now %i\",\n                    maxAge,\n                    payload.auth_time,\n                    timestamp - this[CLOCK_TOLERANCE]\n                ],\n                now: timestamp,\n                tolerance: this[CLOCK_TOLERANCE],\n                auth_time: payload.auth_time,\n                jwt: idToken\n            });\n        }\n        if (nonce !== skipNonceCheck && (payload.nonce || nonce !== undefined) && payload.nonce !== nonce) {\n            throw new RPError({\n                printf: [\n                    \"nonce mismatch, expected %s, got: %s\",\n                    nonce,\n                    payload.nonce\n                ],\n                jwt: idToken\n            });\n        }\n        if (returnedBy === \"authorization\") {\n            if (!payload.at_hash && tokenSet.access_token) {\n                throw new RPError({\n                    message: \"missing required property at_hash\",\n                    jwt: idToken\n                });\n            }\n            if (!payload.c_hash && tokenSet.code) {\n                throw new RPError({\n                    message: \"missing required property c_hash\",\n                    jwt: idToken\n                });\n            }\n            if (this.fapi1()) {\n                if (!payload.s_hash && (tokenSet.state || state)) {\n                    throw new RPError({\n                        message: \"missing required property s_hash\",\n                        jwt: idToken\n                    });\n                }\n            }\n            if (payload.s_hash) {\n                if (!state) {\n                    throw new TypeError('cannot verify s_hash, \"checks.state\" property not provided');\n                }\n                try {\n                    tokenHash.validate({\n                        claim: \"s_hash\",\n                        source: \"state\"\n                    }, payload.s_hash, state, header.alg, key.jwk && key.jwk.crv);\n                } catch (err) {\n                    throw new RPError({\n                        message: err.message,\n                        jwt: idToken\n                    });\n                }\n            }\n        }\n        if (this.fapi() && payload.iat < timestamp - 3600) {\n            throw new RPError({\n                printf: [\n                    \"JWT issued too far in the past, now %i, iat %i\",\n                    timestamp,\n                    payload.iat\n                ],\n                now: timestamp,\n                tolerance: this[CLOCK_TOLERANCE],\n                iat: payload.iat,\n                jwt: idToken\n            });\n        }\n        if (tokenSet.access_token && payload.at_hash !== undefined) {\n            try {\n                tokenHash.validate({\n                    claim: \"at_hash\",\n                    source: \"access_token\"\n                }, payload.at_hash, tokenSet.access_token, header.alg, key.jwk && key.jwk.crv);\n            } catch (err) {\n                throw new RPError({\n                    message: err.message,\n                    jwt: idToken\n                });\n            }\n        }\n        if (tokenSet.code && payload.c_hash !== undefined) {\n            try {\n                tokenHash.validate({\n                    claim: \"c_hash\",\n                    source: \"code\"\n                }, payload.c_hash, tokenSet.code, header.alg, key.jwk && key.jwk.crv);\n            } catch (err) {\n                throw new RPError({\n                    message: err.message,\n                    jwt: idToken\n                });\n            }\n        }\n        return tokenSet;\n    }\n    async validateJWT(jwt, expectedAlg, required = [\n        \"iss\",\n        \"sub\",\n        \"aud\",\n        \"exp\",\n        \"iat\"\n    ]) {\n        const isSelfIssued = this.issuer.issuer === \"https://self-issued.me\";\n        const timestamp = now();\n        let header;\n        let payload;\n        try {\n            ({ header, payload } = decodeJWT(jwt, {\n                complete: true\n            }));\n        } catch (err) {\n            throw new RPError({\n                printf: [\n                    \"failed to decode JWT (%s: %s)\",\n                    err.name,\n                    err.message\n                ],\n                jwt\n            });\n        }\n        if (header.alg !== expectedAlg) {\n            throw new RPError({\n                printf: [\n                    \"unexpected JWT alg received, expected %s, got: %s\",\n                    expectedAlg,\n                    header.alg\n                ],\n                jwt\n            });\n        }\n        if (isSelfIssued) {\n            required = [\n                ...required,\n                \"sub_jwk\"\n            ];\n        }\n        required.forEach(verifyPresence.bind(undefined, payload, jwt));\n        if (payload.iss !== undefined) {\n            let expectedIss = this.issuer.issuer;\n            if (this.#aadIssValidation) {\n                expectedIss = this.issuer.issuer.replace(\"{tenantid}\", payload.tid);\n            }\n            if (payload.iss !== expectedIss) {\n                throw new RPError({\n                    printf: [\n                        \"unexpected iss value, expected %s, got: %s\",\n                        expectedIss,\n                        payload.iss\n                    ],\n                    jwt\n                });\n            }\n        }\n        if (payload.iat !== undefined) {\n            if (typeof payload.iat !== \"number\") {\n                throw new RPError({\n                    message: \"JWT iat claim must be a JSON numeric value\",\n                    jwt\n                });\n            }\n        }\n        if (payload.nbf !== undefined) {\n            if (typeof payload.nbf !== \"number\") {\n                throw new RPError({\n                    message: \"JWT nbf claim must be a JSON numeric value\",\n                    jwt\n                });\n            }\n            if (payload.nbf > timestamp + this[CLOCK_TOLERANCE]) {\n                throw new RPError({\n                    printf: [\n                        \"JWT not active yet, now %i, nbf %i\",\n                        timestamp + this[CLOCK_TOLERANCE],\n                        payload.nbf\n                    ],\n                    now: timestamp,\n                    tolerance: this[CLOCK_TOLERANCE],\n                    nbf: payload.nbf,\n                    jwt\n                });\n            }\n        }\n        if (payload.exp !== undefined) {\n            if (typeof payload.exp !== \"number\") {\n                throw new RPError({\n                    message: \"JWT exp claim must be a JSON numeric value\",\n                    jwt\n                });\n            }\n            if (timestamp - this[CLOCK_TOLERANCE] >= payload.exp) {\n                throw new RPError({\n                    printf: [\n                        \"JWT expired, now %i, exp %i\",\n                        timestamp - this[CLOCK_TOLERANCE],\n                        payload.exp\n                    ],\n                    now: timestamp,\n                    tolerance: this[CLOCK_TOLERANCE],\n                    exp: payload.exp,\n                    jwt\n                });\n            }\n        }\n        if (payload.aud !== undefined) {\n            if (Array.isArray(payload.aud)) {\n                if (payload.aud.length > 1 && !payload.azp) {\n                    throw new RPError({\n                        message: \"missing required JWT property azp\",\n                        jwt\n                    });\n                }\n                if (!payload.aud.includes(this.client_id)) {\n                    throw new RPError({\n                        printf: [\n                            \"aud is missing the client_id, expected %s to be included in %j\",\n                            this.client_id,\n                            payload.aud\n                        ],\n                        jwt\n                    });\n                }\n            } else if (payload.aud !== this.client_id) {\n                throw new RPError({\n                    printf: [\n                        \"aud mismatch, expected %s, got: %s\",\n                        this.client_id,\n                        payload.aud\n                    ],\n                    jwt\n                });\n            }\n        }\n        if (payload.azp !== undefined) {\n            let additionalAuthorizedParties = this.#additionalAuthorizedParties;\n            if (typeof additionalAuthorizedParties === \"string\") {\n                additionalAuthorizedParties = [\n                    this.client_id,\n                    additionalAuthorizedParties\n                ];\n            } else if (Array.isArray(additionalAuthorizedParties)) {\n                additionalAuthorizedParties = [\n                    this.client_id,\n                    ...additionalAuthorizedParties\n                ];\n            } else {\n                additionalAuthorizedParties = [\n                    this.client_id\n                ];\n            }\n            if (!additionalAuthorizedParties.includes(payload.azp)) {\n                throw new RPError({\n                    printf: [\n                        \"azp mismatch, got: %s\",\n                        payload.azp\n                    ],\n                    jwt\n                });\n            }\n        }\n        let keys;\n        if (isSelfIssued) {\n            try {\n                assert(isPlainObject(payload.sub_jwk));\n                const key = await jose.importJWK(payload.sub_jwk, header.alg);\n                assert.equal(key.type, \"public\");\n                keys = [\n                    {\n                        keyObject () {\n                            return key;\n                        }\n                    }\n                ];\n            } catch (err) {\n                throw new RPError({\n                    message: \"failed to use sub_jwk claim as an asymmetric JSON Web Key\",\n                    jwt\n                });\n            }\n            if (await jose.calculateJwkThumbprint(payload.sub_jwk) !== payload.sub) {\n                throw new RPError({\n                    message: \"failed to match the subject with sub_jwk\",\n                    jwt\n                });\n            }\n        } else if (header.alg.startsWith(\"HS\")) {\n            keys = [\n                this.secretForAlg(header.alg)\n            ];\n        } else if (header.alg !== \"none\") {\n            keys = await queryKeyStore.call(this.issuer, {\n                ...header,\n                use: \"sig\"\n            });\n        }\n        if (!keys && header.alg === \"none\") {\n            return {\n                protected: header,\n                payload\n            };\n        }\n        for (const key of keys){\n            const verified = await jose.compactVerify(jwt, key instanceof Uint8Array ? key : await key.keyObject(header.alg)).catch(()=>{});\n            if (verified) {\n                return {\n                    payload,\n                    protected: verified.protectedHeader,\n                    key\n                };\n            }\n        }\n        throw new RPError({\n            message: \"failed to validate JWT signature\",\n            jwt\n        });\n    }\n    async refresh(refreshToken, { exchangeBody, clientAssertionPayload, DPoP } = {}) {\n        let token = refreshToken;\n        if (token instanceof TokenSet) {\n            if (!token.refresh_token) {\n                throw new TypeError(\"refresh_token not present in TokenSet\");\n            }\n            token = token.refresh_token;\n        }\n        const tokenset = await this.grant({\n            ...exchangeBody,\n            grant_type: \"refresh_token\",\n            refresh_token: String(token)\n        }, {\n            clientAssertionPayload,\n            DPoP\n        });\n        if (tokenset.id_token) {\n            await this.decryptIdToken(tokenset);\n            await this.validateIdToken(tokenset, skipNonceCheck, \"token\", skipMaxAgeCheck);\n            if (refreshToken instanceof TokenSet && refreshToken.id_token) {\n                const expectedSub = refreshToken.claims().sub;\n                const actualSub = tokenset.claims().sub;\n                if (actualSub !== expectedSub) {\n                    throw new RPError({\n                        printf: [\n                            \"sub mismatch, expected %s, got: %s\",\n                            expectedSub,\n                            actualSub\n                        ],\n                        jwt: tokenset.id_token\n                    });\n                }\n            }\n        }\n        return tokenset;\n    }\n    async requestResource(resourceUrl, accessToken, { method, headers, body, DPoP, tokenType = DPoP ? \"DPoP\" : accessToken instanceof TokenSet ? accessToken.token_type : \"Bearer\" } = {}, retry) {\n        if (accessToken instanceof TokenSet) {\n            if (!accessToken.access_token) {\n                throw new TypeError(\"access_token not present in TokenSet\");\n            }\n            accessToken = accessToken.access_token;\n        }\n        if (!accessToken) {\n            throw new TypeError(\"no access token provided\");\n        } else if (typeof accessToken !== \"string\") {\n            throw new TypeError(\"invalid access token provided\");\n        }\n        const requestOpts = {\n            headers: {\n                Authorization: authorizationHeaderValue(accessToken, tokenType),\n                ...headers\n            },\n            body\n        };\n        const mTLS = !!this.tls_client_certificate_bound_access_tokens;\n        const response = await request.call(this, {\n            ...requestOpts,\n            responseType: \"buffer\",\n            method,\n            url: resourceUrl\n        }, {\n            accessToken,\n            mTLS,\n            DPoP\n        });\n        const wwwAuthenticate = response.headers[\"www-authenticate\"];\n        if (retry !== retryAttempt && wwwAuthenticate && wwwAuthenticate.toLowerCase().startsWith(\"dpop \") && parseWwwAuthenticate(wwwAuthenticate).error === \"use_dpop_nonce\") {\n            return this.requestResource(resourceUrl, accessToken, {\n                method,\n                headers,\n                body,\n                DPoP,\n                tokenType\n            });\n        }\n        return response;\n    }\n    async userinfo(accessToken, { method = \"GET\", via = \"header\", tokenType, params, DPoP } = {}) {\n        assertIssuerConfiguration(this.issuer, \"userinfo_endpoint\");\n        const options = {\n            tokenType,\n            method: String(method).toUpperCase(),\n            DPoP\n        };\n        if (options.method !== \"GET\" && options.method !== \"POST\") {\n            throw new TypeError(\"#userinfo() method can only be POST or a GET\");\n        }\n        if (via === \"body\" && options.method !== \"POST\") {\n            throw new TypeError(\"can only send body on POST\");\n        }\n        const jwt = !!(this.userinfo_signed_response_alg || this.userinfo_encrypted_response_alg);\n        if (jwt) {\n            options.headers = {\n                Accept: \"application/jwt\"\n            };\n        } else {\n            options.headers = {\n                Accept: \"application/json\"\n            };\n        }\n        const mTLS = !!this.tls_client_certificate_bound_access_tokens;\n        let targetUrl;\n        if (mTLS && this.issuer.mtls_endpoint_aliases) {\n            targetUrl = this.issuer.mtls_endpoint_aliases.userinfo_endpoint;\n        }\n        targetUrl = new URL(targetUrl || this.issuer.userinfo_endpoint);\n        if (via === \"body\") {\n            options.headers.Authorization = undefined;\n            options.headers[\"Content-Type\"] = \"application/x-www-form-urlencoded\";\n            options.body = new URLSearchParams();\n            options.body.append(\"access_token\", accessToken instanceof TokenSet ? accessToken.access_token : accessToken);\n        }\n        // handle additional parameters, GET via querystring, POST via urlencoded body\n        if (params) {\n            if (options.method === \"GET\") {\n                Object.entries(params).forEach(([key, value])=>{\n                    targetUrl.searchParams.append(key, value);\n                });\n            } else if (options.body) {\n                // POST && via body\n                Object.entries(params).forEach(([key, value])=>{\n                    options.body.append(key, value);\n                });\n            } else {\n                // POST && via header\n                options.body = new URLSearchParams();\n                options.headers[\"Content-Type\"] = \"application/x-www-form-urlencoded\";\n                Object.entries(params).forEach(([key, value])=>{\n                    options.body.append(key, value);\n                });\n            }\n        }\n        if (options.body) {\n            options.body = options.body.toString();\n        }\n        const response = await this.requestResource(targetUrl, accessToken, options);\n        let parsed = processResponse(response, {\n            bearer: true\n        });\n        if (jwt) {\n            if (!/^application\\/jwt/.test(response.headers[\"content-type\"])) {\n                throw new RPError({\n                    message: \"expected application/jwt response from the userinfo_endpoint\",\n                    response\n                });\n            }\n            const body = response.body.toString();\n            const userinfo = await this.decryptJWTUserinfo(body);\n            if (!this.userinfo_signed_response_alg) {\n                try {\n                    parsed = JSON.parse(userinfo);\n                    assert(isPlainObject(parsed));\n                } catch (err) {\n                    throw new RPError({\n                        message: \"failed to parse userinfo JWE payload as JSON\",\n                        jwt: userinfo\n                    });\n                }\n            } else {\n                ({ payload: parsed } = await this.validateJWTUserinfo(userinfo));\n            }\n        } else {\n            try {\n                parsed = JSON.parse(response.body);\n            } catch (err) {\n                Object.defineProperty(err, \"response\", {\n                    value: response\n                });\n                throw err;\n            }\n        }\n        if (accessToken instanceof TokenSet && accessToken.id_token) {\n            const expectedSub = accessToken.claims().sub;\n            if (parsed.sub !== expectedSub) {\n                throw new RPError({\n                    printf: [\n                        \"userinfo sub mismatch, expected %s, got: %s\",\n                        expectedSub,\n                        parsed.sub\n                    ],\n                    body: parsed,\n                    jwt: accessToken.id_token\n                });\n            }\n        }\n        return parsed;\n    }\n    encryptionSecret(len) {\n        const hash = len <= 256 ? \"sha256\" : len <= 384 ? \"sha384\" : len <= 512 ? \"sha512\" : false;\n        if (!hash) {\n            throw new Error(\"unsupported symmetric encryption key derivation\");\n        }\n        return crypto.createHash(hash).update(this.client_secret).digest().slice(0, len / 8);\n    }\n    secretForAlg(alg) {\n        if (!this.client_secret) {\n            throw new TypeError(\"client_secret is required\");\n        }\n        if (/^A(\\d{3})(?:GCM)?KW$/.test(alg)) {\n            return this.encryptionSecret(parseInt(RegExp.$1, 10));\n        }\n        if (/^A(\\d{3})(?:GCM|CBC-HS(\\d{3}))$/.test(alg)) {\n            return this.encryptionSecret(parseInt(RegExp.$2 || RegExp.$1, 10));\n        }\n        return new TextEncoder().encode(this.client_secret);\n    }\n    async grant(body, { clientAssertionPayload, DPoP } = {}, retry) {\n        assertIssuerConfiguration(this.issuer, \"token_endpoint\");\n        const response = await authenticatedPost.call(this, \"token\", {\n            form: body,\n            responseType: \"json\"\n        }, {\n            clientAssertionPayload,\n            DPoP\n        });\n        let responseBody;\n        try {\n            responseBody = processResponse(response);\n        } catch (err) {\n            if (retry !== retryAttempt && err instanceof OPError && err.error === \"use_dpop_nonce\") {\n                return this.grant(body, {\n                    clientAssertionPayload,\n                    DPoP\n                }, retryAttempt);\n            }\n            throw err;\n        }\n        return new TokenSet(responseBody);\n    }\n    async deviceAuthorization(params = {}, { exchangeBody, clientAssertionPayload, DPoP } = {}) {\n        assertIssuerConfiguration(this.issuer, \"device_authorization_endpoint\");\n        assertIssuerConfiguration(this.issuer, \"token_endpoint\");\n        const body = authorizationParams.call(this, {\n            client_id: this.client_id,\n            redirect_uri: null,\n            response_type: null,\n            ...params\n        });\n        const response = await authenticatedPost.call(this, \"device_authorization\", {\n            responseType: \"json\",\n            form: body\n        }, {\n            clientAssertionPayload,\n            endpointAuthMethod: \"token\"\n        });\n        const responseBody = processResponse(response);\n        return new DeviceFlowHandle({\n            client: this,\n            exchangeBody,\n            clientAssertionPayload,\n            response: responseBody,\n            maxAge: params.max_age,\n            DPoP\n        });\n    }\n    async revoke(token, hint, { revokeBody, clientAssertionPayload } = {}) {\n        assertIssuerConfiguration(this.issuer, \"revocation_endpoint\");\n        if (hint !== undefined && typeof hint !== \"string\") {\n            throw new TypeError(\"hint must be a string\");\n        }\n        const form = {\n            ...revokeBody,\n            token\n        };\n        if (hint) {\n            form.token_type_hint = hint;\n        }\n        const response = await authenticatedPost.call(this, \"revocation\", {\n            form\n        }, {\n            clientAssertionPayload\n        });\n        processResponse(response, {\n            body: false\n        });\n    }\n    async introspect(token, hint, { introspectBody, clientAssertionPayload } = {}) {\n        assertIssuerConfiguration(this.issuer, \"introspection_endpoint\");\n        if (hint !== undefined && typeof hint !== \"string\") {\n            throw new TypeError(\"hint must be a string\");\n        }\n        const form = {\n            ...introspectBody,\n            token\n        };\n        if (hint) {\n            form.token_type_hint = hint;\n        }\n        const response = await authenticatedPost.call(this, \"introspection\", {\n            form,\n            responseType: \"json\"\n        }, {\n            clientAssertionPayload\n        });\n        const responseBody = processResponse(response);\n        return responseBody;\n    }\n    static async register(metadata, options = {}) {\n        const { initialAccessToken, jwks, ...clientOptions } = options;\n        assertIssuerConfiguration(this.issuer, \"registration_endpoint\");\n        if (jwks !== undefined && !(metadata.jwks || metadata.jwks_uri)) {\n            const keystore = await getKeystore.call(this, jwks);\n            metadata.jwks = keystore.toJWKS();\n        }\n        const response = await request.call(this, {\n            headers: {\n                Accept: \"application/json\",\n                ...initialAccessToken ? {\n                    Authorization: authorizationHeaderValue(initialAccessToken)\n                } : undefined\n            },\n            responseType: \"json\",\n            json: metadata,\n            url: this.issuer.registration_endpoint,\n            method: \"POST\"\n        });\n        const responseBody = processResponse(response, {\n            statusCode: 201,\n            bearer: true\n        });\n        return new this(responseBody, jwks, clientOptions);\n    }\n    get metadata() {\n        return clone(Object.fromEntries(this.#metadata.entries()));\n    }\n    static async fromUri(registrationClientUri, registrationAccessToken, jwks, clientOptions) {\n        const response = await request.call(this, {\n            method: \"GET\",\n            url: registrationClientUri,\n            responseType: \"json\",\n            headers: {\n                Authorization: authorizationHeaderValue(registrationAccessToken),\n                Accept: \"application/json\"\n            }\n        });\n        const responseBody = processResponse(response, {\n            bearer: true\n        });\n        return new this(responseBody, jwks, clientOptions);\n    }\n    async requestObject(requestObject = {}, { sign: signingAlgorithm = this.request_object_signing_alg || \"none\", encrypt: { alg: eKeyManagement = this.request_object_encryption_alg, enc: eContentEncryption = this.request_object_encryption_enc || \"A128CBC-HS256\" } = {} } = {}) {\n        if (!isPlainObject(requestObject)) {\n            throw new TypeError(\"requestObject must be a plain object\");\n        }\n        let signed;\n        let key;\n        const unix = now();\n        const header = {\n            alg: signingAlgorithm,\n            typ: \"oauth-authz-req+jwt\"\n        };\n        const payload = JSON.stringify(defaults({}, requestObject, {\n            iss: this.client_id,\n            aud: this.issuer.issuer,\n            client_id: this.client_id,\n            jti: random(),\n            iat: unix,\n            exp: unix + 300,\n            ...this.fapi() ? {\n                nbf: unix\n            } : undefined\n        }));\n        if (signingAlgorithm === \"none\") {\n            signed = [\n                base64url.encode(JSON.stringify(header)),\n                base64url.encode(payload),\n                \"\"\n            ].join(\".\");\n        } else {\n            const symmetric = signingAlgorithm.startsWith(\"HS\");\n            if (symmetric) {\n                key = this.secretForAlg(signingAlgorithm);\n            } else {\n                const keystore = await keystores.get(this);\n                if (!keystore) {\n                    throw new TypeError(`no keystore present for client, cannot sign using alg ${signingAlgorithm}`);\n                }\n                key = keystore.get({\n                    alg: signingAlgorithm,\n                    use: \"sig\"\n                });\n                if (!key) {\n                    throw new TypeError(`no key to sign with found for alg ${signingAlgorithm}`);\n                }\n            }\n            signed = await new jose.CompactSign(new TextEncoder().encode(payload)).setProtectedHeader({\n                ...header,\n                kid: symmetric ? undefined : key.jwk.kid\n            }).sign(symmetric ? key : await key.keyObject(signingAlgorithm));\n        }\n        if (!eKeyManagement) {\n            return signed;\n        }\n        const fields = {\n            alg: eKeyManagement,\n            enc: eContentEncryption,\n            cty: \"oauth-authz-req+jwt\"\n        };\n        if (fields.alg.match(/^(RSA|ECDH)/)) {\n            [key] = await queryKeyStore.call(this.issuer, {\n                alg: fields.alg,\n                use: \"enc\"\n            }, {\n                allowMulti: true\n            });\n        } else {\n            key = this.secretForAlg(fields.alg === \"dir\" ? fields.enc : fields.alg);\n        }\n        return new jose.CompactEncrypt(new TextEncoder().encode(signed)).setProtectedHeader({\n            ...fields,\n            kid: key instanceof Uint8Array ? undefined : key.jwk.kid\n        }).encrypt(key instanceof Uint8Array ? key : await key.keyObject(fields.alg));\n    }\n    async pushedAuthorizationRequest(params = {}, { clientAssertionPayload } = {}) {\n        assertIssuerConfiguration(this.issuer, \"pushed_authorization_request_endpoint\");\n        const body = {\n            ...\"request\" in params ? params : authorizationParams.call(this, params),\n            client_id: this.client_id\n        };\n        const response = await authenticatedPost.call(this, \"pushed_authorization_request\", {\n            responseType: \"json\",\n            form: body\n        }, {\n            clientAssertionPayload,\n            endpointAuthMethod: \"token\"\n        });\n        const responseBody = processResponse(response, {\n            statusCode: 201\n        });\n        if (!(\"expires_in\" in responseBody)) {\n            throw new RPError({\n                message: \"expected expires_in in Pushed Authorization Successful Response\",\n                response\n            });\n        }\n        if (typeof responseBody.expires_in !== \"number\") {\n            throw new RPError({\n                message: \"invalid expires_in value in Pushed Authorization Successful Response\",\n                response\n            });\n        }\n        if (!(\"request_uri\" in responseBody)) {\n            throw new RPError({\n                message: \"expected request_uri in Pushed Authorization Successful Response\",\n                response\n            });\n        }\n        if (typeof responseBody.request_uri !== \"string\") {\n            throw new RPError({\n                message: \"invalid request_uri value in Pushed Authorization Successful Response\",\n                response\n            });\n        }\n        return responseBody;\n    }\n    get issuer() {\n        return this.#issuer;\n    }\n    /* istanbul ignore next */ [inspect.custom]() {\n        return `${this.constructor.name} ${inspect(this.metadata, {\n            depth: Infinity,\n            colors: process.stdout.isTTY,\n            compact: false,\n            sorted: true\n        })}`;\n    }\n    fapi() {\n        return this.fapi1() || this.fapi2();\n    }\n    fapi1() {\n        return this.constructor.name === \"FAPI1Client\";\n    }\n    fapi2() {\n        return this.constructor.name === \"FAPI2Client\";\n    }\n    async validateJARM(response) {\n        const expectedAlg = this.authorization_signed_response_alg;\n        const { payload } = await this.validateJWT(response, expectedAlg, [\n            \"iss\",\n            \"exp\",\n            \"aud\"\n        ]);\n        return pickCb(payload);\n    }\n    /**\n   * @name dpopProof\n   * @api private\n   */ async dpopProof(payload, privateKeyInput, accessToken) {\n        if (!isPlainObject(payload)) {\n            throw new TypeError(\"payload must be a plain object\");\n        }\n        let privateKey;\n        if (isKeyObject(privateKeyInput)) {\n            privateKey = privateKeyInput;\n        } else if (privateKeyInput[Symbol.toStringTag] === \"CryptoKey\") {\n            privateKey = privateKeyInput;\n        } else if (jose.cryptoRuntime === \"node:crypto\") {\n            privateKey = crypto.createPrivateKey(privateKeyInput);\n        } else {\n            throw new TypeError(\"unrecognized crypto runtime\");\n        }\n        if (privateKey.type !== \"private\") {\n            throw new TypeError('\"DPoP\" option must be a private key');\n        }\n        let alg = determineDPoPAlgorithm.call(this, privateKey, privateKeyInput);\n        if (!alg) {\n            throw new TypeError(\"could not determine DPoP JWS Algorithm\");\n        }\n        return new jose.SignJWT({\n            ath: accessToken ? base64url.encode(crypto.createHash(\"sha256\").update(accessToken).digest()) : undefined,\n            ...payload\n        }).setProtectedHeader({\n            alg,\n            typ: \"dpop+jwt\",\n            jwk: await getJwk(privateKey, privateKeyInput)\n        }).setIssuedAt().setJti(random()).sign(privateKey);\n    }\n}\nfunction determineDPoPAlgorithmFromCryptoKey(cryptoKey) {\n    switch(cryptoKey.algorithm.name){\n        case \"Ed25519\":\n        case \"Ed448\":\n            return \"EdDSA\";\n        case \"ECDSA\":\n            {\n                switch(cryptoKey.algorithm.namedCurve){\n                    case \"P-256\":\n                        return \"ES256\";\n                    case \"P-384\":\n                        return \"ES384\";\n                    case \"P-521\":\n                        return \"ES512\";\n                    default:\n                        break;\n                }\n                break;\n            }\n        case \"RSASSA-PKCS1-v1_5\":\n            return `RS${cryptoKey.algorithm.hash.name.slice(4)}`;\n        case \"RSA-PSS\":\n            return `PS${cryptoKey.algorithm.hash.name.slice(4)}`;\n        default:\n            throw new TypeError(\"unsupported DPoP private key\");\n    }\n}\nlet determineDPoPAlgorithm;\nif (jose.cryptoRuntime === \"node:crypto\") {\n    determineDPoPAlgorithm = function(privateKey, privateKeyInput) {\n        if (privateKeyInput[Symbol.toStringTag] === \"CryptoKey\") {\n            return determineDPoPAlgorithmFromCryptoKey(privateKey);\n        }\n        switch(privateKey.asymmetricKeyType){\n            case \"ed25519\":\n            case \"ed448\":\n                return \"EdDSA\";\n            case \"ec\":\n                return determineEcAlgorithm(privateKey, privateKeyInput);\n            case \"rsa\":\n            case rsaPssParams && \"rsa-pss\":\n                return determineRsaAlgorithm(privateKey, privateKeyInput, this.issuer.dpop_signing_alg_values_supported);\n            default:\n                throw new TypeError(\"unsupported DPoP private key\");\n        }\n    };\n    const RSPS = /^(?:RS|PS)(?:256|384|512)$/;\n    function determineRsaAlgorithm(privateKey, privateKeyInput, valuesSupported) {\n        if (typeof privateKeyInput === \"object\" && privateKeyInput.format === \"jwk\" && privateKeyInput.key && privateKeyInput.key.alg) {\n            return privateKeyInput.key.alg;\n        }\n        if (Array.isArray(valuesSupported)) {\n            let candidates = valuesSupported.filter(RegExp.prototype.test.bind(RSPS));\n            if (privateKey.asymmetricKeyType === \"rsa-pss\") {\n                candidates = candidates.filter((value)=>value.startsWith(\"PS\"));\n            }\n            return [\n                \"PS256\",\n                \"PS384\",\n                \"PS512\",\n                \"RS256\",\n                \"RS384\",\n                \"RS384\"\n            ].find((preferred)=>candidates.includes(preferred));\n        }\n        return \"PS256\";\n    }\n    const p256 = Buffer.from([\n        42,\n        134,\n        72,\n        206,\n        61,\n        3,\n        1,\n        7\n    ]);\n    const p384 = Buffer.from([\n        43,\n        129,\n        4,\n        0,\n        34\n    ]);\n    const p521 = Buffer.from([\n        43,\n        129,\n        4,\n        0,\n        35\n    ]);\n    const secp256k1 = Buffer.from([\n        43,\n        129,\n        4,\n        0,\n        10\n    ]);\n    function determineEcAlgorithm(privateKey, privateKeyInput) {\n        // If input was a JWK\n        switch(typeof privateKeyInput === \"object\" && typeof privateKeyInput.key === \"object\" && privateKeyInput.key.crv){\n            case \"P-256\":\n                return \"ES256\";\n            case \"secp256k1\":\n                return \"ES256K\";\n            case \"P-384\":\n                return \"ES384\";\n            case \"P-512\":\n                return \"ES512\";\n            default:\n                break;\n        }\n        const buf = privateKey.export({\n            format: \"der\",\n            type: \"pkcs8\"\n        });\n        const i = buf[1] < 128 ? 17 : 18;\n        const len = buf[i];\n        const curveOid = buf.slice(i + 1, i + 1 + len);\n        if (curveOid.equals(p256)) {\n            return \"ES256\";\n        }\n        if (curveOid.equals(p384)) {\n            return \"ES384\";\n        }\n        if (curveOid.equals(p521)) {\n            return \"ES512\";\n        }\n        if (curveOid.equals(secp256k1)) {\n            return \"ES256K\";\n        }\n        throw new TypeError(\"unsupported DPoP private key curve\");\n    }\n} else {\n    determineDPoPAlgorithm = determineDPoPAlgorithmFromCryptoKey;\n}\nconst jwkCache = new WeakMap();\nasync function getJwk(keyObject, privateKeyInput) {\n    if (jose.cryptoRuntime === \"node:crypto\" && typeof privateKeyInput === \"object\" && typeof privateKeyInput.key === \"object\" && privateKeyInput.format === \"jwk\") {\n        return pick(privateKeyInput.key, \"kty\", \"crv\", \"x\", \"y\", \"e\", \"n\");\n    }\n    if (jwkCache.has(privateKeyInput)) {\n        return jwkCache.get(privateKeyInput);\n    }\n    const jwk = pick(await jose.exportJWK(keyObject), \"kty\", \"crv\", \"x\", \"y\", \"e\", \"n\");\n    if (isKeyObject(privateKeyInput) || jose.cryptoRuntime === \"WebCryptoAPI\") {\n        jwkCache.set(privateKeyInput, jwk);\n    }\n    return jwk;\n}\nmodule.exports = (issuer, aadIssValidation = false)=>class Client extends BaseClient {\n        constructor(...args){\n            super(issuer, aadIssValidation, ...args);\n        }\n        static get issuer() {\n            return issuer;\n        }\n    };\nmodule.exports.BaseClient = BaseClient;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvY2xpZW50LmpzIiwibWFwcGluZ3MiOiI7QUFBQSxNQUFNLEVBQUVBLE9BQU8sRUFBRSxHQUFHQyxtQkFBT0EsQ0FBQztBQUM1QixNQUFNQyxVQUFVRCxtQkFBT0EsQ0FBQztBQUN4QixNQUFNRSxTQUFTRixtQkFBT0EsQ0FBQztBQUN2QixNQUFNLEVBQUVHLFFBQVFDLE1BQU0sRUFBRSxHQUFHSixtQkFBT0EsQ0FBQztBQUNuQyxNQUFNSyxjQUFjTCxtQkFBT0EsQ0FBQztBQUM1QixNQUFNTSxNQUFNTixtQkFBT0EsQ0FBQztBQUNwQixNQUFNLEVBQUVPLEdBQUcsRUFBRUMsZUFBZSxFQUFFLEdBQUdSLG1CQUFPQSxDQUFDO0FBRXpDLE1BQU1TLE9BQU9ULG1CQUFPQSxDQUFDO0FBQ3JCLE1BQU1VLFlBQVlWLG1CQUFPQSxDQUFDO0FBRTFCLE1BQU1XLGNBQWNYLG1CQUFPQSxDQUFDO0FBQzVCLE1BQU1ZLFlBQVlaLG1CQUFPQSxDQUFDO0FBQzFCLE1BQU1hLFlBQVliLG1CQUFPQSxDQUFDO0FBQzFCLE1BQU1jLFdBQVdkLG1CQUFPQSxDQUFDO0FBQ3pCLE1BQU1lLHVCQUF1QmYsbUJBQU9BLENBQUM7QUFDckMsTUFBTSxFQUFFZ0IsNkJBQTZCLEVBQUVDLHlCQUF5QixFQUFFLEdBQUdqQixtQkFBT0EsQ0FBQztBQUM3RSxNQUFNa0IsT0FBT2xCLG1CQUFPQSxDQUFDO0FBQ3JCLE1BQU1tQixnQkFBZ0JuQixtQkFBT0EsQ0FBQztBQUM5QixNQUFNb0Isa0JBQWtCcEIsbUJBQU9BLENBQUM7QUFDaEMsTUFBTXFCLFdBQVdyQixtQkFBT0EsQ0FBQztBQUN6QixNQUFNLEVBQUVzQixPQUFPLEVBQUVDLE9BQU8sRUFBRSxHQUFHdkIsbUJBQU9BLENBQUM7QUFDckMsTUFBTXdCLE1BQU14QixtQkFBT0EsQ0FBQztBQUNwQixNQUFNLEVBQUV5QixNQUFNLEVBQUUsR0FBR3pCLG1CQUFPQSxDQUFDO0FBQzNCLE1BQU0wQixVQUFVMUIsbUJBQU9BLENBQUM7QUFDeEIsTUFBTSxFQUFFMkIsZUFBZSxFQUFFLEdBQUczQixtQkFBT0EsQ0FBQztBQUNwQyxNQUFNLEVBQUU0QixTQUFTLEVBQUUsR0FBRzVCLG1CQUFPQSxDQUFDO0FBQzlCLE1BQU02QixXQUFXN0IsbUJBQU9BLENBQUM7QUFDekIsTUFBTThCLFFBQVE5QixtQkFBT0EsQ0FBQztBQUN0QixNQUFNLEVBQUUrQixpQkFBaUIsRUFBRUMsbUJBQW1CLEVBQUVDLGtCQUFrQixFQUFFLEdBQUdqQyxtQkFBT0EsQ0FBQztBQUMvRSxNQUFNLEVBQUVrQyxhQUFhLEVBQUUsR0FBR2xDLG1CQUFPQSxDQUFDO0FBQ2xDLE1BQU1tQyxtQkFBbUJuQyxtQkFBT0EsQ0FBQztBQUVqQyxNQUFNLENBQUNvQyxPQUFPQyxNQUFNLEdBQUdDLFFBQVFDLE9BQU8sQ0FDbkNDLEtBQUssQ0FBQyxHQUNOQyxLQUFLLENBQUMsS0FDTkMsR0FBRyxDQUFDLENBQUNDLE1BQVFDLFNBQVNELEtBQUs7QUFFOUIsTUFBTUUsZUFBZVQsU0FBUyxNQUFPQSxVQUFVLE1BQU1DLFNBQVM7QUFDOUQsTUFBTVMsZUFBZUM7QUFDckIsTUFBTUMsaUJBQWlCRDtBQUN2QixNQUFNRSxrQkFBa0JGO0FBRXhCLFNBQVNHLE9BQU9DLEtBQUs7SUFDbkIsT0FBT2pDLEtBQ0xpQyxPQUNBLGdCQUNBLFFBQ0EscUJBQ0EsYUFDQSxTQUNBLGNBQ0EsWUFDQSxPQUNBLFlBQ0EsaUJBQ0EsU0FDQTtBQUVKO0FBRUEsU0FBU0MseUJBQXlCQyxLQUFLLEVBQUVDLFlBQVksUUFBUTtJQUMzRCxPQUFPLENBQUMsRUFBRUEsVUFBVSxDQUFDLEVBQUVELE1BQU0sQ0FBQztBQUNoQztBQUVBLFNBQVNFLGdCQUFnQkosS0FBSztJQUM1QixNQUFNSyxTQUFTbEQsSUFBSW1ELEtBQUssQ0FBQ047SUFDekIsSUFBSSxDQUFDSyxPQUFPRSxNQUFNLEVBQUUsT0FBTyxDQUFDO0lBQzVCLE9BQU9yRCxZQUFZb0QsS0FBSyxDQUFDRCxPQUFPRSxNQUFNLENBQUNDLFNBQVMsQ0FBQztBQUNuRDtBQUVBLFNBQVNDLGVBQWVDLE9BQU8sRUFBRUMsR0FBRyxFQUFFQyxJQUFJO0lBQ3hDLElBQUlGLE9BQU8sQ0FBQ0UsS0FBSyxLQUFLQyxXQUFXO1FBQy9CLE1BQU0sSUFBSXpDLFFBQVE7WUFDaEIwQyxTQUFTLENBQUMsOEJBQThCLEVBQUVGLEtBQUssQ0FBQztZQUNoREQ7UUFDRjtJQUNGO0FBQ0Y7QUFFQSxTQUFTSSxvQkFBb0JDLE1BQU07SUFDakMsTUFBTUMsYUFBYTtRQUNqQkMsV0FBVyxJQUFJLENBQUNBLFNBQVM7UUFDekJDLE9BQU87UUFDUEMsZUFBZXZDLG9CQUFvQndDLElBQUksQ0FBQyxJQUFJO1FBQzVDQyxjQUFjeEMsbUJBQW1CdUMsSUFBSSxDQUFDLElBQUk7UUFDMUMsR0FBR0wsTUFBTTtJQUNYO0lBRUFPLE9BQU9DLE9BQU8sQ0FBQ1AsWUFBWVEsT0FBTyxDQUFDLENBQUMsQ0FBQ0MsS0FBS0MsTUFBTTtRQUM5QyxJQUFJQSxVQUFVLFFBQVFBLFVBQVVkLFdBQVc7WUFDekMsT0FBT0ksVUFBVSxDQUFDUyxJQUFJO1FBQ3hCLE9BQU8sSUFBSUEsUUFBUSxZQUFZLE9BQU9DLFVBQVUsVUFBVTtZQUN4RFYsVUFBVSxDQUFDUyxJQUFJLEdBQUdFLEtBQUtDLFNBQVMsQ0FBQ0Y7UUFDbkMsT0FBTyxJQUFJRCxRQUFRLGNBQWNJLE1BQU1DLE9BQU8sQ0FBQ0osUUFBUTtZQUNyRFYsVUFBVSxDQUFDUyxJQUFJLEdBQUdDO1FBQ3BCLE9BQU8sSUFBSSxPQUFPQSxVQUFVLFVBQVU7WUFDcENWLFVBQVUsQ0FBQ1MsSUFBSSxHQUFHTSxPQUFPTDtRQUMzQjtJQUNGO0lBRUEsT0FBT1Y7QUFDVDtBQUVBLFNBQVNnQixZQUFZQyxJQUFJO0lBQ3ZCLElBQ0UsQ0FBQ2xFLGNBQWNrRSxTQUNmLENBQUNKLE1BQU1DLE9BQU8sQ0FBQ0csS0FBS0MsSUFBSSxLQUN4QkQsS0FBS0MsSUFBSSxDQUFDQyxJQUFJLENBQUMsQ0FBQ0MsSUFBTSxDQUFDckUsY0FBY3FFLE1BQU0sQ0FBRSxVQUFTQSxDQUFBQSxJQUN0RDtRQUNBLE1BQU0sSUFBSUMsVUFBVTtJQUN0QjtJQUVBLE9BQU81RCxTQUFTNkQsUUFBUSxDQUFDTCxNQUFNO1FBQUVNLGFBQWE7SUFBSztBQUNyRDtBQUVBLDhGQUE4RjtBQUM5RixvR0FBb0c7QUFDcEcsMERBQTBEO0FBQzFELFNBQVNDLGtCQUFrQkMsTUFBTSxFQUFFQyxVQUFVO0lBQzNDLElBQUk7UUFDRixNQUFNQyxZQUFZRixPQUFPRyxNQUFNLENBQUNDLHFDQUFxQztRQUNyRSxJQUFJLENBQUNGLFVBQVVHLFFBQVEsQ0FBQ0osV0FBV0ssMEJBQTBCLEdBQUc7WUFDOUQsSUFBSUosVUFBVUcsUUFBUSxDQUFDLHVCQUF1QjtnQkFDNUNKLFdBQVdLLDBCQUEwQixHQUFHO1lBQzFDO1FBQ0Y7SUFDRixFQUFFLE9BQU9DLEtBQUssQ0FBQztBQUNqQjtBQUVBLFNBQVNDLHFCQUFxQlIsTUFBTSxFQUFFUyxRQUFRLEVBQUVSLFVBQVU7SUFDeEQsSUFBSSxDQUFDUSxTQUFTSCwwQkFBMEIsRUFBRTtRQUN4QyxvQ0FBb0M7UUFDcENQLGtCQUFrQkMsUUFBUUM7SUFDNUI7SUFFQSw0QkFBNEI7SUFDNUIsSUFBSVEsU0FBUzdCLFlBQVksRUFBRTtRQUN6QixJQUFJNkIsU0FBU0MsYUFBYSxFQUFFO1lBQzFCLE1BQU0sSUFBSWQsVUFBVTtRQUN0QjtRQUNBSyxXQUFXUyxhQUFhLEdBQUc7WUFBQ0QsU0FBUzdCLFlBQVk7U0FBQztRQUNsRCxPQUFPcUIsV0FBV3JCLFlBQVk7SUFDaEM7SUFFQSxJQUFJNkIsU0FBUy9CLGFBQWEsRUFBRTtRQUMxQixJQUFJK0IsU0FBU0UsY0FBYyxFQUFFO1lBQzNCLE1BQU0sSUFBSWYsVUFBVTtRQUN0QjtRQUNBSyxXQUFXVSxjQUFjLEdBQUc7WUFBQ0YsU0FBUy9CLGFBQWE7U0FBQztRQUNwRCxPQUFPdUIsV0FBV3ZCLGFBQWE7SUFDakM7QUFDRjtBQUVBLFNBQVNrQyx1QkFBdUJDLFFBQVEsRUFBRVYsTUFBTSxFQUFFRixVQUFVO0lBQzFELElBQUksQ0FBQ0UsTUFBTSxDQUFDLENBQUMsRUFBRVUsU0FBUyxTQUFTLENBQUMsQ0FBQyxFQUFFO0lBRXJDLE1BQU1DLDBCQUEwQmIsV0FBV0ssMEJBQTBCO0lBQ3JFLE1BQU1TLDhCQUE4QmQsV0FBV2UsK0JBQStCO0lBRTlFLE1BQU1DLE1BQU0sQ0FBQyxFQUFFSixTQUFTLHFCQUFxQixDQUFDO0lBQzlDLE1BQU1LLE9BQU8sQ0FBQyxFQUFFTCxTQUFTLDBCQUEwQixDQUFDO0lBRXBELElBQUlaLFVBQVUsQ0FBQ2dCLElBQUksS0FBSzlDLGFBQWE4QixVQUFVLENBQUNpQixLQUFLLEtBQUsvQyxXQUFXO1FBQ25FLElBQUkyQyw0QkFBNEIzQyxXQUFXO1lBQ3pDOEIsVUFBVSxDQUFDZ0IsSUFBSSxHQUFHSDtRQUNwQjtRQUNBLElBQUlDLGdDQUFnQzVDLFdBQVc7WUFDN0M4QixVQUFVLENBQUNpQixLQUFLLEdBQUdIO1FBQ3JCO0lBQ0Y7QUFDRjtBQUVBLE1BQU1JO0lBQ0osQ0FBQ1YsUUFBUSxDQUFDO0lBQ1YsQ0FBQ04sTUFBTSxDQUFDO0lBQ1IsQ0FBQ2lCLGdCQUFnQixDQUFDO0lBQ2xCLENBQUNDLDJCQUEyQixDQUFDO0lBQzdCQyxZQUFZbkIsTUFBTSxFQUFFaUIsZ0JBQWdCLEVBQUVYLFdBQVcsQ0FBQyxDQUFDLEVBQUVqQixJQUFJLEVBQUUrQixPQUFPLENBQUU7UUFDbEUsSUFBSSxDQUFDLENBQUNkLFFBQVEsR0FBRyxJQUFJZTtRQUNyQixJQUFJLENBQUMsQ0FBQ3JCLE1BQU0sR0FBR0E7UUFDZixJQUFJLENBQUMsQ0FBQ2lCLGdCQUFnQixHQUFHQTtRQUV6QixJQUFJLE9BQU9YLFNBQVNqQyxTQUFTLEtBQUssWUFBWSxDQUFDaUMsU0FBU2pDLFNBQVMsRUFBRTtZQUNqRSxNQUFNLElBQUlvQixVQUFVO1FBQ3RCO1FBRUEsTUFBTUssYUFBYTtZQUNqQndCLGFBQWE7Z0JBQUM7YUFBcUI7WUFDbkNDLDhCQUE4QjtZQUM5QkMsbUNBQW1DO1lBQ25DaEIsZ0JBQWdCO2dCQUFDO2FBQU87WUFDeEJMLDRCQUE0QjtZQUM1QixHQUFJLElBQUksQ0FBQ3NCLEtBQUssS0FDVjtnQkFDRUgsYUFBYTtvQkFBQztvQkFBc0I7aUJBQVc7Z0JBQy9DQyw4QkFBOEI7Z0JBQzlCQyxtQ0FBbUM7Z0JBQ25DaEIsZ0JBQWdCO29CQUFDO2lCQUFnQjtnQkFDakNrQiw0Q0FBNEM7Z0JBQzVDdkIsNEJBQTRCbkM7WUFDOUIsSUFDQUEsU0FBUztZQUNiLEdBQUksSUFBSSxDQUFDMkQsS0FBSyxLQUNWO2dCQUNFSiw4QkFBOEI7Z0JBQzlCQyxtQ0FBbUM7Z0JBQ25DckIsNEJBQTRCbkM7WUFDOUIsSUFDQUEsU0FBUztZQUNiLEdBQUdzQyxRQUFRO1FBQ2I7UUFFQSxJQUFJLElBQUksQ0FBQ3NCLElBQUksSUFBSTtZQUNmLE9BQVE5QixXQUFXSywwQkFBMEI7Z0JBQzNDLEtBQUs7Z0JBQ0wsS0FBSztvQkFDSDtnQkFDRixLQUFLO29CQUNILElBQUksQ0FBQ2QsTUFBTTt3QkFDVCxNQUFNLElBQUlJLFVBQVU7b0JBQ3RCO29CQUNBO2dCQUNGLEtBQUt6QjtvQkFDSCxNQUFNLElBQUl5QixVQUFVO2dCQUN0QjtvQkFDRSxNQUFNLElBQUlBLFVBQVU7WUFDeEI7UUFDRjtRQUVBLElBQUksSUFBSSxDQUFDa0MsS0FBSyxJQUFJO1lBQ2hCLElBQ0U3QixXQUFXNEIsMENBQTBDLElBQ3JENUIsV0FBVytCLHdCQUF3QixFQUNuQztnQkFDQSxNQUFNLElBQUlwQyxVQUNSO1lBRUo7WUFFQSxJQUNFLENBQUNLLFdBQVc0QiwwQ0FBMEMsSUFDdEQsQ0FBQzVCLFdBQVcrQix3QkFBd0IsRUFDcEM7Z0JBQ0EsTUFBTSxJQUFJcEMsVUFDUjtZQUVKO1FBQ0Y7UUFFQVkscUJBQXFCLElBQUksRUFBRUMsVUFBVVI7UUFFckM5RSw4QkFBOEIsU0FBUyxJQUFJLENBQUNnRixNQUFNLEVBQUVGO1FBQ3BEO1lBQUM7WUFBaUI7U0FBYSxDQUFDbEIsT0FBTyxDQUFDLENBQUM4QjtZQUN2Q0QsdUJBQXVCQyxVQUFVLElBQUksQ0FBQ1YsTUFBTSxFQUFFRjtZQUM5QzlFLDhCQUE4QjBGLFVBQVUsSUFBSSxDQUFDVixNQUFNLEVBQUVGO1FBQ3ZEO1FBRUFwQixPQUFPQyxPQUFPLENBQUNtQixZQUFZbEIsT0FBTyxDQUFDLENBQUMsQ0FBQ0MsS0FBS0MsTUFBTTtZQUM5QyxJQUFJLENBQUMsQ0FBQ3dCLFFBQVEsQ0FBQ3dCLEdBQUcsQ0FBQ2pELEtBQUtDO1lBQ3hCLElBQUksQ0FBQyxJQUFJLENBQUNELElBQUksRUFBRTtnQkFDZEgsT0FBT3FELGNBQWMsQ0FBQyxJQUFJLEVBQUVsRCxLQUFLO29CQUMvQm1EO3dCQUNFLE9BQU8sSUFBSSxDQUFDLENBQUMxQixRQUFRLENBQUMwQixHQUFHLENBQUNuRDtvQkFDNUI7b0JBQ0FvRCxZQUFZO2dCQUNkO1lBQ0Y7UUFDRjtRQUVBLElBQUk1QyxTQUFTckIsV0FBVztZQUN0QixNQUFNa0UsV0FBVzlDLFlBQVlaLElBQUksQ0FBQyxJQUFJLEVBQUVhO1lBQ3hDekQsVUFBVWtHLEdBQUcsQ0FBQyxJQUFJLEVBQUVJO1FBQ3RCO1FBRUEsSUFBSWQsV0FBVyxRQUFRQSxRQUFRRiwyQkFBMkIsRUFBRTtZQUMxRCxJQUFJLENBQUMsQ0FBQ0EsMkJBQTJCLEdBQUdwRixNQUFNc0YsUUFBUUYsMkJBQTJCO1FBQy9FO1FBRUEsSUFBSSxDQUFDdkYsZ0JBQWdCLEdBQUc7SUFDMUI7SUFFQXdHLGlCQUFpQmhFLFNBQVMsQ0FBQyxDQUFDLEVBQUU7UUFDNUIsSUFBSSxDQUFDaEQsY0FBY2dELFNBQVM7WUFDMUIsTUFBTSxJQUFJc0IsVUFBVTtRQUN0QjtRQUNBeEUsMEJBQTBCLElBQUksQ0FBQytFLE1BQU0sRUFBRTtRQUN2QyxNQUFNb0MsU0FBUyxJQUFJN0gsSUFBSSxJQUFJLENBQUN5RixNQUFNLENBQUNxQyxzQkFBc0I7UUFFekQsS0FBSyxNQUFNLENBQUNDLE1BQU14RCxNQUFNLElBQUlKLE9BQU9DLE9BQU8sQ0FBQ1Qsb0JBQW9CTSxJQUFJLENBQUMsSUFBSSxFQUFFTCxTQUFVO1lBQ2xGLElBQUljLE1BQU1DLE9BQU8sQ0FBQ0osUUFBUTtnQkFDeEJzRCxPQUFPRyxZQUFZLENBQUNDLE1BQU0sQ0FBQ0Y7Z0JBQzNCLEtBQUssTUFBTUcsVUFBVTNELE1BQU87b0JBQzFCc0QsT0FBT0csWUFBWSxDQUFDRyxNQUFNLENBQUNKLE1BQU1HO2dCQUNuQztZQUNGLE9BQU87Z0JBQ0xMLE9BQU9HLFlBQVksQ0FBQ1QsR0FBRyxDQUFDUSxNQUFNeEQ7WUFDaEM7UUFDRjtRQUVBLCtCQUErQjtRQUMvQixPQUFPc0QsT0FBT08sSUFBSSxDQUFDQyxPQUFPLENBQUMsT0FBTztJQUNwQztJQUVBQyxrQkFBa0IxRSxTQUFTLENBQUMsQ0FBQyxFQUFFO1FBQzdCLElBQUksQ0FBQ2hELGNBQWNnRCxTQUFTO1lBQzFCLE1BQU0sSUFBSXNCLFVBQVU7UUFDdEI7UUFDQSxNQUFNcUQsU0FBUzVFLG9CQUFvQk0sSUFBSSxDQUFDLElBQUksRUFBRUw7UUFDOUMsTUFBTTRFLGFBQWFyRSxPQUFPWSxJQUFJLENBQUN3RCxRQUM1QnBHLEdBQUcsQ0FBQyxDQUFDNEYsT0FBUyxDQUFDLDJCQUEyQixFQUFFQSxLQUFLLFNBQVMsRUFBRVEsTUFBTSxDQUFDUixLQUFLLENBQUMsR0FBRyxDQUFDLEVBQzdFVSxJQUFJLENBQUM7UUFFUixPQUFPLENBQUM7Ozs7OzRCQUtnQixFQUFFLElBQUksQ0FBQ2hELE1BQU0sQ0FBQ3FDLHNCQUFzQixDQUFDO0VBQy9ELEVBQUVVLFdBQVc7OztPQUdSLENBQUM7SUFDTjtJQUVBRSxjQUFjOUUsU0FBUyxDQUFDLENBQUMsRUFBRTtRQUN6QmxELDBCQUEwQixJQUFJLENBQUMrRSxNQUFNLEVBQUU7UUFFdkMsTUFBTSxFQUFFLEdBQUdrRCxVQUFVLEVBQUVDLE1BQU0sRUFBRSxHQUFHLElBQUksQ0FBQ0MseUJBQXlCLElBQUksRUFBRTtRQUV0RSxNQUFNLEVBQUVDLDJCQUEyQkYsV0FBVyxJQUFJRCxhQUFhbEYsU0FBUyxFQUFFLEdBQUdHO1FBRTdFLElBQUltRjtRQUNILEdBQUVBLGFBQWEsRUFBRSxHQUFHbkYsUUFBUSxHQUFHQSxNQUFLO1FBQ3JDLElBQUltRix5QkFBeUJqSSxVQUFVO1lBQ3JDLElBQUksQ0FBQ2lJLGNBQWNDLFFBQVEsRUFBRTtnQkFDM0IsTUFBTSxJQUFJOUQsVUFBVTtZQUN0QjtZQUNBNkQsZ0JBQWdCQSxjQUFjQyxRQUFRO1FBQ3hDO1FBRUEsTUFBTW5CLFNBQVM5SCxJQUFJbUQsS0FBSyxDQUFDLElBQUksQ0FBQ3VDLE1BQU0sQ0FBQ3dELG9CQUFvQjtRQUN6RCxNQUFNQyxRQUFRM0ksU0FDWnlDLGdCQUFnQixJQUFJLENBQUN5QyxNQUFNLENBQUN3RCxvQkFBb0IsR0FDaERyRixRQUNBO1lBQ0VrRjtZQUNBaEYsV0FBVyxJQUFJLENBQUNBLFNBQVM7UUFDM0IsR0FDQTtZQUFFaUY7UUFBYztRQUdsQjVFLE9BQU9DLE9BQU8sQ0FBQzhFLE9BQU83RSxPQUFPLENBQUMsQ0FBQyxDQUFDQyxLQUFLQyxNQUFNO1lBQ3pDLElBQUlBLFVBQVUsUUFBUUEsVUFBVWQsV0FBVztnQkFDekMsT0FBT3lGLEtBQUssQ0FBQzVFLElBQUk7WUFDbkI7UUFDRjtRQUVBdUQsT0FBTzFFLE1BQU0sR0FBRztRQUNoQjBFLE9BQU9xQixLQUFLLEdBQUdBO1FBRWYsT0FBT25KLElBQUlvSixNQUFNLENBQUN0QjtJQUNwQjtJQUVBdUIsZUFBZXhHLEtBQUssRUFBRTtRQUNwQixNQUFNeUcsb0JBQ0p6RyxpQkFBaUJsRCxRQUFRNEosZUFBZSxJQUFLMUcsU0FBU0EsTUFBTTJHLE1BQU0sSUFBSTNHLE1BQU03QyxHQUFHO1FBQ2pGLE1BQU15SixXQUFXLE9BQU81RyxVQUFVO1FBRWxDLElBQUksQ0FBQzRHLFlBQVksQ0FBQ0gsbUJBQW1CO1lBQ25DLE1BQU0sSUFBSW5FLFVBQ1I7UUFFSjtRQUNBLElBQUltRSxtQkFBbUI7WUFDckIsT0FBUXpHLE1BQU0yRyxNQUFNO2dCQUNsQixLQUFLO29CQUNILE9BQU81RyxPQUFPSyxnQkFBZ0JKLE1BQU03QyxHQUFHO2dCQUN6QyxLQUFLO29CQUNILElBQUk2QyxNQUFNNkcsSUFBSSxLQUFLaEcsV0FBVzt3QkFDNUIsTUFBTSxJQUFJeUIsVUFDUjtvQkFFSjtvQkFDQSxPQUFRLE9BQU90QyxNQUFNNkcsSUFBSTt3QkFDdkIsS0FBSzt3QkFDTCxLQUFLOzRCQUNILElBQUlDLE9BQU9DLFFBQVEsQ0FBQy9HLE1BQU02RyxJQUFJLEdBQUc7Z0NBQy9CLE9BQU85RyxPQUFPN0MsWUFBWW9ELEtBQUssQ0FBQ04sTUFBTTZHLElBQUksQ0FBQ0csUUFBUSxDQUFDOzRCQUN0RDs0QkFDQSxJQUFJLE9BQU9oSCxNQUFNNkcsSUFBSSxLQUFLLFVBQVU7Z0NBQ2xDLE9BQU85RyxPQUFPN0MsWUFBWW9ELEtBQUssQ0FBQ04sTUFBTTZHLElBQUk7NEJBQzVDOzRCQUVBLE9BQU85RyxPQUFPQyxNQUFNNkcsSUFBSTt3QkFDMUI7NEJBQ0UsTUFBTSxJQUFJdkUsVUFBVTtvQkFDeEI7Z0JBQ0Y7b0JBQ0UsTUFBTSxJQUFJQSxVQUFVO1lBQ3hCO1FBQ0YsT0FBTztZQUNMLE9BQU92QyxPQUFPSyxnQkFBZ0JKO1FBQ2hDO0lBQ0Y7SUFFQSxNQUFNaUgsU0FDSkMsV0FBVyxFQUNYQyxVQUFVLEVBQ1ZDLFNBQVMsQ0FBQyxDQUFDLEVBQ1gsRUFBRUMsWUFBWSxFQUFFQyxzQkFBc0IsRUFBRUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxDQUFDLEVBQ25EO1FBQ0EsSUFBSXZHLFNBQVNqQixPQUFPb0g7UUFFcEIsSUFBSUMsT0FBT0ksSUFBSSxJQUFJLENBQUUsZUFBY0wsVUFBUyxHQUFJO1lBQzlDLE1BQU0sSUFBSS9JLFFBQVE7Z0JBQ2hCMEMsU0FBUztnQkFDVHNHO2dCQUNBcEc7WUFDRjtRQUNGLE9BQU8sSUFBSSxjQUFjbUcsWUFBWTtZQUNuQyxNQUFNTSxZQUFZLE1BQU0sSUFBSSxDQUFDQyxXQUFXLENBQUMxRyxPQUFPMkcsUUFBUTtZQUN4RDNHLFNBQVMsTUFBTSxJQUFJLENBQUM0RyxZQUFZLENBQUNIO1FBQ25DO1FBRUEsSUFBSSxJQUFJLENBQUNJLGVBQWUsSUFBSSxDQUFDVCxPQUFPVSxPQUFPLEVBQUU7WUFDM0NWLE9BQU9VLE9BQU8sR0FBRyxJQUFJLENBQUNELGVBQWU7UUFDdkM7UUFFQSxJQUFJN0csT0FBTytHLEtBQUssSUFBSSxDQUFDWCxPQUFPVyxLQUFLLEVBQUU7WUFDakMsTUFBTSxJQUFJekYsVUFBVTtRQUN0QjtRQUVBLElBQUksQ0FBQ3RCLE9BQU8rRyxLQUFLLElBQUlYLE9BQU9XLEtBQUssRUFBRTtZQUNqQyxNQUFNLElBQUkzSixRQUFRO2dCQUNoQjBDLFNBQVM7Z0JBQ1RzRztnQkFDQXBHO1lBQ0Y7UUFDRjtRQUVBLElBQUlvRyxPQUFPVyxLQUFLLEtBQUsvRyxPQUFPK0csS0FBSyxFQUFFO1lBQ2pDLE1BQU0sSUFBSTNKLFFBQVE7Z0JBQ2hCNEosUUFBUTtvQkFBQztvQkFBd0NaLE9BQU9XLEtBQUs7b0JBQUUvRyxPQUFPK0csS0FBSztpQkFBQztnQkFDNUVYO2dCQUNBcEc7WUFDRjtRQUNGO1FBRUEsSUFBSSxTQUFTQSxRQUFRO1lBQ25CbEQsMEJBQTBCLElBQUksQ0FBQytFLE1BQU0sRUFBRTtZQUN2QyxJQUFJN0IsT0FBT2lILEdBQUcsS0FBSyxJQUFJLENBQUNwRixNQUFNLENBQUNBLE1BQU0sRUFBRTtnQkFDckMsTUFBTSxJQUFJekUsUUFBUTtvQkFDaEI0SixRQUFRO3dCQUFDO3dCQUFzQyxJQUFJLENBQUNuRixNQUFNLENBQUNBLE1BQU07d0JBQUU3QixPQUFPaUgsR0FBRztxQkFBQztvQkFDOUVqSDtnQkFDRjtZQUNGO1FBQ0YsT0FBTyxJQUNMLElBQUksQ0FBQzZCLE1BQU0sQ0FBQ3FGLDhDQUE4QyxJQUMxRCxDQUFFLGVBQWNsSCxNQUFLLEtBQ3JCLENBQUUsZUFBY21HLFVBQVMsR0FDekI7WUFDQSxNQUFNLElBQUkvSSxRQUFRO2dCQUNoQjBDLFNBQVM7Z0JBQ1RFO1lBQ0Y7UUFDRjtRQUVBLElBQUlBLE9BQU9tSCxLQUFLLEVBQUU7WUFDaEIsTUFBTSxJQUFJaEssUUFBUTZDO1FBQ3BCO1FBRUEsTUFBTW9ILGdDQUFnQztZQUNwQ0MsTUFBTTtnQkFBQzthQUFPO1lBQ2RqQyxVQUFVO2dCQUFDO2FBQVc7WUFDdEJsRyxPQUFPO2dCQUFDO2dCQUFnQjthQUFhO1FBQ3ZDO1FBRUEsSUFBSWtILE9BQU9oRyxhQUFhLEVBQUU7WUFDeEIsS0FBSyxNQUFNa0gsUUFBUWxCLE9BQU9oRyxhQUFhLENBQUM5QixLQUFLLENBQUMsS0FBTTtnQkFDbEQsSUFBSWdKLFNBQVMsUUFBUTtvQkFDbkIsSUFBSXRILE9BQU9xSCxJQUFJLElBQUlySCxPQUFPb0YsUUFBUSxJQUFJcEYsT0FBT3VILFlBQVksRUFBRTt3QkFDekQsTUFBTSxJQUFJbkssUUFBUTs0QkFDaEIwQyxTQUFTOzRCQUNUc0c7NEJBQ0FwRzt3QkFDRjtvQkFDRjtnQkFDRixPQUFPO29CQUNMLEtBQUssTUFBTXdILFNBQVNKLDZCQUE2QixDQUFDRSxLQUFLLENBQUU7d0JBQ3ZELElBQUksQ0FBQ3RILE1BQU0sQ0FBQ3dILE1BQU0sRUFBRTs0QkFDbEIsTUFBTSxJQUFJcEssUUFBUTtnQ0FDaEIwQyxTQUFTLENBQUMsRUFBRTBILE1BQU0sc0JBQXNCLENBQUM7Z0NBQ3pDcEI7Z0NBQ0FwRzs0QkFDRjt3QkFDRjtvQkFDRjtnQkFDRjtZQUNGO1FBQ0Y7UUFFQSxJQUFJQSxPQUFPb0YsUUFBUSxFQUFFO1lBQ25CLE1BQU1xQyxXQUFXLElBQUl2SyxTQUFTOEM7WUFDOUIsTUFBTSxJQUFJLENBQUMwSCxjQUFjLENBQUNEO1lBQzFCLE1BQU0sSUFBSSxDQUFDRSxlQUFlLENBQ3hCRixVQUNBckIsT0FBT3dCLEtBQUssRUFDWixpQkFDQXhCLE9BQU9VLE9BQU8sRUFDZFYsT0FBT1csS0FBSztZQUdkLElBQUksQ0FBQy9HLE9BQU9xSCxJQUFJLEVBQUU7Z0JBQ2hCLE9BQU9JO1lBQ1Q7UUFDRjtRQUVBLElBQUl6SCxPQUFPcUgsSUFBSSxFQUFFO1lBQ2YsTUFBTUksV0FBVyxNQUFNLElBQUksQ0FBQ0ksS0FBSyxDQUMvQjtnQkFDRSxHQUFHeEIsWUFBWTtnQkFDZnlCLFlBQVk7Z0JBQ1pULE1BQU1ySCxPQUFPcUgsSUFBSTtnQkFDakIvRyxjQUFjNEY7Z0JBQ2Q2QixlQUFlM0IsT0FBTzJCLGFBQWE7WUFDckMsR0FDQTtnQkFBRXpCO2dCQUF3QkM7WUFBSztZQUdqQyxNQUFNLElBQUksQ0FBQ21CLGNBQWMsQ0FBQ0Q7WUFDMUIsTUFBTSxJQUFJLENBQUNFLGVBQWUsQ0FBQ0YsVUFBVXJCLE9BQU93QixLQUFLLEVBQUUsU0FBU3hCLE9BQU9VLE9BQU87WUFFMUUsSUFBSTlHLE9BQU9nSSxhQUFhLEVBQUU7Z0JBQ3hCUCxTQUFTTyxhQUFhLEdBQUdoSSxPQUFPZ0ksYUFBYTtZQUMvQztZQUVBLE9BQU9QO1FBQ1Q7UUFFQSxPQUFPLElBQUl2SyxTQUFTOEM7SUFDdEI7SUFFQSxNQUFNaUksY0FDSi9CLFdBQVcsRUFDWEMsVUFBVSxFQUNWQyxTQUFTLENBQUMsQ0FBQyxFQUNYLEVBQUVDLFlBQVksRUFBRUMsc0JBQXNCLEVBQUVDLElBQUksRUFBRSxHQUFHLENBQUMsQ0FBQyxFQUNuRDtRQUNBLElBQUl2RyxTQUFTakIsT0FBT29IO1FBRXBCLElBQUlDLE9BQU9JLElBQUksSUFBSSxDQUFFLGVBQWNMLFVBQVMsR0FBSTtZQUM5QyxNQUFNLElBQUkvSSxRQUFRO2dCQUNoQjBDLFNBQVM7Z0JBQ1RzRztnQkFDQXBHO1lBQ0Y7UUFDRixPQUFPLElBQUksY0FBY21HLFlBQVk7WUFDbkMsTUFBTU0sWUFBWSxNQUFNLElBQUksQ0FBQ0MsV0FBVyxDQUFDMUcsT0FBTzJHLFFBQVE7WUFDeEQzRyxTQUFTLE1BQU0sSUFBSSxDQUFDNEcsWUFBWSxDQUFDSDtRQUNuQztRQUVBLElBQUl6RyxPQUFPK0csS0FBSyxJQUFJLENBQUNYLE9BQU9XLEtBQUssRUFBRTtZQUNqQyxNQUFNLElBQUl6RixVQUFVO1FBQ3RCO1FBRUEsSUFBSSxDQUFDdEIsT0FBTytHLEtBQUssSUFBSVgsT0FBT1csS0FBSyxFQUFFO1lBQ2pDLE1BQU0sSUFBSTNKLFFBQVE7Z0JBQ2hCMEMsU0FBUztnQkFDVHNHO2dCQUNBcEc7WUFDRjtRQUNGO1FBRUEsSUFBSW9HLE9BQU9XLEtBQUssS0FBSy9HLE9BQU8rRyxLQUFLLEVBQUU7WUFDakMsTUFBTSxJQUFJM0osUUFBUTtnQkFDaEI0SixRQUFRO29CQUFDO29CQUF3Q1osT0FBT1csS0FBSztvQkFBRS9HLE9BQU8rRyxLQUFLO2lCQUFDO2dCQUM1RVg7Z0JBQ0FwRztZQUNGO1FBQ0Y7UUFFQSxJQUFJLFNBQVNBLFFBQVE7WUFDbkJsRCwwQkFBMEIsSUFBSSxDQUFDK0UsTUFBTSxFQUFFO1lBQ3ZDLElBQUk3QixPQUFPaUgsR0FBRyxLQUFLLElBQUksQ0FBQ3BGLE1BQU0sQ0FBQ0EsTUFBTSxFQUFFO2dCQUNyQyxNQUFNLElBQUl6RSxRQUFRO29CQUNoQjRKLFFBQVE7d0JBQUM7d0JBQXNDLElBQUksQ0FBQ25GLE1BQU0sQ0FBQ0EsTUFBTTt3QkFBRTdCLE9BQU9pSCxHQUFHO3FCQUFDO29CQUM5RWpIO2dCQUNGO1lBQ0Y7UUFDRixPQUFPLElBQ0wsSUFBSSxDQUFDNkIsTUFBTSxDQUFDcUYsOENBQThDLElBQzFELENBQUUsZUFBY2xILE1BQUssS0FDckIsQ0FBRSxlQUFjbUcsVUFBUyxHQUN6QjtZQUNBLE1BQU0sSUFBSS9JLFFBQVE7Z0JBQ2hCMEMsU0FBUztnQkFDVEU7WUFDRjtRQUNGO1FBRUEsSUFBSUEsT0FBT21ILEtBQUssRUFBRTtZQUNoQixNQUFNLElBQUloSyxRQUFRNkM7UUFDcEI7UUFFQSxJQUFJLE9BQU9BLE9BQU9vRixRQUFRLEtBQUssWUFBWXBGLE9BQU9vRixRQUFRLENBQUNKLE1BQU0sRUFBRTtZQUNqRSxNQUFNLElBQUk1SCxRQUFRO2dCQUNoQjBDLFNBQ0U7Z0JBQ0ZFO1lBQ0Y7UUFDRjtRQUNBLE9BQU9BLE9BQU9vRixRQUFRO1FBRXRCLE1BQU1nQyxnQ0FBZ0M7WUFDcENDLE1BQU07Z0JBQUM7YUFBTztZQUNkbkksT0FBTztnQkFBQztnQkFBZ0I7YUFBYTtRQUN2QztRQUVBLElBQUlrSCxPQUFPaEcsYUFBYSxFQUFFO1lBQ3hCLEtBQUssTUFBTWtILFFBQVFsQixPQUFPaEcsYUFBYSxDQUFDOUIsS0FBSyxDQUFDLEtBQU07Z0JBQ2xELElBQUlnSixTQUFTLFFBQVE7b0JBQ25CLElBQUl0SCxPQUFPcUgsSUFBSSxJQUFJckgsT0FBT29GLFFBQVEsSUFBSXBGLE9BQU91SCxZQUFZLEVBQUU7d0JBQ3pELE1BQU0sSUFBSW5LLFFBQVE7NEJBQ2hCMEMsU0FBUzs0QkFDVHNHOzRCQUNBcEc7d0JBQ0Y7b0JBQ0Y7Z0JBQ0Y7Z0JBRUEsSUFBSW9ILDZCQUE2QixDQUFDRSxLQUFLLEVBQUU7b0JBQ3ZDLEtBQUssTUFBTUUsU0FBU0osNkJBQTZCLENBQUNFLEtBQUssQ0FBRTt3QkFDdkQsSUFBSSxDQUFDdEgsTUFBTSxDQUFDd0gsTUFBTSxFQUFFOzRCQUNsQixNQUFNLElBQUlwSyxRQUFRO2dDQUNoQjBDLFNBQVMsQ0FBQyxFQUFFMEgsTUFBTSxzQkFBc0IsQ0FBQztnQ0FDekNwQjtnQ0FDQXBHOzRCQUNGO3dCQUNGO29CQUNGO2dCQUNGO1lBQ0Y7UUFDRjtRQUVBLElBQUlBLE9BQU9xSCxJQUFJLEVBQUU7WUFDZixNQUFNSSxXQUFXLE1BQU0sSUFBSSxDQUFDSSxLQUFLLENBQy9CO2dCQUNFLEdBQUd4QixZQUFZO2dCQUNmeUIsWUFBWTtnQkFDWlQsTUFBTXJILE9BQU9xSCxJQUFJO2dCQUNqQi9HLGNBQWM0RjtnQkFDZDZCLGVBQWUzQixPQUFPMkIsYUFBYTtZQUNyQyxHQUNBO2dCQUFFekI7Z0JBQXdCQztZQUFLO1lBR2pDLElBQUksT0FBT2tCLFNBQVNyQyxRQUFRLEtBQUssWUFBWXFDLFNBQVNyQyxRQUFRLENBQUNKLE1BQU0sRUFBRTtnQkFDckUsTUFBTSxJQUFJNUgsUUFBUTtvQkFDaEIwQyxTQUNFO29CQUNGRTtnQkFDRjtZQUNGO1lBQ0EsT0FBT3lILFNBQVNyQyxRQUFRO1lBRXhCLE9BQU9xQztRQUNUO1FBRUEsT0FBTyxJQUFJdkssU0FBUzhDO0lBQ3RCO0lBRUEsTUFBTTBILGVBQWV4SSxLQUFLLEVBQUU7UUFDMUIsSUFBSSxDQUFDLElBQUksQ0FBQ2dKLCtCQUErQixFQUFFO1lBQ3pDLE9BQU9oSjtRQUNUO1FBRUEsSUFBSWlKLFVBQVVqSjtRQUVkLElBQUlpSixtQkFBbUJqTCxVQUFVO1lBQy9CLElBQUksQ0FBQ2lMLFFBQVEvQyxRQUFRLEVBQUU7Z0JBQ3JCLE1BQU0sSUFBSTlELFVBQVU7WUFDdEI7WUFDQTZHLFVBQVVBLFFBQVEvQyxRQUFRO1FBQzVCO1FBRUEsTUFBTWdELGNBQWMsSUFBSSxDQUFDRiwrQkFBK0I7UUFDeEQsTUFBTUcsY0FBYyxJQUFJLENBQUNDLCtCQUErQjtRQUV4RCxNQUFNQyxTQUFTLE1BQU0sSUFBSSxDQUFDQyxVQUFVLENBQUNMLFNBQVNDLGFBQWFDO1FBRTNELElBQUluSixpQkFBaUJoQyxVQUFVO1lBQzdCZ0MsTUFBTWtHLFFBQVEsR0FBR21EO1lBQ2pCLE9BQU9ySjtRQUNUO1FBRUEsT0FBT3FKO0lBQ1Q7SUFFQSxNQUFNRSxvQkFBb0I1QyxJQUFJLEVBQUU7UUFDOUIsTUFBTXVDLGNBQWMsSUFBSSxDQUFDTSw0QkFBNEI7UUFFckQsT0FBTyxJQUFJLENBQUNDLFdBQVcsQ0FBQzlDLE1BQU11QyxhQUFhLEVBQUU7SUFDL0M7SUFFQSxNQUFNMUIsWUFBWUMsUUFBUSxFQUFFO1FBQzFCLElBQUksQ0FBQyxJQUFJLENBQUNpQyxvQ0FBb0MsRUFBRTtZQUM5QyxPQUFPakM7UUFDVDtRQUVBLE1BQU15QixjQUFjLElBQUksQ0FBQ1Esb0NBQW9DO1FBQzdELE1BQU1QLGNBQWMsSUFBSSxDQUFDUSxvQ0FBb0M7UUFFN0QsT0FBTyxJQUFJLENBQUNMLFVBQVUsQ0FBQzdCLFVBQVV5QixhQUFhQztJQUNoRDtJQUVBLE1BQU1TLG1CQUFtQmpELElBQUksRUFBRTtRQUM3QixJQUFJLENBQUMsSUFBSSxDQUFDa0QsK0JBQStCLEVBQUU7WUFDekMsT0FBT2xEO1FBQ1Q7UUFFQSxNQUFNdUMsY0FBYyxJQUFJLENBQUNXLCtCQUErQjtRQUN4RCxNQUFNVixjQUFjLElBQUksQ0FBQ1csK0JBQStCO1FBRXhELE9BQU8sSUFBSSxDQUFDUixVQUFVLENBQUMzQyxNQUFNdUMsYUFBYUM7SUFDNUM7SUFFQSxNQUFNRyxXQUFXUyxHQUFHLEVBQUViLFdBQVcsRUFBRUMsY0FBYyxlQUFlLEVBQUU7UUFDaEUsTUFBTWEsU0FBU3RJLEtBQUt0QixLQUFLLENBQUM1QyxVQUFVeU0sTUFBTSxDQUFDRixJQUFJM0ssS0FBSyxDQUFDLElBQUksQ0FBQyxFQUFFO1FBRTVELElBQUk0SyxPQUFPRSxHQUFHLEtBQUtoQixhQUFhO1lBQzlCLE1BQU0sSUFBSWhMLFFBQVE7Z0JBQ2hCNEosUUFBUTtvQkFBQztvQkFBcURvQjtvQkFBYWMsT0FBT0UsR0FBRztpQkFBQztnQkFDdEZ6SixLQUFLc0o7WUFDUDtRQUNGO1FBRUEsSUFBSUMsT0FBT0csR0FBRyxLQUFLaEIsYUFBYTtZQUM5QixNQUFNLElBQUlqTCxRQUFRO2dCQUNoQjRKLFFBQVE7b0JBQUM7b0JBQXFEcUI7b0JBQWFhLE9BQU9HLEdBQUc7aUJBQUM7Z0JBQ3RGMUosS0FBS3NKO1lBQ1A7UUFDRjtRQUVBLE1BQU1LLGVBQWUsQ0FBQ2YsU0FBVyxJQUFJZ0IsY0FBY0osTUFBTSxDQUFDWixPQUFPaUIsU0FBUztRQUMxRSxJQUFJQTtRQUNKLElBQUlwQixZQUFZcUIsS0FBSyxDQUFDLGtCQUFrQjtZQUN0QyxNQUFNMUYsV0FBVyxNQUFNdEcsVUFBVW9HLEdBQUcsQ0FBQyxJQUFJO1lBRXpDLE1BQU02RixrQkFBa0JwTixLQUFLcU4scUJBQXFCLENBQUNWO1lBRW5ELEtBQUssTUFBTXZJLE9BQU9xRCxTQUFTNkYsR0FBRyxDQUFDO2dCQUM3QixHQUFHRixlQUFlO2dCQUNsQkcsS0FBSztZQUNQLEdBQUk7Z0JBQ0ZMLFlBQVksTUFBTWxOLEtBQ2Z3TixjQUFjLENBQUNiLEtBQUssTUFBTXZJLElBQUlxSixTQUFTLENBQUNMLGdCQUFnQk4sR0FBRyxHQUMzRFksSUFBSSxDQUFDVixjQUFjLEtBQU87Z0JBQzdCLElBQUlFLFdBQVc7WUFDakI7UUFDRixPQUFPO1lBQ0xBLFlBQVksTUFBTWxOLEtBQ2Z3TixjQUFjLENBQUNiLEtBQUssSUFBSSxDQUFDZ0IsWUFBWSxDQUFDN0IsZ0JBQWdCLFFBQVFDLGNBQWNELGNBQzVFNEIsSUFBSSxDQUFDVixjQUFjLEtBQU87UUFDL0I7UUFFQSxJQUFJLENBQUNFLFdBQVc7WUFDZCxNQUFNLElBQUlwTSxRQUFRO2dCQUNoQjBDLFNBQVM7Z0JBQ1RILEtBQUtzSjtZQUNQO1FBQ0Y7UUFDQSxPQUFPTztJQUNUO0lBRUEsTUFBTTdCLGdCQUFnQnVDLFFBQVEsRUFBRXRDLEtBQUssRUFBRXVDLFVBQVUsRUFBRUMsTUFBTSxFQUFFckQsS0FBSyxFQUFFO1FBQ2hFLElBQUlvQixVQUFVK0I7UUFFZCxNQUFNOUIsY0FBYyxJQUFJLENBQUNoRiw0QkFBNEI7UUFFckQsTUFBTWlILGFBQWFsQyxtQkFBbUJqTDtRQUV0QyxJQUFJbU4sWUFBWTtZQUNkLElBQUksQ0FBQ2xDLFFBQVEvQyxRQUFRLEVBQUU7Z0JBQ3JCLE1BQU0sSUFBSTlELFVBQVU7WUFDdEI7WUFDQTZHLFVBQVVBLFFBQVEvQyxRQUFRO1FBQzVCO1FBRUErQyxVQUFVbkgsT0FBT21IO1FBRWpCLE1BQU1tQyxZQUFZak47UUFDbEIsTUFBTSxFQUFFa04sV0FBV3JCLE1BQU0sRUFBRXhKLE9BQU8sRUFBRWdCLEdBQUcsRUFBRSxHQUFHLE1BQU0sSUFBSSxDQUFDaUksV0FBVyxDQUFDUixTQUFTQztRQUU1RSxJQUFJLE9BQU9nQyxXQUFXLFlBQWFBLFdBQVd0TCxtQkFBbUIsSUFBSSxDQUFDMEwsaUJBQWlCLEVBQUc7WUFDeEYsSUFBSSxDQUFDOUssUUFBUStLLFNBQVMsRUFBRTtnQkFDdEIsTUFBTSxJQUFJck4sUUFBUTtvQkFDaEIwQyxTQUFTO29CQUNUSCxLQUFLd0k7Z0JBQ1A7WUFDRjtZQUNBLElBQUksT0FBT3pJLFFBQVErSyxTQUFTLEtBQUssVUFBVTtnQkFDekMsTUFBTSxJQUFJck4sUUFBUTtvQkFDaEIwQyxTQUFTO29CQUNUSCxLQUFLd0k7Z0JBQ1A7WUFDRjtRQUNGO1FBRUEsSUFDRSxPQUFPaUMsV0FBVyxZQUNsQjFLLFFBQVErSyxTQUFTLEdBQUdMLFNBQVNFLFlBQVksSUFBSSxDQUFDOU0sZ0JBQWdCLEVBQzlEO1lBQ0EsTUFBTSxJQUFJSixRQUFRO2dCQUNoQjRKLFFBQVE7b0JBQ047b0JBQ0FvRDtvQkFDQTFLLFFBQVErSyxTQUFTO29CQUNqQkgsWUFBWSxJQUFJLENBQUM5TSxnQkFBZ0I7aUJBQ2xDO2dCQUNESCxLQUFLaU47Z0JBQ0xJLFdBQVcsSUFBSSxDQUFDbE4sZ0JBQWdCO2dCQUNoQ2lOLFdBQVcvSyxRQUFRK0ssU0FBUztnQkFDNUI5SyxLQUFLd0k7WUFDUDtRQUNGO1FBRUEsSUFDRVAsVUFBVS9JLGtCQUNUYSxDQUFBQSxRQUFRa0ksS0FBSyxJQUFJQSxVQUFVL0gsU0FBUSxLQUNwQ0gsUUFBUWtJLEtBQUssS0FBS0EsT0FDbEI7WUFDQSxNQUFNLElBQUl4SyxRQUFRO2dCQUNoQjRKLFFBQVE7b0JBQUM7b0JBQXdDWTtvQkFBT2xJLFFBQVFrSSxLQUFLO2lCQUFDO2dCQUN0RWpJLEtBQUt3STtZQUNQO1FBQ0Y7UUFFQSxJQUFJZ0MsZUFBZSxpQkFBaUI7WUFDbEMsSUFBSSxDQUFDekssUUFBUWlMLE9BQU8sSUFBSVQsU0FBUzNDLFlBQVksRUFBRTtnQkFDN0MsTUFBTSxJQUFJbkssUUFBUTtvQkFDaEIwQyxTQUFTO29CQUNUSCxLQUFLd0k7Z0JBQ1A7WUFDRjtZQUVBLElBQUksQ0FBQ3pJLFFBQVFrTCxNQUFNLElBQUlWLFNBQVM3QyxJQUFJLEVBQUU7Z0JBQ3BDLE1BQU0sSUFBSWpLLFFBQVE7b0JBQ2hCMEMsU0FBUztvQkFDVEgsS0FBS3dJO2dCQUNQO1lBQ0Y7WUFFQSxJQUFJLElBQUksQ0FBQzdFLEtBQUssSUFBSTtnQkFDaEIsSUFBSSxDQUFDNUQsUUFBUW1MLE1BQU0sSUFBS1gsQ0FBQUEsU0FBU25ELEtBQUssSUFBSUEsS0FBSSxHQUFJO29CQUNoRCxNQUFNLElBQUkzSixRQUFRO3dCQUNoQjBDLFNBQVM7d0JBQ1RILEtBQUt3STtvQkFDUDtnQkFDRjtZQUNGO1lBRUEsSUFBSXpJLFFBQVFtTCxNQUFNLEVBQUU7Z0JBQ2xCLElBQUksQ0FBQzlELE9BQU87b0JBQ1YsTUFBTSxJQUFJekYsVUFBVTtnQkFDdEI7Z0JBRUEsSUFBSTtvQkFDRi9FLFVBQVV1TyxRQUFRLENBQ2hCO3dCQUFFQyxPQUFPO3dCQUFVQyxRQUFRO29CQUFRLEdBQ25DdEwsUUFBUW1MLE1BQU0sRUFDZDlELE9BQ0FtQyxPQUFPRSxHQUFHLEVBQ1YxSSxJQUFJdUssR0FBRyxJQUFJdkssSUFBSXVLLEdBQUcsQ0FBQ0MsR0FBRztnQkFFMUIsRUFBRSxPQUFPakosS0FBSztvQkFDWixNQUFNLElBQUk3RSxRQUFRO3dCQUFFMEMsU0FBU21DLElBQUluQyxPQUFPO3dCQUFFSCxLQUFLd0k7b0JBQVE7Z0JBQ3pEO1lBQ0Y7UUFDRjtRQUVBLElBQUksSUFBSSxDQUFDMUUsSUFBSSxNQUFNL0QsUUFBUXlMLEdBQUcsR0FBR2IsWUFBWSxNQUFNO1lBQ2pELE1BQU0sSUFBSWxOLFFBQVE7Z0JBQ2hCNEosUUFBUTtvQkFBQztvQkFBa0RzRDtvQkFBVzVLLFFBQVF5TCxHQUFHO2lCQUFDO2dCQUNsRjlOLEtBQUtpTjtnQkFDTEksV0FBVyxJQUFJLENBQUNsTixnQkFBZ0I7Z0JBQ2hDMk4sS0FBS3pMLFFBQVF5TCxHQUFHO2dCQUNoQnhMLEtBQUt3STtZQUNQO1FBQ0Y7UUFFQSxJQUFJK0IsU0FBUzNDLFlBQVksSUFBSTdILFFBQVFpTCxPQUFPLEtBQUs5SyxXQUFXO1lBQzFELElBQUk7Z0JBQ0Z0RCxVQUFVdU8sUUFBUSxDQUNoQjtvQkFBRUMsT0FBTztvQkFBV0MsUUFBUTtnQkFBZSxHQUMzQ3RMLFFBQVFpTCxPQUFPLEVBQ2ZULFNBQVMzQyxZQUFZLEVBQ3JCMkIsT0FBT0UsR0FBRyxFQUNWMUksSUFBSXVLLEdBQUcsSUFBSXZLLElBQUl1SyxHQUFHLENBQUNDLEdBQUc7WUFFMUIsRUFBRSxPQUFPakosS0FBSztnQkFDWixNQUFNLElBQUk3RSxRQUFRO29CQUFFMEMsU0FBU21DLElBQUluQyxPQUFPO29CQUFFSCxLQUFLd0k7Z0JBQVE7WUFDekQ7UUFDRjtRQUVBLElBQUkrQixTQUFTN0MsSUFBSSxJQUFJM0gsUUFBUWtMLE1BQU0sS0FBSy9LLFdBQVc7WUFDakQsSUFBSTtnQkFDRnRELFVBQVV1TyxRQUFRLENBQ2hCO29CQUFFQyxPQUFPO29CQUFVQyxRQUFRO2dCQUFPLEdBQ2xDdEwsUUFBUWtMLE1BQU0sRUFDZFYsU0FBUzdDLElBQUksRUFDYjZCLE9BQU9FLEdBQUcsRUFDVjFJLElBQUl1SyxHQUFHLElBQUl2SyxJQUFJdUssR0FBRyxDQUFDQyxHQUFHO1lBRTFCLEVBQUUsT0FBT2pKLEtBQUs7Z0JBQ1osTUFBTSxJQUFJN0UsUUFBUTtvQkFBRTBDLFNBQVNtQyxJQUFJbkMsT0FBTztvQkFBRUgsS0FBS3dJO2dCQUFRO1lBQ3pEO1FBQ0Y7UUFFQSxPQUFPK0I7SUFDVDtJQUVBLE1BQU12QixZQUFZaEosR0FBRyxFQUFFeUksV0FBVyxFQUFFZ0QsV0FBVztRQUFDO1FBQU87UUFBTztRQUFPO1FBQU87S0FBTSxFQUFFO1FBQ2xGLE1BQU1DLGVBQWUsSUFBSSxDQUFDeEosTUFBTSxDQUFDQSxNQUFNLEtBQUs7UUFDNUMsTUFBTXlJLFlBQVlqTjtRQUNsQixJQUFJNkw7UUFDSixJQUFJeEo7UUFDSixJQUFJO1lBQ0QsR0FBRXdKLE1BQU0sRUFBRXhKLE9BQU8sRUFBRSxHQUFHakQsVUFBVWtELEtBQUs7Z0JBQUUyTCxVQUFVO1lBQUssRUFBQztRQUMxRCxFQUFFLE9BQU9ySixLQUFLO1lBQ1osTUFBTSxJQUFJN0UsUUFBUTtnQkFDaEI0SixRQUFRO29CQUFDO29CQUFpQy9FLElBQUlrQyxJQUFJO29CQUFFbEMsSUFBSW5DLE9BQU87aUJBQUM7Z0JBQ2hFSDtZQUNGO1FBQ0Y7UUFFQSxJQUFJdUosT0FBT0UsR0FBRyxLQUFLaEIsYUFBYTtZQUM5QixNQUFNLElBQUloTCxRQUFRO2dCQUNoQjRKLFFBQVE7b0JBQUM7b0JBQXFEb0I7b0JBQWFjLE9BQU9FLEdBQUc7aUJBQUM7Z0JBQ3RGeko7WUFDRjtRQUNGO1FBRUEsSUFBSTBMLGNBQWM7WUFDaEJELFdBQVc7bUJBQUlBO2dCQUFVO2FBQVU7UUFDckM7UUFFQUEsU0FBUzNLLE9BQU8sQ0FBQ2hCLGVBQWU4TCxJQUFJLENBQUMxTCxXQUFXSCxTQUFTQztRQUV6RCxJQUFJRCxRQUFRdUgsR0FBRyxLQUFLcEgsV0FBVztZQUM3QixJQUFJMkwsY0FBYyxJQUFJLENBQUMzSixNQUFNLENBQUNBLE1BQU07WUFFcEMsSUFBSSxJQUFJLENBQUMsQ0FBQ2lCLGdCQUFnQixFQUFFO2dCQUMxQjBJLGNBQWMsSUFBSSxDQUFDM0osTUFBTSxDQUFDQSxNQUFNLENBQUM0QyxPQUFPLENBQUMsY0FBYy9FLFFBQVErTCxHQUFHO1lBQ3BFO1lBRUEsSUFBSS9MLFFBQVF1SCxHQUFHLEtBQUt1RSxhQUFhO2dCQUMvQixNQUFNLElBQUlwTyxRQUFRO29CQUNoQjRKLFFBQVE7d0JBQUM7d0JBQThDd0U7d0JBQWE5TCxRQUFRdUgsR0FBRztxQkFBQztvQkFDaEZ0SDtnQkFDRjtZQUNGO1FBQ0Y7UUFFQSxJQUFJRCxRQUFReUwsR0FBRyxLQUFLdEwsV0FBVztZQUM3QixJQUFJLE9BQU9ILFFBQVF5TCxHQUFHLEtBQUssVUFBVTtnQkFDbkMsTUFBTSxJQUFJL04sUUFBUTtvQkFDaEIwQyxTQUFTO29CQUNUSDtnQkFDRjtZQUNGO1FBQ0Y7UUFFQSxJQUFJRCxRQUFRZ00sR0FBRyxLQUFLN0wsV0FBVztZQUM3QixJQUFJLE9BQU9ILFFBQVFnTSxHQUFHLEtBQUssVUFBVTtnQkFDbkMsTUFBTSxJQUFJdE8sUUFBUTtvQkFDaEIwQyxTQUFTO29CQUNUSDtnQkFDRjtZQUNGO1lBQ0EsSUFBSUQsUUFBUWdNLEdBQUcsR0FBR3BCLFlBQVksSUFBSSxDQUFDOU0sZ0JBQWdCLEVBQUU7Z0JBQ25ELE1BQU0sSUFBSUosUUFBUTtvQkFDaEI0SixRQUFRO3dCQUNOO3dCQUNBc0QsWUFBWSxJQUFJLENBQUM5TSxnQkFBZ0I7d0JBQ2pDa0MsUUFBUWdNLEdBQUc7cUJBQ1o7b0JBQ0RyTyxLQUFLaU47b0JBQ0xJLFdBQVcsSUFBSSxDQUFDbE4sZ0JBQWdCO29CQUNoQ2tPLEtBQUtoTSxRQUFRZ00sR0FBRztvQkFDaEIvTDtnQkFDRjtZQUNGO1FBQ0Y7UUFFQSxJQUFJRCxRQUFRaU0sR0FBRyxLQUFLOUwsV0FBVztZQUM3QixJQUFJLE9BQU9ILFFBQVFpTSxHQUFHLEtBQUssVUFBVTtnQkFDbkMsTUFBTSxJQUFJdk8sUUFBUTtvQkFDaEIwQyxTQUFTO29CQUNUSDtnQkFDRjtZQUNGO1lBQ0EsSUFBSTJLLFlBQVksSUFBSSxDQUFDOU0sZ0JBQWdCLElBQUlrQyxRQUFRaU0sR0FBRyxFQUFFO2dCQUNwRCxNQUFNLElBQUl2TyxRQUFRO29CQUNoQjRKLFFBQVE7d0JBQUM7d0JBQStCc0QsWUFBWSxJQUFJLENBQUM5TSxnQkFBZ0I7d0JBQUVrQyxRQUFRaU0sR0FBRztxQkFBQztvQkFDdkZ0TyxLQUFLaU47b0JBQ0xJLFdBQVcsSUFBSSxDQUFDbE4sZ0JBQWdCO29CQUNoQ21PLEtBQUtqTSxRQUFRaU0sR0FBRztvQkFDaEJoTTtnQkFDRjtZQUNGO1FBQ0Y7UUFFQSxJQUFJRCxRQUFRa00sR0FBRyxLQUFLL0wsV0FBVztZQUM3QixJQUFJaUIsTUFBTUMsT0FBTyxDQUFDckIsUUFBUWtNLEdBQUcsR0FBRztnQkFDOUIsSUFBSWxNLFFBQVFrTSxHQUFHLENBQUM1RyxNQUFNLEdBQUcsS0FBSyxDQUFDdEYsUUFBUW1NLEdBQUcsRUFBRTtvQkFDMUMsTUFBTSxJQUFJek8sUUFBUTt3QkFDaEIwQyxTQUFTO3dCQUNUSDtvQkFDRjtnQkFDRjtnQkFFQSxJQUFJLENBQUNELFFBQVFrTSxHQUFHLENBQUM3SixRQUFRLENBQUMsSUFBSSxDQUFDN0IsU0FBUyxHQUFHO29CQUN6QyxNQUFNLElBQUk5QyxRQUFRO3dCQUNoQjRKLFFBQVE7NEJBQ047NEJBQ0EsSUFBSSxDQUFDOUcsU0FBUzs0QkFDZFIsUUFBUWtNLEdBQUc7eUJBQ1o7d0JBQ0RqTTtvQkFDRjtnQkFDRjtZQUNGLE9BQU8sSUFBSUQsUUFBUWtNLEdBQUcsS0FBSyxJQUFJLENBQUMxTCxTQUFTLEVBQUU7Z0JBQ3pDLE1BQU0sSUFBSTlDLFFBQVE7b0JBQ2hCNEosUUFBUTt3QkFBQzt3QkFBc0MsSUFBSSxDQUFDOUcsU0FBUzt3QkFBRVIsUUFBUWtNLEdBQUc7cUJBQUM7b0JBQzNFak07Z0JBQ0Y7WUFDRjtRQUNGO1FBRUEsSUFBSUQsUUFBUW1NLEdBQUcsS0FBS2hNLFdBQVc7WUFDN0IsSUFBSWtELDhCQUE4QixJQUFJLENBQUMsQ0FBQ0EsMkJBQTJCO1lBRW5FLElBQUksT0FBT0EsZ0NBQWdDLFVBQVU7Z0JBQ25EQSw4QkFBOEI7b0JBQUMsSUFBSSxDQUFDN0MsU0FBUztvQkFBRTZDO2lCQUE0QjtZQUM3RSxPQUFPLElBQUlqQyxNQUFNQyxPQUFPLENBQUNnQyw4QkFBOEI7Z0JBQ3JEQSw4QkFBOEI7b0JBQUMsSUFBSSxDQUFDN0MsU0FBUzt1QkFBSzZDO2lCQUE0QjtZQUNoRixPQUFPO2dCQUNMQSw4QkFBOEI7b0JBQUMsSUFBSSxDQUFDN0MsU0FBUztpQkFBQztZQUNoRDtZQUVBLElBQUksQ0FBQzZDLDRCQUE0QmhCLFFBQVEsQ0FBQ3JDLFFBQVFtTSxHQUFHLEdBQUc7Z0JBQ3RELE1BQU0sSUFBSXpPLFFBQVE7b0JBQ2hCNEosUUFBUTt3QkFBQzt3QkFBeUJ0SCxRQUFRbU0sR0FBRztxQkFBQztvQkFDOUNsTTtnQkFDRjtZQUNGO1FBQ0Y7UUFFQSxJQUFJd0I7UUFFSixJQUFJa0ssY0FBYztZQUNoQixJQUFJO2dCQUNGcFAsT0FBT2UsY0FBYzBDLFFBQVFvTSxPQUFPO2dCQUNwQyxNQUFNcEwsTUFBTSxNQUFNcEUsS0FBS3lQLFNBQVMsQ0FBQ3JNLFFBQVFvTSxPQUFPLEVBQUU1QyxPQUFPRSxHQUFHO2dCQUM1RG5OLE9BQU8rUCxLQUFLLENBQUN0TCxJQUFJNEcsSUFBSSxFQUFFO2dCQUN2Qm5HLE9BQU87b0JBQ0w7d0JBQ0U0STs0QkFDRSxPQUFPcko7d0JBQ1Q7b0JBQ0Y7aUJBQ0Q7WUFDSCxFQUFFLE9BQU91QixLQUFLO2dCQUNaLE1BQU0sSUFBSTdFLFFBQVE7b0JBQ2hCMEMsU0FBUztvQkFDVEg7Z0JBQ0Y7WUFDRjtZQUNBLElBQUksTUFBT3JELEtBQUsyUCxzQkFBc0IsQ0FBQ3ZNLFFBQVFvTSxPQUFPLE1BQU9wTSxRQUFRd00sR0FBRyxFQUFFO2dCQUN4RSxNQUFNLElBQUk5TyxRQUFRO29CQUNoQjBDLFNBQVM7b0JBQ1RIO2dCQUNGO1lBQ0Y7UUFDRixPQUFPLElBQUl1SixPQUFPRSxHQUFHLENBQUMrQyxVQUFVLENBQUMsT0FBTztZQUN0Q2hMLE9BQU87Z0JBQUMsSUFBSSxDQUFDOEksWUFBWSxDQUFDZixPQUFPRSxHQUFHO2FBQUU7UUFDeEMsT0FBTyxJQUFJRixPQUFPRSxHQUFHLEtBQUssUUFBUTtZQUNoQ2pJLE9BQU8sTUFBTXBELGNBQWNzQyxJQUFJLENBQUMsSUFBSSxDQUFDd0IsTUFBTSxFQUFFO2dCQUFFLEdBQUdxSCxNQUFNO2dCQUFFVyxLQUFLO1lBQU07UUFDdkU7UUFFQSxJQUFJLENBQUMxSSxRQUFRK0gsT0FBT0UsR0FBRyxLQUFLLFFBQVE7WUFDbEMsT0FBTztnQkFBRW1CLFdBQVdyQjtnQkFBUXhKO1lBQVE7UUFDdEM7UUFFQSxLQUFLLE1BQU1nQixPQUFPUyxLQUFNO1lBQ3RCLE1BQU1pTCxXQUFXLE1BQU05UCxLQUNwQitQLGFBQWEsQ0FBQzFNLEtBQUtlLGVBQWU0TCxhQUFhNUwsTUFBTSxNQUFNQSxJQUFJcUosU0FBUyxDQUFDYixPQUFPRSxHQUFHLEdBQ25GbUQsS0FBSyxDQUFDLEtBQU87WUFDaEIsSUFBSUgsVUFBVTtnQkFDWixPQUFPO29CQUNMMU07b0JBQ0E2SyxXQUFXNkIsU0FBUzFDLGVBQWU7b0JBQ25DaEo7Z0JBQ0Y7WUFDRjtRQUNGO1FBRUEsTUFBTSxJQUFJdEQsUUFBUTtZQUNoQjBDLFNBQVM7WUFDVEg7UUFDRjtJQUNGO0lBRUEsTUFBTTZNLFFBQVFDLFlBQVksRUFBRSxFQUFFcEcsWUFBWSxFQUFFQyxzQkFBc0IsRUFBRUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxDQUFDLEVBQUU7UUFDL0UsSUFBSXJILFFBQVF1TjtRQUVaLElBQUl2TixpQkFBaUJoQyxVQUFVO1lBQzdCLElBQUksQ0FBQ2dDLE1BQU13TixhQUFhLEVBQUU7Z0JBQ3hCLE1BQU0sSUFBSXBMLFVBQVU7WUFDdEI7WUFDQXBDLFFBQVFBLE1BQU13TixhQUFhO1FBQzdCO1FBRUEsTUFBTWpGLFdBQVcsTUFBTSxJQUFJLENBQUNJLEtBQUssQ0FDL0I7WUFDRSxHQUFHeEIsWUFBWTtZQUNmeUIsWUFBWTtZQUNaNEUsZUFBZTFMLE9BQU85QjtRQUN4QixHQUNBO1lBQUVvSDtZQUF3QkM7UUFBSztRQUdqQyxJQUFJa0IsU0FBU3JDLFFBQVEsRUFBRTtZQUNyQixNQUFNLElBQUksQ0FBQ3NDLGNBQWMsQ0FBQ0Q7WUFDMUIsTUFBTSxJQUFJLENBQUNFLGVBQWUsQ0FBQ0YsVUFBVTVJLGdCQUFnQixTQUFTQztZQUU5RCxJQUFJMk4sd0JBQXdCdlAsWUFBWXVQLGFBQWFySCxRQUFRLEVBQUU7Z0JBQzdELE1BQU11SCxjQUFjRixhQUFhRyxNQUFNLEdBQUdWLEdBQUc7Z0JBQzdDLE1BQU1XLFlBQVlwRixTQUFTbUYsTUFBTSxHQUFHVixHQUFHO2dCQUN2QyxJQUFJVyxjQUFjRixhQUFhO29CQUM3QixNQUFNLElBQUl2UCxRQUFRO3dCQUNoQjRKLFFBQVE7NEJBQUM7NEJBQXNDMkY7NEJBQWFFO3lCQUFVO3dCQUN0RWxOLEtBQUs4SCxTQUFTckMsUUFBUTtvQkFDeEI7Z0JBQ0Y7WUFDRjtRQUNGO1FBRUEsT0FBT3FDO0lBQ1Q7SUFFQSxNQUFNcUYsZ0JBQ0pDLFdBQVcsRUFDWEMsV0FBVyxFQUNYLEVBQ0VySCxNQUFNLEVBQ05zSCxPQUFPLEVBQ1BwSCxJQUFJLEVBQ0pVLElBQUksRUFDSnBILFlBQVlvSCxPQUNSLFNBQ0F5Ryx1QkFBdUI5UCxXQUN2QjhQLFlBQVlFLFVBQVUsR0FDdEIsUUFBUSxFQUNiLEdBQUcsQ0FBQyxDQUFDLEVBQ05DLEtBQUssRUFDTDtRQUNBLElBQUlILHVCQUF1QjlQLFVBQVU7WUFDbkMsSUFBSSxDQUFDOFAsWUFBWXpGLFlBQVksRUFBRTtnQkFDN0IsTUFBTSxJQUFJakcsVUFBVTtZQUN0QjtZQUNBMEwsY0FBY0EsWUFBWXpGLFlBQVk7UUFDeEM7UUFFQSxJQUFJLENBQUN5RixhQUFhO1lBQ2hCLE1BQU0sSUFBSTFMLFVBQVU7UUFDdEIsT0FBTyxJQUFJLE9BQU8wTCxnQkFBZ0IsVUFBVTtZQUMxQyxNQUFNLElBQUkxTCxVQUFVO1FBQ3RCO1FBRUEsTUFBTThMLGNBQWM7WUFDbEJILFNBQVM7Z0JBQ1BJLGVBQWVwTyx5QkFBeUIrTixhQUFhN047Z0JBQ3JELEdBQUc4TixPQUFPO1lBQ1o7WUFDQXBIO1FBQ0Y7UUFFQSxNQUFNeUgsT0FBTyxDQUFDLENBQUMsSUFBSSxDQUFDL0osMENBQTBDO1FBRTlELE1BQU1vRCxXQUFXLE1BQU1wSixRQUFROEMsSUFBSSxDQUNqQyxJQUFJLEVBQ0o7WUFDRSxHQUFHK00sV0FBVztZQUNkRyxjQUFjO1lBQ2Q1SDtZQUNBeEosS0FBSzRRO1FBQ1AsR0FDQTtZQUFFQztZQUFhTTtZQUFNL0c7UUFBSztRQUc1QixNQUFNaUgsa0JBQWtCN0csU0FBU3NHLE9BQU8sQ0FBQyxtQkFBbUI7UUFDNUQsSUFDRUUsVUFBVXhPLGdCQUNWNk8sbUJBQ0FBLGdCQUFnQkMsV0FBVyxHQUFHdEIsVUFBVSxDQUFDLFlBQ3pDdlAscUJBQXFCNFEsaUJBQWlCckcsS0FBSyxLQUFLLGtCQUNoRDtZQUNBLE9BQU8sSUFBSSxDQUFDMkYsZUFBZSxDQUFDQyxhQUFhQyxhQUFhO2dCQUNwRHJIO2dCQUNBc0g7Z0JBQ0FwSDtnQkFDQVU7Z0JBQ0FwSDtZQUNGO1FBQ0Y7UUFFQSxPQUFPd0g7SUFDVDtJQUVBLE1BQU0rRyxTQUFTVixXQUFXLEVBQUUsRUFBRXJILFNBQVMsS0FBSyxFQUFFZ0ksTUFBTSxRQUFRLEVBQUV4TyxTQUFTLEVBQUVhLE1BQU0sRUFBRXVHLElBQUksRUFBRSxHQUFHLENBQUMsQ0FBQyxFQUFFO1FBQzVGekosMEJBQTBCLElBQUksQ0FBQytFLE1BQU0sRUFBRTtRQUN2QyxNQUFNb0IsVUFBVTtZQUNkOUQ7WUFDQXdHLFFBQVEzRSxPQUFPMkUsUUFBUWlJLFdBQVc7WUFDbENySDtRQUNGO1FBRUEsSUFBSXRELFFBQVEwQyxNQUFNLEtBQUssU0FBUzFDLFFBQVEwQyxNQUFNLEtBQUssUUFBUTtZQUN6RCxNQUFNLElBQUlyRSxVQUFVO1FBQ3RCO1FBRUEsSUFBSXFNLFFBQVEsVUFBVTFLLFFBQVEwQyxNQUFNLEtBQUssUUFBUTtZQUMvQyxNQUFNLElBQUlyRSxVQUFVO1FBQ3RCO1FBRUEsTUFBTTNCLE1BQU0sQ0FBQyxDQUFFLEtBQUksQ0FBQytJLDRCQUE0QixJQUFJLElBQUksQ0FBQ0ssK0JBQStCO1FBRXhGLElBQUlwSixLQUFLO1lBQ1BzRCxRQUFRZ0ssT0FBTyxHQUFHO2dCQUFFWSxRQUFRO1lBQWtCO1FBQ2hELE9BQU87WUFDTDVLLFFBQVFnSyxPQUFPLEdBQUc7Z0JBQUVZLFFBQVE7WUFBbUI7UUFDakQ7UUFDQSxNQUFNUCxPQUFPLENBQUMsQ0FBQyxJQUFJLENBQUMvSiwwQ0FBMEM7UUFFOUQsSUFBSXVLO1FBQ0osSUFBSVIsUUFBUSxJQUFJLENBQUN6TCxNQUFNLENBQUNrTSxxQkFBcUIsRUFBRTtZQUM3Q0QsWUFBWSxJQUFJLENBQUNqTSxNQUFNLENBQUNrTSxxQkFBcUIsQ0FBQ0MsaUJBQWlCO1FBQ2pFO1FBRUFGLFlBQVksSUFBSTFSLElBQUkwUixhQUFhLElBQUksQ0FBQ2pNLE1BQU0sQ0FBQ21NLGlCQUFpQjtRQUU5RCxJQUFJTCxRQUFRLFFBQVE7WUFDbEIxSyxRQUFRZ0ssT0FBTyxDQUFDSSxhQUFhLEdBQUd4TjtZQUNoQ29ELFFBQVFnSyxPQUFPLENBQUMsZUFBZSxHQUFHO1lBQ2xDaEssUUFBUTRDLElBQUksR0FBRyxJQUFJeEo7WUFDbkI0RyxRQUFRNEMsSUFBSSxDQUFDdEIsTUFBTSxDQUNqQixnQkFDQXlJLHVCQUF1QjlQLFdBQVc4UCxZQUFZekYsWUFBWSxHQUFHeUY7UUFFakU7UUFFQSw4RUFBOEU7UUFDOUUsSUFBSWhOLFFBQVE7WUFDVixJQUFJaUQsUUFBUTBDLE1BQU0sS0FBSyxPQUFPO2dCQUM1QnBGLE9BQU9DLE9BQU8sQ0FBQ1IsUUFBUVMsT0FBTyxDQUFDLENBQUMsQ0FBQ0MsS0FBS0MsTUFBTTtvQkFDMUNtTixVQUFVMUosWUFBWSxDQUFDRyxNQUFNLENBQUM3RCxLQUFLQztnQkFDckM7WUFDRixPQUFPLElBQUlzQyxRQUFRNEMsSUFBSSxFQUFFO2dCQUN2QixtQkFBbUI7Z0JBQ25CdEYsT0FBT0MsT0FBTyxDQUFDUixRQUFRUyxPQUFPLENBQUMsQ0FBQyxDQUFDQyxLQUFLQyxNQUFNO29CQUMxQ3NDLFFBQVE0QyxJQUFJLENBQUN0QixNQUFNLENBQUM3RCxLQUFLQztnQkFDM0I7WUFDRixPQUFPO2dCQUNMLHFCQUFxQjtnQkFDckJzQyxRQUFRNEMsSUFBSSxHQUFHLElBQUl4SjtnQkFDbkI0RyxRQUFRZ0ssT0FBTyxDQUFDLGVBQWUsR0FBRztnQkFDbEMxTSxPQUFPQyxPQUFPLENBQUNSLFFBQVFTLE9BQU8sQ0FBQyxDQUFDLENBQUNDLEtBQUtDLE1BQU07b0JBQzFDc0MsUUFBUTRDLElBQUksQ0FBQ3RCLE1BQU0sQ0FBQzdELEtBQUtDO2dCQUMzQjtZQUNGO1FBQ0Y7UUFFQSxJQUFJc0MsUUFBUTRDLElBQUksRUFBRTtZQUNoQjVDLFFBQVE0QyxJQUFJLEdBQUc1QyxRQUFRNEMsSUFBSSxDQUFDRyxRQUFRO1FBQ3RDO1FBRUEsTUFBTVcsV0FBVyxNQUFNLElBQUksQ0FBQ21HLGVBQWUsQ0FBQ2dCLFdBQVdkLGFBQWEvSjtRQUVwRSxJQUFJNUQsU0FBU3BDLGdCQUFnQjBKLFVBQVU7WUFBRXNILFFBQVE7UUFBSztRQUV0RCxJQUFJdE8sS0FBSztZQUNQLElBQUksQ0FBQyxvQkFBb0J1TyxJQUFJLENBQUN2SCxTQUFTc0csT0FBTyxDQUFDLGVBQWUsR0FBRztnQkFDL0QsTUFBTSxJQUFJN1AsUUFBUTtvQkFDaEIwQyxTQUFTO29CQUNUNkc7Z0JBQ0Y7WUFDRjtZQUVBLE1BQU1kLE9BQU9jLFNBQVNkLElBQUksQ0FBQ0csUUFBUTtZQUNuQyxNQUFNMEgsV0FBVyxNQUFNLElBQUksQ0FBQzVFLGtCQUFrQixDQUFDakQ7WUFDL0MsSUFBSSxDQUFDLElBQUksQ0FBQzZDLDRCQUE0QixFQUFFO2dCQUN0QyxJQUFJO29CQUNGckosU0FBU3VCLEtBQUt0QixLQUFLLENBQUNvTztvQkFDcEJ6UixPQUFPZSxjQUFjcUM7Z0JBQ3ZCLEVBQUUsT0FBTzRDLEtBQUs7b0JBQ1osTUFBTSxJQUFJN0UsUUFBUTt3QkFDaEIwQyxTQUFTO3dCQUNUSCxLQUFLK047b0JBQ1A7Z0JBQ0Y7WUFDRixPQUFPO2dCQUNKLEdBQUVoTyxTQUFTTCxNQUFNLEVBQUUsR0FBRyxNQUFNLElBQUksQ0FBQ29KLG1CQUFtQixDQUFDaUYsU0FBUTtZQUNoRTtRQUNGLE9BQU87WUFDTCxJQUFJO2dCQUNGck8sU0FBU3VCLEtBQUt0QixLQUFLLENBQUNxSCxTQUFTZCxJQUFJO1lBQ25DLEVBQUUsT0FBTzVELEtBQUs7Z0JBQ1oxQixPQUFPcUQsY0FBYyxDQUFDM0IsS0FBSyxZQUFZO29CQUFFdEIsT0FBT2dHO2dCQUFTO2dCQUN6RCxNQUFNMUU7WUFDUjtRQUNGO1FBRUEsSUFBSStLLHVCQUF1QjlQLFlBQVk4UCxZQUFZNUgsUUFBUSxFQUFFO1lBQzNELE1BQU11SCxjQUFjSyxZQUFZSixNQUFNLEdBQUdWLEdBQUc7WUFDNUMsSUFBSTdNLE9BQU82TSxHQUFHLEtBQUtTLGFBQWE7Z0JBQzlCLE1BQU0sSUFBSXZQLFFBQVE7b0JBQ2hCNEosUUFBUTt3QkFBQzt3QkFBK0MyRjt3QkFBYXROLE9BQU82TSxHQUFHO3FCQUFDO29CQUNoRnJHLE1BQU14RztvQkFDTk0sS0FBS3FOLFlBQVk1SCxRQUFRO2dCQUMzQjtZQUNGO1FBQ0Y7UUFFQSxPQUFPL0Y7SUFDVDtJQUVBOE8saUJBQWlCQyxHQUFHLEVBQUU7UUFDcEIsTUFBTUMsT0FBT0QsT0FBTyxNQUFNLFdBQVdBLE9BQU8sTUFBTSxXQUFXQSxPQUFPLE1BQU0sV0FBVztRQUNyRixJQUFJLENBQUNDLE1BQU07WUFDVCxNQUFNLElBQUlDLE1BQU07UUFDbEI7UUFFQSxPQUFPdlMsT0FDSndTLFVBQVUsQ0FBQ0YsTUFDWEcsTUFBTSxDQUFDLElBQUksQ0FBQ0MsYUFBYSxFQUN6QkMsTUFBTSxHQUNOclEsS0FBSyxDQUFDLEdBQUcrUCxNQUFNO0lBQ3BCO0lBRUFuRSxhQUFhYixHQUFHLEVBQUU7UUFDaEIsSUFBSSxDQUFDLElBQUksQ0FBQ3FGLGFBQWEsRUFBRTtZQUN2QixNQUFNLElBQUluTixVQUFVO1FBQ3RCO1FBRUEsSUFBSSx1QkFBdUI0TSxJQUFJLENBQUM5RSxNQUFNO1lBQ3BDLE9BQU8sSUFBSSxDQUFDK0UsZ0JBQWdCLENBQUMxUCxTQUFTa1EsT0FBT0MsRUFBRSxFQUFFO1FBQ25EO1FBRUEsSUFBSSxrQ0FBa0NWLElBQUksQ0FBQzlFLE1BQU07WUFDL0MsT0FBTyxJQUFJLENBQUMrRSxnQkFBZ0IsQ0FBQzFQLFNBQVNrUSxPQUFPRSxFQUFFLElBQUlGLE9BQU9DLEVBQUUsRUFBRTtRQUNoRTtRQUVBLE9BQU8sSUFBSUUsY0FBY0MsTUFBTSxDQUFDLElBQUksQ0FBQ04sYUFBYTtJQUNwRDtJQUVBLE1BQU01RyxNQUFNaEMsSUFBSSxFQUFFLEVBQUVTLHNCQUFzQixFQUFFQyxJQUFJLEVBQUUsR0FBRyxDQUFDLENBQUMsRUFBRTRHLEtBQUssRUFBRTtRQUM5RHJRLDBCQUEwQixJQUFJLENBQUMrRSxNQUFNLEVBQUU7UUFDdkMsTUFBTThFLFdBQVcsTUFBTS9JLGtCQUFrQnlDLElBQUksQ0FDM0MsSUFBSSxFQUNKLFNBQ0E7WUFDRTJPLE1BQU1uSjtZQUNOMEgsY0FBYztRQUNoQixHQUNBO1lBQUVqSDtZQUF3QkM7UUFBSztRQUVqQyxJQUFJMEk7UUFDSixJQUFJO1lBQ0ZBLGVBQWVoUyxnQkFBZ0IwSjtRQUNqQyxFQUFFLE9BQU8xRSxLQUFLO1lBQ1osSUFBSWtMLFVBQVV4TyxnQkFBZ0JzRCxlQUFlOUUsV0FBVzhFLElBQUlrRixLQUFLLEtBQUssa0JBQWtCO2dCQUN0RixPQUFPLElBQUksQ0FBQ1UsS0FBSyxDQUFDaEMsTUFBTTtvQkFBRVM7b0JBQXdCQztnQkFBSyxHQUFHNUg7WUFDNUQ7WUFDQSxNQUFNc0Q7UUFDUjtRQUVBLE9BQU8sSUFBSS9FLFNBQVMrUjtJQUN0QjtJQUVBLE1BQU1DLG9CQUFvQmxQLFNBQVMsQ0FBQyxDQUFDLEVBQUUsRUFBRXFHLFlBQVksRUFBRUMsc0JBQXNCLEVBQUVDLElBQUksRUFBRSxHQUFHLENBQUMsQ0FBQyxFQUFFO1FBQzFGekosMEJBQTBCLElBQUksQ0FBQytFLE1BQU0sRUFBRTtRQUN2Qy9FLDBCQUEwQixJQUFJLENBQUMrRSxNQUFNLEVBQUU7UUFFdkMsTUFBTWdFLE9BQU85RixvQkFBb0JNLElBQUksQ0FBQyxJQUFJLEVBQUU7WUFDMUNILFdBQVcsSUFBSSxDQUFDQSxTQUFTO1lBQ3pCSSxjQUFjO1lBQ2RGLGVBQWU7WUFDZixHQUFHSixNQUFNO1FBQ1g7UUFFQSxNQUFNMkcsV0FBVyxNQUFNL0ksa0JBQWtCeUMsSUFBSSxDQUMzQyxJQUFJLEVBQ0osd0JBQ0E7WUFDRWtOLGNBQWM7WUFDZHlCLE1BQU1uSjtRQUNSLEdBQ0E7WUFBRVM7WUFBd0I2SSxvQkFBb0I7UUFBUTtRQUV4RCxNQUFNRixlQUFlaFMsZ0JBQWdCMEo7UUFFckMsT0FBTyxJQUFJM0ksaUJBQWlCO1lBQzFCMEQsUUFBUSxJQUFJO1lBQ1oyRTtZQUNBQztZQUNBSyxVQUFVc0k7WUFDVjdFLFFBQVFwSyxPQUFPOEcsT0FBTztZQUN0QlA7UUFDRjtJQUNGO0lBRUEsTUFBTTZJLE9BQU9sUSxLQUFLLEVBQUVtUSxJQUFJLEVBQUUsRUFBRUMsVUFBVSxFQUFFaEosc0JBQXNCLEVBQUUsR0FBRyxDQUFDLENBQUMsRUFBRTtRQUNyRXhKLDBCQUEwQixJQUFJLENBQUMrRSxNQUFNLEVBQUU7UUFDdkMsSUFBSXdOLFNBQVN4UCxhQUFhLE9BQU93UCxTQUFTLFVBQVU7WUFDbEQsTUFBTSxJQUFJL04sVUFBVTtRQUN0QjtRQUVBLE1BQU0wTixPQUFPO1lBQUUsR0FBR00sVUFBVTtZQUFFcFE7UUFBTTtRQUVwQyxJQUFJbVEsTUFBTTtZQUNSTCxLQUFLTyxlQUFlLEdBQUdGO1FBQ3pCO1FBRUEsTUFBTTFJLFdBQVcsTUFBTS9JLGtCQUFrQnlDLElBQUksQ0FDM0MsSUFBSSxFQUNKLGNBQ0E7WUFDRTJPO1FBQ0YsR0FDQTtZQUFFMUk7UUFBdUI7UUFFM0JySixnQkFBZ0IwSixVQUFVO1lBQUVkLE1BQU07UUFBTTtJQUMxQztJQUVBLE1BQU0ySixXQUFXdFEsS0FBSyxFQUFFbVEsSUFBSSxFQUFFLEVBQUVJLGNBQWMsRUFBRW5KLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxDQUFDLEVBQUU7UUFDN0V4SiwwQkFBMEIsSUFBSSxDQUFDK0UsTUFBTSxFQUFFO1FBQ3ZDLElBQUl3TixTQUFTeFAsYUFBYSxPQUFPd1AsU0FBUyxVQUFVO1lBQ2xELE1BQU0sSUFBSS9OLFVBQVU7UUFDdEI7UUFFQSxNQUFNME4sT0FBTztZQUFFLEdBQUdTLGNBQWM7WUFBRXZRO1FBQU07UUFDeEMsSUFBSW1RLE1BQU07WUFDUkwsS0FBS08sZUFBZSxHQUFHRjtRQUN6QjtRQUVBLE1BQU0xSSxXQUFXLE1BQU0vSSxrQkFBa0J5QyxJQUFJLENBQzNDLElBQUksRUFDSixpQkFDQTtZQUFFMk87WUFBTXpCLGNBQWM7UUFBTyxHQUM3QjtZQUFFakg7UUFBdUI7UUFHM0IsTUFBTTJJLGVBQWVoUyxnQkFBZ0IwSjtRQUVyQyxPQUFPc0k7SUFDVDtJQUVBLGFBQWFTLFNBQVN2TixRQUFRLEVBQUVjLFVBQVUsQ0FBQyxDQUFDLEVBQUU7UUFDNUMsTUFBTSxFQUFFME0sa0JBQWtCLEVBQUV6TyxJQUFJLEVBQUUsR0FBRzBPLGVBQWUsR0FBRzNNO1FBRXZEbkcsMEJBQTBCLElBQUksQ0FBQytFLE1BQU0sRUFBRTtRQUV2QyxJQUFJWCxTQUFTckIsYUFBYSxDQUFFc0MsQ0FBQUEsU0FBU2pCLElBQUksSUFBSWlCLFNBQVMwTixRQUFRLEdBQUc7WUFDL0QsTUFBTTlMLFdBQVcsTUFBTTlDLFlBQVlaLElBQUksQ0FBQyxJQUFJLEVBQUVhO1lBQzlDaUIsU0FBU2pCLElBQUksR0FBRzZDLFNBQVMrTCxNQUFNO1FBQ2pDO1FBRUEsTUFBTW5KLFdBQVcsTUFBTXBKLFFBQVE4QyxJQUFJLENBQUMsSUFBSSxFQUFFO1lBQ3hDNE0sU0FBUztnQkFDUFksUUFBUTtnQkFDUixHQUFJOEIscUJBQ0E7b0JBQ0V0QyxlQUFlcE8seUJBQXlCMFE7Z0JBQzFDLElBQ0E5UCxTQUFTO1lBQ2Y7WUFDQTBOLGNBQWM7WUFDZHdDLE1BQU01TjtZQUNOaEcsS0FBSyxJQUFJLENBQUMwRixNQUFNLENBQUNtTyxxQkFBcUI7WUFDdENySyxRQUFRO1FBQ1Y7UUFDQSxNQUFNc0osZUFBZWhTLGdCQUFnQjBKLFVBQVU7WUFBRXNKLFlBQVk7WUFBS2hDLFFBQVE7UUFBSztRQUUvRSxPQUFPLElBQUksSUFBSSxDQUFDZ0IsY0FBYy9OLE1BQU0wTztJQUN0QztJQUVBLElBQUl6TixXQUFXO1FBQ2IsT0FBT3hFLE1BQU00QyxPQUFPMlAsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDL04sUUFBUSxDQUFDM0IsT0FBTztJQUN4RDtJQUVBLGFBQWEyUCxRQUFRQyxxQkFBcUIsRUFBRUMsdUJBQXVCLEVBQUVuUCxJQUFJLEVBQUUwTyxhQUFhLEVBQUU7UUFDeEYsTUFBTWpKLFdBQVcsTUFBTXBKLFFBQVE4QyxJQUFJLENBQUMsSUFBSSxFQUFFO1lBQ3hDc0YsUUFBUTtZQUNSeEosS0FBS2lVO1lBQ0w3QyxjQUFjO1lBQ2ROLFNBQVM7Z0JBQ1BJLGVBQWVwTyx5QkFBeUJvUjtnQkFDeEN4QyxRQUFRO1lBQ1Y7UUFDRjtRQUNBLE1BQU1vQixlQUFlaFMsZ0JBQWdCMEosVUFBVTtZQUFFc0gsUUFBUTtRQUFLO1FBRTlELE9BQU8sSUFBSSxJQUFJLENBQUNnQixjQUFjL04sTUFBTTBPO0lBQ3RDO0lBRUEsTUFBTVUsY0FDSkEsZ0JBQWdCLENBQUMsQ0FBQyxFQUNsQixFQUNFQyxNQUFNQyxtQkFBbUIsSUFBSSxDQUFDQywwQkFBMEIsSUFBSSxNQUFNLEVBQ2xFQyxTQUFTLEVBQ1B0SCxLQUFLdUgsaUJBQWlCLElBQUksQ0FBQ0MsNkJBQTZCLEVBQ3hEdkgsS0FBS3dILHFCQUFxQixJQUFJLENBQUNDLDZCQUE2QixJQUFJLGVBQWUsRUFDaEYsR0FBRyxDQUFDLENBQUMsRUFDUCxHQUFHLENBQUMsQ0FBQyxFQUNOO1FBQ0EsSUFBSSxDQUFDOVQsY0FBY3NULGdCQUFnQjtZQUNqQyxNQUFNLElBQUloUCxVQUFVO1FBQ3RCO1FBRUEsSUFBSXlQO1FBQ0osSUFBSXJRO1FBQ0osTUFBTXNRLE9BQU8zVDtRQUNiLE1BQU02TCxTQUFTO1lBQUVFLEtBQUtvSDtZQUFrQlMsS0FBSztRQUFzQjtRQUNuRSxNQUFNdlIsVUFBVWtCLEtBQUtDLFNBQVMsQ0FDNUJsRSxTQUFTLENBQUMsR0FBRzJULGVBQWU7WUFDMUJySixLQUFLLElBQUksQ0FBQy9HLFNBQVM7WUFDbkIwTCxLQUFLLElBQUksQ0FBQy9KLE1BQU0sQ0FBQ0EsTUFBTTtZQUN2QjNCLFdBQVcsSUFBSSxDQUFDQSxTQUFTO1lBQ3pCZ1IsS0FBSzVUO1lBQ0w2TixLQUFLNkY7WUFDTHJGLEtBQUtxRixPQUFPO1lBQ1osR0FBSSxJQUFJLENBQUN2TixJQUFJLEtBQUs7Z0JBQUVpSSxLQUFLc0Y7WUFBSyxJQUFJblIsU0FBUztRQUM3QztRQUVGLElBQUkyUSxxQkFBcUIsUUFBUTtZQUMvQk8sU0FBUztnQkFBQ3JVLFVBQVVxUyxNQUFNLENBQUNuTyxLQUFLQyxTQUFTLENBQUNxSTtnQkFBVXhNLFVBQVVxUyxNQUFNLENBQUNyUDtnQkFBVTthQUFHLENBQUNtRixJQUFJLENBQUM7UUFDMUYsT0FBTztZQUNMLE1BQU1zTSxZQUFZWCxpQkFBaUJyRSxVQUFVLENBQUM7WUFDOUMsSUFBSWdGLFdBQVc7Z0JBQ2J6USxNQUFNLElBQUksQ0FBQ3VKLFlBQVksQ0FBQ3VHO1lBQzFCLE9BQU87Z0JBQ0wsTUFBTXpNLFdBQVcsTUFBTXRHLFVBQVVvRyxHQUFHLENBQUMsSUFBSTtnQkFFekMsSUFBSSxDQUFDRSxVQUFVO29CQUNiLE1BQU0sSUFBSXpDLFVBQ1IsQ0FBQyxzREFBc0QsRUFBRWtQLGlCQUFpQixDQUFDO2dCQUUvRTtnQkFDQTlQLE1BQU1xRCxTQUFTRixHQUFHLENBQUM7b0JBQUV1RixLQUFLb0g7b0JBQWtCM0csS0FBSztnQkFBTTtnQkFDdkQsSUFBSSxDQUFDbkosS0FBSztvQkFDUixNQUFNLElBQUlZLFVBQVUsQ0FBQyxrQ0FBa0MsRUFBRWtQLGlCQUFpQixDQUFDO2dCQUM3RTtZQUNGO1lBRUFPLFNBQVMsTUFBTSxJQUFJelUsS0FBSzhVLFdBQVcsQ0FBQyxJQUFJdEMsY0FBY0MsTUFBTSxDQUFDclAsVUFDMUQyUixrQkFBa0IsQ0FBQztnQkFDbEIsR0FBR25JLE1BQU07Z0JBQ1RvSSxLQUFLSCxZQUFZdFIsWUFBWWEsSUFBSXVLLEdBQUcsQ0FBQ3FHLEdBQUc7WUFDMUMsR0FDQ2YsSUFBSSxDQUFDWSxZQUFZelEsTUFBTSxNQUFNQSxJQUFJcUosU0FBUyxDQUFDeUc7UUFDaEQ7UUFFQSxJQUFJLENBQUNHLGdCQUFnQjtZQUNuQixPQUFPSTtRQUNUO1FBRUEsTUFBTVEsU0FBUztZQUFFbkksS0FBS3VIO1lBQWdCdEgsS0FBS3dIO1lBQW9CVyxLQUFLO1FBQXNCO1FBRTFGLElBQUlELE9BQU9uSSxHQUFHLENBQUNLLEtBQUssQ0FBQyxnQkFBZ0I7WUFDbkMsQ0FBQy9JLElBQUksR0FBRyxNQUFNM0MsY0FBY3NDLElBQUksQ0FDOUIsSUFBSSxDQUFDd0IsTUFBTSxFQUNYO2dCQUFFdUgsS0FBS21JLE9BQU9uSSxHQUFHO2dCQUFFUyxLQUFLO1lBQU0sR0FDOUI7Z0JBQUU0SCxZQUFZO1lBQUs7UUFFdkIsT0FBTztZQUNML1EsTUFBTSxJQUFJLENBQUN1SixZQUFZLENBQUNzSCxPQUFPbkksR0FBRyxLQUFLLFFBQVFtSSxPQUFPbEksR0FBRyxHQUFHa0ksT0FBT25JLEdBQUc7UUFDeEU7UUFFQSxPQUFPLElBQUk5TSxLQUFLb1YsY0FBYyxDQUFDLElBQUk1QyxjQUFjQyxNQUFNLENBQUNnQyxTQUNyRE0sa0JBQWtCLENBQUM7WUFDbEIsR0FBR0UsTUFBTTtZQUNURCxLQUFLNVEsZUFBZTRMLGFBQWF6TSxZQUFZYSxJQUFJdUssR0FBRyxDQUFDcUcsR0FBRztRQUMxRCxHQUNDWixPQUFPLENBQUNoUSxlQUFlNEwsYUFBYTVMLE1BQU0sTUFBTUEsSUFBSXFKLFNBQVMsQ0FBQ3dILE9BQU9uSSxHQUFHO0lBQzdFO0lBRUEsTUFBTXVJLDJCQUEyQjNSLFNBQVMsQ0FBQyxDQUFDLEVBQUUsRUFBRXNHLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxDQUFDLEVBQUU7UUFDN0V4SiwwQkFBMEIsSUFBSSxDQUFDK0UsTUFBTSxFQUFFO1FBRXZDLE1BQU1nRSxPQUFPO1lBQ1gsR0FBSSxhQUFhN0YsU0FBU0EsU0FBU0Qsb0JBQW9CTSxJQUFJLENBQUMsSUFBSSxFQUFFTCxPQUFPO1lBQ3pFRSxXQUFXLElBQUksQ0FBQ0EsU0FBUztRQUMzQjtRQUVBLE1BQU15RyxXQUFXLE1BQU0vSSxrQkFBa0J5QyxJQUFJLENBQzNDLElBQUksRUFDSixnQ0FDQTtZQUNFa04sY0FBYztZQUNkeUIsTUFBTW5KO1FBQ1IsR0FDQTtZQUFFUztZQUF3QjZJLG9CQUFvQjtRQUFRO1FBRXhELE1BQU1GLGVBQWVoUyxnQkFBZ0IwSixVQUFVO1lBQUVzSixZQUFZO1FBQUk7UUFFakUsSUFBSSxDQUFFLGlCQUFnQmhCLFlBQVcsR0FBSTtZQUNuQyxNQUFNLElBQUk3UixRQUFRO2dCQUNoQjBDLFNBQVM7Z0JBQ1Q2RztZQUNGO1FBQ0Y7UUFDQSxJQUFJLE9BQU9zSSxhQUFhMkMsVUFBVSxLQUFLLFVBQVU7WUFDL0MsTUFBTSxJQUFJeFUsUUFBUTtnQkFDaEIwQyxTQUFTO2dCQUNUNkc7WUFDRjtRQUNGO1FBQ0EsSUFBSSxDQUFFLGtCQUFpQnNJLFlBQVcsR0FBSTtZQUNwQyxNQUFNLElBQUk3UixRQUFRO2dCQUNoQjBDLFNBQVM7Z0JBQ1Q2RztZQUNGO1FBQ0Y7UUFDQSxJQUFJLE9BQU9zSSxhQUFhNEMsV0FBVyxLQUFLLFVBQVU7WUFDaEQsTUFBTSxJQUFJelUsUUFBUTtnQkFDaEIwQyxTQUFTO2dCQUNUNkc7WUFDRjtRQUNGO1FBRUEsT0FBT3NJO0lBQ1Q7SUFFQSxJQUFJcE4sU0FBUztRQUNYLE9BQU8sSUFBSSxDQUFDLENBQUNBLE1BQU07SUFDckI7SUFFQSx3QkFBd0IsR0FDeEIsQ0FBQ2pHLFFBQVFrVyxNQUFNLENBQUMsR0FBRztRQUNqQixPQUFPLENBQUMsRUFBRSxJQUFJLENBQUM5TyxXQUFXLENBQUNtQixJQUFJLENBQUMsQ0FBQyxFQUFFdkksUUFBUSxJQUFJLENBQUN1RyxRQUFRLEVBQUU7WUFDeEQ0UCxPQUFPQztZQUNQQyxRQUFROVQsUUFBUStULE1BQU0sQ0FBQ0MsS0FBSztZQUM1QkMsU0FBUztZQUNUQyxRQUFRO1FBQ1YsR0FBRyxDQUFDO0lBQ047SUFFQTVPLE9BQU87UUFDTCxPQUFPLElBQUksQ0FBQ0gsS0FBSyxNQUFNLElBQUksQ0FBQ0UsS0FBSztJQUNuQztJQUVBRixRQUFRO1FBQ04sT0FBTyxJQUFJLENBQUNOLFdBQVcsQ0FBQ21CLElBQUksS0FBSztJQUNuQztJQUVBWCxRQUFRO1FBQ04sT0FBTyxJQUFJLENBQUNSLFdBQVcsQ0FBQ21CLElBQUksS0FBSztJQUNuQztJQUVBLE1BQU15QyxhQUFhRCxRQUFRLEVBQUU7UUFDM0IsTUFBTXlCLGNBQWMsSUFBSSxDQUFDL0UsaUNBQWlDO1FBQzFELE1BQU0sRUFBRTNELE9BQU8sRUFBRSxHQUFHLE1BQU0sSUFBSSxDQUFDaUosV0FBVyxDQUFDaEMsVUFBVXlCLGFBQWE7WUFBQztZQUFPO1lBQU87U0FBTTtRQUN2RixPQUFPckosT0FBT1c7SUFDaEI7SUFFQTs7O0dBR0MsR0FDRCxNQUFNNFMsVUFBVTVTLE9BQU8sRUFBRTZTLGVBQWUsRUFBRXZGLFdBQVcsRUFBRTtRQUNyRCxJQUFJLENBQUNoUSxjQUFjMEMsVUFBVTtZQUMzQixNQUFNLElBQUk0QixVQUFVO1FBQ3RCO1FBRUEsSUFBSWtSO1FBQ0osSUFBSWhXLFlBQVkrVixrQkFBa0I7WUFDaENDLGFBQWFEO1FBQ2YsT0FBTyxJQUFJQSxlQUFlLENBQUMzVCxPQUFPNlQsV0FBVyxDQUFDLEtBQUssYUFBYTtZQUM5REQsYUFBYUQ7UUFDZixPQUFPLElBQUlqVyxLQUFLb1csYUFBYSxLQUFLLGVBQWU7WUFDL0NGLGFBQWF6VyxPQUFPNFcsZ0JBQWdCLENBQUNKO1FBQ3ZDLE9BQU87WUFDTCxNQUFNLElBQUlqUixVQUFVO1FBQ3RCO1FBRUEsSUFBSWtSLFdBQVdsTCxJQUFJLEtBQUssV0FBVztZQUNqQyxNQUFNLElBQUloRyxVQUFVO1FBQ3RCO1FBQ0EsSUFBSThILE1BQU13Six1QkFBdUJ2UyxJQUFJLENBQUMsSUFBSSxFQUFFbVMsWUFBWUQ7UUFFeEQsSUFBSSxDQUFDbkosS0FBSztZQUNSLE1BQU0sSUFBSTlILFVBQVU7UUFDdEI7UUFFQSxPQUFPLElBQUloRixLQUFLdVcsT0FBTyxDQUFDO1lBQ3RCQyxLQUFLOUYsY0FDRHRRLFVBQVVxUyxNQUFNLENBQUNoVCxPQUFPd1MsVUFBVSxDQUFDLFVBQVVDLE1BQU0sQ0FBQ3hCLGFBQWEwQixNQUFNLE1BQ3ZFN087WUFDSixHQUFHSCxPQUFPO1FBQ1osR0FDRzJSLGtCQUFrQixDQUFDO1lBQ2xCakk7WUFDQTZILEtBQUs7WUFDTGhHLEtBQUssTUFBTThILE9BQU9QLFlBQVlEO1FBQ2hDLEdBQ0NTLFdBQVcsR0FDWEMsTUFBTSxDQUFDM1YsVUFDUGlULElBQUksQ0FBQ2lDO0lBQ1Y7QUFDRjtBQUVBLFNBQVNVLG9DQUFvQ0MsU0FBUztJQUNwRCxPQUFRQSxVQUFVQyxTQUFTLENBQUNqUCxJQUFJO1FBQzlCLEtBQUs7UUFDTCxLQUFLO1lBQ0gsT0FBTztRQUNULEtBQUs7WUFBUztnQkFDWixPQUFRZ1AsVUFBVUMsU0FBUyxDQUFDQyxVQUFVO29CQUNwQyxLQUFLO3dCQUNILE9BQU87b0JBQ1QsS0FBSzt3QkFDSCxPQUFPO29CQUNULEtBQUs7d0JBQ0gsT0FBTztvQkFDVDt3QkFDRTtnQkFDSjtnQkFDQTtZQUNGO1FBQ0EsS0FBSztZQUNILE9BQU8sQ0FBQyxFQUFFLEVBQUVGLFVBQVVDLFNBQVMsQ0FBQy9FLElBQUksQ0FBQ2xLLElBQUksQ0FBQzlGLEtBQUssQ0FBQyxHQUFHLENBQUM7UUFDdEQsS0FBSztZQUNILE9BQU8sQ0FBQyxFQUFFLEVBQUU4VSxVQUFVQyxTQUFTLENBQUMvRSxJQUFJLENBQUNsSyxJQUFJLENBQUM5RixLQUFLLENBQUMsR0FBRyxDQUFDO1FBQ3REO1lBQ0UsTUFBTSxJQUFJaUQsVUFBVTtJQUN4QjtBQUNGO0FBRUEsSUFBSXNSO0FBQ0osSUFBSXRXLEtBQUtvVyxhQUFhLEtBQUssZUFBZTtJQUN4Q0UseUJBQXlCLFNBQVVKLFVBQVUsRUFBRUQsZUFBZTtRQUM1RCxJQUFJQSxlQUFlLENBQUMzVCxPQUFPNlQsV0FBVyxDQUFDLEtBQUssYUFBYTtZQUN2RCxPQUFPUyxvQ0FBb0NWO1FBQzdDO1FBRUEsT0FBUUEsV0FBV2MsaUJBQWlCO1lBQ2xDLEtBQUs7WUFDTCxLQUFLO2dCQUNILE9BQU87WUFDVCxLQUFLO2dCQUNILE9BQU9DLHFCQUFxQmYsWUFBWUQ7WUFDMUMsS0FBSztZQUNMLEtBQUs3VCxnQkFBZ0I7Z0JBQ25CLE9BQU84VSxzQkFDTGhCLFlBQ0FELGlCQUNBLElBQUksQ0FBQzFRLE1BQU0sQ0FBQzRSLGlDQUFpQztZQUVqRDtnQkFDRSxNQUFNLElBQUluUyxVQUFVO1FBQ3hCO0lBQ0Y7SUFFQSxNQUFNb1MsT0FBTztJQUNiLFNBQVNGLHNCQUFzQmhCLFVBQVUsRUFBRUQsZUFBZSxFQUFFb0IsZUFBZTtRQUN6RSxJQUNFLE9BQU9wQixvQkFBb0IsWUFDM0JBLGdCQUFnQmhOLE1BQU0sS0FBSyxTQUMzQmdOLGdCQUFnQjdSLEdBQUcsSUFDbkI2UixnQkFBZ0I3UixHQUFHLENBQUMwSSxHQUFHLEVBQ3ZCO1lBQ0EsT0FBT21KLGdCQUFnQjdSLEdBQUcsQ0FBQzBJLEdBQUc7UUFDaEM7UUFFQSxJQUFJdEksTUFBTUMsT0FBTyxDQUFDNFMsa0JBQWtCO1lBQ2xDLElBQUlDLGFBQWFELGdCQUFnQkUsTUFBTSxDQUFDbEYsT0FBT21GLFNBQVMsQ0FBQzVGLElBQUksQ0FBQzNDLElBQUksQ0FBQ21JO1lBQ25FLElBQUlsQixXQUFXYyxpQkFBaUIsS0FBSyxXQUFXO2dCQUM5Q00sYUFBYUEsV0FBV0MsTUFBTSxDQUFDLENBQUNsVCxRQUFVQSxNQUFNd0wsVUFBVSxDQUFDO1lBQzdEO1lBQ0EsT0FBTztnQkFBQztnQkFBUztnQkFBUztnQkFBUztnQkFBUztnQkFBUzthQUFRLENBQUM0SCxJQUFJLENBQUMsQ0FBQ0MsWUFDbEVKLFdBQVc3UixRQUFRLENBQUNpUztRQUV4QjtRQUVBLE9BQU87SUFDVDtJQUVBLE1BQU1DLE9BQU9uTyxPQUFPb08sSUFBSSxDQUFDO1FBQUM7UUFBSTtRQUFLO1FBQUk7UUFBSztRQUFJO1FBQUc7UUFBRztLQUFFO0lBQ3hELE1BQU1DLE9BQU9yTyxPQUFPb08sSUFBSSxDQUFDO1FBQUM7UUFBSTtRQUFLO1FBQUc7UUFBRztLQUFHO0lBQzVDLE1BQU1FLE9BQU90TyxPQUFPb08sSUFBSSxDQUFDO1FBQUM7UUFBSTtRQUFLO1FBQUc7UUFBRztLQUFHO0lBQzVDLE1BQU1HLFlBQVl2TyxPQUFPb08sSUFBSSxDQUFDO1FBQUM7UUFBSTtRQUFLO1FBQUc7UUFBRztLQUFHO0lBRWpELFNBQVNYLHFCQUFxQmYsVUFBVSxFQUFFRCxlQUFlO1FBQ3ZELHFCQUFxQjtRQUNyQixPQUNFLE9BQU9BLG9CQUFvQixZQUMzQixPQUFPQSxnQkFBZ0I3UixHQUFHLEtBQUssWUFDL0I2UixnQkFBZ0I3UixHQUFHLENBQUN3SyxHQUFHO1lBRXZCLEtBQUs7Z0JBQ0gsT0FBTztZQUNULEtBQUs7Z0JBQ0gsT0FBTztZQUNULEtBQUs7Z0JBQ0gsT0FBTztZQUNULEtBQUs7Z0JBQ0gsT0FBTztZQUNUO2dCQUNFO1FBQ0o7UUFFQSxNQUFNb0osTUFBTTlCLFdBQVcrQixNQUFNLENBQUM7WUFBRWhQLFFBQVE7WUFBTytCLE1BQU07UUFBUTtRQUM3RCxNQUFNa04sSUFBSUYsR0FBRyxDQUFDLEVBQUUsR0FBRyxNQUFNLEtBQUs7UUFDOUIsTUFBTWxHLE1BQU1rRyxHQUFHLENBQUNFLEVBQUU7UUFDbEIsTUFBTUMsV0FBV0gsSUFBSWpXLEtBQUssQ0FBQ21XLElBQUksR0FBR0EsSUFBSSxJQUFJcEc7UUFDMUMsSUFBSXFHLFNBQVNDLE1BQU0sQ0FBQ1QsT0FBTztZQUN6QixPQUFPO1FBQ1Q7UUFFQSxJQUFJUSxTQUFTQyxNQUFNLENBQUNQLE9BQU87WUFDekIsT0FBTztRQUNUO1FBQ0EsSUFBSU0sU0FBU0MsTUFBTSxDQUFDTixPQUFPO1lBQ3pCLE9BQU87UUFDVDtRQUVBLElBQUlLLFNBQVNDLE1BQU0sQ0FBQ0wsWUFBWTtZQUM5QixPQUFPO1FBQ1Q7UUFFQSxNQUFNLElBQUkvUyxVQUFVO0lBQ3RCO0FBQ0YsT0FBTztJQUNMc1IseUJBQXlCTTtBQUMzQjtBQUVBLE1BQU15QixXQUFXLElBQUlDO0FBQ3JCLGVBQWU3QixPQUFPaEosU0FBUyxFQUFFd0ksZUFBZTtJQUM5QyxJQUNFalcsS0FBS29XLGFBQWEsS0FBSyxpQkFDdkIsT0FBT0gsb0JBQW9CLFlBQzNCLE9BQU9BLGdCQUFnQjdSLEdBQUcsS0FBSyxZQUMvQjZSLGdCQUFnQmhOLE1BQU0sS0FBSyxPQUMzQjtRQUNBLE9BQU94SSxLQUFLd1YsZ0JBQWdCN1IsR0FBRyxFQUFFLE9BQU8sT0FBTyxLQUFLLEtBQUssS0FBSztJQUNoRTtJQUVBLElBQUlpVSxTQUFTRSxHQUFHLENBQUN0QyxrQkFBa0I7UUFDakMsT0FBT29DLFNBQVM5USxHQUFHLENBQUMwTztJQUN0QjtJQUVBLE1BQU10SCxNQUFNbE8sS0FBSyxNQUFNVCxLQUFLd1ksU0FBUyxDQUFDL0ssWUFBWSxPQUFPLE9BQU8sS0FBSyxLQUFLLEtBQUs7SUFFL0UsSUFBSXZOLFlBQVkrVixvQkFBb0JqVyxLQUFLb1csYUFBYSxLQUFLLGdCQUFnQjtRQUN6RWlDLFNBQVNoUixHQUFHLENBQUM0TyxpQkFBaUJ0SDtJQUNoQztJQUVBLE9BQU9BO0FBQ1Q7QUFFQThKLE9BQU9DLE9BQU8sR0FBRyxDQUFDblQsUUFBUWlCLG1CQUFtQixLQUFLLEdBQ2hELE1BQU1tUyxlQUFlcFM7UUFDbkJHLFlBQVksR0FBR2tTLElBQUksQ0FBRTtZQUNuQixLQUFLLENBQUNyVCxRQUFRaUIscUJBQXFCb1M7UUFDckM7UUFFQSxXQUFXclQsU0FBUztZQUNsQixPQUFPQTtRQUNUO0lBQ0Y7QUFFRmtULHlCQUF5QixHQUFHbFMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbGliL2NsaWVudC5qcz9kNGZjIl0sInNvdXJjZXNDb250ZW50IjpbImNvbnN0IHsgaW5zcGVjdCB9ID0gcmVxdWlyZSgndXRpbCcpO1xuY29uc3Qgc3RkaHR0cCA9IHJlcXVpcmUoJ2h0dHAnKTtcbmNvbnN0IGNyeXB0byA9IHJlcXVpcmUoJ2NyeXB0bycpO1xuY29uc3QgeyBzdHJpY3Q6IGFzc2VydCB9ID0gcmVxdWlyZSgnYXNzZXJ0Jyk7XG5jb25zdCBxdWVyeXN0cmluZyA9IHJlcXVpcmUoJ3F1ZXJ5c3RyaW5nJyk7XG5jb25zdCB1cmwgPSByZXF1aXJlKCd1cmwnKTtcbmNvbnN0IHsgVVJMLCBVUkxTZWFyY2hQYXJhbXMgfSA9IHJlcXVpcmUoJ3VybCcpO1xuXG5jb25zdCBqb3NlID0gcmVxdWlyZSgnam9zZScpO1xuY29uc3QgdG9rZW5IYXNoID0gcmVxdWlyZSgnb2lkYy10b2tlbi1oYXNoJyk7XG5cbmNvbnN0IGlzS2V5T2JqZWN0ID0gcmVxdWlyZSgnLi9oZWxwZXJzL2lzX2tleV9vYmplY3QnKTtcbmNvbnN0IGRlY29kZUpXVCA9IHJlcXVpcmUoJy4vaGVscGVycy9kZWNvZGVfand0Jyk7XG5jb25zdCBiYXNlNjR1cmwgPSByZXF1aXJlKCcuL2hlbHBlcnMvYmFzZTY0dXJsJyk7XG5jb25zdCBkZWZhdWx0cyA9IHJlcXVpcmUoJy4vaGVscGVycy9kZWZhdWx0cycpO1xuY29uc3QgcGFyc2VXd3dBdXRoZW50aWNhdGUgPSByZXF1aXJlKCcuL2hlbHBlcnMvd3d3X2F1dGhlbnRpY2F0ZV9wYXJzZXInKTtcbmNvbnN0IHsgYXNzZXJ0U2lnbmluZ0FsZ1ZhbHVlc1N1cHBvcnQsIGFzc2VydElzc3VlckNvbmZpZ3VyYXRpb24gfSA9IHJlcXVpcmUoJy4vaGVscGVycy9hc3NlcnQnKTtcbmNvbnN0IHBpY2sgPSByZXF1aXJlKCcuL2hlbHBlcnMvcGljaycpO1xuY29uc3QgaXNQbGFpbk9iamVjdCA9IHJlcXVpcmUoJy4vaGVscGVycy9pc19wbGFpbl9vYmplY3QnKTtcbmNvbnN0IHByb2Nlc3NSZXNwb25zZSA9IHJlcXVpcmUoJy4vaGVscGVycy9wcm9jZXNzX3Jlc3BvbnNlJyk7XG5jb25zdCBUb2tlblNldCA9IHJlcXVpcmUoJy4vdG9rZW5fc2V0Jyk7XG5jb25zdCB7IE9QRXJyb3IsIFJQRXJyb3IgfSA9IHJlcXVpcmUoJy4vZXJyb3JzJyk7XG5jb25zdCBub3cgPSByZXF1aXJlKCcuL2hlbHBlcnMvdW5peF90aW1lc3RhbXAnKTtcbmNvbnN0IHsgcmFuZG9tIH0gPSByZXF1aXJlKCcuL2hlbHBlcnMvZ2VuZXJhdG9ycycpO1xuY29uc3QgcmVxdWVzdCA9IHJlcXVpcmUoJy4vaGVscGVycy9yZXF1ZXN0Jyk7XG5jb25zdCB7IENMT0NLX1RPTEVSQU5DRSB9ID0gcmVxdWlyZSgnLi9oZWxwZXJzL2NvbnN0cycpO1xuY29uc3QgeyBrZXlzdG9yZXMgfSA9IHJlcXVpcmUoJy4vaGVscGVycy93ZWFrX2NhY2hlJyk7XG5jb25zdCBLZXlTdG9yZSA9IHJlcXVpcmUoJy4vaGVscGVycy9rZXlzdG9yZScpO1xuY29uc3QgY2xvbmUgPSByZXF1aXJlKCcuL2hlbHBlcnMvZGVlcF9jbG9uZScpO1xuY29uc3QgeyBhdXRoZW50aWNhdGVkUG9zdCwgcmVzb2x2ZVJlc3BvbnNlVHlwZSwgcmVzb2x2ZVJlZGlyZWN0VXJpIH0gPSByZXF1aXJlKCcuL2hlbHBlcnMvY2xpZW50Jyk7XG5jb25zdCB7IHF1ZXJ5S2V5U3RvcmUgfSA9IHJlcXVpcmUoJy4vaGVscGVycy9pc3N1ZXInKTtcbmNvbnN0IERldmljZUZsb3dIYW5kbGUgPSByZXF1aXJlKCcuL2RldmljZV9mbG93X2hhbmRsZScpO1xuXG5jb25zdCBbbWFqb3IsIG1pbm9yXSA9IHByb2Nlc3MudmVyc2lvblxuICAuc2xpY2UoMSlcbiAgLnNwbGl0KCcuJylcbiAgLm1hcCgoc3RyKSA9PiBwYXJzZUludChzdHIsIDEwKSk7XG5cbmNvbnN0IHJzYVBzc1BhcmFtcyA9IG1ham9yID49IDE3IHx8IChtYWpvciA9PT0gMTYgJiYgbWlub3IgPj0gOSk7XG5jb25zdCByZXRyeUF0dGVtcHQgPSBTeW1ib2woKTtcbmNvbnN0IHNraXBOb25jZUNoZWNrID0gU3ltYm9sKCk7XG5jb25zdCBza2lwTWF4QWdlQ2hlY2sgPSBTeW1ib2woKTtcblxuZnVuY3Rpb24gcGlja0NiKGlucHV0KSB7XG4gIHJldHVybiBwaWNrKFxuICAgIGlucHV0LFxuICAgICdhY2Nlc3NfdG9rZW4nLCAvLyBPQXV0aCAyLjBcbiAgICAnY29kZScsIC8vIE9BdXRoIDIuMFxuICAgICdlcnJvcl9kZXNjcmlwdGlvbicsIC8vIE9BdXRoIDIuMFxuICAgICdlcnJvcl91cmknLCAvLyBPQXV0aCAyLjBcbiAgICAnZXJyb3InLCAvLyBPQXV0aCAyLjBcbiAgICAnZXhwaXJlc19pbicsIC8vIE9BdXRoIDIuMFxuICAgICdpZF90b2tlbicsIC8vIE9JREMgQ29yZSAxLjBcbiAgICAnaXNzJywgLy8gZHJhZnQtaWV0Zi1vYXV0aC1pc3MtYXV0aC1yZXNwXG4gICAgJ3Jlc3BvbnNlJywgLy8gRkFQSSBKQVJNXG4gICAgJ3Nlc3Npb25fc3RhdGUnLCAvLyBPSURDIFNlc3Npb24gTWFuYWdlbWVudFxuICAgICdzdGF0ZScsIC8vIE9BdXRoIDIuMFxuICAgICd0b2tlbl90eXBlJywgLy8gT0F1dGggMi4wXG4gICk7XG59XG5cbmZ1bmN0aW9uIGF1dGhvcml6YXRpb25IZWFkZXJWYWx1ZSh0b2tlbiwgdG9rZW5UeXBlID0gJ0JlYXJlcicpIHtcbiAgcmV0dXJuIGAke3Rva2VuVHlwZX0gJHt0b2tlbn1gO1xufVxuXG5mdW5jdGlvbiBnZXRTZWFyY2hQYXJhbXMoaW5wdXQpIHtcbiAgY29uc3QgcGFyc2VkID0gdXJsLnBhcnNlKGlucHV0KTtcbiAgaWYgKCFwYXJzZWQuc2VhcmNoKSByZXR1cm4ge307XG4gIHJldHVybiBxdWVyeXN0cmluZy5wYXJzZShwYXJzZWQuc2VhcmNoLnN1YnN0cmluZygxKSk7XG59XG5cbmZ1bmN0aW9uIHZlcmlmeVByZXNlbmNlKHBheWxvYWQsIGp3dCwgcHJvcCkge1xuICBpZiAocGF5bG9hZFtwcm9wXSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgbWVzc2FnZTogYG1pc3NpbmcgcmVxdWlyZWQgSldUIHByb3BlcnR5ICR7cHJvcH1gLFxuICAgICAgand0LFxuICAgIH0pO1xuICB9XG59XG5cbmZ1bmN0aW9uIGF1dGhvcml6YXRpb25QYXJhbXMocGFyYW1zKSB7XG4gIGNvbnN0IGF1dGhQYXJhbXMgPSB7XG4gICAgY2xpZW50X2lkOiB0aGlzLmNsaWVudF9pZCxcbiAgICBzY29wZTogJ29wZW5pZCcsXG4gICAgcmVzcG9uc2VfdHlwZTogcmVzb2x2ZVJlc3BvbnNlVHlwZS5jYWxsKHRoaXMpLFxuICAgIHJlZGlyZWN0X3VyaTogcmVzb2x2ZVJlZGlyZWN0VXJpLmNhbGwodGhpcyksXG4gICAgLi4ucGFyYW1zLFxuICB9O1xuXG4gIE9iamVjdC5lbnRyaWVzKGF1dGhQYXJhbXMpLmZvckVhY2goKFtrZXksIHZhbHVlXSkgPT4ge1xuICAgIGlmICh2YWx1ZSA9PT0gbnVsbCB8fCB2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICBkZWxldGUgYXV0aFBhcmFtc1trZXldO1xuICAgIH0gZWxzZSBpZiAoa2V5ID09PSAnY2xhaW1zJyAmJiB0eXBlb2YgdmFsdWUgPT09ICdvYmplY3QnKSB7XG4gICAgICBhdXRoUGFyYW1zW2tleV0gPSBKU09OLnN0cmluZ2lmeSh2YWx1ZSk7XG4gICAgfSBlbHNlIGlmIChrZXkgPT09ICdyZXNvdXJjZScgJiYgQXJyYXkuaXNBcnJheSh2YWx1ZSkpIHtcbiAgICAgIGF1dGhQYXJhbXNba2V5XSA9IHZhbHVlO1xuICAgIH0gZWxzZSBpZiAodHlwZW9mIHZhbHVlICE9PSAnc3RyaW5nJykge1xuICAgICAgYXV0aFBhcmFtc1trZXldID0gU3RyaW5nKHZhbHVlKTtcbiAgICB9XG4gIH0pO1xuXG4gIHJldHVybiBhdXRoUGFyYW1zO1xufVxuXG5mdW5jdGlvbiBnZXRLZXlzdG9yZShqd2tzKSB7XG4gIGlmIChcbiAgICAhaXNQbGFpbk9iamVjdChqd2tzKSB8fFxuICAgICFBcnJheS5pc0FycmF5KGp3a3Mua2V5cykgfHxcbiAgICBqd2tzLmtleXMuc29tZSgoaykgPT4gIWlzUGxhaW5PYmplY3QoaykgfHwgISgna3R5JyBpbiBrKSlcbiAgKSB7XG4gICAgdGhyb3cgbmV3IFR5cGVFcnJvcignandrcyBtdXN0IGJlIGEgSlNPTiBXZWIgS2V5IFNldCBmb3JtYXR0ZWQgb2JqZWN0Jyk7XG4gIH1cblxuICByZXR1cm4gS2V5U3RvcmUuZnJvbUpXS1MoandrcywgeyBvbmx5UHJpdmF0ZTogdHJ1ZSB9KTtcbn1cblxuLy8gaWYgYW4gT1AgZG9lc250IHN1cHBvcnQgY2xpZW50X3NlY3JldF9iYXNpYyBidXQgc3VwcG9ydHMgY2xpZW50X3NlY3JldF9wb3N0LCB1c2UgaXQgaW5zdGVhZFxuLy8gdGhpcyBpcyBpbiBwbGFjZSB0byB0YWtlIGNhcmUgb2YgbW9zdCBjb21tb24gcGl0ZmFsbHMgd2hlbiBmaXJzdCB1c2luZyBkaXNjb3ZlcmVkIElzc3VlcnMgd2l0aG91dFxuLy8gdGhlIHN1cHBvcnQgZm9yIGRlZmF1bHQgdmFsdWVzIGRlZmluZWQgYnkgRGlzY292ZXJ5IDEuMFxuZnVuY3Rpb24gY2hlY2tCYXNpY1N1cHBvcnQoY2xpZW50LCBwcm9wZXJ0aWVzKSB7XG4gIHRyeSB7XG4gICAgY29uc3Qgc3VwcG9ydGVkID0gY2xpZW50Lmlzc3Vlci50b2tlbl9lbmRwb2ludF9hdXRoX21ldGhvZHNfc3VwcG9ydGVkO1xuICAgIGlmICghc3VwcG9ydGVkLmluY2x1ZGVzKHByb3BlcnRpZXMudG9rZW5fZW5kcG9pbnRfYXV0aF9tZXRob2QpKSB7XG4gICAgICBpZiAoc3VwcG9ydGVkLmluY2x1ZGVzKCdjbGllbnRfc2VjcmV0X3Bvc3QnKSkge1xuICAgICAgICBwcm9wZXJ0aWVzLnRva2VuX2VuZHBvaW50X2F1dGhfbWV0aG9kID0gJ2NsaWVudF9zZWNyZXRfcG9zdCc7XG4gICAgICB9XG4gICAgfVxuICB9IGNhdGNoIChlcnIpIHt9XG59XG5cbmZ1bmN0aW9uIGhhbmRsZUNvbW1vbk1pc3Rha2VzKGNsaWVudCwgbWV0YWRhdGEsIHByb3BlcnRpZXMpIHtcbiAgaWYgKCFtZXRhZGF0YS50b2tlbl9lbmRwb2ludF9hdXRoX21ldGhvZCkge1xuICAgIC8vIGlmIG5vIGV4cGxpY2l0IHZhbHVlIHdhcyBwcm92aWRlZFxuICAgIGNoZWNrQmFzaWNTdXBwb3J0KGNsaWVudCwgcHJvcGVydGllcyk7XG4gIH1cblxuICAvLyA6ZnA6IGMnbW9uIHBlb3BsZS4uLiBSVEZNXG4gIGlmIChtZXRhZGF0YS5yZWRpcmVjdF91cmkpIHtcbiAgICBpZiAobWV0YWRhdGEucmVkaXJlY3RfdXJpcykge1xuICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcigncHJvdmlkZSBhIHJlZGlyZWN0X3VyaSBvciByZWRpcmVjdF91cmlzLCBub3QgYm90aCcpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzLnJlZGlyZWN0X3VyaXMgPSBbbWV0YWRhdGEucmVkaXJlY3RfdXJpXTtcbiAgICBkZWxldGUgcHJvcGVydGllcy5yZWRpcmVjdF91cmk7XG4gIH1cblxuICBpZiAobWV0YWRhdGEucmVzcG9uc2VfdHlwZSkge1xuICAgIGlmIChtZXRhZGF0YS5yZXNwb25zZV90eXBlcykge1xuICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcigncHJvdmlkZSBhIHJlc3BvbnNlX3R5cGUgb3IgcmVzcG9uc2VfdHlwZXMsIG5vdCBib3RoJyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMucmVzcG9uc2VfdHlwZXMgPSBbbWV0YWRhdGEucmVzcG9uc2VfdHlwZV07XG4gICAgZGVsZXRlIHByb3BlcnRpZXMucmVzcG9uc2VfdHlwZTtcbiAgfVxufVxuXG5mdW5jdGlvbiBnZXREZWZhdWx0c0ZvckVuZHBvaW50KGVuZHBvaW50LCBpc3N1ZXIsIHByb3BlcnRpZXMpIHtcbiAgaWYgKCFpc3N1ZXJbYCR7ZW5kcG9pbnR9X2VuZHBvaW50YF0pIHJldHVybjtcblxuICBjb25zdCB0b2tlbkVuZHBvaW50QXV0aE1ldGhvZCA9IHByb3BlcnRpZXMudG9rZW5fZW5kcG9pbnRfYXV0aF9tZXRob2Q7XG4gIGNvbnN0IHRva2VuRW5kcG9pbnRBdXRoU2lnbmluZ0FsZyA9IHByb3BlcnRpZXMudG9rZW5fZW5kcG9pbnRfYXV0aF9zaWduaW5nX2FsZztcblxuICBjb25zdCBlYW0gPSBgJHtlbmRwb2ludH1fZW5kcG9pbnRfYXV0aF9tZXRob2RgO1xuICBjb25zdCBlYXNhID0gYCR7ZW5kcG9pbnR9X2VuZHBvaW50X2F1dGhfc2lnbmluZ19hbGdgO1xuXG4gIGlmIChwcm9wZXJ0aWVzW2VhbV0gPT09IHVuZGVmaW5lZCAmJiBwcm9wZXJ0aWVzW2Vhc2FdID09PSB1bmRlZmluZWQpIHtcbiAgICBpZiAodG9rZW5FbmRwb2ludEF1dGhNZXRob2QgIT09IHVuZGVmaW5lZCkge1xuICAgICAgcHJvcGVydGllc1tlYW1dID0gdG9rZW5FbmRwb2ludEF1dGhNZXRob2Q7XG4gICAgfVxuICAgIGlmICh0b2tlbkVuZHBvaW50QXV0aFNpZ25pbmdBbGcgIT09IHVuZGVmaW5lZCkge1xuICAgICAgcHJvcGVydGllc1tlYXNhXSA9IHRva2VuRW5kcG9pbnRBdXRoU2lnbmluZ0FsZztcbiAgICB9XG4gIH1cbn1cblxuY2xhc3MgQmFzZUNsaWVudCB7XG4gICNtZXRhZGF0YTtcbiAgI2lzc3VlcjtcbiAgI2FhZElzc1ZhbGlkYXRpb247XG4gICNhZGRpdGlvbmFsQXV0aG9yaXplZFBhcnRpZXM7XG4gIGNvbnN0cnVjdG9yKGlzc3VlciwgYWFkSXNzVmFsaWRhdGlvbiwgbWV0YWRhdGEgPSB7fSwgandrcywgb3B0aW9ucykge1xuICAgIHRoaXMuI21ldGFkYXRhID0gbmV3IE1hcCgpO1xuICAgIHRoaXMuI2lzc3VlciA9IGlzc3VlcjtcbiAgICB0aGlzLiNhYWRJc3NWYWxpZGF0aW9uID0gYWFkSXNzVmFsaWRhdGlvbjtcblxuICAgIGlmICh0eXBlb2YgbWV0YWRhdGEuY2xpZW50X2lkICE9PSAnc3RyaW5nJyB8fCAhbWV0YWRhdGEuY2xpZW50X2lkKSB7XG4gICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCdjbGllbnRfaWQgaXMgcmVxdWlyZWQnKTtcbiAgICB9XG5cbiAgICBjb25zdCBwcm9wZXJ0aWVzID0ge1xuICAgICAgZ3JhbnRfdHlwZXM6IFsnYXV0aG9yaXphdGlvbl9jb2RlJ10sXG4gICAgICBpZF90b2tlbl9zaWduZWRfcmVzcG9uc2VfYWxnOiAnUlMyNTYnLFxuICAgICAgYXV0aG9yaXphdGlvbl9zaWduZWRfcmVzcG9uc2VfYWxnOiAnUlMyNTYnLFxuICAgICAgcmVzcG9uc2VfdHlwZXM6IFsnY29kZSddLFxuICAgICAgdG9rZW5fZW5kcG9pbnRfYXV0aF9tZXRob2Q6ICdjbGllbnRfc2VjcmV0X2Jhc2ljJyxcbiAgICAgIC4uLih0aGlzLmZhcGkxKClcbiAgICAgICAgPyB7XG4gICAgICAgICAgICBncmFudF90eXBlczogWydhdXRob3JpemF0aW9uX2NvZGUnLCAnaW1wbGljaXQnXSxcbiAgICAgICAgICAgIGlkX3Rva2VuX3NpZ25lZF9yZXNwb25zZV9hbGc6ICdQUzI1NicsXG4gICAgICAgICAgICBhdXRob3JpemF0aW9uX3NpZ25lZF9yZXNwb25zZV9hbGc6ICdQUzI1NicsXG4gICAgICAgICAgICByZXNwb25zZV90eXBlczogWydjb2RlIGlkX3Rva2VuJ10sXG4gICAgICAgICAgICB0bHNfY2xpZW50X2NlcnRpZmljYXRlX2JvdW5kX2FjY2Vzc190b2tlbnM6IHRydWUsXG4gICAgICAgICAgICB0b2tlbl9lbmRwb2ludF9hdXRoX21ldGhvZDogdW5kZWZpbmVkLFxuICAgICAgICAgIH1cbiAgICAgICAgOiB1bmRlZmluZWQpLFxuICAgICAgLi4uKHRoaXMuZmFwaTIoKVxuICAgICAgICA/IHtcbiAgICAgICAgICAgIGlkX3Rva2VuX3NpZ25lZF9yZXNwb25zZV9hbGc6ICdQUzI1NicsXG4gICAgICAgICAgICBhdXRob3JpemF0aW9uX3NpZ25lZF9yZXNwb25zZV9hbGc6ICdQUzI1NicsXG4gICAgICAgICAgICB0b2tlbl9lbmRwb2ludF9hdXRoX21ldGhvZDogdW5kZWZpbmVkLFxuICAgICAgICAgIH1cbiAgICAgICAgOiB1bmRlZmluZWQpLFxuICAgICAgLi4ubWV0YWRhdGEsXG4gICAgfTtcblxuICAgIGlmICh0aGlzLmZhcGkoKSkge1xuICAgICAgc3dpdGNoIChwcm9wZXJ0aWVzLnRva2VuX2VuZHBvaW50X2F1dGhfbWV0aG9kKSB7XG4gICAgICAgIGNhc2UgJ3NlbGZfc2lnbmVkX3Rsc19jbGllbnRfYXV0aCc6XG4gICAgICAgIGNhc2UgJ3Rsc19jbGllbnRfYXV0aCc6XG4gICAgICAgICAgYnJlYWs7XG4gICAgICAgIGNhc2UgJ3ByaXZhdGVfa2V5X2p3dCc6XG4gICAgICAgICAgaWYgKCFqd2tzKSB7XG4gICAgICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCdqd2tzIGlzIHJlcXVpcmVkJyk7XG4gICAgICAgICAgfVxuICAgICAgICAgIGJyZWFrO1xuICAgICAgICBjYXNlIHVuZGVmaW5lZDpcbiAgICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCd0b2tlbl9lbmRwb2ludF9hdXRoX21ldGhvZCBpcyByZXF1aXJlZCcpO1xuICAgICAgICBkZWZhdWx0OlxuICAgICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ2ludmFsaWQgb3IgdW5zdXBwb3J0ZWQgdG9rZW5fZW5kcG9pbnRfYXV0aF9tZXRob2QnKTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBpZiAodGhpcy5mYXBpMigpKSB7XG4gICAgICBpZiAoXG4gICAgICAgIHByb3BlcnRpZXMudGxzX2NsaWVudF9jZXJ0aWZpY2F0ZV9ib3VuZF9hY2Nlc3NfdG9rZW5zICYmXG4gICAgICAgIHByb3BlcnRpZXMuZHBvcF9ib3VuZF9hY2Nlc3NfdG9rZW5zXG4gICAgICApIHtcbiAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcihcbiAgICAgICAgICAnZWl0aGVyIHRsc19jbGllbnRfY2VydGlmaWNhdGVfYm91bmRfYWNjZXNzX3Rva2VucyBvciBkcG9wX2JvdW5kX2FjY2Vzc190b2tlbnMgbXVzdCBiZSBzZXQgdG8gdHJ1ZScsXG4gICAgICAgICk7XG4gICAgICB9XG5cbiAgICAgIGlmIChcbiAgICAgICAgIXByb3BlcnRpZXMudGxzX2NsaWVudF9jZXJ0aWZpY2F0ZV9ib3VuZF9hY2Nlc3NfdG9rZW5zICYmXG4gICAgICAgICFwcm9wZXJ0aWVzLmRwb3BfYm91bmRfYWNjZXNzX3Rva2Vuc1xuICAgICAgKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoXG4gICAgICAgICAgJ2VpdGhlciB0bHNfY2xpZW50X2NlcnRpZmljYXRlX2JvdW5kX2FjY2Vzc190b2tlbnMgb3IgZHBvcF9ib3VuZF9hY2Nlc3NfdG9rZW5zIG11c3QgYmUgc2V0IHRvIHRydWUnLFxuICAgICAgICApO1xuICAgICAgfVxuICAgIH1cblxuICAgIGhhbmRsZUNvbW1vbk1pc3Rha2VzKHRoaXMsIG1ldGFkYXRhLCBwcm9wZXJ0aWVzKTtcblxuICAgIGFzc2VydFNpZ25pbmdBbGdWYWx1ZXNTdXBwb3J0KCd0b2tlbicsIHRoaXMuaXNzdWVyLCBwcm9wZXJ0aWVzKTtcbiAgICBbJ2ludHJvc3BlY3Rpb24nLCAncmV2b2NhdGlvbiddLmZvckVhY2goKGVuZHBvaW50KSA9PiB7XG4gICAgICBnZXREZWZhdWx0c0ZvckVuZHBvaW50KGVuZHBvaW50LCB0aGlzLmlzc3VlciwgcHJvcGVydGllcyk7XG4gICAgICBhc3NlcnRTaWduaW5nQWxnVmFsdWVzU3VwcG9ydChlbmRwb2ludCwgdGhpcy5pc3N1ZXIsIHByb3BlcnRpZXMpO1xuICAgIH0pO1xuXG4gICAgT2JqZWN0LmVudHJpZXMocHJvcGVydGllcykuZm9yRWFjaCgoW2tleSwgdmFsdWVdKSA9PiB7XG4gICAgICB0aGlzLiNtZXRhZGF0YS5zZXQoa2V5LCB2YWx1ZSk7XG4gICAgICBpZiAoIXRoaXNba2V5XSkge1xuICAgICAgICBPYmplY3QuZGVmaW5lUHJvcGVydHkodGhpcywga2V5LCB7XG4gICAgICAgICAgZ2V0KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuI21ldGFkYXRhLmdldChrZXkpO1xuICAgICAgICAgIH0sXG4gICAgICAgICAgZW51bWVyYWJsZTogdHJ1ZSxcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgfSk7XG5cbiAgICBpZiAoandrcyAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBjb25zdCBrZXlzdG9yZSA9IGdldEtleXN0b3JlLmNhbGwodGhpcywgandrcyk7XG4gICAgICBrZXlzdG9yZXMuc2V0KHRoaXMsIGtleXN0b3JlKTtcbiAgICB9XG5cbiAgICBpZiAob3B0aW9ucyAhPSBudWxsICYmIG9wdGlvbnMuYWRkaXRpb25hbEF1dGhvcml6ZWRQYXJ0aWVzKSB7XG4gICAgICB0aGlzLiNhZGRpdGlvbmFsQXV0aG9yaXplZFBhcnRpZXMgPSBjbG9uZShvcHRpb25zLmFkZGl0aW9uYWxBdXRob3JpemVkUGFydGllcyk7XG4gICAgfVxuXG4gICAgdGhpc1tDTE9DS19UT0xFUkFOQ0VdID0gMDtcbiAgfVxuXG4gIGF1dGhvcml6YXRpb25VcmwocGFyYW1zID0ge30pIHtcbiAgICBpZiAoIWlzUGxhaW5PYmplY3QocGFyYW1zKSkge1xuICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcigncGFyYW1zIG11c3QgYmUgYSBwbGFpbiBvYmplY3QnKTtcbiAgICB9XG4gICAgYXNzZXJ0SXNzdWVyQ29uZmlndXJhdGlvbih0aGlzLmlzc3VlciwgJ2F1dGhvcml6YXRpb25fZW5kcG9pbnQnKTtcbiAgICBjb25zdCB0YXJnZXQgPSBuZXcgVVJMKHRoaXMuaXNzdWVyLmF1dGhvcml6YXRpb25fZW5kcG9pbnQpO1xuXG4gICAgZm9yIChjb25zdCBbbmFtZSwgdmFsdWVdIG9mIE9iamVjdC5lbnRyaWVzKGF1dGhvcml6YXRpb25QYXJhbXMuY2FsbCh0aGlzLCBwYXJhbXMpKSkge1xuICAgICAgaWYgKEFycmF5LmlzQXJyYXkodmFsdWUpKSB7XG4gICAgICAgIHRhcmdldC5zZWFyY2hQYXJhbXMuZGVsZXRlKG5hbWUpO1xuICAgICAgICBmb3IgKGNvbnN0IG1lbWJlciBvZiB2YWx1ZSkge1xuICAgICAgICAgIHRhcmdldC5zZWFyY2hQYXJhbXMuYXBwZW5kKG5hbWUsIG1lbWJlcik7XG4gICAgICAgIH1cbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHRhcmdldC5zZWFyY2hQYXJhbXMuc2V0KG5hbWUsIHZhbHVlKTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICAvLyBUT0RPOiBpcyB0aGUgcmVwbGFjZSBuZWVkZWQ/XG4gICAgcmV0dXJuIHRhcmdldC5ocmVmLnJlcGxhY2UoL1xcKy9nLCAnJTIwJyk7XG4gIH1cblxuICBhdXRob3JpemF0aW9uUG9zdChwYXJhbXMgPSB7fSkge1xuICAgIGlmICghaXNQbGFpbk9iamVjdChwYXJhbXMpKSB7XG4gICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCdwYXJhbXMgbXVzdCBiZSBhIHBsYWluIG9iamVjdCcpO1xuICAgIH1cbiAgICBjb25zdCBpbnB1dHMgPSBhdXRob3JpemF0aW9uUGFyYW1zLmNhbGwodGhpcywgcGFyYW1zKTtcbiAgICBjb25zdCBmb3JtSW5wdXRzID0gT2JqZWN0LmtleXMoaW5wdXRzKVxuICAgICAgLm1hcCgobmFtZSkgPT4gYDxpbnB1dCB0eXBlPVwiaGlkZGVuXCIgbmFtZT1cIiR7bmFtZX1cIiB2YWx1ZT1cIiR7aW5wdXRzW25hbWVdfVwiLz5gKVxuICAgICAgLmpvaW4oJ1xcbicpO1xuXG4gICAgcmV0dXJuIGA8IURPQ1RZUEUgaHRtbD5cbjxoZWFkPlxuPHRpdGxlPlJlcXVlc3RpbmcgQXV0aG9yaXphdGlvbjwvdGl0bGU+XG48L2hlYWQ+XG48Ym9keSBvbmxvYWQ9XCJqYXZhc2NyaXB0OmRvY3VtZW50LmZvcm1zWzBdLnN1Ym1pdCgpXCI+XG48Zm9ybSBtZXRob2Q9XCJwb3N0XCIgYWN0aW9uPVwiJHt0aGlzLmlzc3Vlci5hdXRob3JpemF0aW9uX2VuZHBvaW50fVwiPlxuICAke2Zvcm1JbnB1dHN9XG48L2Zvcm0+XG48L2JvZHk+XG48L2h0bWw+YDtcbiAgfVxuXG4gIGVuZFNlc3Npb25VcmwocGFyYW1zID0ge30pIHtcbiAgICBhc3NlcnRJc3N1ZXJDb25maWd1cmF0aW9uKHRoaXMuaXNzdWVyLCAnZW5kX3Nlc3Npb25fZW5kcG9pbnQnKTtcblxuICAgIGNvbnN0IHsgMDogcG9zdExvZ291dCwgbGVuZ3RoIH0gPSB0aGlzLnBvc3RfbG9nb3V0X3JlZGlyZWN0X3VyaXMgfHwgW107XG5cbiAgICBjb25zdCB7IHBvc3RfbG9nb3V0X3JlZGlyZWN0X3VyaSA9IGxlbmd0aCA9PT0gMSA/IHBvc3RMb2dvdXQgOiB1bmRlZmluZWQgfSA9IHBhcmFtcztcblxuICAgIGxldCBpZF90b2tlbl9oaW50O1xuICAgICh7IGlkX3Rva2VuX2hpbnQsIC4uLnBhcmFtcyB9ID0gcGFyYW1zKTtcbiAgICBpZiAoaWRfdG9rZW5faGludCBpbnN0YW5jZW9mIFRva2VuU2V0KSB7XG4gICAgICBpZiAoIWlkX3Rva2VuX2hpbnQuaWRfdG9rZW4pIHtcbiAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcignaWRfdG9rZW4gbm90IHByZXNlbnQgaW4gVG9rZW5TZXQnKTtcbiAgICAgIH1cbiAgICAgIGlkX3Rva2VuX2hpbnQgPSBpZF90b2tlbl9oaW50LmlkX3Rva2VuO1xuICAgIH1cblxuICAgIGNvbnN0IHRhcmdldCA9IHVybC5wYXJzZSh0aGlzLmlzc3Vlci5lbmRfc2Vzc2lvbl9lbmRwb2ludCk7XG4gICAgY29uc3QgcXVlcnkgPSBkZWZhdWx0cyhcbiAgICAgIGdldFNlYXJjaFBhcmFtcyh0aGlzLmlzc3Vlci5lbmRfc2Vzc2lvbl9lbmRwb2ludCksXG4gICAgICBwYXJhbXMsXG4gICAgICB7XG4gICAgICAgIHBvc3RfbG9nb3V0X3JlZGlyZWN0X3VyaSxcbiAgICAgICAgY2xpZW50X2lkOiB0aGlzLmNsaWVudF9pZCxcbiAgICAgIH0sXG4gICAgICB7IGlkX3Rva2VuX2hpbnQgfSxcbiAgICApO1xuXG4gICAgT2JqZWN0LmVudHJpZXMocXVlcnkpLmZvckVhY2goKFtrZXksIHZhbHVlXSkgPT4ge1xuICAgICAgaWYgKHZhbHVlID09PSBudWxsIHx8IHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgICAgZGVsZXRlIHF1ZXJ5W2tleV07XG4gICAgICB9XG4gICAgfSk7XG5cbiAgICB0YXJnZXQuc2VhcmNoID0gbnVsbDtcbiAgICB0YXJnZXQucXVlcnkgPSBxdWVyeTtcblxuICAgIHJldHVybiB1cmwuZm9ybWF0KHRhcmdldCk7XG4gIH1cblxuICBjYWxsYmFja1BhcmFtcyhpbnB1dCkge1xuICAgIGNvbnN0IGlzSW5jb21pbmdNZXNzYWdlID1cbiAgICAgIGlucHV0IGluc3RhbmNlb2Ygc3RkaHR0cC5JbmNvbWluZ01lc3NhZ2UgfHwgKGlucHV0ICYmIGlucHV0Lm1ldGhvZCAmJiBpbnB1dC51cmwpO1xuICAgIGNvbnN0IGlzU3RyaW5nID0gdHlwZW9mIGlucHV0ID09PSAnc3RyaW5nJztcblxuICAgIGlmICghaXNTdHJpbmcgJiYgIWlzSW5jb21pbmdNZXNzYWdlKSB7XG4gICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKFxuICAgICAgICAnI2NhbGxiYWNrUGFyYW1zIG9ubHkgYWNjZXB0cyBzdHJpbmcgdXJscywgaHR0cC5JbmNvbWluZ01lc3NhZ2Ugb3IgYSBsb29rYWxpa2UnLFxuICAgICAgKTtcbiAgICB9XG4gICAgaWYgKGlzSW5jb21pbmdNZXNzYWdlKSB7XG4gICAgICBzd2l0Y2ggKGlucHV0Lm1ldGhvZCkge1xuICAgICAgICBjYXNlICdHRVQnOlxuICAgICAgICAgIHJldHVybiBwaWNrQ2IoZ2V0U2VhcmNoUGFyYW1zKGlucHV0LnVybCkpO1xuICAgICAgICBjYXNlICdQT1NUJzpcbiAgICAgICAgICBpZiAoaW5wdXQuYm9keSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKFxuICAgICAgICAgICAgICAnaW5jb21pbmcgbWVzc2FnZSBib2R5IG1pc3NpbmcsIGluY2x1ZGUgYSBib2R5IHBhcnNlciBwcmlvciB0byB0aGlzIG1ldGhvZCBjYWxsJyxcbiAgICAgICAgICAgICk7XG4gICAgICAgICAgfVxuICAgICAgICAgIHN3aXRjaCAodHlwZW9mIGlucHV0LmJvZHkpIHtcbiAgICAgICAgICAgIGNhc2UgJ29iamVjdCc6XG4gICAgICAgICAgICBjYXNlICdzdHJpbmcnOlxuICAgICAgICAgICAgICBpZiAoQnVmZmVyLmlzQnVmZmVyKGlucHV0LmJvZHkpKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHBpY2tDYihxdWVyeXN0cmluZy5wYXJzZShpbnB1dC5ib2R5LnRvU3RyaW5nKCd1dGYtOCcpKSk7XG4gICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgaWYgKHR5cGVvZiBpbnB1dC5ib2R5ID09PSAnc3RyaW5nJykge1xuICAgICAgICAgICAgICAgIHJldHVybiBwaWNrQ2IocXVlcnlzdHJpbmcucGFyc2UoaW5wdXQuYm9keSkpO1xuICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgcmV0dXJuIHBpY2tDYihpbnB1dC5ib2R5KTtcbiAgICAgICAgICAgIGRlZmF1bHQ6XG4gICAgICAgICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ2ludmFsaWQgSW5jb21pbmdNZXNzYWdlIGJvZHkgb2JqZWN0Jyk7XG4gICAgICAgICAgfVxuICAgICAgICBkZWZhdWx0OlxuICAgICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ2ludmFsaWQgSW5jb21pbmdNZXNzYWdlIG1ldGhvZCcpO1xuICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gcGlja0NiKGdldFNlYXJjaFBhcmFtcyhpbnB1dCkpO1xuICAgIH1cbiAgfVxuXG4gIGFzeW5jIGNhbGxiYWNrKFxuICAgIHJlZGlyZWN0VXJpLFxuICAgIHBhcmFtZXRlcnMsXG4gICAgY2hlY2tzID0ge30sXG4gICAgeyBleGNoYW5nZUJvZHksIGNsaWVudEFzc2VydGlvblBheWxvYWQsIERQb1AgfSA9IHt9LFxuICApIHtcbiAgICBsZXQgcGFyYW1zID0gcGlja0NiKHBhcmFtZXRlcnMpO1xuXG4gICAgaWYgKGNoZWNrcy5qYXJtICYmICEoJ3Jlc3BvbnNlJyBpbiBwYXJhbWV0ZXJzKSkge1xuICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICBtZXNzYWdlOiAnZXhwZWN0ZWQgYSBKQVJNIHJlc3BvbnNlJyxcbiAgICAgICAgY2hlY2tzLFxuICAgICAgICBwYXJhbXMsXG4gICAgICB9KTtcbiAgICB9IGVsc2UgaWYgKCdyZXNwb25zZScgaW4gcGFyYW1ldGVycykge1xuICAgICAgY29uc3QgZGVjcnlwdGVkID0gYXdhaXQgdGhpcy5kZWNyeXB0SkFSTShwYXJhbXMucmVzcG9uc2UpO1xuICAgICAgcGFyYW1zID0gYXdhaXQgdGhpcy52YWxpZGF0ZUpBUk0oZGVjcnlwdGVkKTtcbiAgICB9XG5cbiAgICBpZiAodGhpcy5kZWZhdWx0X21heF9hZ2UgJiYgIWNoZWNrcy5tYXhfYWdlKSB7XG4gICAgICBjaGVja3MubWF4X2FnZSA9IHRoaXMuZGVmYXVsdF9tYXhfYWdlO1xuICAgIH1cblxuICAgIGlmIChwYXJhbXMuc3RhdGUgJiYgIWNoZWNrcy5zdGF0ZSkge1xuICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcignY2hlY2tzLnN0YXRlIGFyZ3VtZW50IGlzIG1pc3NpbmcnKTtcbiAgICB9XG5cbiAgICBpZiAoIXBhcmFtcy5zdGF0ZSAmJiBjaGVja3Muc3RhdGUpIHtcbiAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgbWVzc2FnZTogJ3N0YXRlIG1pc3NpbmcgZnJvbSB0aGUgcmVzcG9uc2UnLFxuICAgICAgICBjaGVja3MsXG4gICAgICAgIHBhcmFtcyxcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIGlmIChjaGVja3Muc3RhdGUgIT09IHBhcmFtcy5zdGF0ZSkge1xuICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICBwcmludGY6IFsnc3RhdGUgbWlzbWF0Y2gsIGV4cGVjdGVkICVzLCBnb3Q6ICVzJywgY2hlY2tzLnN0YXRlLCBwYXJhbXMuc3RhdGVdLFxuICAgICAgICBjaGVja3MsXG4gICAgICAgIHBhcmFtcyxcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIGlmICgnaXNzJyBpbiBwYXJhbXMpIHtcbiAgICAgIGFzc2VydElzc3VlckNvbmZpZ3VyYXRpb24odGhpcy5pc3N1ZXIsICdpc3N1ZXInKTtcbiAgICAgIGlmIChwYXJhbXMuaXNzICE9PSB0aGlzLmlzc3Vlci5pc3N1ZXIpIHtcbiAgICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICAgIHByaW50ZjogWydpc3MgbWlzbWF0Y2gsIGV4cGVjdGVkICVzLCBnb3Q6ICVzJywgdGhpcy5pc3N1ZXIuaXNzdWVyLCBwYXJhbXMuaXNzXSxcbiAgICAgICAgICBwYXJhbXMsXG4gICAgICAgIH0pO1xuICAgICAgfVxuICAgIH0gZWxzZSBpZiAoXG4gICAgICB0aGlzLmlzc3Vlci5hdXRob3JpemF0aW9uX3Jlc3BvbnNlX2lzc19wYXJhbWV0ZXJfc3VwcG9ydGVkICYmXG4gICAgICAhKCdpZF90b2tlbicgaW4gcGFyYW1zKSAmJlxuICAgICAgISgncmVzcG9uc2UnIGluIHBhcmFtZXRlcnMpXG4gICAgKSB7XG4gICAgICB0aHJvdyBuZXcgUlBFcnJvcih7XG4gICAgICAgIG1lc3NhZ2U6ICdpc3MgbWlzc2luZyBmcm9tIHRoZSByZXNwb25zZScsXG4gICAgICAgIHBhcmFtcyxcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIGlmIChwYXJhbXMuZXJyb3IpIHtcbiAgICAgIHRocm93IG5ldyBPUEVycm9yKHBhcmFtcyk7XG4gICAgfVxuXG4gICAgY29uc3QgUkVTUE9OU0VfVFlQRV9SRVFVSVJFRF9QQVJBTVMgPSB7XG4gICAgICBjb2RlOiBbJ2NvZGUnXSxcbiAgICAgIGlkX3Rva2VuOiBbJ2lkX3Rva2VuJ10sXG4gICAgICB0b2tlbjogWydhY2Nlc3NfdG9rZW4nLCAndG9rZW5fdHlwZSddLFxuICAgIH07XG5cbiAgICBpZiAoY2hlY2tzLnJlc3BvbnNlX3R5cGUpIHtcbiAgICAgIGZvciAoY29uc3QgdHlwZSBvZiBjaGVja3MucmVzcG9uc2VfdHlwZS5zcGxpdCgnICcpKSB7XG4gICAgICAgIGlmICh0eXBlID09PSAnbm9uZScpIHtcbiAgICAgICAgICBpZiAocGFyYW1zLmNvZGUgfHwgcGFyYW1zLmlkX3Rva2VuIHx8IHBhcmFtcy5hY2Nlc3NfdG9rZW4pIHtcbiAgICAgICAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgICAgICAgbWVzc2FnZTogJ3VuZXhwZWN0ZWQgcGFyYW1zIGVuY291bnRlcmVkIGZvciBcIm5vbmVcIiByZXNwb25zZScsXG4gICAgICAgICAgICAgIGNoZWNrcyxcbiAgICAgICAgICAgICAgcGFyYW1zLFxuICAgICAgICAgICAgfSk7XG4gICAgICAgICAgfVxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIGZvciAoY29uc3QgcGFyYW0gb2YgUkVTUE9OU0VfVFlQRV9SRVFVSVJFRF9QQVJBTVNbdHlwZV0pIHtcbiAgICAgICAgICAgIGlmICghcGFyYW1zW3BhcmFtXSkge1xuICAgICAgICAgICAgICB0aHJvdyBuZXcgUlBFcnJvcih7XG4gICAgICAgICAgICAgICAgbWVzc2FnZTogYCR7cGFyYW19IG1pc3NpbmcgZnJvbSByZXNwb25zZWAsXG4gICAgICAgICAgICAgICAgY2hlY2tzLFxuICAgICAgICAgICAgICAgIHBhcmFtcyxcbiAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuXG4gICAgaWYgKHBhcmFtcy5pZF90b2tlbikge1xuICAgICAgY29uc3QgdG9rZW5zZXQgPSBuZXcgVG9rZW5TZXQocGFyYW1zKTtcbiAgICAgIGF3YWl0IHRoaXMuZGVjcnlwdElkVG9rZW4odG9rZW5zZXQpO1xuICAgICAgYXdhaXQgdGhpcy52YWxpZGF0ZUlkVG9rZW4oXG4gICAgICAgIHRva2Vuc2V0LFxuICAgICAgICBjaGVja3Mubm9uY2UsXG4gICAgICAgICdhdXRob3JpemF0aW9uJyxcbiAgICAgICAgY2hlY2tzLm1heF9hZ2UsXG4gICAgICAgIGNoZWNrcy5zdGF0ZSxcbiAgICAgICk7XG5cbiAgICAgIGlmICghcGFyYW1zLmNvZGUpIHtcbiAgICAgICAgcmV0dXJuIHRva2Vuc2V0O1xuICAgICAgfVxuICAgIH1cblxuICAgIGlmIChwYXJhbXMuY29kZSkge1xuICAgICAgY29uc3QgdG9rZW5zZXQgPSBhd2FpdCB0aGlzLmdyYW50KFxuICAgICAgICB7XG4gICAgICAgICAgLi4uZXhjaGFuZ2VCb2R5LFxuICAgICAgICAgIGdyYW50X3R5cGU6ICdhdXRob3JpemF0aW9uX2NvZGUnLFxuICAgICAgICAgIGNvZGU6IHBhcmFtcy5jb2RlLFxuICAgICAgICAgIHJlZGlyZWN0X3VyaTogcmVkaXJlY3RVcmksXG4gICAgICAgICAgY29kZV92ZXJpZmllcjogY2hlY2tzLmNvZGVfdmVyaWZpZXIsXG4gICAgICAgIH0sXG4gICAgICAgIHsgY2xpZW50QXNzZXJ0aW9uUGF5bG9hZCwgRFBvUCB9LFxuICAgICAgKTtcblxuICAgICAgYXdhaXQgdGhpcy5kZWNyeXB0SWRUb2tlbih0b2tlbnNldCk7XG4gICAgICBhd2FpdCB0aGlzLnZhbGlkYXRlSWRUb2tlbih0b2tlbnNldCwgY2hlY2tzLm5vbmNlLCAndG9rZW4nLCBjaGVja3MubWF4X2FnZSk7XG5cbiAgICAgIGlmIChwYXJhbXMuc2Vzc2lvbl9zdGF0ZSkge1xuICAgICAgICB0b2tlbnNldC5zZXNzaW9uX3N0YXRlID0gcGFyYW1zLnNlc3Npb25fc3RhdGU7XG4gICAgICB9XG5cbiAgICAgIHJldHVybiB0b2tlbnNldDtcbiAgICB9XG5cbiAgICByZXR1cm4gbmV3IFRva2VuU2V0KHBhcmFtcyk7XG4gIH1cblxuICBhc3luYyBvYXV0aENhbGxiYWNrKFxuICAgIHJlZGlyZWN0VXJpLFxuICAgIHBhcmFtZXRlcnMsXG4gICAgY2hlY2tzID0ge30sXG4gICAgeyBleGNoYW5nZUJvZHksIGNsaWVudEFzc2VydGlvblBheWxvYWQsIERQb1AgfSA9IHt9LFxuICApIHtcbiAgICBsZXQgcGFyYW1zID0gcGlja0NiKHBhcmFtZXRlcnMpO1xuXG4gICAgaWYgKGNoZWNrcy5qYXJtICYmICEoJ3Jlc3BvbnNlJyBpbiBwYXJhbWV0ZXJzKSkge1xuICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICBtZXNzYWdlOiAnZXhwZWN0ZWQgYSBKQVJNIHJlc3BvbnNlJyxcbiAgICAgICAgY2hlY2tzLFxuICAgICAgICBwYXJhbXMsXG4gICAgICB9KTtcbiAgICB9IGVsc2UgaWYgKCdyZXNwb25zZScgaW4gcGFyYW1ldGVycykge1xuICAgICAgY29uc3QgZGVjcnlwdGVkID0gYXdhaXQgdGhpcy5kZWNyeXB0SkFSTShwYXJhbXMucmVzcG9uc2UpO1xuICAgICAgcGFyYW1zID0gYXdhaXQgdGhpcy52YWxpZGF0ZUpBUk0oZGVjcnlwdGVkKTtcbiAgICB9XG5cbiAgICBpZiAocGFyYW1zLnN0YXRlICYmICFjaGVja3Muc3RhdGUpIHtcbiAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ2NoZWNrcy5zdGF0ZSBhcmd1bWVudCBpcyBtaXNzaW5nJyk7XG4gICAgfVxuXG4gICAgaWYgKCFwYXJhbXMuc3RhdGUgJiYgY2hlY2tzLnN0YXRlKSB7XG4gICAgICB0aHJvdyBuZXcgUlBFcnJvcih7XG4gICAgICAgIG1lc3NhZ2U6ICdzdGF0ZSBtaXNzaW5nIGZyb20gdGhlIHJlc3BvbnNlJyxcbiAgICAgICAgY2hlY2tzLFxuICAgICAgICBwYXJhbXMsXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICBpZiAoY2hlY2tzLnN0YXRlICE9PSBwYXJhbXMuc3RhdGUpIHtcbiAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgcHJpbnRmOiBbJ3N0YXRlIG1pc21hdGNoLCBleHBlY3RlZCAlcywgZ290OiAlcycsIGNoZWNrcy5zdGF0ZSwgcGFyYW1zLnN0YXRlXSxcbiAgICAgICAgY2hlY2tzLFxuICAgICAgICBwYXJhbXMsXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICBpZiAoJ2lzcycgaW4gcGFyYW1zKSB7XG4gICAgICBhc3NlcnRJc3N1ZXJDb25maWd1cmF0aW9uKHRoaXMuaXNzdWVyLCAnaXNzdWVyJyk7XG4gICAgICBpZiAocGFyYW1zLmlzcyAhPT0gdGhpcy5pc3N1ZXIuaXNzdWVyKSB7XG4gICAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgICBwcmludGY6IFsnaXNzIG1pc21hdGNoLCBleHBlY3RlZCAlcywgZ290OiAlcycsIHRoaXMuaXNzdWVyLmlzc3VlciwgcGFyYW1zLmlzc10sXG4gICAgICAgICAgcGFyYW1zLFxuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICB9IGVsc2UgaWYgKFxuICAgICAgdGhpcy5pc3N1ZXIuYXV0aG9yaXphdGlvbl9yZXNwb25zZV9pc3NfcGFyYW1ldGVyX3N1cHBvcnRlZCAmJlxuICAgICAgISgnaWRfdG9rZW4nIGluIHBhcmFtcykgJiZcbiAgICAgICEoJ3Jlc3BvbnNlJyBpbiBwYXJhbWV0ZXJzKVxuICAgICkge1xuICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICBtZXNzYWdlOiAnaXNzIG1pc3NpbmcgZnJvbSB0aGUgcmVzcG9uc2UnLFxuICAgICAgICBwYXJhbXMsXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICBpZiAocGFyYW1zLmVycm9yKSB7XG4gICAgICB0aHJvdyBuZXcgT1BFcnJvcihwYXJhbXMpO1xuICAgIH1cblxuICAgIGlmICh0eXBlb2YgcGFyYW1zLmlkX3Rva2VuID09PSAnc3RyaW5nJyAmJiBwYXJhbXMuaWRfdG9rZW4ubGVuZ3RoKSB7XG4gICAgICB0aHJvdyBuZXcgUlBFcnJvcih7XG4gICAgICAgIG1lc3NhZ2U6XG4gICAgICAgICAgJ2lkX3Rva2VuIGRldGVjdGVkIGluIHRoZSByZXNwb25zZSwgeW91IG11c3QgdXNlIGNsaWVudC5jYWxsYmFjaygpIGluc3RlYWQgb2YgY2xpZW50Lm9hdXRoQ2FsbGJhY2soKScsXG4gICAgICAgIHBhcmFtcyxcbiAgICAgIH0pO1xuICAgIH1cbiAgICBkZWxldGUgcGFyYW1zLmlkX3Rva2VuO1xuXG4gICAgY29uc3QgUkVTUE9OU0VfVFlQRV9SRVFVSVJFRF9QQVJBTVMgPSB7XG4gICAgICBjb2RlOiBbJ2NvZGUnXSxcbiAgICAgIHRva2VuOiBbJ2FjY2Vzc190b2tlbicsICd0b2tlbl90eXBlJ10sXG4gICAgfTtcblxuICAgIGlmIChjaGVja3MucmVzcG9uc2VfdHlwZSkge1xuICAgICAgZm9yIChjb25zdCB0eXBlIG9mIGNoZWNrcy5yZXNwb25zZV90eXBlLnNwbGl0KCcgJykpIHtcbiAgICAgICAgaWYgKHR5cGUgPT09ICdub25lJykge1xuICAgICAgICAgIGlmIChwYXJhbXMuY29kZSB8fCBwYXJhbXMuaWRfdG9rZW4gfHwgcGFyYW1zLmFjY2Vzc190b2tlbikge1xuICAgICAgICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICAgICAgICBtZXNzYWdlOiAndW5leHBlY3RlZCBwYXJhbXMgZW5jb3VudGVyZWQgZm9yIFwibm9uZVwiIHJlc3BvbnNlJyxcbiAgICAgICAgICAgICAgY2hlY2tzLFxuICAgICAgICAgICAgICBwYXJhbXMsXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoUkVTUE9OU0VfVFlQRV9SRVFVSVJFRF9QQVJBTVNbdHlwZV0pIHtcbiAgICAgICAgICBmb3IgKGNvbnN0IHBhcmFtIG9mIFJFU1BPTlNFX1RZUEVfUkVRVUlSRURfUEFSQU1TW3R5cGVdKSB7XG4gICAgICAgICAgICBpZiAoIXBhcmFtc1twYXJhbV0pIHtcbiAgICAgICAgICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICAgICAgICAgIG1lc3NhZ2U6IGAke3BhcmFtfSBtaXNzaW5nIGZyb20gcmVzcG9uc2VgLFxuICAgICAgICAgICAgICAgIGNoZWNrcyxcbiAgICAgICAgICAgICAgICBwYXJhbXMsXG4gICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cblxuICAgIGlmIChwYXJhbXMuY29kZSkge1xuICAgICAgY29uc3QgdG9rZW5zZXQgPSBhd2FpdCB0aGlzLmdyYW50KFxuICAgICAgICB7XG4gICAgICAgICAgLi4uZXhjaGFuZ2VCb2R5LFxuICAgICAgICAgIGdyYW50X3R5cGU6ICdhdXRob3JpemF0aW9uX2NvZGUnLFxuICAgICAgICAgIGNvZGU6IHBhcmFtcy5jb2RlLFxuICAgICAgICAgIHJlZGlyZWN0X3VyaTogcmVkaXJlY3RVcmksXG4gICAgICAgICAgY29kZV92ZXJpZmllcjogY2hlY2tzLmNvZGVfdmVyaWZpZXIsXG4gICAgICAgIH0sXG4gICAgICAgIHsgY2xpZW50QXNzZXJ0aW9uUGF5bG9hZCwgRFBvUCB9LFxuICAgICAgKTtcblxuICAgICAgaWYgKHR5cGVvZiB0b2tlbnNldC5pZF90b2tlbiA9PT0gJ3N0cmluZycgJiYgdG9rZW5zZXQuaWRfdG9rZW4ubGVuZ3RoKSB7XG4gICAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgICBtZXNzYWdlOlxuICAgICAgICAgICAgJ2lkX3Rva2VuIGRldGVjdGVkIGluIHRoZSByZXNwb25zZSwgeW91IG11c3QgdXNlIGNsaWVudC5jYWxsYmFjaygpIGluc3RlYWQgb2YgY2xpZW50Lm9hdXRoQ2FsbGJhY2soKScsXG4gICAgICAgICAgcGFyYW1zLFxuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICAgIGRlbGV0ZSB0b2tlbnNldC5pZF90b2tlbjtcblxuICAgICAgcmV0dXJuIHRva2Vuc2V0O1xuICAgIH1cblxuICAgIHJldHVybiBuZXcgVG9rZW5TZXQocGFyYW1zKTtcbiAgfVxuXG4gIGFzeW5jIGRlY3J5cHRJZFRva2VuKHRva2VuKSB7XG4gICAgaWYgKCF0aGlzLmlkX3Rva2VuX2VuY3J5cHRlZF9yZXNwb25zZV9hbGcpIHtcbiAgICAgIHJldHVybiB0b2tlbjtcbiAgICB9XG5cbiAgICBsZXQgaWRUb2tlbiA9IHRva2VuO1xuXG4gICAgaWYgKGlkVG9rZW4gaW5zdGFuY2VvZiBUb2tlblNldCkge1xuICAgICAgaWYgKCFpZFRva2VuLmlkX3Rva2VuKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ2lkX3Rva2VuIG5vdCBwcmVzZW50IGluIFRva2VuU2V0Jyk7XG4gICAgICB9XG4gICAgICBpZFRva2VuID0gaWRUb2tlbi5pZF90b2tlbjtcbiAgICB9XG5cbiAgICBjb25zdCBleHBlY3RlZEFsZyA9IHRoaXMuaWRfdG9rZW5fZW5jcnlwdGVkX3Jlc3BvbnNlX2FsZztcbiAgICBjb25zdCBleHBlY3RlZEVuYyA9IHRoaXMuaWRfdG9rZW5fZW5jcnlwdGVkX3Jlc3BvbnNlX2VuYztcblxuICAgIGNvbnN0IHJlc3VsdCA9IGF3YWl0IHRoaXMuZGVjcnlwdEpXRShpZFRva2VuLCBleHBlY3RlZEFsZywgZXhwZWN0ZWRFbmMpO1xuXG4gICAgaWYgKHRva2VuIGluc3RhbmNlb2YgVG9rZW5TZXQpIHtcbiAgICAgIHRva2VuLmlkX3Rva2VuID0gcmVzdWx0O1xuICAgICAgcmV0dXJuIHRva2VuO1xuICAgIH1cblxuICAgIHJldHVybiByZXN1bHQ7XG4gIH1cblxuICBhc3luYyB2YWxpZGF0ZUpXVFVzZXJpbmZvKGJvZHkpIHtcbiAgICBjb25zdCBleHBlY3RlZEFsZyA9IHRoaXMudXNlcmluZm9fc2lnbmVkX3Jlc3BvbnNlX2FsZztcblxuICAgIHJldHVybiB0aGlzLnZhbGlkYXRlSldUKGJvZHksIGV4cGVjdGVkQWxnLCBbXSk7XG4gIH1cblxuICBhc3luYyBkZWNyeXB0SkFSTShyZXNwb25zZSkge1xuICAgIGlmICghdGhpcy5hdXRob3JpemF0aW9uX2VuY3J5cHRlZF9yZXNwb25zZV9hbGcpIHtcbiAgICAgIHJldHVybiByZXNwb25zZTtcbiAgICB9XG5cbiAgICBjb25zdCBleHBlY3RlZEFsZyA9IHRoaXMuYXV0aG9yaXphdGlvbl9lbmNyeXB0ZWRfcmVzcG9uc2VfYWxnO1xuICAgIGNvbnN0IGV4cGVjdGVkRW5jID0gdGhpcy5hdXRob3JpemF0aW9uX2VuY3J5cHRlZF9yZXNwb25zZV9lbmM7XG5cbiAgICByZXR1cm4gdGhpcy5kZWNyeXB0SldFKHJlc3BvbnNlLCBleHBlY3RlZEFsZywgZXhwZWN0ZWRFbmMpO1xuICB9XG5cbiAgYXN5bmMgZGVjcnlwdEpXVFVzZXJpbmZvKGJvZHkpIHtcbiAgICBpZiAoIXRoaXMudXNlcmluZm9fZW5jcnlwdGVkX3Jlc3BvbnNlX2FsZykge1xuICAgICAgcmV0dXJuIGJvZHk7XG4gICAgfVxuXG4gICAgY29uc3QgZXhwZWN0ZWRBbGcgPSB0aGlzLnVzZXJpbmZvX2VuY3J5cHRlZF9yZXNwb25zZV9hbGc7XG4gICAgY29uc3QgZXhwZWN0ZWRFbmMgPSB0aGlzLnVzZXJpbmZvX2VuY3J5cHRlZF9yZXNwb25zZV9lbmM7XG5cbiAgICByZXR1cm4gdGhpcy5kZWNyeXB0SldFKGJvZHksIGV4cGVjdGVkQWxnLCBleHBlY3RlZEVuYyk7XG4gIH1cblxuICBhc3luYyBkZWNyeXB0SldFKGp3ZSwgZXhwZWN0ZWRBbGcsIGV4cGVjdGVkRW5jID0gJ0ExMjhDQkMtSFMyNTYnKSB7XG4gICAgY29uc3QgaGVhZGVyID0gSlNPTi5wYXJzZShiYXNlNjR1cmwuZGVjb2RlKGp3ZS5zcGxpdCgnLicpWzBdKSk7XG5cbiAgICBpZiAoaGVhZGVyLmFsZyAhPT0gZXhwZWN0ZWRBbGcpIHtcbiAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgcHJpbnRmOiBbJ3VuZXhwZWN0ZWQgSldFIGFsZyByZWNlaXZlZCwgZXhwZWN0ZWQgJXMsIGdvdDogJXMnLCBleHBlY3RlZEFsZywgaGVhZGVyLmFsZ10sXG4gICAgICAgIGp3dDogandlLFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgaWYgKGhlYWRlci5lbmMgIT09IGV4cGVjdGVkRW5jKSB7XG4gICAgICB0aHJvdyBuZXcgUlBFcnJvcih7XG4gICAgICAgIHByaW50ZjogWyd1bmV4cGVjdGVkIEpXRSBlbmMgcmVjZWl2ZWQsIGV4cGVjdGVkICVzLCBnb3Q6ICVzJywgZXhwZWN0ZWRFbmMsIGhlYWRlci5lbmNdLFxuICAgICAgICBqd3Q6IGp3ZSxcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIGNvbnN0IGdldFBsYWludGV4dCA9IChyZXN1bHQpID0+IG5ldyBUZXh0RGVjb2RlcigpLmRlY29kZShyZXN1bHQucGxhaW50ZXh0KTtcbiAgICBsZXQgcGxhaW50ZXh0O1xuICAgIGlmIChleHBlY3RlZEFsZy5tYXRjaCgvXig/OlJTQXxFQ0RIKS8pKSB7XG4gICAgICBjb25zdCBrZXlzdG9yZSA9IGF3YWl0IGtleXN0b3Jlcy5nZXQodGhpcyk7XG5cbiAgICAgIGNvbnN0IHByb3RlY3RlZEhlYWRlciA9IGpvc2UuZGVjb2RlUHJvdGVjdGVkSGVhZGVyKGp3ZSk7XG5cbiAgICAgIGZvciAoY29uc3Qga2V5IG9mIGtleXN0b3JlLmFsbCh7XG4gICAgICAgIC4uLnByb3RlY3RlZEhlYWRlcixcbiAgICAgICAgdXNlOiAnZW5jJyxcbiAgICAgIH0pKSB7XG4gICAgICAgIHBsYWludGV4dCA9IGF3YWl0IGpvc2VcbiAgICAgICAgICAuY29tcGFjdERlY3J5cHQoandlLCBhd2FpdCBrZXkua2V5T2JqZWN0KHByb3RlY3RlZEhlYWRlci5hbGcpKVxuICAgICAgICAgIC50aGVuKGdldFBsYWludGV4dCwgKCkgPT4ge30pO1xuICAgICAgICBpZiAocGxhaW50ZXh0KSBicmVhaztcbiAgICAgIH1cbiAgICB9IGVsc2Uge1xuICAgICAgcGxhaW50ZXh0ID0gYXdhaXQgam9zZVxuICAgICAgICAuY29tcGFjdERlY3J5cHQoandlLCB0aGlzLnNlY3JldEZvckFsZyhleHBlY3RlZEFsZyA9PT0gJ2RpcicgPyBleHBlY3RlZEVuYyA6IGV4cGVjdGVkQWxnKSlcbiAgICAgICAgLnRoZW4oZ2V0UGxhaW50ZXh0LCAoKSA9PiB7fSk7XG4gICAgfVxuXG4gICAgaWYgKCFwbGFpbnRleHQpIHtcbiAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgbWVzc2FnZTogJ2ZhaWxlZCB0byBkZWNyeXB0IEpXRScsXG4gICAgICAgIGp3dDogandlLFxuICAgICAgfSk7XG4gICAgfVxuICAgIHJldHVybiBwbGFpbnRleHQ7XG4gIH1cblxuICBhc3luYyB2YWxpZGF0ZUlkVG9rZW4odG9rZW5TZXQsIG5vbmNlLCByZXR1cm5lZEJ5LCBtYXhBZ2UsIHN0YXRlKSB7XG4gICAgbGV0IGlkVG9rZW4gPSB0b2tlblNldDtcblxuICAgIGNvbnN0IGV4cGVjdGVkQWxnID0gdGhpcy5pZF90b2tlbl9zaWduZWRfcmVzcG9uc2VfYWxnO1xuXG4gICAgY29uc3QgaXNUb2tlblNldCA9IGlkVG9rZW4gaW5zdGFuY2VvZiBUb2tlblNldDtcblxuICAgIGlmIChpc1Rva2VuU2V0KSB7XG4gICAgICBpZiAoIWlkVG9rZW4uaWRfdG9rZW4pIHtcbiAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcignaWRfdG9rZW4gbm90IHByZXNlbnQgaW4gVG9rZW5TZXQnKTtcbiAgICAgIH1cbiAgICAgIGlkVG9rZW4gPSBpZFRva2VuLmlkX3Rva2VuO1xuICAgIH1cblxuICAgIGlkVG9rZW4gPSBTdHJpbmcoaWRUb2tlbik7XG5cbiAgICBjb25zdCB0aW1lc3RhbXAgPSBub3coKTtcbiAgICBjb25zdCB7IHByb3RlY3RlZDogaGVhZGVyLCBwYXlsb2FkLCBrZXkgfSA9IGF3YWl0IHRoaXMudmFsaWRhdGVKV1QoaWRUb2tlbiwgZXhwZWN0ZWRBbGcpO1xuXG4gICAgaWYgKHR5cGVvZiBtYXhBZ2UgPT09ICdudW1iZXInIHx8IChtYXhBZ2UgIT09IHNraXBNYXhBZ2VDaGVjayAmJiB0aGlzLnJlcXVpcmVfYXV0aF90aW1lKSkge1xuICAgICAgaWYgKCFwYXlsb2FkLmF1dGhfdGltZSkge1xuICAgICAgICB0aHJvdyBuZXcgUlBFcnJvcih7XG4gICAgICAgICAgbWVzc2FnZTogJ21pc3NpbmcgcmVxdWlyZWQgSldUIHByb3BlcnR5IGF1dGhfdGltZScsXG4gICAgICAgICAgand0OiBpZFRva2VuLFxuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICAgIGlmICh0eXBlb2YgcGF5bG9hZC5hdXRoX3RpbWUgIT09ICdudW1iZXInKSB7XG4gICAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgICBtZXNzYWdlOiAnSldUIGF1dGhfdGltZSBjbGFpbSBtdXN0IGJlIGEgSlNPTiBudW1lcmljIHZhbHVlJyxcbiAgICAgICAgICBqd3Q6IGlkVG9rZW4sXG4gICAgICAgIH0pO1xuICAgICAgfVxuICAgIH1cblxuICAgIGlmIChcbiAgICAgIHR5cGVvZiBtYXhBZ2UgPT09ICdudW1iZXInICYmXG4gICAgICBwYXlsb2FkLmF1dGhfdGltZSArIG1heEFnZSA8IHRpbWVzdGFtcCAtIHRoaXNbQ0xPQ0tfVE9MRVJBTkNFXVxuICAgICkge1xuICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICBwcmludGY6IFtcbiAgICAgICAgICAndG9vIG11Y2ggdGltZSBoYXMgZWxhcHNlZCBzaW5jZSB0aGUgbGFzdCBFbmQtVXNlciBhdXRoZW50aWNhdGlvbiwgbWF4X2FnZSAlaSwgYXV0aF90aW1lOiAlaSwgbm93ICVpJyxcbiAgICAgICAgICBtYXhBZ2UsXG4gICAgICAgICAgcGF5bG9hZC5hdXRoX3RpbWUsXG4gICAgICAgICAgdGltZXN0YW1wIC0gdGhpc1tDTE9DS19UT0xFUkFOQ0VdLFxuICAgICAgICBdLFxuICAgICAgICBub3c6IHRpbWVzdGFtcCxcbiAgICAgICAgdG9sZXJhbmNlOiB0aGlzW0NMT0NLX1RPTEVSQU5DRV0sXG4gICAgICAgIGF1dGhfdGltZTogcGF5bG9hZC5hdXRoX3RpbWUsXG4gICAgICAgIGp3dDogaWRUb2tlbixcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIGlmIChcbiAgICAgIG5vbmNlICE9PSBza2lwTm9uY2VDaGVjayAmJlxuICAgICAgKHBheWxvYWQubm9uY2UgfHwgbm9uY2UgIT09IHVuZGVmaW5lZCkgJiZcbiAgICAgIHBheWxvYWQubm9uY2UgIT09IG5vbmNlXG4gICAgKSB7XG4gICAgICB0aHJvdyBuZXcgUlBFcnJvcih7XG4gICAgICAgIHByaW50ZjogWydub25jZSBtaXNtYXRjaCwgZXhwZWN0ZWQgJXMsIGdvdDogJXMnLCBub25jZSwgcGF5bG9hZC5ub25jZV0sXG4gICAgICAgIGp3dDogaWRUb2tlbixcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIGlmIChyZXR1cm5lZEJ5ID09PSAnYXV0aG9yaXphdGlvbicpIHtcbiAgICAgIGlmICghcGF5bG9hZC5hdF9oYXNoICYmIHRva2VuU2V0LmFjY2Vzc190b2tlbikge1xuICAgICAgICB0aHJvdyBuZXcgUlBFcnJvcih7XG4gICAgICAgICAgbWVzc2FnZTogJ21pc3NpbmcgcmVxdWlyZWQgcHJvcGVydHkgYXRfaGFzaCcsXG4gICAgICAgICAgand0OiBpZFRva2VuLFxuICAgICAgICB9KTtcbiAgICAgIH1cblxuICAgICAgaWYgKCFwYXlsb2FkLmNfaGFzaCAmJiB0b2tlblNldC5jb2RlKSB7XG4gICAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgICBtZXNzYWdlOiAnbWlzc2luZyByZXF1aXJlZCBwcm9wZXJ0eSBjX2hhc2gnLFxuICAgICAgICAgIGp3dDogaWRUb2tlbixcbiAgICAgICAgfSk7XG4gICAgICB9XG5cbiAgICAgIGlmICh0aGlzLmZhcGkxKCkpIHtcbiAgICAgICAgaWYgKCFwYXlsb2FkLnNfaGFzaCAmJiAodG9rZW5TZXQuc3RhdGUgfHwgc3RhdGUpKSB7XG4gICAgICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICAgICAgbWVzc2FnZTogJ21pc3NpbmcgcmVxdWlyZWQgcHJvcGVydHkgc19oYXNoJyxcbiAgICAgICAgICAgIGp3dDogaWRUb2tlbixcbiAgICAgICAgICB9KTtcbiAgICAgICAgfVxuICAgICAgfVxuXG4gICAgICBpZiAocGF5bG9hZC5zX2hhc2gpIHtcbiAgICAgICAgaWYgKCFzdGF0ZSkge1xuICAgICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ2Nhbm5vdCB2ZXJpZnkgc19oYXNoLCBcImNoZWNrcy5zdGF0ZVwiIHByb3BlcnR5IG5vdCBwcm92aWRlZCcpO1xuICAgICAgICB9XG5cbiAgICAgICAgdHJ5IHtcbiAgICAgICAgICB0b2tlbkhhc2gudmFsaWRhdGUoXG4gICAgICAgICAgICB7IGNsYWltOiAnc19oYXNoJywgc291cmNlOiAnc3RhdGUnIH0sXG4gICAgICAgICAgICBwYXlsb2FkLnNfaGFzaCxcbiAgICAgICAgICAgIHN0YXRlLFxuICAgICAgICAgICAgaGVhZGVyLmFsZyxcbiAgICAgICAgICAgIGtleS5qd2sgJiYga2V5Lmp3ay5jcnYsXG4gICAgICAgICAgKTtcbiAgICAgICAgfSBjYXRjaCAoZXJyKSB7XG4gICAgICAgICAgdGhyb3cgbmV3IFJQRXJyb3IoeyBtZXNzYWdlOiBlcnIubWVzc2FnZSwgand0OiBpZFRva2VuIH0pO1xuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuXG4gICAgaWYgKHRoaXMuZmFwaSgpICYmIHBheWxvYWQuaWF0IDwgdGltZXN0YW1wIC0gMzYwMCkge1xuICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICBwcmludGY6IFsnSldUIGlzc3VlZCB0b28gZmFyIGluIHRoZSBwYXN0LCBub3cgJWksIGlhdCAlaScsIHRpbWVzdGFtcCwgcGF5bG9hZC5pYXRdLFxuICAgICAgICBub3c6IHRpbWVzdGFtcCxcbiAgICAgICAgdG9sZXJhbmNlOiB0aGlzW0NMT0NLX1RPTEVSQU5DRV0sXG4gICAgICAgIGlhdDogcGF5bG9hZC5pYXQsXG4gICAgICAgIGp3dDogaWRUb2tlbixcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIGlmICh0b2tlblNldC5hY2Nlc3NfdG9rZW4gJiYgcGF5bG9hZC5hdF9oYXNoICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIHRyeSB7XG4gICAgICAgIHRva2VuSGFzaC52YWxpZGF0ZShcbiAgICAgICAgICB7IGNsYWltOiAnYXRfaGFzaCcsIHNvdXJjZTogJ2FjY2Vzc190b2tlbicgfSxcbiAgICAgICAgICBwYXlsb2FkLmF0X2hhc2gsXG4gICAgICAgICAgdG9rZW5TZXQuYWNjZXNzX3Rva2VuLFxuICAgICAgICAgIGhlYWRlci5hbGcsXG4gICAgICAgICAga2V5Lmp3ayAmJiBrZXkuandrLmNydixcbiAgICAgICAgKTtcbiAgICAgIH0gY2F0Y2ggKGVycikge1xuICAgICAgICB0aHJvdyBuZXcgUlBFcnJvcih7IG1lc3NhZ2U6IGVyci5tZXNzYWdlLCBqd3Q6IGlkVG9rZW4gfSk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgaWYgKHRva2VuU2V0LmNvZGUgJiYgcGF5bG9hZC5jX2hhc2ggIT09IHVuZGVmaW5lZCkge1xuICAgICAgdHJ5IHtcbiAgICAgICAgdG9rZW5IYXNoLnZhbGlkYXRlKFxuICAgICAgICAgIHsgY2xhaW06ICdjX2hhc2gnLCBzb3VyY2U6ICdjb2RlJyB9LFxuICAgICAgICAgIHBheWxvYWQuY19oYXNoLFxuICAgICAgICAgIHRva2VuU2V0LmNvZGUsXG4gICAgICAgICAgaGVhZGVyLmFsZyxcbiAgICAgICAgICBrZXkuandrICYmIGtleS5qd2suY3J2LFxuICAgICAgICApO1xuICAgICAgfSBjYXRjaCAoZXJyKSB7XG4gICAgICAgIHRocm93IG5ldyBSUEVycm9yKHsgbWVzc2FnZTogZXJyLm1lc3NhZ2UsIGp3dDogaWRUb2tlbiB9KTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gdG9rZW5TZXQ7XG4gIH1cblxuICBhc3luYyB2YWxpZGF0ZUpXVChqd3QsIGV4cGVjdGVkQWxnLCByZXF1aXJlZCA9IFsnaXNzJywgJ3N1YicsICdhdWQnLCAnZXhwJywgJ2lhdCddKSB7XG4gICAgY29uc3QgaXNTZWxmSXNzdWVkID0gdGhpcy5pc3N1ZXIuaXNzdWVyID09PSAnaHR0cHM6Ly9zZWxmLWlzc3VlZC5tZSc7XG4gICAgY29uc3QgdGltZXN0YW1wID0gbm93KCk7XG4gICAgbGV0IGhlYWRlcjtcbiAgICBsZXQgcGF5bG9hZDtcbiAgICB0cnkge1xuICAgICAgKHsgaGVhZGVyLCBwYXlsb2FkIH0gPSBkZWNvZGVKV1Qoand0LCB7IGNvbXBsZXRlOiB0cnVlIH0pKTtcbiAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgcHJpbnRmOiBbJ2ZhaWxlZCB0byBkZWNvZGUgSldUICglczogJXMpJywgZXJyLm5hbWUsIGVyci5tZXNzYWdlXSxcbiAgICAgICAgand0LFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgaWYgKGhlYWRlci5hbGcgIT09IGV4cGVjdGVkQWxnKSB7XG4gICAgICB0aHJvdyBuZXcgUlBFcnJvcih7XG4gICAgICAgIHByaW50ZjogWyd1bmV4cGVjdGVkIEpXVCBhbGcgcmVjZWl2ZWQsIGV4cGVjdGVkICVzLCBnb3Q6ICVzJywgZXhwZWN0ZWRBbGcsIGhlYWRlci5hbGddLFxuICAgICAgICBqd3QsXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICBpZiAoaXNTZWxmSXNzdWVkKSB7XG4gICAgICByZXF1aXJlZCA9IFsuLi5yZXF1aXJlZCwgJ3N1Yl9qd2snXTtcbiAgICB9XG5cbiAgICByZXF1aXJlZC5mb3JFYWNoKHZlcmlmeVByZXNlbmNlLmJpbmQodW5kZWZpbmVkLCBwYXlsb2FkLCBqd3QpKTtcblxuICAgIGlmIChwYXlsb2FkLmlzcyAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBsZXQgZXhwZWN0ZWRJc3MgPSB0aGlzLmlzc3Vlci5pc3N1ZXI7XG5cbiAgICAgIGlmICh0aGlzLiNhYWRJc3NWYWxpZGF0aW9uKSB7XG4gICAgICAgIGV4cGVjdGVkSXNzID0gdGhpcy5pc3N1ZXIuaXNzdWVyLnJlcGxhY2UoJ3t0ZW5hbnRpZH0nLCBwYXlsb2FkLnRpZCk7XG4gICAgICB9XG5cbiAgICAgIGlmIChwYXlsb2FkLmlzcyAhPT0gZXhwZWN0ZWRJc3MpIHtcbiAgICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICAgIHByaW50ZjogWyd1bmV4cGVjdGVkIGlzcyB2YWx1ZSwgZXhwZWN0ZWQgJXMsIGdvdDogJXMnLCBleHBlY3RlZElzcywgcGF5bG9hZC5pc3NdLFxuICAgICAgICAgIGp3dCxcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgaWYgKHBheWxvYWQuaWF0ICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGlmICh0eXBlb2YgcGF5bG9hZC5pYXQgIT09ICdudW1iZXInKSB7XG4gICAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgICBtZXNzYWdlOiAnSldUIGlhdCBjbGFpbSBtdXN0IGJlIGEgSlNPTiBudW1lcmljIHZhbHVlJyxcbiAgICAgICAgICBqd3QsXG4gICAgICAgIH0pO1xuICAgICAgfVxuICAgIH1cblxuICAgIGlmIChwYXlsb2FkLm5iZiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBpZiAodHlwZW9mIHBheWxvYWQubmJmICE9PSAnbnVtYmVyJykge1xuICAgICAgICB0aHJvdyBuZXcgUlBFcnJvcih7XG4gICAgICAgICAgbWVzc2FnZTogJ0pXVCBuYmYgY2xhaW0gbXVzdCBiZSBhIEpTT04gbnVtZXJpYyB2YWx1ZScsXG4gICAgICAgICAgand0LFxuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICAgIGlmIChwYXlsb2FkLm5iZiA+IHRpbWVzdGFtcCArIHRoaXNbQ0xPQ0tfVE9MRVJBTkNFXSkge1xuICAgICAgICB0aHJvdyBuZXcgUlBFcnJvcih7XG4gICAgICAgICAgcHJpbnRmOiBbXG4gICAgICAgICAgICAnSldUIG5vdCBhY3RpdmUgeWV0LCBub3cgJWksIG5iZiAlaScsXG4gICAgICAgICAgICB0aW1lc3RhbXAgKyB0aGlzW0NMT0NLX1RPTEVSQU5DRV0sXG4gICAgICAgICAgICBwYXlsb2FkLm5iZixcbiAgICAgICAgICBdLFxuICAgICAgICAgIG5vdzogdGltZXN0YW1wLFxuICAgICAgICAgIHRvbGVyYW5jZTogdGhpc1tDTE9DS19UT0xFUkFOQ0VdLFxuICAgICAgICAgIG5iZjogcGF5bG9hZC5uYmYsXG4gICAgICAgICAgand0LFxuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBpZiAocGF5bG9hZC5leHAgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaWYgKHR5cGVvZiBwYXlsb2FkLmV4cCAhPT0gJ251bWJlcicpIHtcbiAgICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICAgIG1lc3NhZ2U6ICdKV1QgZXhwIGNsYWltIG11c3QgYmUgYSBKU09OIG51bWVyaWMgdmFsdWUnLFxuICAgICAgICAgIGp3dCxcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgICBpZiAodGltZXN0YW1wIC0gdGhpc1tDTE9DS19UT0xFUkFOQ0VdID49IHBheWxvYWQuZXhwKSB7XG4gICAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgICBwcmludGY6IFsnSldUIGV4cGlyZWQsIG5vdyAlaSwgZXhwICVpJywgdGltZXN0YW1wIC0gdGhpc1tDTE9DS19UT0xFUkFOQ0VdLCBwYXlsb2FkLmV4cF0sXG4gICAgICAgICAgbm93OiB0aW1lc3RhbXAsXG4gICAgICAgICAgdG9sZXJhbmNlOiB0aGlzW0NMT0NLX1RPTEVSQU5DRV0sXG4gICAgICAgICAgZXhwOiBwYXlsb2FkLmV4cCxcbiAgICAgICAgICBqd3QsXG4gICAgICAgIH0pO1xuICAgICAgfVxuICAgIH1cblxuICAgIGlmIChwYXlsb2FkLmF1ZCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBpZiAoQXJyYXkuaXNBcnJheShwYXlsb2FkLmF1ZCkpIHtcbiAgICAgICAgaWYgKHBheWxvYWQuYXVkLmxlbmd0aCA+IDEgJiYgIXBheWxvYWQuYXpwKSB7XG4gICAgICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICAgICAgbWVzc2FnZTogJ21pc3NpbmcgcmVxdWlyZWQgSldUIHByb3BlcnR5IGF6cCcsXG4gICAgICAgICAgICBqd3QsXG4gICAgICAgICAgfSk7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoIXBheWxvYWQuYXVkLmluY2x1ZGVzKHRoaXMuY2xpZW50X2lkKSkge1xuICAgICAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgICAgIHByaW50ZjogW1xuICAgICAgICAgICAgICAnYXVkIGlzIG1pc3NpbmcgdGhlIGNsaWVudF9pZCwgZXhwZWN0ZWQgJXMgdG8gYmUgaW5jbHVkZWQgaW4gJWonLFxuICAgICAgICAgICAgICB0aGlzLmNsaWVudF9pZCxcbiAgICAgICAgICAgICAgcGF5bG9hZC5hdWQsXG4gICAgICAgICAgICBdLFxuICAgICAgICAgICAgand0LFxuICAgICAgICAgIH0pO1xuICAgICAgICB9XG4gICAgICB9IGVsc2UgaWYgKHBheWxvYWQuYXVkICE9PSB0aGlzLmNsaWVudF9pZCkge1xuICAgICAgICB0aHJvdyBuZXcgUlBFcnJvcih7XG4gICAgICAgICAgcHJpbnRmOiBbJ2F1ZCBtaXNtYXRjaCwgZXhwZWN0ZWQgJXMsIGdvdDogJXMnLCB0aGlzLmNsaWVudF9pZCwgcGF5bG9hZC5hdWRdLFxuICAgICAgICAgIGp3dCxcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgaWYgKHBheWxvYWQuYXpwICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGxldCBhZGRpdGlvbmFsQXV0aG9yaXplZFBhcnRpZXMgPSB0aGlzLiNhZGRpdGlvbmFsQXV0aG9yaXplZFBhcnRpZXM7XG5cbiAgICAgIGlmICh0eXBlb2YgYWRkaXRpb25hbEF1dGhvcml6ZWRQYXJ0aWVzID09PSAnc3RyaW5nJykge1xuICAgICAgICBhZGRpdGlvbmFsQXV0aG9yaXplZFBhcnRpZXMgPSBbdGhpcy5jbGllbnRfaWQsIGFkZGl0aW9uYWxBdXRob3JpemVkUGFydGllc107XG4gICAgICB9IGVsc2UgaWYgKEFycmF5LmlzQXJyYXkoYWRkaXRpb25hbEF1dGhvcml6ZWRQYXJ0aWVzKSkge1xuICAgICAgICBhZGRpdGlvbmFsQXV0aG9yaXplZFBhcnRpZXMgPSBbdGhpcy5jbGllbnRfaWQsIC4uLmFkZGl0aW9uYWxBdXRob3JpemVkUGFydGllc107XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBhZGRpdGlvbmFsQXV0aG9yaXplZFBhcnRpZXMgPSBbdGhpcy5jbGllbnRfaWRdO1xuICAgICAgfVxuXG4gICAgICBpZiAoIWFkZGl0aW9uYWxBdXRob3JpemVkUGFydGllcy5pbmNsdWRlcyhwYXlsb2FkLmF6cCkpIHtcbiAgICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICAgIHByaW50ZjogWydhenAgbWlzbWF0Y2gsIGdvdDogJXMnLCBwYXlsb2FkLmF6cF0sXG4gICAgICAgICAgand0LFxuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBsZXQga2V5cztcblxuICAgIGlmIChpc1NlbGZJc3N1ZWQpIHtcbiAgICAgIHRyeSB7XG4gICAgICAgIGFzc2VydChpc1BsYWluT2JqZWN0KHBheWxvYWQuc3ViX2p3aykpO1xuICAgICAgICBjb25zdCBrZXkgPSBhd2FpdCBqb3NlLmltcG9ydEpXSyhwYXlsb2FkLnN1Yl9qd2ssIGhlYWRlci5hbGcpO1xuICAgICAgICBhc3NlcnQuZXF1YWwoa2V5LnR5cGUsICdwdWJsaWMnKTtcbiAgICAgICAga2V5cyA9IFtcbiAgICAgICAgICB7XG4gICAgICAgICAgICBrZXlPYmplY3QoKSB7XG4gICAgICAgICAgICAgIHJldHVybiBrZXk7XG4gICAgICAgICAgICB9LFxuICAgICAgICAgIH0sXG4gICAgICAgIF07XG4gICAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICAgIG1lc3NhZ2U6ICdmYWlsZWQgdG8gdXNlIHN1Yl9qd2sgY2xhaW0gYXMgYW4gYXN5bW1ldHJpYyBKU09OIFdlYiBLZXknLFxuICAgICAgICAgIGp3dCxcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgICBpZiAoKGF3YWl0IGpvc2UuY2FsY3VsYXRlSndrVGh1bWJwcmludChwYXlsb2FkLnN1Yl9qd2spKSAhPT0gcGF5bG9hZC5zdWIpIHtcbiAgICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICAgIG1lc3NhZ2U6ICdmYWlsZWQgdG8gbWF0Y2ggdGhlIHN1YmplY3Qgd2l0aCBzdWJfandrJyxcbiAgICAgICAgICBqd3QsXG4gICAgICAgIH0pO1xuICAgICAgfVxuICAgIH0gZWxzZSBpZiAoaGVhZGVyLmFsZy5zdGFydHNXaXRoKCdIUycpKSB7XG4gICAgICBrZXlzID0gW3RoaXMuc2VjcmV0Rm9yQWxnKGhlYWRlci5hbGcpXTtcbiAgICB9IGVsc2UgaWYgKGhlYWRlci5hbGcgIT09ICdub25lJykge1xuICAgICAga2V5cyA9IGF3YWl0IHF1ZXJ5S2V5U3RvcmUuY2FsbCh0aGlzLmlzc3VlciwgeyAuLi5oZWFkZXIsIHVzZTogJ3NpZycgfSk7XG4gICAgfVxuXG4gICAgaWYgKCFrZXlzICYmIGhlYWRlci5hbGcgPT09ICdub25lJykge1xuICAgICAgcmV0dXJuIHsgcHJvdGVjdGVkOiBoZWFkZXIsIHBheWxvYWQgfTtcbiAgICB9XG5cbiAgICBmb3IgKGNvbnN0IGtleSBvZiBrZXlzKSB7XG4gICAgICBjb25zdCB2ZXJpZmllZCA9IGF3YWl0IGpvc2VcbiAgICAgICAgLmNvbXBhY3RWZXJpZnkoand0LCBrZXkgaW5zdGFuY2VvZiBVaW50OEFycmF5ID8ga2V5IDogYXdhaXQga2V5LmtleU9iamVjdChoZWFkZXIuYWxnKSlcbiAgICAgICAgLmNhdGNoKCgpID0+IHt9KTtcbiAgICAgIGlmICh2ZXJpZmllZCkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgIHBheWxvYWQsXG4gICAgICAgICAgcHJvdGVjdGVkOiB2ZXJpZmllZC5wcm90ZWN0ZWRIZWFkZXIsXG4gICAgICAgICAga2V5LFxuICAgICAgICB9O1xuICAgICAgfVxuICAgIH1cblxuICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgIG1lc3NhZ2U6ICdmYWlsZWQgdG8gdmFsaWRhdGUgSldUIHNpZ25hdHVyZScsXG4gICAgICBqd3QsXG4gICAgfSk7XG4gIH1cblxuICBhc3luYyByZWZyZXNoKHJlZnJlc2hUb2tlbiwgeyBleGNoYW5nZUJvZHksIGNsaWVudEFzc2VydGlvblBheWxvYWQsIERQb1AgfSA9IHt9KSB7XG4gICAgbGV0IHRva2VuID0gcmVmcmVzaFRva2VuO1xuXG4gICAgaWYgKHRva2VuIGluc3RhbmNlb2YgVG9rZW5TZXQpIHtcbiAgICAgIGlmICghdG9rZW4ucmVmcmVzaF90b2tlbikge1xuICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCdyZWZyZXNoX3Rva2VuIG5vdCBwcmVzZW50IGluIFRva2VuU2V0Jyk7XG4gICAgICB9XG4gICAgICB0b2tlbiA9IHRva2VuLnJlZnJlc2hfdG9rZW47XG4gICAgfVxuXG4gICAgY29uc3QgdG9rZW5zZXQgPSBhd2FpdCB0aGlzLmdyYW50KFxuICAgICAge1xuICAgICAgICAuLi5leGNoYW5nZUJvZHksXG4gICAgICAgIGdyYW50X3R5cGU6ICdyZWZyZXNoX3Rva2VuJyxcbiAgICAgICAgcmVmcmVzaF90b2tlbjogU3RyaW5nKHRva2VuKSxcbiAgICAgIH0sXG4gICAgICB7IGNsaWVudEFzc2VydGlvblBheWxvYWQsIERQb1AgfSxcbiAgICApO1xuXG4gICAgaWYgKHRva2Vuc2V0LmlkX3Rva2VuKSB7XG4gICAgICBhd2FpdCB0aGlzLmRlY3J5cHRJZFRva2VuKHRva2Vuc2V0KTtcbiAgICAgIGF3YWl0IHRoaXMudmFsaWRhdGVJZFRva2VuKHRva2Vuc2V0LCBza2lwTm9uY2VDaGVjaywgJ3Rva2VuJywgc2tpcE1heEFnZUNoZWNrKTtcblxuICAgICAgaWYgKHJlZnJlc2hUb2tlbiBpbnN0YW5jZW9mIFRva2VuU2V0ICYmIHJlZnJlc2hUb2tlbi5pZF90b2tlbikge1xuICAgICAgICBjb25zdCBleHBlY3RlZFN1YiA9IHJlZnJlc2hUb2tlbi5jbGFpbXMoKS5zdWI7XG4gICAgICAgIGNvbnN0IGFjdHVhbFN1YiA9IHRva2Vuc2V0LmNsYWltcygpLnN1YjtcbiAgICAgICAgaWYgKGFjdHVhbFN1YiAhPT0gZXhwZWN0ZWRTdWIpIHtcbiAgICAgICAgICB0aHJvdyBuZXcgUlBFcnJvcih7XG4gICAgICAgICAgICBwcmludGY6IFsnc3ViIG1pc21hdGNoLCBleHBlY3RlZCAlcywgZ290OiAlcycsIGV4cGVjdGVkU3ViLCBhY3R1YWxTdWJdLFxuICAgICAgICAgICAgand0OiB0b2tlbnNldC5pZF90b2tlbixcbiAgICAgICAgICB9KTtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cblxuICAgIHJldHVybiB0b2tlbnNldDtcbiAgfVxuXG4gIGFzeW5jIHJlcXVlc3RSZXNvdXJjZShcbiAgICByZXNvdXJjZVVybCxcbiAgICBhY2Nlc3NUb2tlbixcbiAgICB7XG4gICAgICBtZXRob2QsXG4gICAgICBoZWFkZXJzLFxuICAgICAgYm9keSxcbiAgICAgIERQb1AsXG4gICAgICB0b2tlblR5cGUgPSBEUG9QXG4gICAgICAgID8gJ0RQb1AnXG4gICAgICAgIDogYWNjZXNzVG9rZW4gaW5zdGFuY2VvZiBUb2tlblNldFxuICAgICAgICA/IGFjY2Vzc1Rva2VuLnRva2VuX3R5cGVcbiAgICAgICAgOiAnQmVhcmVyJyxcbiAgICB9ID0ge30sXG4gICAgcmV0cnksXG4gICkge1xuICAgIGlmIChhY2Nlc3NUb2tlbiBpbnN0YW5jZW9mIFRva2VuU2V0KSB7XG4gICAgICBpZiAoIWFjY2Vzc1Rva2VuLmFjY2Vzc190b2tlbikge1xuICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCdhY2Nlc3NfdG9rZW4gbm90IHByZXNlbnQgaW4gVG9rZW5TZXQnKTtcbiAgICAgIH1cbiAgICAgIGFjY2Vzc1Rva2VuID0gYWNjZXNzVG9rZW4uYWNjZXNzX3Rva2VuO1xuICAgIH1cblxuICAgIGlmICghYWNjZXNzVG9rZW4pIHtcbiAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ25vIGFjY2VzcyB0b2tlbiBwcm92aWRlZCcpO1xuICAgIH0gZWxzZSBpZiAodHlwZW9mIGFjY2Vzc1Rva2VuICE9PSAnc3RyaW5nJykge1xuICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcignaW52YWxpZCBhY2Nlc3MgdG9rZW4gcHJvdmlkZWQnKTtcbiAgICB9XG5cbiAgICBjb25zdCByZXF1ZXN0T3B0cyA9IHtcbiAgICAgIGhlYWRlcnM6IHtcbiAgICAgICAgQXV0aG9yaXphdGlvbjogYXV0aG9yaXphdGlvbkhlYWRlclZhbHVlKGFjY2Vzc1Rva2VuLCB0b2tlblR5cGUpLFxuICAgICAgICAuLi5oZWFkZXJzLFxuICAgICAgfSxcbiAgICAgIGJvZHksXG4gICAgfTtcblxuICAgIGNvbnN0IG1UTFMgPSAhIXRoaXMudGxzX2NsaWVudF9jZXJ0aWZpY2F0ZV9ib3VuZF9hY2Nlc3NfdG9rZW5zO1xuXG4gICAgY29uc3QgcmVzcG9uc2UgPSBhd2FpdCByZXF1ZXN0LmNhbGwoXG4gICAgICB0aGlzLFxuICAgICAge1xuICAgICAgICAuLi5yZXF1ZXN0T3B0cyxcbiAgICAgICAgcmVzcG9uc2VUeXBlOiAnYnVmZmVyJyxcbiAgICAgICAgbWV0aG9kLFxuICAgICAgICB1cmw6IHJlc291cmNlVXJsLFxuICAgICAgfSxcbiAgICAgIHsgYWNjZXNzVG9rZW4sIG1UTFMsIERQb1AgfSxcbiAgICApO1xuXG4gICAgY29uc3Qgd3d3QXV0aGVudGljYXRlID0gcmVzcG9uc2UuaGVhZGVyc1snd3d3LWF1dGhlbnRpY2F0ZSddO1xuICAgIGlmIChcbiAgICAgIHJldHJ5ICE9PSByZXRyeUF0dGVtcHQgJiZcbiAgICAgIHd3d0F1dGhlbnRpY2F0ZSAmJlxuICAgICAgd3d3QXV0aGVudGljYXRlLnRvTG93ZXJDYXNlKCkuc3RhcnRzV2l0aCgnZHBvcCAnKSAmJlxuICAgICAgcGFyc2VXd3dBdXRoZW50aWNhdGUod3d3QXV0aGVudGljYXRlKS5lcnJvciA9PT0gJ3VzZV9kcG9wX25vbmNlJ1xuICAgICkge1xuICAgICAgcmV0dXJuIHRoaXMucmVxdWVzdFJlc291cmNlKHJlc291cmNlVXJsLCBhY2Nlc3NUb2tlbiwge1xuICAgICAgICBtZXRob2QsXG4gICAgICAgIGhlYWRlcnMsXG4gICAgICAgIGJvZHksXG4gICAgICAgIERQb1AsXG4gICAgICAgIHRva2VuVHlwZSxcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIHJldHVybiByZXNwb25zZTtcbiAgfVxuXG4gIGFzeW5jIHVzZXJpbmZvKGFjY2Vzc1Rva2VuLCB7IG1ldGhvZCA9ICdHRVQnLCB2aWEgPSAnaGVhZGVyJywgdG9rZW5UeXBlLCBwYXJhbXMsIERQb1AgfSA9IHt9KSB7XG4gICAgYXNzZXJ0SXNzdWVyQ29uZmlndXJhdGlvbih0aGlzLmlzc3VlciwgJ3VzZXJpbmZvX2VuZHBvaW50Jyk7XG4gICAgY29uc3Qgb3B0aW9ucyA9IHtcbiAgICAgIHRva2VuVHlwZSxcbiAgICAgIG1ldGhvZDogU3RyaW5nKG1ldGhvZCkudG9VcHBlckNhc2UoKSxcbiAgICAgIERQb1AsXG4gICAgfTtcblxuICAgIGlmIChvcHRpb25zLm1ldGhvZCAhPT0gJ0dFVCcgJiYgb3B0aW9ucy5tZXRob2QgIT09ICdQT1NUJykge1xuICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcignI3VzZXJpbmZvKCkgbWV0aG9kIGNhbiBvbmx5IGJlIFBPU1Qgb3IgYSBHRVQnKTtcbiAgICB9XG5cbiAgICBpZiAodmlhID09PSAnYm9keScgJiYgb3B0aW9ucy5tZXRob2QgIT09ICdQT1NUJykge1xuICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcignY2FuIG9ubHkgc2VuZCBib2R5IG9uIFBPU1QnKTtcbiAgICB9XG5cbiAgICBjb25zdCBqd3QgPSAhISh0aGlzLnVzZXJpbmZvX3NpZ25lZF9yZXNwb25zZV9hbGcgfHwgdGhpcy51c2VyaW5mb19lbmNyeXB0ZWRfcmVzcG9uc2VfYWxnKTtcblxuICAgIGlmIChqd3QpIHtcbiAgICAgIG9wdGlvbnMuaGVhZGVycyA9IHsgQWNjZXB0OiAnYXBwbGljYXRpb24vand0JyB9O1xuICAgIH0gZWxzZSB7XG4gICAgICBvcHRpb25zLmhlYWRlcnMgPSB7IEFjY2VwdDogJ2FwcGxpY2F0aW9uL2pzb24nIH07XG4gICAgfVxuICAgIGNvbnN0IG1UTFMgPSAhIXRoaXMudGxzX2NsaWVudF9jZXJ0aWZpY2F0ZV9ib3VuZF9hY2Nlc3NfdG9rZW5zO1xuXG4gICAgbGV0IHRhcmdldFVybDtcbiAgICBpZiAobVRMUyAmJiB0aGlzLmlzc3Vlci5tdGxzX2VuZHBvaW50X2FsaWFzZXMpIHtcbiAgICAgIHRhcmdldFVybCA9IHRoaXMuaXNzdWVyLm10bHNfZW5kcG9pbnRfYWxpYXNlcy51c2VyaW5mb19lbmRwb2ludDtcbiAgICB9XG5cbiAgICB0YXJnZXRVcmwgPSBuZXcgVVJMKHRhcmdldFVybCB8fCB0aGlzLmlzc3Vlci51c2VyaW5mb19lbmRwb2ludCk7XG5cbiAgICBpZiAodmlhID09PSAnYm9keScpIHtcbiAgICAgIG9wdGlvbnMuaGVhZGVycy5BdXRob3JpemF0aW9uID0gdW5kZWZpbmVkO1xuICAgICAgb3B0aW9ucy5oZWFkZXJzWydDb250ZW50LVR5cGUnXSA9ICdhcHBsaWNhdGlvbi94LXd3dy1mb3JtLXVybGVuY29kZWQnO1xuICAgICAgb3B0aW9ucy5ib2R5ID0gbmV3IFVSTFNlYXJjaFBhcmFtcygpO1xuICAgICAgb3B0aW9ucy5ib2R5LmFwcGVuZChcbiAgICAgICAgJ2FjY2Vzc190b2tlbicsXG4gICAgICAgIGFjY2Vzc1Rva2VuIGluc3RhbmNlb2YgVG9rZW5TZXQgPyBhY2Nlc3NUb2tlbi5hY2Nlc3NfdG9rZW4gOiBhY2Nlc3NUb2tlbixcbiAgICAgICk7XG4gICAgfVxuXG4gICAgLy8gaGFuZGxlIGFkZGl0aW9uYWwgcGFyYW1ldGVycywgR0VUIHZpYSBxdWVyeXN0cmluZywgUE9TVCB2aWEgdXJsZW5jb2RlZCBib2R5XG4gICAgaWYgKHBhcmFtcykge1xuICAgICAgaWYgKG9wdGlvbnMubWV0aG9kID09PSAnR0VUJykge1xuICAgICAgICBPYmplY3QuZW50cmllcyhwYXJhbXMpLmZvckVhY2goKFtrZXksIHZhbHVlXSkgPT4ge1xuICAgICAgICAgIHRhcmdldFVybC5zZWFyY2hQYXJhbXMuYXBwZW5kKGtleSwgdmFsdWUpO1xuICAgICAgICB9KTtcbiAgICAgIH0gZWxzZSBpZiAob3B0aW9ucy5ib2R5KSB7XG4gICAgICAgIC8vIFBPU1QgJiYgdmlhIGJvZHlcbiAgICAgICAgT2JqZWN0LmVudHJpZXMocGFyYW1zKS5mb3JFYWNoKChba2V5LCB2YWx1ZV0pID0+IHtcbiAgICAgICAgICBvcHRpb25zLmJvZHkuYXBwZW5kKGtleSwgdmFsdWUpO1xuICAgICAgICB9KTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIC8vIFBPU1QgJiYgdmlhIGhlYWRlclxuICAgICAgICBvcHRpb25zLmJvZHkgPSBuZXcgVVJMU2VhcmNoUGFyYW1zKCk7XG4gICAgICAgIG9wdGlvbnMuaGVhZGVyc1snQ29udGVudC1UeXBlJ10gPSAnYXBwbGljYXRpb24veC13d3ctZm9ybS11cmxlbmNvZGVkJztcbiAgICAgICAgT2JqZWN0LmVudHJpZXMocGFyYW1zKS5mb3JFYWNoKChba2V5LCB2YWx1ZV0pID0+IHtcbiAgICAgICAgICBvcHRpb25zLmJvZHkuYXBwZW5kKGtleSwgdmFsdWUpO1xuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBpZiAob3B0aW9ucy5ib2R5KSB7XG4gICAgICBvcHRpb25zLmJvZHkgPSBvcHRpb25zLmJvZHkudG9TdHJpbmcoKTtcbiAgICB9XG5cbiAgICBjb25zdCByZXNwb25zZSA9IGF3YWl0IHRoaXMucmVxdWVzdFJlc291cmNlKHRhcmdldFVybCwgYWNjZXNzVG9rZW4sIG9wdGlvbnMpO1xuXG4gICAgbGV0IHBhcnNlZCA9IHByb2Nlc3NSZXNwb25zZShyZXNwb25zZSwgeyBiZWFyZXI6IHRydWUgfSk7XG5cbiAgICBpZiAoand0KSB7XG4gICAgICBpZiAoIS9eYXBwbGljYXRpb25cXC9qd3QvLnRlc3QocmVzcG9uc2UuaGVhZGVyc1snY29udGVudC10eXBlJ10pKSB7XG4gICAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgICBtZXNzYWdlOiAnZXhwZWN0ZWQgYXBwbGljYXRpb24vand0IHJlc3BvbnNlIGZyb20gdGhlIHVzZXJpbmZvX2VuZHBvaW50JyxcbiAgICAgICAgICByZXNwb25zZSxcbiAgICAgICAgfSk7XG4gICAgICB9XG5cbiAgICAgIGNvbnN0IGJvZHkgPSByZXNwb25zZS5ib2R5LnRvU3RyaW5nKCk7XG4gICAgICBjb25zdCB1c2VyaW5mbyA9IGF3YWl0IHRoaXMuZGVjcnlwdEpXVFVzZXJpbmZvKGJvZHkpO1xuICAgICAgaWYgKCF0aGlzLnVzZXJpbmZvX3NpZ25lZF9yZXNwb25zZV9hbGcpIHtcbiAgICAgICAgdHJ5IHtcbiAgICAgICAgICBwYXJzZWQgPSBKU09OLnBhcnNlKHVzZXJpbmZvKTtcbiAgICAgICAgICBhc3NlcnQoaXNQbGFpbk9iamVjdChwYXJzZWQpKTtcbiAgICAgICAgfSBjYXRjaCAoZXJyKSB7XG4gICAgICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICAgICAgbWVzc2FnZTogJ2ZhaWxlZCB0byBwYXJzZSB1c2VyaW5mbyBKV0UgcGF5bG9hZCBhcyBKU09OJyxcbiAgICAgICAgICAgIGp3dDogdXNlcmluZm8sXG4gICAgICAgICAgfSk7XG4gICAgICAgIH1cbiAgICAgIH0gZWxzZSB7XG4gICAgICAgICh7IHBheWxvYWQ6IHBhcnNlZCB9ID0gYXdhaXQgdGhpcy52YWxpZGF0ZUpXVFVzZXJpbmZvKHVzZXJpbmZvKSk7XG4gICAgICB9XG4gICAgfSBlbHNlIHtcbiAgICAgIHRyeSB7XG4gICAgICAgIHBhcnNlZCA9IEpTT04ucGFyc2UocmVzcG9uc2UuYm9keSk7XG4gICAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgICAgT2JqZWN0LmRlZmluZVByb3BlcnR5KGVyciwgJ3Jlc3BvbnNlJywgeyB2YWx1ZTogcmVzcG9uc2UgfSk7XG4gICAgICAgIHRocm93IGVycjtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBpZiAoYWNjZXNzVG9rZW4gaW5zdGFuY2VvZiBUb2tlblNldCAmJiBhY2Nlc3NUb2tlbi5pZF90b2tlbikge1xuICAgICAgY29uc3QgZXhwZWN0ZWRTdWIgPSBhY2Nlc3NUb2tlbi5jbGFpbXMoKS5zdWI7XG4gICAgICBpZiAocGFyc2VkLnN1YiAhPT0gZXhwZWN0ZWRTdWIpIHtcbiAgICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICAgIHByaW50ZjogWyd1c2VyaW5mbyBzdWIgbWlzbWF0Y2gsIGV4cGVjdGVkICVzLCBnb3Q6ICVzJywgZXhwZWN0ZWRTdWIsIHBhcnNlZC5zdWJdLFxuICAgICAgICAgIGJvZHk6IHBhcnNlZCxcbiAgICAgICAgICBqd3Q6IGFjY2Vzc1Rva2VuLmlkX3Rva2VuLFxuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gcGFyc2VkO1xuICB9XG5cbiAgZW5jcnlwdGlvblNlY3JldChsZW4pIHtcbiAgICBjb25zdCBoYXNoID0gbGVuIDw9IDI1NiA/ICdzaGEyNTYnIDogbGVuIDw9IDM4NCA/ICdzaGEzODQnIDogbGVuIDw9IDUxMiA/ICdzaGE1MTInIDogZmFsc2U7XG4gICAgaWYgKCFoYXNoKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ3Vuc3VwcG9ydGVkIHN5bW1ldHJpYyBlbmNyeXB0aW9uIGtleSBkZXJpdmF0aW9uJyk7XG4gICAgfVxuXG4gICAgcmV0dXJuIGNyeXB0b1xuICAgICAgLmNyZWF0ZUhhc2goaGFzaClcbiAgICAgIC51cGRhdGUodGhpcy5jbGllbnRfc2VjcmV0KVxuICAgICAgLmRpZ2VzdCgpXG4gICAgICAuc2xpY2UoMCwgbGVuIC8gOCk7XG4gIH1cblxuICBzZWNyZXRGb3JBbGcoYWxnKSB7XG4gICAgaWYgKCF0aGlzLmNsaWVudF9zZWNyZXQpIHtcbiAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ2NsaWVudF9zZWNyZXQgaXMgcmVxdWlyZWQnKTtcbiAgICB9XG5cbiAgICBpZiAoL15BKFxcZHszfSkoPzpHQ00pP0tXJC8udGVzdChhbGcpKSB7XG4gICAgICByZXR1cm4gdGhpcy5lbmNyeXB0aW9uU2VjcmV0KHBhcnNlSW50KFJlZ0V4cC4kMSwgMTApKTtcbiAgICB9XG5cbiAgICBpZiAoL15BKFxcZHszfSkoPzpHQ018Q0JDLUhTKFxcZHszfSkpJC8udGVzdChhbGcpKSB7XG4gICAgICByZXR1cm4gdGhpcy5lbmNyeXB0aW9uU2VjcmV0KHBhcnNlSW50KFJlZ0V4cC4kMiB8fCBSZWdFeHAuJDEsIDEwKSk7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBUZXh0RW5jb2RlcigpLmVuY29kZSh0aGlzLmNsaWVudF9zZWNyZXQpO1xuICB9XG5cbiAgYXN5bmMgZ3JhbnQoYm9keSwgeyBjbGllbnRBc3NlcnRpb25QYXlsb2FkLCBEUG9QIH0gPSB7fSwgcmV0cnkpIHtcbiAgICBhc3NlcnRJc3N1ZXJDb25maWd1cmF0aW9uKHRoaXMuaXNzdWVyLCAndG9rZW5fZW5kcG9pbnQnKTtcbiAgICBjb25zdCByZXNwb25zZSA9IGF3YWl0IGF1dGhlbnRpY2F0ZWRQb3N0LmNhbGwoXG4gICAgICB0aGlzLFxuICAgICAgJ3Rva2VuJyxcbiAgICAgIHtcbiAgICAgICAgZm9ybTogYm9keSxcbiAgICAgICAgcmVzcG9uc2VUeXBlOiAnanNvbicsXG4gICAgICB9LFxuICAgICAgeyBjbGllbnRBc3NlcnRpb25QYXlsb2FkLCBEUG9QIH0sXG4gICAgKTtcbiAgICBsZXQgcmVzcG9uc2VCb2R5O1xuICAgIHRyeSB7XG4gICAgICByZXNwb25zZUJvZHkgPSBwcm9jZXNzUmVzcG9uc2UocmVzcG9uc2UpO1xuICAgIH0gY2F0Y2ggKGVycikge1xuICAgICAgaWYgKHJldHJ5ICE9PSByZXRyeUF0dGVtcHQgJiYgZXJyIGluc3RhbmNlb2YgT1BFcnJvciAmJiBlcnIuZXJyb3IgPT09ICd1c2VfZHBvcF9ub25jZScpIHtcbiAgICAgICAgcmV0dXJuIHRoaXMuZ3JhbnQoYm9keSwgeyBjbGllbnRBc3NlcnRpb25QYXlsb2FkLCBEUG9QIH0sIHJldHJ5QXR0ZW1wdCk7XG4gICAgICB9XG4gICAgICB0aHJvdyBlcnI7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBUb2tlblNldChyZXNwb25zZUJvZHkpO1xuICB9XG5cbiAgYXN5bmMgZGV2aWNlQXV0aG9yaXphdGlvbihwYXJhbXMgPSB7fSwgeyBleGNoYW5nZUJvZHksIGNsaWVudEFzc2VydGlvblBheWxvYWQsIERQb1AgfSA9IHt9KSB7XG4gICAgYXNzZXJ0SXNzdWVyQ29uZmlndXJhdGlvbih0aGlzLmlzc3VlciwgJ2RldmljZV9hdXRob3JpemF0aW9uX2VuZHBvaW50Jyk7XG4gICAgYXNzZXJ0SXNzdWVyQ29uZmlndXJhdGlvbih0aGlzLmlzc3VlciwgJ3Rva2VuX2VuZHBvaW50Jyk7XG5cbiAgICBjb25zdCBib2R5ID0gYXV0aG9yaXphdGlvblBhcmFtcy5jYWxsKHRoaXMsIHtcbiAgICAgIGNsaWVudF9pZDogdGhpcy5jbGllbnRfaWQsXG4gICAgICByZWRpcmVjdF91cmk6IG51bGwsXG4gICAgICByZXNwb25zZV90eXBlOiBudWxsLFxuICAgICAgLi4ucGFyYW1zLFxuICAgIH0pO1xuXG4gICAgY29uc3QgcmVzcG9uc2UgPSBhd2FpdCBhdXRoZW50aWNhdGVkUG9zdC5jYWxsKFxuICAgICAgdGhpcyxcbiAgICAgICdkZXZpY2VfYXV0aG9yaXphdGlvbicsXG4gICAgICB7XG4gICAgICAgIHJlc3BvbnNlVHlwZTogJ2pzb24nLFxuICAgICAgICBmb3JtOiBib2R5LFxuICAgICAgfSxcbiAgICAgIHsgY2xpZW50QXNzZXJ0aW9uUGF5bG9hZCwgZW5kcG9pbnRBdXRoTWV0aG9kOiAndG9rZW4nIH0sXG4gICAgKTtcbiAgICBjb25zdCByZXNwb25zZUJvZHkgPSBwcm9jZXNzUmVzcG9uc2UocmVzcG9uc2UpO1xuXG4gICAgcmV0dXJuIG5ldyBEZXZpY2VGbG93SGFuZGxlKHtcbiAgICAgIGNsaWVudDogdGhpcyxcbiAgICAgIGV4Y2hhbmdlQm9keSxcbiAgICAgIGNsaWVudEFzc2VydGlvblBheWxvYWQsXG4gICAgICByZXNwb25zZTogcmVzcG9uc2VCb2R5LFxuICAgICAgbWF4QWdlOiBwYXJhbXMubWF4X2FnZSxcbiAgICAgIERQb1AsXG4gICAgfSk7XG4gIH1cblxuICBhc3luYyByZXZva2UodG9rZW4sIGhpbnQsIHsgcmV2b2tlQm9keSwgY2xpZW50QXNzZXJ0aW9uUGF5bG9hZCB9ID0ge30pIHtcbiAgICBhc3NlcnRJc3N1ZXJDb25maWd1cmF0aW9uKHRoaXMuaXNzdWVyLCAncmV2b2NhdGlvbl9lbmRwb2ludCcpO1xuICAgIGlmIChoaW50ICE9PSB1bmRlZmluZWQgJiYgdHlwZW9mIGhpbnQgIT09ICdzdHJpbmcnKSB7XG4gICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCdoaW50IG11c3QgYmUgYSBzdHJpbmcnKTtcbiAgICB9XG5cbiAgICBjb25zdCBmb3JtID0geyAuLi5yZXZva2VCb2R5LCB0b2tlbiB9O1xuXG4gICAgaWYgKGhpbnQpIHtcbiAgICAgIGZvcm0udG9rZW5fdHlwZV9oaW50ID0gaGludDtcbiAgICB9XG5cbiAgICBjb25zdCByZXNwb25zZSA9IGF3YWl0IGF1dGhlbnRpY2F0ZWRQb3N0LmNhbGwoXG4gICAgICB0aGlzLFxuICAgICAgJ3Jldm9jYXRpb24nLFxuICAgICAge1xuICAgICAgICBmb3JtLFxuICAgICAgfSxcbiAgICAgIHsgY2xpZW50QXNzZXJ0aW9uUGF5bG9hZCB9LFxuICAgICk7XG4gICAgcHJvY2Vzc1Jlc3BvbnNlKHJlc3BvbnNlLCB7IGJvZHk6IGZhbHNlIH0pO1xuICB9XG5cbiAgYXN5bmMgaW50cm9zcGVjdCh0b2tlbiwgaGludCwgeyBpbnRyb3NwZWN0Qm9keSwgY2xpZW50QXNzZXJ0aW9uUGF5bG9hZCB9ID0ge30pIHtcbiAgICBhc3NlcnRJc3N1ZXJDb25maWd1cmF0aW9uKHRoaXMuaXNzdWVyLCAnaW50cm9zcGVjdGlvbl9lbmRwb2ludCcpO1xuICAgIGlmIChoaW50ICE9PSB1bmRlZmluZWQgJiYgdHlwZW9mIGhpbnQgIT09ICdzdHJpbmcnKSB7XG4gICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCdoaW50IG11c3QgYmUgYSBzdHJpbmcnKTtcbiAgICB9XG5cbiAgICBjb25zdCBmb3JtID0geyAuLi5pbnRyb3NwZWN0Qm9keSwgdG9rZW4gfTtcbiAgICBpZiAoaGludCkge1xuICAgICAgZm9ybS50b2tlbl90eXBlX2hpbnQgPSBoaW50O1xuICAgIH1cblxuICAgIGNvbnN0IHJlc3BvbnNlID0gYXdhaXQgYXV0aGVudGljYXRlZFBvc3QuY2FsbChcbiAgICAgIHRoaXMsXG4gICAgICAnaW50cm9zcGVjdGlvbicsXG4gICAgICB7IGZvcm0sIHJlc3BvbnNlVHlwZTogJ2pzb24nIH0sXG4gICAgICB7IGNsaWVudEFzc2VydGlvblBheWxvYWQgfSxcbiAgICApO1xuXG4gICAgY29uc3QgcmVzcG9uc2VCb2R5ID0gcHJvY2Vzc1Jlc3BvbnNlKHJlc3BvbnNlKTtcblxuICAgIHJldHVybiByZXNwb25zZUJvZHk7XG4gIH1cblxuICBzdGF0aWMgYXN5bmMgcmVnaXN0ZXIobWV0YWRhdGEsIG9wdGlvbnMgPSB7fSkge1xuICAgIGNvbnN0IHsgaW5pdGlhbEFjY2Vzc1Rva2VuLCBqd2tzLCAuLi5jbGllbnRPcHRpb25zIH0gPSBvcHRpb25zO1xuXG4gICAgYXNzZXJ0SXNzdWVyQ29uZmlndXJhdGlvbih0aGlzLmlzc3VlciwgJ3JlZ2lzdHJhdGlvbl9lbmRwb2ludCcpO1xuXG4gICAgaWYgKGp3a3MgIT09IHVuZGVmaW5lZCAmJiAhKG1ldGFkYXRhLmp3a3MgfHwgbWV0YWRhdGEuandrc191cmkpKSB7XG4gICAgICBjb25zdCBrZXlzdG9yZSA9IGF3YWl0IGdldEtleXN0b3JlLmNhbGwodGhpcywgandrcyk7XG4gICAgICBtZXRhZGF0YS5qd2tzID0ga2V5c3RvcmUudG9KV0tTKCk7XG4gICAgfVxuXG4gICAgY29uc3QgcmVzcG9uc2UgPSBhd2FpdCByZXF1ZXN0LmNhbGwodGhpcywge1xuICAgICAgaGVhZGVyczoge1xuICAgICAgICBBY2NlcHQ6ICdhcHBsaWNhdGlvbi9qc29uJyxcbiAgICAgICAgLi4uKGluaXRpYWxBY2Nlc3NUb2tlblxuICAgICAgICAgID8ge1xuICAgICAgICAgICAgICBBdXRob3JpemF0aW9uOiBhdXRob3JpemF0aW9uSGVhZGVyVmFsdWUoaW5pdGlhbEFjY2Vzc1Rva2VuKSxcbiAgICAgICAgICAgIH1cbiAgICAgICAgICA6IHVuZGVmaW5lZCksXG4gICAgICB9LFxuICAgICAgcmVzcG9uc2VUeXBlOiAnanNvbicsXG4gICAgICBqc29uOiBtZXRhZGF0YSxcbiAgICAgIHVybDogdGhpcy5pc3N1ZXIucmVnaXN0cmF0aW9uX2VuZHBvaW50LFxuICAgICAgbWV0aG9kOiAnUE9TVCcsXG4gICAgfSk7XG4gICAgY29uc3QgcmVzcG9uc2VCb2R5ID0gcHJvY2Vzc1Jlc3BvbnNlKHJlc3BvbnNlLCB7IHN0YXR1c0NvZGU6IDIwMSwgYmVhcmVyOiB0cnVlIH0pO1xuXG4gICAgcmV0dXJuIG5ldyB0aGlzKHJlc3BvbnNlQm9keSwgandrcywgY2xpZW50T3B0aW9ucyk7XG4gIH1cblxuICBnZXQgbWV0YWRhdGEoKSB7XG4gICAgcmV0dXJuIGNsb25lKE9iamVjdC5mcm9tRW50cmllcyh0aGlzLiNtZXRhZGF0YS5lbnRyaWVzKCkpKTtcbiAgfVxuXG4gIHN0YXRpYyBhc3luYyBmcm9tVXJpKHJlZ2lzdHJhdGlvbkNsaWVudFVyaSwgcmVnaXN0cmF0aW9uQWNjZXNzVG9rZW4sIGp3a3MsIGNsaWVudE9wdGlvbnMpIHtcbiAgICBjb25zdCByZXNwb25zZSA9IGF3YWl0IHJlcXVlc3QuY2FsbCh0aGlzLCB7XG4gICAgICBtZXRob2Q6ICdHRVQnLFxuICAgICAgdXJsOiByZWdpc3RyYXRpb25DbGllbnRVcmksXG4gICAgICByZXNwb25zZVR5cGU6ICdqc29uJyxcbiAgICAgIGhlYWRlcnM6IHtcbiAgICAgICAgQXV0aG9yaXphdGlvbjogYXV0aG9yaXphdGlvbkhlYWRlclZhbHVlKHJlZ2lzdHJhdGlvbkFjY2Vzc1Rva2VuKSxcbiAgICAgICAgQWNjZXB0OiAnYXBwbGljYXRpb24vanNvbicsXG4gICAgICB9LFxuICAgIH0pO1xuICAgIGNvbnN0IHJlc3BvbnNlQm9keSA9IHByb2Nlc3NSZXNwb25zZShyZXNwb25zZSwgeyBiZWFyZXI6IHRydWUgfSk7XG5cbiAgICByZXR1cm4gbmV3IHRoaXMocmVzcG9uc2VCb2R5LCBqd2tzLCBjbGllbnRPcHRpb25zKTtcbiAgfVxuXG4gIGFzeW5jIHJlcXVlc3RPYmplY3QoXG4gICAgcmVxdWVzdE9iamVjdCA9IHt9LFxuICAgIHtcbiAgICAgIHNpZ246IHNpZ25pbmdBbGdvcml0aG0gPSB0aGlzLnJlcXVlc3Rfb2JqZWN0X3NpZ25pbmdfYWxnIHx8ICdub25lJyxcbiAgICAgIGVuY3J5cHQ6IHtcbiAgICAgICAgYWxnOiBlS2V5TWFuYWdlbWVudCA9IHRoaXMucmVxdWVzdF9vYmplY3RfZW5jcnlwdGlvbl9hbGcsXG4gICAgICAgIGVuYzogZUNvbnRlbnRFbmNyeXB0aW9uID0gdGhpcy5yZXF1ZXN0X29iamVjdF9lbmNyeXB0aW9uX2VuYyB8fCAnQTEyOENCQy1IUzI1NicsXG4gICAgICB9ID0ge30sXG4gICAgfSA9IHt9LFxuICApIHtcbiAgICBpZiAoIWlzUGxhaW5PYmplY3QocmVxdWVzdE9iamVjdCkpIHtcbiAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ3JlcXVlc3RPYmplY3QgbXVzdCBiZSBhIHBsYWluIG9iamVjdCcpO1xuICAgIH1cblxuICAgIGxldCBzaWduZWQ7XG4gICAgbGV0IGtleTtcbiAgICBjb25zdCB1bml4ID0gbm93KCk7XG4gICAgY29uc3QgaGVhZGVyID0geyBhbGc6IHNpZ25pbmdBbGdvcml0aG0sIHR5cDogJ29hdXRoLWF1dGh6LXJlcStqd3QnIH07XG4gICAgY29uc3QgcGF5bG9hZCA9IEpTT04uc3RyaW5naWZ5KFxuICAgICAgZGVmYXVsdHMoe30sIHJlcXVlc3RPYmplY3QsIHtcbiAgICAgICAgaXNzOiB0aGlzLmNsaWVudF9pZCxcbiAgICAgICAgYXVkOiB0aGlzLmlzc3Vlci5pc3N1ZXIsXG4gICAgICAgIGNsaWVudF9pZDogdGhpcy5jbGllbnRfaWQsXG4gICAgICAgIGp0aTogcmFuZG9tKCksXG4gICAgICAgIGlhdDogdW5peCxcbiAgICAgICAgZXhwOiB1bml4ICsgMzAwLFxuICAgICAgICAuLi4odGhpcy5mYXBpKCkgPyB7IG5iZjogdW5peCB9IDogdW5kZWZpbmVkKSxcbiAgICAgIH0pLFxuICAgICk7XG4gICAgaWYgKHNpZ25pbmdBbGdvcml0aG0gPT09ICdub25lJykge1xuICAgICAgc2lnbmVkID0gW2Jhc2U2NHVybC5lbmNvZGUoSlNPTi5zdHJpbmdpZnkoaGVhZGVyKSksIGJhc2U2NHVybC5lbmNvZGUocGF5bG9hZCksICcnXS5qb2luKCcuJyk7XG4gICAgfSBlbHNlIHtcbiAgICAgIGNvbnN0IHN5bW1ldHJpYyA9IHNpZ25pbmdBbGdvcml0aG0uc3RhcnRzV2l0aCgnSFMnKTtcbiAgICAgIGlmIChzeW1tZXRyaWMpIHtcbiAgICAgICAga2V5ID0gdGhpcy5zZWNyZXRGb3JBbGcoc2lnbmluZ0FsZ29yaXRobSk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBjb25zdCBrZXlzdG9yZSA9IGF3YWl0IGtleXN0b3Jlcy5nZXQodGhpcyk7XG5cbiAgICAgICAgaWYgKCFrZXlzdG9yZSkge1xuICAgICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoXG4gICAgICAgICAgICBgbm8ga2V5c3RvcmUgcHJlc2VudCBmb3IgY2xpZW50LCBjYW5ub3Qgc2lnbiB1c2luZyBhbGcgJHtzaWduaW5nQWxnb3JpdGhtfWAsXG4gICAgICAgICAgKTtcbiAgICAgICAgfVxuICAgICAgICBrZXkgPSBrZXlzdG9yZS5nZXQoeyBhbGc6IHNpZ25pbmdBbGdvcml0aG0sIHVzZTogJ3NpZycgfSk7XG4gICAgICAgIGlmICgha2V5KSB7XG4gICAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcihgbm8ga2V5IHRvIHNpZ24gd2l0aCBmb3VuZCBmb3IgYWxnICR7c2lnbmluZ0FsZ29yaXRobX1gKTtcbiAgICAgICAgfVxuICAgICAgfVxuXG4gICAgICBzaWduZWQgPSBhd2FpdCBuZXcgam9zZS5Db21wYWN0U2lnbihuZXcgVGV4dEVuY29kZXIoKS5lbmNvZGUocGF5bG9hZCkpXG4gICAgICAgIC5zZXRQcm90ZWN0ZWRIZWFkZXIoe1xuICAgICAgICAgIC4uLmhlYWRlcixcbiAgICAgICAgICBraWQ6IHN5bW1ldHJpYyA/IHVuZGVmaW5lZCA6IGtleS5qd2sua2lkLFxuICAgICAgICB9KVxuICAgICAgICAuc2lnbihzeW1tZXRyaWMgPyBrZXkgOiBhd2FpdCBrZXkua2V5T2JqZWN0KHNpZ25pbmdBbGdvcml0aG0pKTtcbiAgICB9XG5cbiAgICBpZiAoIWVLZXlNYW5hZ2VtZW50KSB7XG4gICAgICByZXR1cm4gc2lnbmVkO1xuICAgIH1cblxuICAgIGNvbnN0IGZpZWxkcyA9IHsgYWxnOiBlS2V5TWFuYWdlbWVudCwgZW5jOiBlQ29udGVudEVuY3J5cHRpb24sIGN0eTogJ29hdXRoLWF1dGh6LXJlcStqd3QnIH07XG5cbiAgICBpZiAoZmllbGRzLmFsZy5tYXRjaCgvXihSU0F8RUNESCkvKSkge1xuICAgICAgW2tleV0gPSBhd2FpdCBxdWVyeUtleVN0b3JlLmNhbGwoXG4gICAgICAgIHRoaXMuaXNzdWVyLFxuICAgICAgICB7IGFsZzogZmllbGRzLmFsZywgdXNlOiAnZW5jJyB9LFxuICAgICAgICB7IGFsbG93TXVsdGk6IHRydWUgfSxcbiAgICAgICk7XG4gICAgfSBlbHNlIHtcbiAgICAgIGtleSA9IHRoaXMuc2VjcmV0Rm9yQWxnKGZpZWxkcy5hbGcgPT09ICdkaXInID8gZmllbGRzLmVuYyA6IGZpZWxkcy5hbGcpO1xuICAgIH1cblxuICAgIHJldHVybiBuZXcgam9zZS5Db21wYWN0RW5jcnlwdChuZXcgVGV4dEVuY29kZXIoKS5lbmNvZGUoc2lnbmVkKSlcbiAgICAgIC5zZXRQcm90ZWN0ZWRIZWFkZXIoe1xuICAgICAgICAuLi5maWVsZHMsXG4gICAgICAgIGtpZDoga2V5IGluc3RhbmNlb2YgVWludDhBcnJheSA/IHVuZGVmaW5lZCA6IGtleS5qd2sua2lkLFxuICAgICAgfSlcbiAgICAgIC5lbmNyeXB0KGtleSBpbnN0YW5jZW9mIFVpbnQ4QXJyYXkgPyBrZXkgOiBhd2FpdCBrZXkua2V5T2JqZWN0KGZpZWxkcy5hbGcpKTtcbiAgfVxuXG4gIGFzeW5jIHB1c2hlZEF1dGhvcml6YXRpb25SZXF1ZXN0KHBhcmFtcyA9IHt9LCB7IGNsaWVudEFzc2VydGlvblBheWxvYWQgfSA9IHt9KSB7XG4gICAgYXNzZXJ0SXNzdWVyQ29uZmlndXJhdGlvbih0aGlzLmlzc3VlciwgJ3B1c2hlZF9hdXRob3JpemF0aW9uX3JlcXVlc3RfZW5kcG9pbnQnKTtcblxuICAgIGNvbnN0IGJvZHkgPSB7XG4gICAgICAuLi4oJ3JlcXVlc3QnIGluIHBhcmFtcyA/IHBhcmFtcyA6IGF1dGhvcml6YXRpb25QYXJhbXMuY2FsbCh0aGlzLCBwYXJhbXMpKSxcbiAgICAgIGNsaWVudF9pZDogdGhpcy5jbGllbnRfaWQsXG4gICAgfTtcblxuICAgIGNvbnN0IHJlc3BvbnNlID0gYXdhaXQgYXV0aGVudGljYXRlZFBvc3QuY2FsbChcbiAgICAgIHRoaXMsXG4gICAgICAncHVzaGVkX2F1dGhvcml6YXRpb25fcmVxdWVzdCcsXG4gICAgICB7XG4gICAgICAgIHJlc3BvbnNlVHlwZTogJ2pzb24nLFxuICAgICAgICBmb3JtOiBib2R5LFxuICAgICAgfSxcbiAgICAgIHsgY2xpZW50QXNzZXJ0aW9uUGF5bG9hZCwgZW5kcG9pbnRBdXRoTWV0aG9kOiAndG9rZW4nIH0sXG4gICAgKTtcbiAgICBjb25zdCByZXNwb25zZUJvZHkgPSBwcm9jZXNzUmVzcG9uc2UocmVzcG9uc2UsIHsgc3RhdHVzQ29kZTogMjAxIH0pO1xuXG4gICAgaWYgKCEoJ2V4cGlyZXNfaW4nIGluIHJlc3BvbnNlQm9keSkpIHtcbiAgICAgIHRocm93IG5ldyBSUEVycm9yKHtcbiAgICAgICAgbWVzc2FnZTogJ2V4cGVjdGVkIGV4cGlyZXNfaW4gaW4gUHVzaGVkIEF1dGhvcml6YXRpb24gU3VjY2Vzc2Z1bCBSZXNwb25zZScsXG4gICAgICAgIHJlc3BvbnNlLFxuICAgICAgfSk7XG4gICAgfVxuICAgIGlmICh0eXBlb2YgcmVzcG9uc2VCb2R5LmV4cGlyZXNfaW4gIT09ICdudW1iZXInKSB7XG4gICAgICB0aHJvdyBuZXcgUlBFcnJvcih7XG4gICAgICAgIG1lc3NhZ2U6ICdpbnZhbGlkIGV4cGlyZXNfaW4gdmFsdWUgaW4gUHVzaGVkIEF1dGhvcml6YXRpb24gU3VjY2Vzc2Z1bCBSZXNwb25zZScsXG4gICAgICAgIHJlc3BvbnNlLFxuICAgICAgfSk7XG4gICAgfVxuICAgIGlmICghKCdyZXF1ZXN0X3VyaScgaW4gcmVzcG9uc2VCb2R5KSkge1xuICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICBtZXNzYWdlOiAnZXhwZWN0ZWQgcmVxdWVzdF91cmkgaW4gUHVzaGVkIEF1dGhvcml6YXRpb24gU3VjY2Vzc2Z1bCBSZXNwb25zZScsXG4gICAgICAgIHJlc3BvbnNlLFxuICAgICAgfSk7XG4gICAgfVxuICAgIGlmICh0eXBlb2YgcmVzcG9uc2VCb2R5LnJlcXVlc3RfdXJpICE9PSAnc3RyaW5nJykge1xuICAgICAgdGhyb3cgbmV3IFJQRXJyb3Ioe1xuICAgICAgICBtZXNzYWdlOiAnaW52YWxpZCByZXF1ZXN0X3VyaSB2YWx1ZSBpbiBQdXNoZWQgQXV0aG9yaXphdGlvbiBTdWNjZXNzZnVsIFJlc3BvbnNlJyxcbiAgICAgICAgcmVzcG9uc2UsXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICByZXR1cm4gcmVzcG9uc2VCb2R5O1xuICB9XG5cbiAgZ2V0IGlzc3VlcigpIHtcbiAgICByZXR1cm4gdGhpcy4jaXNzdWVyO1xuICB9XG5cbiAgLyogaXN0YW5idWwgaWdub3JlIG5leHQgKi9cbiAgW2luc3BlY3QuY3VzdG9tXSgpIHtcbiAgICByZXR1cm4gYCR7dGhpcy5jb25zdHJ1Y3Rvci5uYW1lfSAke2luc3BlY3QodGhpcy5tZXRhZGF0YSwge1xuICAgICAgZGVwdGg6IEluZmluaXR5LFxuICAgICAgY29sb3JzOiBwcm9jZXNzLnN0ZG91dC5pc1RUWSxcbiAgICAgIGNvbXBhY3Q6IGZhbHNlLFxuICAgICAgc29ydGVkOiB0cnVlLFxuICAgIH0pfWA7XG4gIH1cblxuICBmYXBpKCkge1xuICAgIHJldHVybiB0aGlzLmZhcGkxKCkgfHwgdGhpcy5mYXBpMigpO1xuICB9XG5cbiAgZmFwaTEoKSB7XG4gICAgcmV0dXJuIHRoaXMuY29uc3RydWN0b3IubmFtZSA9PT0gJ0ZBUEkxQ2xpZW50JztcbiAgfVxuXG4gIGZhcGkyKCkge1xuICAgIHJldHVybiB0aGlzLmNvbnN0cnVjdG9yLm5hbWUgPT09ICdGQVBJMkNsaWVudCc7XG4gIH1cblxuICBhc3luYyB2YWxpZGF0ZUpBUk0ocmVzcG9uc2UpIHtcbiAgICBjb25zdCBleHBlY3RlZEFsZyA9IHRoaXMuYXV0aG9yaXphdGlvbl9zaWduZWRfcmVzcG9uc2VfYWxnO1xuICAgIGNvbnN0IHsgcGF5bG9hZCB9ID0gYXdhaXQgdGhpcy52YWxpZGF0ZUpXVChyZXNwb25zZSwgZXhwZWN0ZWRBbGcsIFsnaXNzJywgJ2V4cCcsICdhdWQnXSk7XG4gICAgcmV0dXJuIHBpY2tDYihwYXlsb2FkKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAbmFtZSBkcG9wUHJvb2ZcbiAgICogQGFwaSBwcml2YXRlXG4gICAqL1xuICBhc3luYyBkcG9wUHJvb2YocGF5bG9hZCwgcHJpdmF0ZUtleUlucHV0LCBhY2Nlc3NUb2tlbikge1xuICAgIGlmICghaXNQbGFpbk9iamVjdChwYXlsb2FkKSkge1xuICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcigncGF5bG9hZCBtdXN0IGJlIGEgcGxhaW4gb2JqZWN0Jyk7XG4gICAgfVxuXG4gICAgbGV0IHByaXZhdGVLZXk7XG4gICAgaWYgKGlzS2V5T2JqZWN0KHByaXZhdGVLZXlJbnB1dCkpIHtcbiAgICAgIHByaXZhdGVLZXkgPSBwcml2YXRlS2V5SW5wdXQ7XG4gICAgfSBlbHNlIGlmIChwcml2YXRlS2V5SW5wdXRbU3ltYm9sLnRvU3RyaW5nVGFnXSA9PT0gJ0NyeXB0b0tleScpIHtcbiAgICAgIHByaXZhdGVLZXkgPSBwcml2YXRlS2V5SW5wdXQ7XG4gICAgfSBlbHNlIGlmIChqb3NlLmNyeXB0b1J1bnRpbWUgPT09ICdub2RlOmNyeXB0bycpIHtcbiAgICAgIHByaXZhdGVLZXkgPSBjcnlwdG8uY3JlYXRlUHJpdmF0ZUtleShwcml2YXRlS2V5SW5wdXQpO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCd1bnJlY29nbml6ZWQgY3J5cHRvIHJ1bnRpbWUnKTtcbiAgICB9XG5cbiAgICBpZiAocHJpdmF0ZUtleS50eXBlICE9PSAncHJpdmF0ZScpIHtcbiAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ1wiRFBvUFwiIG9wdGlvbiBtdXN0IGJlIGEgcHJpdmF0ZSBrZXknKTtcbiAgICB9XG4gICAgbGV0IGFsZyA9IGRldGVybWluZURQb1BBbGdvcml0aG0uY2FsbCh0aGlzLCBwcml2YXRlS2V5LCBwcml2YXRlS2V5SW5wdXQpO1xuXG4gICAgaWYgKCFhbGcpIHtcbiAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ2NvdWxkIG5vdCBkZXRlcm1pbmUgRFBvUCBKV1MgQWxnb3JpdGhtJyk7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBqb3NlLlNpZ25KV1Qoe1xuICAgICAgYXRoOiBhY2Nlc3NUb2tlblxuICAgICAgICA/IGJhc2U2NHVybC5lbmNvZGUoY3J5cHRvLmNyZWF0ZUhhc2goJ3NoYTI1NicpLnVwZGF0ZShhY2Nlc3NUb2tlbikuZGlnZXN0KCkpXG4gICAgICAgIDogdW5kZWZpbmVkLFxuICAgICAgLi4ucGF5bG9hZCxcbiAgICB9KVxuICAgICAgLnNldFByb3RlY3RlZEhlYWRlcih7XG4gICAgICAgIGFsZyxcbiAgICAgICAgdHlwOiAnZHBvcCtqd3QnLFxuICAgICAgICBqd2s6IGF3YWl0IGdldEp3ayhwcml2YXRlS2V5LCBwcml2YXRlS2V5SW5wdXQpLFxuICAgICAgfSlcbiAgICAgIC5zZXRJc3N1ZWRBdCgpXG4gICAgICAuc2V0SnRpKHJhbmRvbSgpKVxuICAgICAgLnNpZ24ocHJpdmF0ZUtleSk7XG4gIH1cbn1cblxuZnVuY3Rpb24gZGV0ZXJtaW5lRFBvUEFsZ29yaXRobUZyb21DcnlwdG9LZXkoY3J5cHRvS2V5KSB7XG4gIHN3aXRjaCAoY3J5cHRvS2V5LmFsZ29yaXRobS5uYW1lKSB7XG4gICAgY2FzZSAnRWQyNTUxOSc6XG4gICAgY2FzZSAnRWQ0NDgnOlxuICAgICAgcmV0dXJuICdFZERTQSc7XG4gICAgY2FzZSAnRUNEU0EnOiB7XG4gICAgICBzd2l0Y2ggKGNyeXB0b0tleS5hbGdvcml0aG0ubmFtZWRDdXJ2ZSkge1xuICAgICAgICBjYXNlICdQLTI1Nic6XG4gICAgICAgICAgcmV0dXJuICdFUzI1Nic7XG4gICAgICAgIGNhc2UgJ1AtMzg0JzpcbiAgICAgICAgICByZXR1cm4gJ0VTMzg0JztcbiAgICAgICAgY2FzZSAnUC01MjEnOlxuICAgICAgICAgIHJldHVybiAnRVM1MTInO1xuICAgICAgICBkZWZhdWx0OlxuICAgICAgICAgIGJyZWFrO1xuICAgICAgfVxuICAgICAgYnJlYWs7XG4gICAgfVxuICAgIGNhc2UgJ1JTQVNTQS1QS0NTMS12MV81JzpcbiAgICAgIHJldHVybiBgUlMke2NyeXB0b0tleS5hbGdvcml0aG0uaGFzaC5uYW1lLnNsaWNlKDQpfWA7XG4gICAgY2FzZSAnUlNBLVBTUyc6XG4gICAgICByZXR1cm4gYFBTJHtjcnlwdG9LZXkuYWxnb3JpdGhtLmhhc2gubmFtZS5zbGljZSg0KX1gO1xuICAgIGRlZmF1bHQ6XG4gICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCd1bnN1cHBvcnRlZCBEUG9QIHByaXZhdGUga2V5Jyk7XG4gIH1cbn1cblxubGV0IGRldGVybWluZURQb1BBbGdvcml0aG07XG5pZiAoam9zZS5jcnlwdG9SdW50aW1lID09PSAnbm9kZTpjcnlwdG8nKSB7XG4gIGRldGVybWluZURQb1BBbGdvcml0aG0gPSBmdW5jdGlvbiAocHJpdmF0ZUtleSwgcHJpdmF0ZUtleUlucHV0KSB7XG4gICAgaWYgKHByaXZhdGVLZXlJbnB1dFtTeW1ib2wudG9TdHJpbmdUYWddID09PSAnQ3J5cHRvS2V5Jykge1xuICAgICAgcmV0dXJuIGRldGVybWluZURQb1BBbGdvcml0aG1Gcm9tQ3J5cHRvS2V5KHByaXZhdGVLZXkpO1xuICAgIH1cblxuICAgIHN3aXRjaCAocHJpdmF0ZUtleS5hc3ltbWV0cmljS2V5VHlwZSkge1xuICAgICAgY2FzZSAnZWQyNTUxOSc6XG4gICAgICBjYXNlICdlZDQ0OCc6XG4gICAgICAgIHJldHVybiAnRWREU0EnO1xuICAgICAgY2FzZSAnZWMnOlxuICAgICAgICByZXR1cm4gZGV0ZXJtaW5lRWNBbGdvcml0aG0ocHJpdmF0ZUtleSwgcHJpdmF0ZUtleUlucHV0KTtcbiAgICAgIGNhc2UgJ3JzYSc6XG4gICAgICBjYXNlIHJzYVBzc1BhcmFtcyAmJiAncnNhLXBzcyc6XG4gICAgICAgIHJldHVybiBkZXRlcm1pbmVSc2FBbGdvcml0aG0oXG4gICAgICAgICAgcHJpdmF0ZUtleSxcbiAgICAgICAgICBwcml2YXRlS2V5SW5wdXQsXG4gICAgICAgICAgdGhpcy5pc3N1ZXIuZHBvcF9zaWduaW5nX2FsZ192YWx1ZXNfc3VwcG9ydGVkLFxuICAgICAgICApO1xuICAgICAgZGVmYXVsdDpcbiAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcigndW5zdXBwb3J0ZWQgRFBvUCBwcml2YXRlIGtleScpO1xuICAgIH1cbiAgfTtcblxuICBjb25zdCBSU1BTID0gL14oPzpSU3xQUykoPzoyNTZ8Mzg0fDUxMikkLztcbiAgZnVuY3Rpb24gZGV0ZXJtaW5lUnNhQWxnb3JpdGhtKHByaXZhdGVLZXksIHByaXZhdGVLZXlJbnB1dCwgdmFsdWVzU3VwcG9ydGVkKSB7XG4gICAgaWYgKFxuICAgICAgdHlwZW9mIHByaXZhdGVLZXlJbnB1dCA9PT0gJ29iamVjdCcgJiZcbiAgICAgIHByaXZhdGVLZXlJbnB1dC5mb3JtYXQgPT09ICdqd2snICYmXG4gICAgICBwcml2YXRlS2V5SW5wdXQua2V5ICYmXG4gICAgICBwcml2YXRlS2V5SW5wdXQua2V5LmFsZ1xuICAgICkge1xuICAgICAgcmV0dXJuIHByaXZhdGVLZXlJbnB1dC5rZXkuYWxnO1xuICAgIH1cblxuICAgIGlmIChBcnJheS5pc0FycmF5KHZhbHVlc1N1cHBvcnRlZCkpIHtcbiAgICAgIGxldCBjYW5kaWRhdGVzID0gdmFsdWVzU3VwcG9ydGVkLmZpbHRlcihSZWdFeHAucHJvdG90eXBlLnRlc3QuYmluZChSU1BTKSk7XG4gICAgICBpZiAocHJpdmF0ZUtleS5hc3ltbWV0cmljS2V5VHlwZSA9PT0gJ3JzYS1wc3MnKSB7XG4gICAgICAgIGNhbmRpZGF0ZXMgPSBjYW5kaWRhdGVzLmZpbHRlcigodmFsdWUpID0+IHZhbHVlLnN0YXJ0c1dpdGgoJ1BTJykpO1xuICAgICAgfVxuICAgICAgcmV0dXJuIFsnUFMyNTYnLCAnUFMzODQnLCAnUFM1MTInLCAnUlMyNTYnLCAnUlMzODQnLCAnUlMzODQnXS5maW5kKChwcmVmZXJyZWQpID0+XG4gICAgICAgIGNhbmRpZGF0ZXMuaW5jbHVkZXMocHJlZmVycmVkKSxcbiAgICAgICk7XG4gICAgfVxuXG4gICAgcmV0dXJuICdQUzI1Nic7XG4gIH1cblxuICBjb25zdCBwMjU2ID0gQnVmZmVyLmZyb20oWzQyLCAxMzQsIDcyLCAyMDYsIDYxLCAzLCAxLCA3XSk7XG4gIGNvbnN0IHAzODQgPSBCdWZmZXIuZnJvbShbNDMsIDEyOSwgNCwgMCwgMzRdKTtcbiAgY29uc3QgcDUyMSA9IEJ1ZmZlci5mcm9tKFs0MywgMTI5LCA0LCAwLCAzNV0pO1xuICBjb25zdCBzZWNwMjU2azEgPSBCdWZmZXIuZnJvbShbNDMsIDEyOSwgNCwgMCwgMTBdKTtcblxuICBmdW5jdGlvbiBkZXRlcm1pbmVFY0FsZ29yaXRobShwcml2YXRlS2V5LCBwcml2YXRlS2V5SW5wdXQpIHtcbiAgICAvLyBJZiBpbnB1dCB3YXMgYSBKV0tcbiAgICBzd2l0Y2ggKFxuICAgICAgdHlwZW9mIHByaXZhdGVLZXlJbnB1dCA9PT0gJ29iamVjdCcgJiZcbiAgICAgIHR5cGVvZiBwcml2YXRlS2V5SW5wdXQua2V5ID09PSAnb2JqZWN0JyAmJlxuICAgICAgcHJpdmF0ZUtleUlucHV0LmtleS5jcnZcbiAgICApIHtcbiAgICAgIGNhc2UgJ1AtMjU2JzpcbiAgICAgICAgcmV0dXJuICdFUzI1Nic7XG4gICAgICBjYXNlICdzZWNwMjU2azEnOlxuICAgICAgICByZXR1cm4gJ0VTMjU2Syc7XG4gICAgICBjYXNlICdQLTM4NCc6XG4gICAgICAgIHJldHVybiAnRVMzODQnO1xuICAgICAgY2FzZSAnUC01MTInOlxuICAgICAgICByZXR1cm4gJ0VTNTEyJztcbiAgICAgIGRlZmF1bHQ6XG4gICAgICAgIGJyZWFrO1xuICAgIH1cblxuICAgIGNvbnN0IGJ1ZiA9IHByaXZhdGVLZXkuZXhwb3J0KHsgZm9ybWF0OiAnZGVyJywgdHlwZTogJ3BrY3M4JyB9KTtcbiAgICBjb25zdCBpID0gYnVmWzFdIDwgMTI4ID8gMTcgOiAxODtcbiAgICBjb25zdCBsZW4gPSBidWZbaV07XG4gICAgY29uc3QgY3VydmVPaWQgPSBidWYuc2xpY2UoaSArIDEsIGkgKyAxICsgbGVuKTtcbiAgICBpZiAoY3VydmVPaWQuZXF1YWxzKHAyNTYpKSB7XG4gICAgICByZXR1cm4gJ0VTMjU2JztcbiAgICB9XG5cbiAgICBpZiAoY3VydmVPaWQuZXF1YWxzKHAzODQpKSB7XG4gICAgICByZXR1cm4gJ0VTMzg0JztcbiAgICB9XG4gICAgaWYgKGN1cnZlT2lkLmVxdWFscyhwNTIxKSkge1xuICAgICAgcmV0dXJuICdFUzUxMic7XG4gICAgfVxuXG4gICAgaWYgKGN1cnZlT2lkLmVxdWFscyhzZWNwMjU2azEpKSB7XG4gICAgICByZXR1cm4gJ0VTMjU2Syc7XG4gICAgfVxuXG4gICAgdGhyb3cgbmV3IFR5cGVFcnJvcigndW5zdXBwb3J0ZWQgRFBvUCBwcml2YXRlIGtleSBjdXJ2ZScpO1xuICB9XG59IGVsc2Uge1xuICBkZXRlcm1pbmVEUG9QQWxnb3JpdGhtID0gZGV0ZXJtaW5lRFBvUEFsZ29yaXRobUZyb21DcnlwdG9LZXk7XG59XG5cbmNvbnN0IGp3a0NhY2hlID0gbmV3IFdlYWtNYXAoKTtcbmFzeW5jIGZ1bmN0aW9uIGdldEp3ayhrZXlPYmplY3QsIHByaXZhdGVLZXlJbnB1dCkge1xuICBpZiAoXG4gICAgam9zZS5jcnlwdG9SdW50aW1lID09PSAnbm9kZTpjcnlwdG8nICYmXG4gICAgdHlwZW9mIHByaXZhdGVLZXlJbnB1dCA9PT0gJ29iamVjdCcgJiZcbiAgICB0eXBlb2YgcHJpdmF0ZUtleUlucHV0LmtleSA9PT0gJ29iamVjdCcgJiZcbiAgICBwcml2YXRlS2V5SW5wdXQuZm9ybWF0ID09PSAnandrJ1xuICApIHtcbiAgICByZXR1cm4gcGljayhwcml2YXRlS2V5SW5wdXQua2V5LCAna3R5JywgJ2NydicsICd4JywgJ3knLCAnZScsICduJyk7XG4gIH1cblxuICBpZiAoandrQ2FjaGUuaGFzKHByaXZhdGVLZXlJbnB1dCkpIHtcbiAgICByZXR1cm4gandrQ2FjaGUuZ2V0KHByaXZhdGVLZXlJbnB1dCk7XG4gIH1cblxuICBjb25zdCBqd2sgPSBwaWNrKGF3YWl0IGpvc2UuZXhwb3J0SldLKGtleU9iamVjdCksICdrdHknLCAnY3J2JywgJ3gnLCAneScsICdlJywgJ24nKTtcblxuICBpZiAoaXNLZXlPYmplY3QocHJpdmF0ZUtleUlucHV0KSB8fCBqb3NlLmNyeXB0b1J1bnRpbWUgPT09ICdXZWJDcnlwdG9BUEknKSB7XG4gICAgandrQ2FjaGUuc2V0KHByaXZhdGVLZXlJbnB1dCwgandrKTtcbiAgfVxuXG4gIHJldHVybiBqd2s7XG59XG5cbm1vZHVsZS5leHBvcnRzID0gKGlzc3VlciwgYWFkSXNzVmFsaWRhdGlvbiA9IGZhbHNlKSA9PlxuICBjbGFzcyBDbGllbnQgZXh0ZW5kcyBCYXNlQ2xpZW50IHtcbiAgICBjb25zdHJ1Y3RvciguLi5hcmdzKSB7XG4gICAgICBzdXBlcihpc3N1ZXIsIGFhZElzc1ZhbGlkYXRpb24sIC4uLmFyZ3MpO1xuICAgIH1cblxuICAgIHN0YXRpYyBnZXQgaXNzdWVyKCkge1xuICAgICAgcmV0dXJuIGlzc3VlcjtcbiAgICB9XG4gIH07XG5cbm1vZHVsZS5leHBvcnRzLkJhc2VDbGllbnQgPSBCYXNlQ2xpZW50O1xuIl0sIm5hbWVzIjpbImluc3BlY3QiLCJyZXF1aXJlIiwic3RkaHR0cCIsImNyeXB0byIsInN0cmljdCIsImFzc2VydCIsInF1ZXJ5c3RyaW5nIiwidXJsIiwiVVJMIiwiVVJMU2VhcmNoUGFyYW1zIiwiam9zZSIsInRva2VuSGFzaCIsImlzS2V5T2JqZWN0IiwiZGVjb2RlSldUIiwiYmFzZTY0dXJsIiwiZGVmYXVsdHMiLCJwYXJzZVd3d0F1dGhlbnRpY2F0ZSIsImFzc2VydFNpZ25pbmdBbGdWYWx1ZXNTdXBwb3J0IiwiYXNzZXJ0SXNzdWVyQ29uZmlndXJhdGlvbiIsInBpY2siLCJpc1BsYWluT2JqZWN0IiwicHJvY2Vzc1Jlc3BvbnNlIiwiVG9rZW5TZXQiLCJPUEVycm9yIiwiUlBFcnJvciIsIm5vdyIsInJhbmRvbSIsInJlcXVlc3QiLCJDTE9DS19UT0xFUkFOQ0UiLCJrZXlzdG9yZXMiLCJLZXlTdG9yZSIsImNsb25lIiwiYXV0aGVudGljYXRlZFBvc3QiLCJyZXNvbHZlUmVzcG9uc2VUeXBlIiwicmVzb2x2ZVJlZGlyZWN0VXJpIiwicXVlcnlLZXlTdG9yZSIsIkRldmljZUZsb3dIYW5kbGUiLCJtYWpvciIsIm1pbm9yIiwicHJvY2VzcyIsInZlcnNpb24iLCJzbGljZSIsInNwbGl0IiwibWFwIiwic3RyIiwicGFyc2VJbnQiLCJyc2FQc3NQYXJhbXMiLCJyZXRyeUF0dGVtcHQiLCJTeW1ib2wiLCJza2lwTm9uY2VDaGVjayIsInNraXBNYXhBZ2VDaGVjayIsInBpY2tDYiIsImlucHV0IiwiYXV0aG9yaXphdGlvbkhlYWRlclZhbHVlIiwidG9rZW4iLCJ0b2tlblR5cGUiLCJnZXRTZWFyY2hQYXJhbXMiLCJwYXJzZWQiLCJwYXJzZSIsInNlYXJjaCIsInN1YnN0cmluZyIsInZlcmlmeVByZXNlbmNlIiwicGF5bG9hZCIsImp3dCIsInByb3AiLCJ1bmRlZmluZWQiLCJtZXNzYWdlIiwiYXV0aG9yaXphdGlvblBhcmFtcyIsInBhcmFtcyIsImF1dGhQYXJhbXMiLCJjbGllbnRfaWQiLCJzY29wZSIsInJlc3BvbnNlX3R5cGUiLCJjYWxsIiwicmVkaXJlY3RfdXJpIiwiT2JqZWN0IiwiZW50cmllcyIsImZvckVhY2giLCJrZXkiLCJ2YWx1ZSIsIkpTT04iLCJzdHJpbmdpZnkiLCJBcnJheSIsImlzQXJyYXkiLCJTdHJpbmciLCJnZXRLZXlzdG9yZSIsImp3a3MiLCJrZXlzIiwic29tZSIsImsiLCJUeXBlRXJyb3IiLCJmcm9tSldLUyIsIm9ubHlQcml2YXRlIiwiY2hlY2tCYXNpY1N1cHBvcnQiLCJjbGllbnQiLCJwcm9wZXJ0aWVzIiwic3VwcG9ydGVkIiwiaXNzdWVyIiwidG9rZW5fZW5kcG9pbnRfYXV0aF9tZXRob2RzX3N1cHBvcnRlZCIsImluY2x1ZGVzIiwidG9rZW5fZW5kcG9pbnRfYXV0aF9tZXRob2QiLCJlcnIiLCJoYW5kbGVDb21tb25NaXN0YWtlcyIsIm1ldGFkYXRhIiwicmVkaXJlY3RfdXJpcyIsInJlc3BvbnNlX3R5cGVzIiwiZ2V0RGVmYXVsdHNGb3JFbmRwb2ludCIsImVuZHBvaW50IiwidG9rZW5FbmRwb2ludEF1dGhNZXRob2QiLCJ0b2tlbkVuZHBvaW50QXV0aFNpZ25pbmdBbGciLCJ0b2tlbl9lbmRwb2ludF9hdXRoX3NpZ25pbmdfYWxnIiwiZWFtIiwiZWFzYSIsIkJhc2VDbGllbnQiLCJhYWRJc3NWYWxpZGF0aW9uIiwiYWRkaXRpb25hbEF1dGhvcml6ZWRQYXJ0aWVzIiwiY29uc3RydWN0b3IiLCJvcHRpb25zIiwiTWFwIiwiZ3JhbnRfdHlwZXMiLCJpZF90b2tlbl9zaWduZWRfcmVzcG9uc2VfYWxnIiwiYXV0aG9yaXphdGlvbl9zaWduZWRfcmVzcG9uc2VfYWxnIiwiZmFwaTEiLCJ0bHNfY2xpZW50X2NlcnRpZmljYXRlX2JvdW5kX2FjY2Vzc190b2tlbnMiLCJmYXBpMiIsImZhcGkiLCJkcG9wX2JvdW5kX2FjY2Vzc190b2tlbnMiLCJzZXQiLCJkZWZpbmVQcm9wZXJ0eSIsImdldCIsImVudW1lcmFibGUiLCJrZXlzdG9yZSIsImF1dGhvcml6YXRpb25VcmwiLCJ0YXJnZXQiLCJhdXRob3JpemF0aW9uX2VuZHBvaW50IiwibmFtZSIsInNlYXJjaFBhcmFtcyIsImRlbGV0ZSIsIm1lbWJlciIsImFwcGVuZCIsImhyZWYiLCJyZXBsYWNlIiwiYXV0aG9yaXphdGlvblBvc3QiLCJpbnB1dHMiLCJmb3JtSW5wdXRzIiwiam9pbiIsImVuZFNlc3Npb25VcmwiLCJwb3N0TG9nb3V0IiwibGVuZ3RoIiwicG9zdF9sb2dvdXRfcmVkaXJlY3RfdXJpcyIsInBvc3RfbG9nb3V0X3JlZGlyZWN0X3VyaSIsImlkX3Rva2VuX2hpbnQiLCJpZF90b2tlbiIsImVuZF9zZXNzaW9uX2VuZHBvaW50IiwicXVlcnkiLCJmb3JtYXQiLCJjYWxsYmFja1BhcmFtcyIsImlzSW5jb21pbmdNZXNzYWdlIiwiSW5jb21pbmdNZXNzYWdlIiwibWV0aG9kIiwiaXNTdHJpbmciLCJib2R5IiwiQnVmZmVyIiwiaXNCdWZmZXIiLCJ0b1N0cmluZyIsImNhbGxiYWNrIiwicmVkaXJlY3RVcmkiLCJwYXJhbWV0ZXJzIiwiY2hlY2tzIiwiZXhjaGFuZ2VCb2R5IiwiY2xpZW50QXNzZXJ0aW9uUGF5bG9hZCIsIkRQb1AiLCJqYXJtIiwiZGVjcnlwdGVkIiwiZGVjcnlwdEpBUk0iLCJyZXNwb25zZSIsInZhbGlkYXRlSkFSTSIsImRlZmF1bHRfbWF4X2FnZSIsIm1heF9hZ2UiLCJzdGF0ZSIsInByaW50ZiIsImlzcyIsImF1dGhvcml6YXRpb25fcmVzcG9uc2VfaXNzX3BhcmFtZXRlcl9zdXBwb3J0ZWQiLCJlcnJvciIsIlJFU1BPTlNFX1RZUEVfUkVRVUlSRURfUEFSQU1TIiwiY29kZSIsInR5cGUiLCJhY2Nlc3NfdG9rZW4iLCJwYXJhbSIsInRva2Vuc2V0IiwiZGVjcnlwdElkVG9rZW4iLCJ2YWxpZGF0ZUlkVG9rZW4iLCJub25jZSIsImdyYW50IiwiZ3JhbnRfdHlwZSIsImNvZGVfdmVyaWZpZXIiLCJzZXNzaW9uX3N0YXRlIiwib2F1dGhDYWxsYmFjayIsImlkX3Rva2VuX2VuY3J5cHRlZF9yZXNwb25zZV9hbGciLCJpZFRva2VuIiwiZXhwZWN0ZWRBbGciLCJleHBlY3RlZEVuYyIsImlkX3Rva2VuX2VuY3J5cHRlZF9yZXNwb25zZV9lbmMiLCJyZXN1bHQiLCJkZWNyeXB0SldFIiwidmFsaWRhdGVKV1RVc2VyaW5mbyIsInVzZXJpbmZvX3NpZ25lZF9yZXNwb25zZV9hbGciLCJ2YWxpZGF0ZUpXVCIsImF1dGhvcml6YXRpb25fZW5jcnlwdGVkX3Jlc3BvbnNlX2FsZyIsImF1dGhvcml6YXRpb25fZW5jcnlwdGVkX3Jlc3BvbnNlX2VuYyIsImRlY3J5cHRKV1RVc2VyaW5mbyIsInVzZXJpbmZvX2VuY3J5cHRlZF9yZXNwb25zZV9hbGciLCJ1c2VyaW5mb19lbmNyeXB0ZWRfcmVzcG9uc2VfZW5jIiwiandlIiwiaGVhZGVyIiwiZGVjb2RlIiwiYWxnIiwiZW5jIiwiZ2V0UGxhaW50ZXh0IiwiVGV4dERlY29kZXIiLCJwbGFpbnRleHQiLCJtYXRjaCIsInByb3RlY3RlZEhlYWRlciIsImRlY29kZVByb3RlY3RlZEhlYWRlciIsImFsbCIsInVzZSIsImNvbXBhY3REZWNyeXB0Iiwia2V5T2JqZWN0IiwidGhlbiIsInNlY3JldEZvckFsZyIsInRva2VuU2V0IiwicmV0dXJuZWRCeSIsIm1heEFnZSIsImlzVG9rZW5TZXQiLCJ0aW1lc3RhbXAiLCJwcm90ZWN0ZWQiLCJyZXF1aXJlX2F1dGhfdGltZSIsImF1dGhfdGltZSIsInRvbGVyYW5jZSIsImF0X2hhc2giLCJjX2hhc2giLCJzX2hhc2giLCJ2YWxpZGF0ZSIsImNsYWltIiwic291cmNlIiwiandrIiwiY3J2IiwiaWF0IiwicmVxdWlyZWQiLCJpc1NlbGZJc3N1ZWQiLCJjb21wbGV0ZSIsImJpbmQiLCJleHBlY3RlZElzcyIsInRpZCIsIm5iZiIsImV4cCIsImF1ZCIsImF6cCIsInN1Yl9qd2siLCJpbXBvcnRKV0siLCJlcXVhbCIsImNhbGN1bGF0ZUp3a1RodW1icHJpbnQiLCJzdWIiLCJzdGFydHNXaXRoIiwidmVyaWZpZWQiLCJjb21wYWN0VmVyaWZ5IiwiVWludDhBcnJheSIsImNhdGNoIiwicmVmcmVzaCIsInJlZnJlc2hUb2tlbiIsInJlZnJlc2hfdG9rZW4iLCJleHBlY3RlZFN1YiIsImNsYWltcyIsImFjdHVhbFN1YiIsInJlcXVlc3RSZXNvdXJjZSIsInJlc291cmNlVXJsIiwiYWNjZXNzVG9rZW4iLCJoZWFkZXJzIiwidG9rZW5fdHlwZSIsInJldHJ5IiwicmVxdWVzdE9wdHMiLCJBdXRob3JpemF0aW9uIiwibVRMUyIsInJlc3BvbnNlVHlwZSIsInd3d0F1dGhlbnRpY2F0ZSIsInRvTG93ZXJDYXNlIiwidXNlcmluZm8iLCJ2aWEiLCJ0b1VwcGVyQ2FzZSIsIkFjY2VwdCIsInRhcmdldFVybCIsIm10bHNfZW5kcG9pbnRfYWxpYXNlcyIsInVzZXJpbmZvX2VuZHBvaW50IiwiYmVhcmVyIiwidGVzdCIsImVuY3J5cHRpb25TZWNyZXQiLCJsZW4iLCJoYXNoIiwiRXJyb3IiLCJjcmVhdGVIYXNoIiwidXBkYXRlIiwiY2xpZW50X3NlY3JldCIsImRpZ2VzdCIsIlJlZ0V4cCIsIiQxIiwiJDIiLCJUZXh0RW5jb2RlciIsImVuY29kZSIsImZvcm0iLCJyZXNwb25zZUJvZHkiLCJkZXZpY2VBdXRob3JpemF0aW9uIiwiZW5kcG9pbnRBdXRoTWV0aG9kIiwicmV2b2tlIiwiaGludCIsInJldm9rZUJvZHkiLCJ0b2tlbl90eXBlX2hpbnQiLCJpbnRyb3NwZWN0IiwiaW50cm9zcGVjdEJvZHkiLCJyZWdpc3RlciIsImluaXRpYWxBY2Nlc3NUb2tlbiIsImNsaWVudE9wdGlvbnMiLCJqd2tzX3VyaSIsInRvSldLUyIsImpzb24iLCJyZWdpc3RyYXRpb25fZW5kcG9pbnQiLCJzdGF0dXNDb2RlIiwiZnJvbUVudHJpZXMiLCJmcm9tVXJpIiwicmVnaXN0cmF0aW9uQ2xpZW50VXJpIiwicmVnaXN0cmF0aW9uQWNjZXNzVG9rZW4iLCJyZXF1ZXN0T2JqZWN0Iiwic2lnbiIsInNpZ25pbmdBbGdvcml0aG0iLCJyZXF1ZXN0X29iamVjdF9zaWduaW5nX2FsZyIsImVuY3J5cHQiLCJlS2V5TWFuYWdlbWVudCIsInJlcXVlc3Rfb2JqZWN0X2VuY3J5cHRpb25fYWxnIiwiZUNvbnRlbnRFbmNyeXB0aW9uIiwicmVxdWVzdF9vYmplY3RfZW5jcnlwdGlvbl9lbmMiLCJzaWduZWQiLCJ1bml4IiwidHlwIiwianRpIiwic3ltbWV0cmljIiwiQ29tcGFjdFNpZ24iLCJzZXRQcm90ZWN0ZWRIZWFkZXIiLCJraWQiLCJmaWVsZHMiLCJjdHkiLCJhbGxvd011bHRpIiwiQ29tcGFjdEVuY3J5cHQiLCJwdXNoZWRBdXRob3JpemF0aW9uUmVxdWVzdCIsImV4cGlyZXNfaW4iLCJyZXF1ZXN0X3VyaSIsImN1c3RvbSIsImRlcHRoIiwiSW5maW5pdHkiLCJjb2xvcnMiLCJzdGRvdXQiLCJpc1RUWSIsImNvbXBhY3QiLCJzb3J0ZWQiLCJkcG9wUHJvb2YiLCJwcml2YXRlS2V5SW5wdXQiLCJwcml2YXRlS2V5IiwidG9TdHJpbmdUYWciLCJjcnlwdG9SdW50aW1lIiwiY3JlYXRlUHJpdmF0ZUtleSIsImRldGVybWluZURQb1BBbGdvcml0aG0iLCJTaWduSldUIiwiYXRoIiwiZ2V0SndrIiwic2V0SXNzdWVkQXQiLCJzZXRKdGkiLCJkZXRlcm1pbmVEUG9QQWxnb3JpdGhtRnJvbUNyeXB0b0tleSIsImNyeXB0b0tleSIsImFsZ29yaXRobSIsIm5hbWVkQ3VydmUiLCJhc3ltbWV0cmljS2V5VHlwZSIsImRldGVybWluZUVjQWxnb3JpdGhtIiwiZGV0ZXJtaW5lUnNhQWxnb3JpdGhtIiwiZHBvcF9zaWduaW5nX2FsZ192YWx1ZXNfc3VwcG9ydGVkIiwiUlNQUyIsInZhbHVlc1N1cHBvcnRlZCIsImNhbmRpZGF0ZXMiLCJmaWx0ZXIiLCJwcm90b3R5cGUiLCJmaW5kIiwicHJlZmVycmVkIiwicDI1NiIsImZyb20iLCJwMzg0IiwicDUyMSIsInNlY3AyNTZrMSIsImJ1ZiIsImV4cG9ydCIsImkiLCJjdXJ2ZU9pZCIsImVxdWFscyIsImp3a0NhY2hlIiwiV2Vha01hcCIsImhhcyIsImV4cG9ydEpXSyIsIm1vZHVsZSIsImV4cG9ydHMiLCJDbGllbnQiLCJhcmdzIl0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/client.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/device_flow_handle.js":
/*!**************************************************************!*\
  !*** ./node_modules/openid-client/lib/device_flow_handle.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const { inspect } = __webpack_require__(/*! util */ \"util\");\n\nconst { RPError, OPError } = __webpack_require__(/*! ./errors */ \"(ssr)/./node_modules/openid-client/lib/errors.js\");\nconst now = __webpack_require__(/*! ./helpers/unix_timestamp */ \"(ssr)/./node_modules/openid-client/lib/helpers/unix_timestamp.js\");\n\nclass DeviceFlowHandle {\n  #aborted;\n  #client;\n  #clientAssertionPayload;\n  #DPoP;\n  #exchangeBody;\n  #expires_at;\n  #interval;\n  #maxAge;\n  #response;\n  constructor({ client, exchangeBody, clientAssertionPayload, response, maxAge, DPoP }) {\n    ['verification_uri', 'user_code', 'device_code'].forEach((prop) => {\n      if (typeof response[prop] !== 'string' || !response[prop]) {\n        throw new RPError(\n          `expected ${prop} string to be returned by Device Authorization Response, got %j`,\n          response[prop],\n        );\n      }\n    });\n\n    if (!Number.isSafeInteger(response.expires_in)) {\n      throw new RPError(\n        'expected expires_in number to be returned by Device Authorization Response, got %j',\n        response.expires_in,\n      );\n    }\n\n    this.#expires_at = now() + response.expires_in;\n    this.#client = client;\n    this.#DPoP = DPoP;\n    this.#maxAge = maxAge;\n    this.#exchangeBody = exchangeBody;\n    this.#clientAssertionPayload = clientAssertionPayload;\n    this.#response = response;\n    this.#interval = response.interval * 1000 || 5000;\n  }\n\n  abort() {\n    this.#aborted = true;\n  }\n\n  async poll({ signal } = {}) {\n    if ((signal && signal.aborted) || this.#aborted) {\n      throw new RPError('polling aborted');\n    }\n\n    if (this.expired()) {\n      throw new RPError(\n        'the device code %j has expired and the device authorization session has concluded',\n        this.device_code,\n      );\n    }\n\n    await new Promise((resolve) => setTimeout(resolve, this.#interval));\n\n    let tokenset;\n    try {\n      tokenset = await this.#client.grant(\n        {\n          ...this.#exchangeBody,\n          grant_type: 'urn:ietf:params:oauth:grant-type:device_code',\n          device_code: this.device_code,\n        },\n        { clientAssertionPayload: this.#clientAssertionPayload, DPoP: this.#DPoP },\n      );\n    } catch (err) {\n      switch (err instanceof OPError && err.error) {\n        case 'slow_down':\n          this.#interval += 5000;\n        case 'authorization_pending':\n          return this.poll({ signal });\n        default:\n          throw err;\n      }\n    }\n\n    if ('id_token' in tokenset) {\n      await this.#client.decryptIdToken(tokenset);\n      await this.#client.validateIdToken(tokenset, undefined, 'token', this.#maxAge);\n    }\n\n    return tokenset;\n  }\n\n  get device_code() {\n    return this.#response.device_code;\n  }\n\n  get user_code() {\n    return this.#response.user_code;\n  }\n\n  get verification_uri() {\n    return this.#response.verification_uri;\n  }\n\n  get verification_uri_complete() {\n    return this.#response.verification_uri_complete;\n  }\n\n  get expires_in() {\n    return Math.max.apply(null, [this.#expires_at - now(), 0]);\n  }\n\n  expired() {\n    return this.expires_in === 0;\n  }\n\n  /* istanbul ignore next */\n  [inspect.custom]() {\n    return `${this.constructor.name} ${inspect(this.#response, {\n      depth: Infinity,\n      colors: process.stdout.isTTY,\n      compact: false,\n      sorted: true,\n    })}`;\n  }\n}\n\nmodule.exports = DeviceFlowHandle;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/device_flow_handle.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/errors.js":
/*!**************************************************!*\
  !*** ./node_modules/openid-client/lib/errors.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const { format } = __webpack_require__(/*! util */ \"util\");\n\nclass OPError extends Error {\n  constructor({ error_description, error, error_uri, session_state, state, scope }, response) {\n    super(!error_description ? error : `${error} (${error_description})`);\n\n    Object.assign(\n      this,\n      { error },\n      error_description && { error_description },\n      error_uri && { error_uri },\n      state && { state },\n      scope && { scope },\n      session_state && { session_state },\n    );\n\n    if (response) {\n      Object.defineProperty(this, 'response', {\n        value: response,\n      });\n    }\n\n    this.name = this.constructor.name;\n    Error.captureStackTrace(this, this.constructor);\n  }\n}\n\nclass RPError extends Error {\n  constructor(...args) {\n    if (typeof args[0] === 'string') {\n      super(format(...args));\n    } else {\n      const { message, printf, response, ...rest } = args[0];\n      if (printf) {\n        super(format(...printf));\n      } else {\n        super(message);\n      }\n      Object.assign(this, rest);\n      if (response) {\n        Object.defineProperty(this, 'response', {\n          value: response,\n        });\n      }\n    }\n\n    this.name = this.constructor.name;\n    Error.captureStackTrace(this, this.constructor);\n  }\n}\n\nmodule.exports = {\n  OPError,\n  RPError,\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/errors.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/assert.js":
/*!**********************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/assert.js ***!
  \**********************************************************/
/***/ ((module) => {

eval("function assertSigningAlgValuesSupport(endpoint, issuer, properties) {\n  if (!issuer[`${endpoint}_endpoint`]) return;\n\n  const eam = `${endpoint}_endpoint_auth_method`;\n  const easa = `${endpoint}_endpoint_auth_signing_alg`;\n  const easavs = `${endpoint}_endpoint_auth_signing_alg_values_supported`;\n\n  if (properties[eam] && properties[eam].endsWith('_jwt') && !properties[easa] && !issuer[easavs]) {\n    throw new TypeError(\n      `${easavs} must be configured on the issuer if ${easa} is not defined on a client`,\n    );\n  }\n}\n\nfunction assertIssuerConfiguration(issuer, endpoint) {\n  if (!issuer[endpoint]) {\n    throw new TypeError(`${endpoint} must be configured on the issuer`);\n  }\n}\n\nmodule.exports = {\n  assertSigningAlgValuesSupport,\n  assertIssuerConfiguration,\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy9hc3NlcnQuanMiLCJtYXBwaW5ncyI6IkFBQUE7QUFDQSxpQkFBaUIsU0FBUzs7QUFFMUIsaUJBQWlCLFNBQVM7QUFDMUIsa0JBQWtCLFNBQVM7QUFDM0Isb0JBQW9CLFNBQVM7O0FBRTdCO0FBQ0E7QUFDQSxTQUFTLFFBQVEsc0NBQXNDLE1BQU07QUFDN0Q7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSwyQkFBMkIsVUFBVTtBQUNyQztBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L2xpYi9oZWxwZXJzL2Fzc2VydC5qcz8zNmYwIl0sInNvdXJjZXNDb250ZW50IjpbImZ1bmN0aW9uIGFzc2VydFNpZ25pbmdBbGdWYWx1ZXNTdXBwb3J0KGVuZHBvaW50LCBpc3N1ZXIsIHByb3BlcnRpZXMpIHtcbiAgaWYgKCFpc3N1ZXJbYCR7ZW5kcG9pbnR9X2VuZHBvaW50YF0pIHJldHVybjtcblxuICBjb25zdCBlYW0gPSBgJHtlbmRwb2ludH1fZW5kcG9pbnRfYXV0aF9tZXRob2RgO1xuICBjb25zdCBlYXNhID0gYCR7ZW5kcG9pbnR9X2VuZHBvaW50X2F1dGhfc2lnbmluZ19hbGdgO1xuICBjb25zdCBlYXNhdnMgPSBgJHtlbmRwb2ludH1fZW5kcG9pbnRfYXV0aF9zaWduaW5nX2FsZ192YWx1ZXNfc3VwcG9ydGVkYDtcblxuICBpZiAocHJvcGVydGllc1tlYW1dICYmIHByb3BlcnRpZXNbZWFtXS5lbmRzV2l0aCgnX2p3dCcpICYmICFwcm9wZXJ0aWVzW2Vhc2FdICYmICFpc3N1ZXJbZWFzYXZzXSkge1xuICAgIHRocm93IG5ldyBUeXBlRXJyb3IoXG4gICAgICBgJHtlYXNhdnN9IG11c3QgYmUgY29uZmlndXJlZCBvbiB0aGUgaXNzdWVyIGlmICR7ZWFzYX0gaXMgbm90IGRlZmluZWQgb24gYSBjbGllbnRgLFxuICAgICk7XG4gIH1cbn1cblxuZnVuY3Rpb24gYXNzZXJ0SXNzdWVyQ29uZmlndXJhdGlvbihpc3N1ZXIsIGVuZHBvaW50KSB7XG4gIGlmICghaXNzdWVyW2VuZHBvaW50XSkge1xuICAgIHRocm93IG5ldyBUeXBlRXJyb3IoYCR7ZW5kcG9pbnR9IG11c3QgYmUgY29uZmlndXJlZCBvbiB0aGUgaXNzdWVyYCk7XG4gIH1cbn1cblxubW9kdWxlLmV4cG9ydHMgPSB7XG4gIGFzc2VydFNpZ25pbmdBbGdWYWx1ZXNTdXBwb3J0LFxuICBhc3NlcnRJc3N1ZXJDb25maWd1cmF0aW9uLFxufTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/assert.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/base64url.js":
/*!*************************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/base64url.js ***!
  \*************************************************************/
/***/ ((module) => {

eval("let encode;\nif (Buffer.isEncoding('base64url')) {\n  encode = (input, encoding = 'utf8') => Buffer.from(input, encoding).toString('base64url');\n} else {\n  const fromBase64 = (base64) => base64.replace(/=/g, '').replace(/\\+/g, '-').replace(/\\//g, '_');\n  encode = (input, encoding = 'utf8') =>\n    fromBase64(Buffer.from(input, encoding).toString('base64'));\n}\n\nconst decode = (input) => Buffer.from(input, 'base64');\n\nmodule.exports.decode = decode;\nmodule.exports.encode = encode;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy9iYXNlNjR1cmwuanMiLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0EsRUFBRTtBQUNGO0FBQ0E7QUFDQTtBQUNBOztBQUVBOztBQUVBLHFCQUFxQjtBQUNyQixxQkFBcUIiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbGliL2hlbHBlcnMvYmFzZTY0dXJsLmpzPzA3NjkiXSwic291cmNlc0NvbnRlbnQiOlsibGV0IGVuY29kZTtcbmlmIChCdWZmZXIuaXNFbmNvZGluZygnYmFzZTY0dXJsJykpIHtcbiAgZW5jb2RlID0gKGlucHV0LCBlbmNvZGluZyA9ICd1dGY4JykgPT4gQnVmZmVyLmZyb20oaW5wdXQsIGVuY29kaW5nKS50b1N0cmluZygnYmFzZTY0dXJsJyk7XG59IGVsc2Uge1xuICBjb25zdCBmcm9tQmFzZTY0ID0gKGJhc2U2NCkgPT4gYmFzZTY0LnJlcGxhY2UoLz0vZywgJycpLnJlcGxhY2UoL1xcKy9nLCAnLScpLnJlcGxhY2UoL1xcLy9nLCAnXycpO1xuICBlbmNvZGUgPSAoaW5wdXQsIGVuY29kaW5nID0gJ3V0ZjgnKSA9PlxuICAgIGZyb21CYXNlNjQoQnVmZmVyLmZyb20oaW5wdXQsIGVuY29kaW5nKS50b1N0cmluZygnYmFzZTY0JykpO1xufVxuXG5jb25zdCBkZWNvZGUgPSAoaW5wdXQpID0+IEJ1ZmZlci5mcm9tKGlucHV0LCAnYmFzZTY0Jyk7XG5cbm1vZHVsZS5leHBvcnRzLmRlY29kZSA9IGRlY29kZTtcbm1vZHVsZS5leHBvcnRzLmVuY29kZSA9IGVuY29kZTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/base64url.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/client.js":
/*!**********************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/client.js ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const jose = __webpack_require__(/*! jose */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/index.js\");\n\nconst { RPError } = __webpack_require__(/*! ../errors */ \"(ssr)/./node_modules/openid-client/lib/errors.js\");\n\nconst { assertIssuerConfiguration } = __webpack_require__(/*! ./assert */ \"(ssr)/./node_modules/openid-client/lib/helpers/assert.js\");\nconst { random } = __webpack_require__(/*! ./generators */ \"(ssr)/./node_modules/openid-client/lib/helpers/generators.js\");\nconst now = __webpack_require__(/*! ./unix_timestamp */ \"(ssr)/./node_modules/openid-client/lib/helpers/unix_timestamp.js\");\nconst request = __webpack_require__(/*! ./request */ \"(ssr)/./node_modules/openid-client/lib/helpers/request.js\");\nconst { keystores } = __webpack_require__(/*! ./weak_cache */ \"(ssr)/./node_modules/openid-client/lib/helpers/weak_cache.js\");\nconst merge = __webpack_require__(/*! ./merge */ \"(ssr)/./node_modules/openid-client/lib/helpers/merge.js\");\n\n// TODO: in v6.x additionally encode the `- _ . ! ~ * ' ( )` characters\n// https://github.com/panva/node-openid-client/commit/5a2ea80ef5e59ec0c03dbd97d82f551e24a9d348\nconst formUrlEncode = (value) => encodeURIComponent(value).replace(/%20/g, '+');\n\nasync function clientAssertion(endpoint, payload) {\n  let alg = this[`${endpoint}_endpoint_auth_signing_alg`];\n  if (!alg) {\n    assertIssuerConfiguration(\n      this.issuer,\n      `${endpoint}_endpoint_auth_signing_alg_values_supported`,\n    );\n  }\n\n  if (this[`${endpoint}_endpoint_auth_method`] === 'client_secret_jwt') {\n    if (!alg) {\n      const supported = this.issuer[`${endpoint}_endpoint_auth_signing_alg_values_supported`];\n      alg =\n        Array.isArray(supported) && supported.find((signAlg) => /^HS(?:256|384|512)/.test(signAlg));\n    }\n\n    if (!alg) {\n      throw new RPError(\n        `failed to determine a JWS Algorithm to use for ${\n          this[`${endpoint}_endpoint_auth_method`]\n        } Client Assertion`,\n      );\n    }\n\n    return new jose.CompactSign(Buffer.from(JSON.stringify(payload)))\n      .setProtectedHeader({ alg })\n      .sign(this.secretForAlg(alg));\n  }\n\n  const keystore = await keystores.get(this);\n\n  if (!keystore) {\n    throw new TypeError('no client jwks provided for signing a client assertion with');\n  }\n\n  if (!alg) {\n    const supported = this.issuer[`${endpoint}_endpoint_auth_signing_alg_values_supported`];\n    alg =\n      Array.isArray(supported) &&\n      supported.find((signAlg) => keystore.get({ alg: signAlg, use: 'sig' }));\n  }\n\n  if (!alg) {\n    throw new RPError(\n      `failed to determine a JWS Algorithm to use for ${\n        this[`${endpoint}_endpoint_auth_method`]\n      } Client Assertion`,\n    );\n  }\n\n  const key = keystore.get({ alg, use: 'sig' });\n  if (!key) {\n    throw new RPError(\n      `no key found in client jwks to sign a client assertion with using alg ${alg}`,\n    );\n  }\n\n  return new jose.CompactSign(Buffer.from(JSON.stringify(payload)))\n    .setProtectedHeader({ alg, kid: key.jwk && key.jwk.kid })\n    .sign(await key.keyObject(alg));\n}\n\nasync function authFor(endpoint, { clientAssertionPayload } = {}) {\n  const authMethod = this[`${endpoint}_endpoint_auth_method`];\n  switch (authMethod) {\n    case 'self_signed_tls_client_auth':\n    case 'tls_client_auth':\n    case 'none':\n      return { form: { client_id: this.client_id } };\n    case 'client_secret_post':\n      if (typeof this.client_secret !== 'string') {\n        throw new TypeError(\n          'client_secret_post client authentication method requires a client_secret',\n        );\n      }\n      return { form: { client_id: this.client_id, client_secret: this.client_secret } };\n    case 'private_key_jwt':\n    case 'client_secret_jwt': {\n      const timestamp = now();\n\n      const assertion = await clientAssertion.call(this, endpoint, {\n        iat: timestamp,\n        exp: timestamp + 60,\n        jti: random(),\n        iss: this.client_id,\n        sub: this.client_id,\n        aud: this.issuer.issuer,\n        ...clientAssertionPayload,\n      });\n\n      return {\n        form: {\n          client_id: this.client_id,\n          client_assertion: assertion,\n          client_assertion_type: 'urn:ietf:params:oauth:client-assertion-type:jwt-bearer',\n        },\n      };\n    }\n    case 'client_secret_basic': {\n      // This is correct behaviour, see https://tools.ietf.org/html/rfc6749#section-2.3.1 and the\n      // related appendix. (also https://github.com/panva/node-openid-client/pull/91)\n      // > The client identifier is encoded using the\n      // > \"application/x-www-form-urlencoded\" encoding algorithm per\n      // > Appendix B, and the encoded value is used as the username; the client\n      // > password is encoded using the same algorithm and used as the\n      // > password.\n      if (typeof this.client_secret !== 'string') {\n        throw new TypeError(\n          'client_secret_basic client authentication method requires a client_secret',\n        );\n      }\n      const encoded = `${formUrlEncode(this.client_id)}:${formUrlEncode(this.client_secret)}`;\n      const value = Buffer.from(encoded).toString('base64');\n      return { headers: { Authorization: `Basic ${value}` } };\n    }\n    default: {\n      throw new TypeError(`missing, or unsupported, ${endpoint}_endpoint_auth_method`);\n    }\n  }\n}\n\nfunction resolveResponseType() {\n  const { length, 0: value } = this.response_types;\n\n  if (length === 1) {\n    return value;\n  }\n\n  return undefined;\n}\n\nfunction resolveRedirectUri() {\n  const { length, 0: value } = this.redirect_uris || [];\n\n  if (length === 1) {\n    return value;\n  }\n\n  return undefined;\n}\n\nasync function authenticatedPost(\n  endpoint,\n  opts,\n  { clientAssertionPayload, endpointAuthMethod = endpoint, DPoP } = {},\n) {\n  const auth = await authFor.call(this, endpointAuthMethod, { clientAssertionPayload });\n  const requestOpts = merge(opts, auth);\n\n  const mTLS =\n    this[`${endpointAuthMethod}_endpoint_auth_method`].includes('tls_client_auth') ||\n    (endpoint === 'token' && this.tls_client_certificate_bound_access_tokens);\n\n  let targetUrl;\n  if (mTLS && this.issuer.mtls_endpoint_aliases) {\n    targetUrl = this.issuer.mtls_endpoint_aliases[`${endpoint}_endpoint`];\n  }\n\n  targetUrl = targetUrl || this.issuer[`${endpoint}_endpoint`];\n\n  if ('form' in requestOpts) {\n    for (const [key, value] of Object.entries(requestOpts.form)) {\n      if (typeof value === 'undefined') {\n        delete requestOpts.form[key];\n      }\n    }\n  }\n\n  return request.call(\n    this,\n    {\n      ...requestOpts,\n      method: 'POST',\n      url: targetUrl,\n      headers: {\n        ...(endpoint !== 'revocation'\n          ? {\n              Accept: 'application/json',\n            }\n          : undefined),\n        ...requestOpts.headers,\n      },\n    },\n    { mTLS, DPoP },\n  );\n}\n\nmodule.exports = {\n  resolveResponseType,\n  resolveRedirectUri,\n  authFor,\n  authenticatedPost,\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/client.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/consts.js":
/*!**********************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/consts.js ***!
  \**********************************************************/
/***/ ((module) => {

eval("const HTTP_OPTIONS = Symbol();\nconst CLOCK_TOLERANCE = Symbol();\n\nmodule.exports = {\n  CLOCK_TOLERANCE,\n  HTTP_OPTIONS,\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy9jb25zdHMuanMiLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy9jb25zdHMuanM/MzY4OCJdLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBIVFRQX09QVElPTlMgPSBTeW1ib2woKTtcbmNvbnN0IENMT0NLX1RPTEVSQU5DRSA9IFN5bWJvbCgpO1xuXG5tb2R1bGUuZXhwb3J0cyA9IHtcbiAgQ0xPQ0tfVE9MRVJBTkNFLFxuICBIVFRQX09QVElPTlMsXG59O1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/consts.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/decode_jwt.js":
/*!**************************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/decode_jwt.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const base64url = __webpack_require__(/*! ./base64url */ \"(ssr)/./node_modules/openid-client/lib/helpers/base64url.js\");\n\nmodule.exports = (token) => {\n  if (typeof token !== 'string' || !token) {\n    throw new TypeError('JWT must be a string');\n  }\n\n  const { 0: header, 1: payload, 2: signature, length } = token.split('.');\n\n  if (length === 5) {\n    throw new TypeError('encrypted JWTs cannot be decoded');\n  }\n\n  if (length !== 3) {\n    throw new Error('JWTs must have three components');\n  }\n\n  try {\n    return {\n      header: JSON.parse(base64url.decode(header)),\n      payload: JSON.parse(base64url.decode(payload)),\n      signature,\n    };\n  } catch (err) {\n    throw new Error('JWT is malformed');\n  }\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy9kZWNvZGVfand0LmpzIiwibWFwcGluZ3MiOiJBQUFBLGtCQUFrQixtQkFBTyxDQUFDLGdGQUFhOztBQUV2QztBQUNBO0FBQ0E7QUFDQTs7QUFFQSxVQUFVLDhDQUE4Qzs7QUFFeEQ7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxJQUFJO0FBQ0o7QUFDQTtBQUNBIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L2xpYi9oZWxwZXJzL2RlY29kZV9qd3QuanM/OTkxMiJdLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBiYXNlNjR1cmwgPSByZXF1aXJlKCcuL2Jhc2U2NHVybCcpO1xuXG5tb2R1bGUuZXhwb3J0cyA9ICh0b2tlbikgPT4ge1xuICBpZiAodHlwZW9mIHRva2VuICE9PSAnc3RyaW5nJyB8fCAhdG9rZW4pIHtcbiAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCdKV1QgbXVzdCBiZSBhIHN0cmluZycpO1xuICB9XG5cbiAgY29uc3QgeyAwOiBoZWFkZXIsIDE6IHBheWxvYWQsIDI6IHNpZ25hdHVyZSwgbGVuZ3RoIH0gPSB0b2tlbi5zcGxpdCgnLicpO1xuXG4gIGlmIChsZW5ndGggPT09IDUpIHtcbiAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCdlbmNyeXB0ZWQgSldUcyBjYW5ub3QgYmUgZGVjb2RlZCcpO1xuICB9XG5cbiAgaWYgKGxlbmd0aCAhPT0gMykge1xuICAgIHRocm93IG5ldyBFcnJvcignSldUcyBtdXN0IGhhdmUgdGhyZWUgY29tcG9uZW50cycpO1xuICB9XG5cbiAgdHJ5IHtcbiAgICByZXR1cm4ge1xuICAgICAgaGVhZGVyOiBKU09OLnBhcnNlKGJhc2U2NHVybC5kZWNvZGUoaGVhZGVyKSksXG4gICAgICBwYXlsb2FkOiBKU09OLnBhcnNlKGJhc2U2NHVybC5kZWNvZGUocGF5bG9hZCkpLFxuICAgICAgc2lnbmF0dXJlLFxuICAgIH07XG4gIH0gY2F0Y2ggKGVycikge1xuICAgIHRocm93IG5ldyBFcnJvcignSldUIGlzIG1hbGZvcm1lZCcpO1xuICB9XG59O1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/decode_jwt.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/deep_clone.js":
/*!**************************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/deep_clone.js ***!
  \**************************************************************/
/***/ ((module) => {

eval("module.exports = globalThis.structuredClone || ((obj) => JSON.parse(JSON.stringify(obj)));\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy9kZWVwX2Nsb25lLmpzIiwibWFwcGluZ3MiOiJBQUFBIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L2xpYi9oZWxwZXJzL2RlZXBfY2xvbmUuanM/MGNmZiJdLCJzb3VyY2VzQ29udGVudCI6WyJtb2R1bGUuZXhwb3J0cyA9IGdsb2JhbFRoaXMuc3RydWN0dXJlZENsb25lIHx8ICgob2JqKSA9PiBKU09OLnBhcnNlKEpTT04uc3RyaW5naWZ5KG9iaikpKTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/deep_clone.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/defaults.js":
/*!************************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/defaults.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const isPlainObject = __webpack_require__(/*! ./is_plain_object */ \"(ssr)/./node_modules/openid-client/lib/helpers/is_plain_object.js\");\n\nfunction defaults(deep, target, ...sources) {\n  for (const source of sources) {\n    if (!isPlainObject(source)) {\n      continue;\n    }\n    for (const [key, value] of Object.entries(source)) {\n      /* istanbul ignore if */\n      if (key === '__proto__' || key === 'constructor') {\n        continue;\n      }\n      if (typeof target[key] === 'undefined' && typeof value !== 'undefined') {\n        target[key] = value;\n      }\n\n      if (deep && isPlainObject(target[key]) && isPlainObject(value)) {\n        defaults(true, target[key], value);\n      }\n    }\n  }\n\n  return target;\n}\n\nmodule.exports = defaults.bind(undefined, false);\nmodule.exports.deep = defaults.bind(undefined, true);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy9kZWZhdWx0cy5qcyIsIm1hcHBpbmdzIjoiQUFBQSxzQkFBc0IsbUJBQU8sQ0FBQyw0RkFBbUI7O0FBRWpEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBLG1CQUFtQiIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy9kZWZhdWx0cy5qcz8wYjlhIl0sInNvdXJjZXNDb250ZW50IjpbImNvbnN0IGlzUGxhaW5PYmplY3QgPSByZXF1aXJlKCcuL2lzX3BsYWluX29iamVjdCcpO1xuXG5mdW5jdGlvbiBkZWZhdWx0cyhkZWVwLCB0YXJnZXQsIC4uLnNvdXJjZXMpIHtcbiAgZm9yIChjb25zdCBzb3VyY2Ugb2Ygc291cmNlcykge1xuICAgIGlmICghaXNQbGFpbk9iamVjdChzb3VyY2UpKSB7XG4gICAgICBjb250aW51ZTtcbiAgICB9XG4gICAgZm9yIChjb25zdCBba2V5LCB2YWx1ZV0gb2YgT2JqZWN0LmVudHJpZXMoc291cmNlKSkge1xuICAgICAgLyogaXN0YW5idWwgaWdub3JlIGlmICovXG4gICAgICBpZiAoa2V5ID09PSAnX19wcm90b19fJyB8fCBrZXkgPT09ICdjb25zdHJ1Y3RvcicpIHtcbiAgICAgICAgY29udGludWU7XG4gICAgICB9XG4gICAgICBpZiAodHlwZW9mIHRhcmdldFtrZXldID09PSAndW5kZWZpbmVkJyAmJiB0eXBlb2YgdmFsdWUgIT09ICd1bmRlZmluZWQnKSB7XG4gICAgICAgIHRhcmdldFtrZXldID0gdmFsdWU7XG4gICAgICB9XG5cbiAgICAgIGlmIChkZWVwICYmIGlzUGxhaW5PYmplY3QodGFyZ2V0W2tleV0pICYmIGlzUGxhaW5PYmplY3QodmFsdWUpKSB7XG4gICAgICAgIGRlZmF1bHRzKHRydWUsIHRhcmdldFtrZXldLCB2YWx1ZSk7XG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIHRhcmdldDtcbn1cblxubW9kdWxlLmV4cG9ydHMgPSBkZWZhdWx0cy5iaW5kKHVuZGVmaW5lZCwgZmFsc2UpO1xubW9kdWxlLmV4cG9ydHMuZGVlcCA9IGRlZmF1bHRzLmJpbmQodW5kZWZpbmVkLCB0cnVlKTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/defaults.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/generators.js":
/*!**************************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/generators.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const { createHash, randomBytes } = __webpack_require__(/*! crypto */ \"crypto\");\n\nconst base64url = __webpack_require__(/*! ./base64url */ \"(ssr)/./node_modules/openid-client/lib/helpers/base64url.js\");\n\nconst random = (bytes = 32) => base64url.encode(randomBytes(bytes));\n\nmodule.exports = {\n  random,\n  state: random,\n  nonce: random,\n  codeVerifier: random,\n  codeChallenge: (codeVerifier) =>\n    base64url.encode(createHash('sha256').update(codeVerifier).digest()),\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy9nZW5lcmF0b3JzLmpzIiwibWFwcGluZ3MiOiJBQUFBLFFBQVEsMEJBQTBCLEVBQUUsbUJBQU8sQ0FBQyxzQkFBUTs7QUFFcEQsa0JBQWtCLG1CQUFPLENBQUMsZ0ZBQWE7O0FBRXZDOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbGliL2hlbHBlcnMvZ2VuZXJhdG9ycy5qcz8yMjZmIl0sInNvdXJjZXNDb250ZW50IjpbImNvbnN0IHsgY3JlYXRlSGFzaCwgcmFuZG9tQnl0ZXMgfSA9IHJlcXVpcmUoJ2NyeXB0bycpO1xuXG5jb25zdCBiYXNlNjR1cmwgPSByZXF1aXJlKCcuL2Jhc2U2NHVybCcpO1xuXG5jb25zdCByYW5kb20gPSAoYnl0ZXMgPSAzMikgPT4gYmFzZTY0dXJsLmVuY29kZShyYW5kb21CeXRlcyhieXRlcykpO1xuXG5tb2R1bGUuZXhwb3J0cyA9IHtcbiAgcmFuZG9tLFxuICBzdGF0ZTogcmFuZG9tLFxuICBub25jZTogcmFuZG9tLFxuICBjb2RlVmVyaWZpZXI6IHJhbmRvbSxcbiAgY29kZUNoYWxsZW5nZTogKGNvZGVWZXJpZmllcikgPT5cbiAgICBiYXNlNjR1cmwuZW5jb2RlKGNyZWF0ZUhhc2goJ3NoYTI1NicpLnVwZGF0ZShjb2RlVmVyaWZpZXIpLmRpZ2VzdCgpKSxcbn07XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/generators.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/is_key_object.js":
/*!*****************************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/is_key_object.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const util = __webpack_require__(/*! util */ \"util\");\nconst crypto = __webpack_require__(/*! crypto */ \"crypto\");\n\nmodule.exports = util.types.isKeyObject || ((obj) => obj && obj instanceof crypto.KeyObject);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy9pc19rZXlfb2JqZWN0LmpzIiwibWFwcGluZ3MiOiJBQUFBLGFBQWEsbUJBQU8sQ0FBQyxrQkFBTTtBQUMzQixlQUFlLG1CQUFPLENBQUMsc0JBQVE7O0FBRS9CIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L2xpYi9oZWxwZXJzL2lzX2tleV9vYmplY3QuanM/MjA0MSJdLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCB1dGlsID0gcmVxdWlyZSgndXRpbCcpO1xuY29uc3QgY3J5cHRvID0gcmVxdWlyZSgnY3J5cHRvJyk7XG5cbm1vZHVsZS5leHBvcnRzID0gdXRpbC50eXBlcy5pc0tleU9iamVjdCB8fCAoKG9iaikgPT4gb2JqICYmIG9iaiBpbnN0YW5jZW9mIGNyeXB0by5LZXlPYmplY3QpO1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/is_key_object.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/is_plain_object.js":
/*!*******************************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/is_plain_object.js ***!
  \*******************************************************************/
/***/ ((module) => {

eval("module.exports = (a) => !!a && a.constructor === Object;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy9pc19wbGFpbl9vYmplY3QuanMiLCJtYXBwaW5ncyI6IkFBQUEiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbGliL2hlbHBlcnMvaXNfcGxhaW5fb2JqZWN0LmpzP2Q0MDIiXSwic291cmNlc0NvbnRlbnQiOlsibW9kdWxlLmV4cG9ydHMgPSAoYSkgPT4gISFhICYmIGEuY29uc3RydWN0b3IgPT09IE9iamVjdDtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/is_plain_object.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/issuer.js":
/*!**********************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/issuer.js ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const objectHash = __webpack_require__(/*! object-hash */ \"(ssr)/./node_modules/openid-client/node_modules/object-hash/index.js\");\nconst LRU = __webpack_require__(/*! lru-cache */ \"(ssr)/./node_modules/openid-client/node_modules/lru-cache/index.js\");\n\nconst { RPError } = __webpack_require__(/*! ../errors */ \"(ssr)/./node_modules/openid-client/lib/errors.js\");\n\nconst { assertIssuerConfiguration } = __webpack_require__(/*! ./assert */ \"(ssr)/./node_modules/openid-client/lib/helpers/assert.js\");\nconst KeyStore = __webpack_require__(/*! ./keystore */ \"(ssr)/./node_modules/openid-client/lib/helpers/keystore.js\");\nconst { keystores } = __webpack_require__(/*! ./weak_cache */ \"(ssr)/./node_modules/openid-client/lib/helpers/weak_cache.js\");\nconst processResponse = __webpack_require__(/*! ./process_response */ \"(ssr)/./node_modules/openid-client/lib/helpers/process_response.js\");\nconst request = __webpack_require__(/*! ./request */ \"(ssr)/./node_modules/openid-client/lib/helpers/request.js\");\n\nconst inFlight = new WeakMap();\nconst caches = new WeakMap();\nconst lrus = (ctx) => {\n  if (!caches.has(ctx)) {\n    caches.set(ctx, new LRU({ max: 100 }));\n  }\n  return caches.get(ctx);\n};\n\nasync function getKeyStore(reload = false) {\n  assertIssuerConfiguration(this, 'jwks_uri');\n\n  const keystore = keystores.get(this);\n  const cache = lrus(this);\n\n  if (reload || !keystore) {\n    if (inFlight.has(this)) {\n      return inFlight.get(this);\n    }\n    cache.reset();\n    inFlight.set(\n      this,\n      (async () => {\n        const response = await request\n          .call(this, {\n            method: 'GET',\n            responseType: 'json',\n            url: this.jwks_uri,\n            headers: {\n              Accept: 'application/json, application/jwk-set+json',\n            },\n          })\n          .finally(() => {\n            inFlight.delete(this);\n          });\n        const jwks = processResponse(response);\n\n        const joseKeyStore = KeyStore.fromJWKS(jwks, { onlyPublic: true });\n        cache.set('throttle', true, 60 * 1000);\n        keystores.set(this, joseKeyStore);\n\n        return joseKeyStore;\n      })(),\n    );\n\n    return inFlight.get(this);\n  }\n\n  return keystore;\n}\n\nasync function queryKeyStore({ kid, kty, alg, use }, { allowMulti = false } = {}) {\n  const cache = lrus(this);\n\n  const def = {\n    kid,\n    kty,\n    alg,\n    use,\n  };\n\n  const defHash = objectHash(def, {\n    algorithm: 'sha256',\n    ignoreUnknown: true,\n    unorderedArrays: true,\n    unorderedSets: true,\n    respectType: false,\n  });\n\n  // refresh keystore on every unknown key but also only upto once every minute\n  const freshJwksUri = cache.get(defHash) || cache.get('throttle');\n\n  const keystore = await getKeyStore.call(this, !freshJwksUri);\n  const keys = keystore.all(def);\n\n  delete def.use;\n  if (keys.length === 0) {\n    throw new RPError({\n      printf: [\"no valid key found in issuer's jwks_uri for key parameters %j\", def],\n      jwks: keystore,\n    });\n  }\n\n  if (!allowMulti && keys.length > 1 && !kid) {\n    throw new RPError({\n      printf: [\n        \"multiple matching keys found in issuer's jwks_uri for key parameters %j, kid must be provided in this case\",\n        def,\n      ],\n      jwks: keystore,\n    });\n  }\n\n  cache.set(defHash, true);\n\n  return keys;\n}\n\nmodule.exports.queryKeyStore = queryKeyStore;\nmodule.exports.keystore = getKeyStore;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/issuer.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/keystore.js":
/*!************************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/keystore.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const jose = __webpack_require__(/*! jose */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/index.js\");\n\nconst clone = __webpack_require__(/*! ./deep_clone */ \"(ssr)/./node_modules/openid-client/lib/helpers/deep_clone.js\");\nconst isPlainObject = __webpack_require__(/*! ./is_plain_object */ \"(ssr)/./node_modules/openid-client/lib/helpers/is_plain_object.js\");\n\nconst internal = Symbol();\n\nconst keyscore = (key, { alg, use }) => {\n  let score = 0;\n\n  if (alg && key.alg) {\n    score++;\n  }\n\n  if (use && key.use) {\n    score++;\n  }\n\n  return score;\n};\n\nfunction getKtyFromAlg(alg) {\n  switch (typeof alg === 'string' && alg.slice(0, 2)) {\n    case 'RS':\n    case 'PS':\n      return 'RSA';\n    case 'ES':\n      return 'EC';\n    case 'Ed':\n      return 'OKP';\n    default:\n      return undefined;\n  }\n}\n\nfunction getAlgorithms(use, alg, kty, crv) {\n  // Ed25519, Ed448, and secp256k1 always have \"alg\"\n  // OKP always has \"use\"\n  if (alg) {\n    return new Set([alg]);\n  }\n\n  switch (kty) {\n    case 'EC': {\n      let algs = [];\n\n      if (use === 'enc' || use === undefined) {\n        algs = algs.concat(['ECDH-ES', 'ECDH-ES+A128KW', 'ECDH-ES+A192KW', 'ECDH-ES+A256KW']);\n      }\n\n      if (use === 'sig' || use === undefined) {\n        switch (crv) {\n          case 'P-256':\n          case 'P-384':\n            algs = algs.concat([`ES${crv.slice(-3)}`]);\n            break;\n          case 'P-521':\n            algs = algs.concat(['ES512']);\n            break;\n          case 'secp256k1':\n            if (jose.cryptoRuntime === 'node:crypto') {\n              algs = algs.concat(['ES256K']);\n            }\n            break;\n        }\n      }\n\n      return new Set(algs);\n    }\n    case 'OKP': {\n      return new Set(['ECDH-ES', 'ECDH-ES+A128KW', 'ECDH-ES+A192KW', 'ECDH-ES+A256KW']);\n    }\n    case 'RSA': {\n      let algs = [];\n\n      if (use === 'enc' || use === undefined) {\n        algs = algs.concat(['RSA-OAEP', 'RSA-OAEP-256', 'RSA-OAEP-384', 'RSA-OAEP-512']);\n        if (jose.cryptoRuntime === 'node:crypto') {\n          algs = algs.concat(['RSA1_5']);\n        }\n      }\n\n      if (use === 'sig' || use === undefined) {\n        algs = algs.concat(['PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512']);\n      }\n\n      return new Set(algs);\n    }\n    default:\n      throw new Error('unreachable');\n  }\n}\n\nmodule.exports = class KeyStore {\n  #keys;\n\n  constructor(i, keys) {\n    if (i !== internal) throw new Error('invalid constructor call');\n    this.#keys = keys;\n  }\n\n  toJWKS() {\n    return {\n      keys: this.map(({ jwk: { d, p, q, dp, dq, qi, ...jwk } }) => jwk),\n    };\n  }\n\n  all({ alg, kid, use } = {}) {\n    if (!use || !alg) {\n      throw new Error();\n    }\n\n    const kty = getKtyFromAlg(alg);\n\n    const search = { alg, use };\n    return this.filter((key) => {\n      let candidate = true;\n\n      if (candidate && kty !== undefined && key.jwk.kty !== kty) {\n        candidate = false;\n      }\n\n      if (candidate && kid !== undefined && key.jwk.kid !== kid) {\n        candidate = false;\n      }\n\n      if (candidate && use !== undefined && key.jwk.use !== undefined && key.jwk.use !== use) {\n        candidate = false;\n      }\n\n      if (candidate && key.jwk.alg && key.jwk.alg !== alg) {\n        candidate = false;\n      } else if (!key.algorithms.has(alg)) {\n        candidate = false;\n      }\n\n      return candidate;\n    }).sort((first, second) => keyscore(second, search) - keyscore(first, search));\n  }\n\n  get(...args) {\n    return this.all(...args)[0];\n  }\n\n  static async fromJWKS(jwks, { onlyPublic = false, onlyPrivate = false } = {}) {\n    if (\n      !isPlainObject(jwks) ||\n      !Array.isArray(jwks.keys) ||\n      jwks.keys.some((k) => !isPlainObject(k) || !('kty' in k))\n    ) {\n      throw new TypeError('jwks must be a JSON Web Key Set formatted object');\n    }\n\n    const keys = [];\n\n    for (let jwk of jwks.keys) {\n      jwk = clone(jwk);\n      const { kty, kid, crv } = jwk;\n\n      let { alg, use } = jwk;\n\n      if (typeof kty !== 'string' || !kty) {\n        continue;\n      }\n\n      if (use !== undefined && use !== 'sig' && use !== 'enc') {\n        continue;\n      }\n\n      if (typeof alg !== 'string' && alg !== undefined) {\n        continue;\n      }\n\n      if (typeof kid !== 'string' && kid !== undefined) {\n        continue;\n      }\n\n      if (kty === 'EC' && use === 'sig') {\n        switch (crv) {\n          case 'P-256':\n            alg = 'ES256';\n            break;\n          case 'P-384':\n            alg = 'ES384';\n            break;\n          case 'P-521':\n            alg = 'ES512';\n            break;\n          default:\n            break;\n        }\n      }\n\n      if (crv === 'secp256k1') {\n        use = 'sig';\n        alg = 'ES256K';\n      }\n\n      if (kty === 'OKP') {\n        switch (crv) {\n          case 'Ed25519':\n          case 'Ed448':\n            use = 'sig';\n            alg = 'EdDSA';\n            break;\n          case 'X25519':\n          case 'X448':\n            use = 'enc';\n            break;\n          default:\n            break;\n        }\n      }\n\n      if (alg && !use) {\n        switch (true) {\n          case alg.startsWith('ECDH'):\n            use = 'enc';\n            break;\n          case alg.startsWith('RSA'):\n            use = 'enc';\n            break;\n          default:\n            break;\n        }\n      }\n\n      if (onlyPrivate && (jwk.kty === 'oct' || !jwk.d)) {\n        throw new Error('jwks must only contain private keys');\n      }\n\n      if (onlyPublic && (jwk.d || jwk.k)) {\n        continue;\n      }\n\n      keys.push({\n        jwk: { ...jwk, alg, use },\n        async keyObject(alg) {\n          if (this[alg]) {\n            return this[alg];\n          }\n\n          const keyObject = await jose.importJWK(this.jwk, alg);\n          this[alg] = keyObject;\n          return keyObject;\n        },\n        get algorithms() {\n          Object.defineProperty(this, 'algorithms', {\n            value: getAlgorithms(this.jwk.use, this.jwk.alg, this.jwk.kty, this.jwk.crv),\n            enumerable: true,\n            configurable: false,\n          });\n          return this.algorithms;\n        },\n      });\n    }\n\n    return new this(internal, keys);\n  }\n\n  filter(...args) {\n    return this.#keys.filter(...args);\n  }\n\n  find(...args) {\n    return this.#keys.find(...args);\n  }\n\n  every(...args) {\n    return this.#keys.every(...args);\n  }\n\n  some(...args) {\n    return this.#keys.some(...args);\n  }\n\n  map(...args) {\n    return this.#keys.map(...args);\n  }\n\n  forEach(...args) {\n    return this.#keys.forEach(...args);\n  }\n\n  reduce(...args) {\n    return this.#keys.reduce(...args);\n  }\n\n  sort(...args) {\n    return this.#keys.sort(...args);\n  }\n\n  *[Symbol.iterator]() {\n    for (const key of this.#keys) {\n      yield key;\n    }\n  }\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/keystore.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/merge.js":
/*!*********************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/merge.js ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const isPlainObject = __webpack_require__(/*! ./is_plain_object */ \"(ssr)/./node_modules/openid-client/lib/helpers/is_plain_object.js\");\n\nfunction merge(target, ...sources) {\n  for (const source of sources) {\n    if (!isPlainObject(source)) {\n      continue;\n    }\n    for (const [key, value] of Object.entries(source)) {\n      /* istanbul ignore if */\n      if (key === '__proto__' || key === 'constructor') {\n        continue;\n      }\n      if (isPlainObject(target[key]) && isPlainObject(value)) {\n        target[key] = merge(target[key], value);\n      } else if (typeof value !== 'undefined') {\n        target[key] = value;\n      }\n    }\n  }\n\n  return target;\n}\n\nmodule.exports = merge;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy9tZXJnZS5qcyIsIm1hcHBpbmdzIjoiQUFBQSxzQkFBc0IsbUJBQU8sQ0FBQyw0RkFBbUI7O0FBRWpEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L2xpYi9oZWxwZXJzL21lcmdlLmpzPzIwZGYiXSwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgaXNQbGFpbk9iamVjdCA9IHJlcXVpcmUoJy4vaXNfcGxhaW5fb2JqZWN0Jyk7XG5cbmZ1bmN0aW9uIG1lcmdlKHRhcmdldCwgLi4uc291cmNlcykge1xuICBmb3IgKGNvbnN0IHNvdXJjZSBvZiBzb3VyY2VzKSB7XG4gICAgaWYgKCFpc1BsYWluT2JqZWN0KHNvdXJjZSkpIHtcbiAgICAgIGNvbnRpbnVlO1xuICAgIH1cbiAgICBmb3IgKGNvbnN0IFtrZXksIHZhbHVlXSBvZiBPYmplY3QuZW50cmllcyhzb3VyY2UpKSB7XG4gICAgICAvKiBpc3RhbmJ1bCBpZ25vcmUgaWYgKi9cbiAgICAgIGlmIChrZXkgPT09ICdfX3Byb3RvX18nIHx8IGtleSA9PT0gJ2NvbnN0cnVjdG9yJykge1xuICAgICAgICBjb250aW51ZTtcbiAgICAgIH1cbiAgICAgIGlmIChpc1BsYWluT2JqZWN0KHRhcmdldFtrZXldKSAmJiBpc1BsYWluT2JqZWN0KHZhbHVlKSkge1xuICAgICAgICB0YXJnZXRba2V5XSA9IG1lcmdlKHRhcmdldFtrZXldLCB2YWx1ZSk7XG4gICAgICB9IGVsc2UgaWYgKHR5cGVvZiB2YWx1ZSAhPT0gJ3VuZGVmaW5lZCcpIHtcbiAgICAgICAgdGFyZ2V0W2tleV0gPSB2YWx1ZTtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICByZXR1cm4gdGFyZ2V0O1xufVxuXG5tb2R1bGUuZXhwb3J0cyA9IG1lcmdlO1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/merge.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/pick.js":
/*!********************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/pick.js ***!
  \********************************************************/
/***/ ((module) => {

eval("module.exports = function pick(object, ...paths) {\n  const obj = {};\n  for (const path of paths) {\n    if (object[path] !== undefined) {\n      obj[path] = object[path];\n    }\n  }\n  return obj;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy9waWNrLmpzIiwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy9waWNrLmpzPzk1NjUiXSwic291cmNlc0NvbnRlbnQiOlsibW9kdWxlLmV4cG9ydHMgPSBmdW5jdGlvbiBwaWNrKG9iamVjdCwgLi4ucGF0aHMpIHtcbiAgY29uc3Qgb2JqID0ge307XG4gIGZvciAoY29uc3QgcGF0aCBvZiBwYXRocykge1xuICAgIGlmIChvYmplY3RbcGF0aF0gIT09IHVuZGVmaW5lZCkge1xuICAgICAgb2JqW3BhdGhdID0gb2JqZWN0W3BhdGhdO1xuICAgIH1cbiAgfVxuICByZXR1cm4gb2JqO1xufTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/pick.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/process_response.js":
/*!********************************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/process_response.js ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const { STATUS_CODES } = __webpack_require__(/*! http */ \"http\");\nconst { format } = __webpack_require__(/*! util */ \"util\");\n\nconst { OPError } = __webpack_require__(/*! ../errors */ \"(ssr)/./node_modules/openid-client/lib/errors.js\");\nconst parseWwwAuthenticate = __webpack_require__(/*! ./www_authenticate_parser */ \"(ssr)/./node_modules/openid-client/lib/helpers/www_authenticate_parser.js\");\n\nconst throwAuthenticateErrors = (response) => {\n  const params = parseWwwAuthenticate(response.headers['www-authenticate']);\n\n  if (params.error) {\n    throw new OPError(params, response);\n  }\n};\n\nconst isStandardBodyError = (response) => {\n  let result = false;\n  try {\n    let jsonbody;\n    if (typeof response.body !== 'object' || Buffer.isBuffer(response.body)) {\n      jsonbody = JSON.parse(response.body);\n    } else {\n      jsonbody = response.body;\n    }\n    result = typeof jsonbody.error === 'string' && jsonbody.error.length;\n    if (result) Object.defineProperty(response, 'body', { value: jsonbody, configurable: true });\n  } catch (err) {}\n\n  return result;\n};\n\nfunction processResponse(response, { statusCode = 200, body = true, bearer = false } = {}) {\n  if (response.statusCode !== statusCode) {\n    if (bearer) {\n      throwAuthenticateErrors(response);\n    }\n\n    if (isStandardBodyError(response)) {\n      throw new OPError(response.body, response);\n    }\n\n    throw new OPError(\n      {\n        error: format(\n          'expected %i %s, got: %i %s',\n          statusCode,\n          STATUS_CODES[statusCode],\n          response.statusCode,\n          STATUS_CODES[response.statusCode],\n        ),\n      },\n      response,\n    );\n  }\n\n  if (body && !response.body) {\n    throw new OPError(\n      {\n        error: format(\n          'expected %i %s with body but no body was returned',\n          statusCode,\n          STATUS_CODES[statusCode],\n        ),\n      },\n      response,\n    );\n  }\n\n  return response.body;\n}\n\nmodule.exports = processResponse;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/process_response.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/request.js":
/*!***********************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/request.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const assert = __webpack_require__(/*! assert */ \"assert\");\nconst querystring = __webpack_require__(/*! querystring */ \"querystring\");\nconst http = __webpack_require__(/*! http */ \"http\");\nconst https = __webpack_require__(/*! https */ \"https\");\nconst { once } = __webpack_require__(/*! events */ \"events\");\nconst { URL } = __webpack_require__(/*! url */ \"url\");\n\nconst LRU = __webpack_require__(/*! lru-cache */ \"(ssr)/./node_modules/openid-client/node_modules/lru-cache/index.js\");\n\nconst pkg = __webpack_require__(/*! ../../package.json */ \"(ssr)/./node_modules/openid-client/package.json\");\nconst { RPError } = __webpack_require__(/*! ../errors */ \"(ssr)/./node_modules/openid-client/lib/errors.js\");\n\nconst pick = __webpack_require__(/*! ./pick */ \"(ssr)/./node_modules/openid-client/lib/helpers/pick.js\");\nconst { deep: defaultsDeep } = __webpack_require__(/*! ./defaults */ \"(ssr)/./node_modules/openid-client/lib/helpers/defaults.js\");\nconst { HTTP_OPTIONS } = __webpack_require__(/*! ./consts */ \"(ssr)/./node_modules/openid-client/lib/helpers/consts.js\");\n\nlet DEFAULT_HTTP_OPTIONS;\nconst NQCHAR = /^[\\x21\\x23-\\x5B\\x5D-\\x7E]+$/;\n\nconst allowed = [\n  'agent',\n  'ca',\n  'cert',\n  'crl',\n  'headers',\n  'key',\n  'lookup',\n  'passphrase',\n  'pfx',\n  'timeout',\n];\n\nconst setDefaults = (props, options) => {\n  DEFAULT_HTTP_OPTIONS = defaultsDeep(\n    {},\n    props.length ? pick(options, ...props) : options,\n    DEFAULT_HTTP_OPTIONS,\n  );\n};\n\nsetDefaults([], {\n  headers: {\n    'User-Agent': `${pkg.name}/${pkg.version} (${pkg.homepage})`,\n    'Accept-Encoding': 'identity',\n  },\n  timeout: 3500,\n});\n\nfunction send(req, body, contentType) {\n  if (contentType) {\n    req.removeHeader('content-type');\n    req.setHeader('content-type', contentType);\n  }\n  if (body) {\n    req.removeHeader('content-length');\n    req.setHeader('content-length', Buffer.byteLength(body));\n    req.write(body);\n  }\n  req.end();\n}\n\nconst nonces = new LRU({ max: 100 });\n\nmodule.exports = async function request(options, { accessToken, mTLS = false, DPoP } = {}) {\n  let url;\n  try {\n    url = new URL(options.url);\n    delete options.url;\n    assert(/^(https?:)$/.test(url.protocol));\n  } catch (err) {\n    throw new TypeError('only valid absolute URLs can be requested');\n  }\n  const optsFn = this[HTTP_OPTIONS];\n  let opts = options;\n\n  const nonceKey = `${url.origin}${url.pathname}`;\n  if (DPoP && 'dpopProof' in this) {\n    opts.headers = opts.headers || {};\n    opts.headers.DPoP = await this.dpopProof(\n      {\n        htu: `${url.origin}${url.pathname}`,\n        htm: options.method || 'GET',\n        nonce: nonces.get(nonceKey),\n      },\n      DPoP,\n      accessToken,\n    );\n  }\n\n  let userOptions;\n  if (optsFn) {\n    userOptions = pick(\n      optsFn.call(this, url, defaultsDeep({}, opts, DEFAULT_HTTP_OPTIONS)),\n      ...allowed,\n    );\n  }\n  opts = defaultsDeep({}, userOptions, opts, DEFAULT_HTTP_OPTIONS);\n\n  if (mTLS && !opts.pfx && !(opts.key && opts.cert)) {\n    throw new TypeError('mutual-TLS certificate and key not set');\n  }\n\n  if (opts.searchParams) {\n    for (const [key, value] of Object.entries(opts.searchParams)) {\n      url.searchParams.delete(key);\n      url.searchParams.set(key, value);\n    }\n  }\n\n  let responseType;\n  let form;\n  let json;\n  let body;\n  ({ form, responseType, json, body, ...opts } = opts);\n\n  for (const [key, value] of Object.entries(opts.headers || {})) {\n    if (value === undefined) {\n      delete opts.headers[key];\n    }\n  }\n\n  let response;\n  const req = (url.protocol === 'https:' ? https.request : http.request)(url.href, opts);\n  return (async () => {\n    if (json) {\n      send(req, JSON.stringify(json), 'application/json');\n    } else if (form) {\n      send(req, querystring.stringify(form), 'application/x-www-form-urlencoded');\n    } else if (body) {\n      send(req, body);\n    } else {\n      send(req);\n    }\n\n    [response] = await Promise.race([once(req, 'response'), once(req, 'timeout')]);\n\n    // timeout reached\n    if (!response) {\n      req.destroy();\n      throw new RPError(`outgoing request timed out after ${opts.timeout}ms`);\n    }\n\n    const parts = [];\n\n    for await (const part of response) {\n      parts.push(part);\n    }\n\n    if (parts.length) {\n      switch (responseType) {\n        case 'json': {\n          Object.defineProperty(response, 'body', {\n            get() {\n              let value = Buffer.concat(parts);\n              try {\n                value = JSON.parse(value);\n              } catch (err) {\n                Object.defineProperty(err, 'response', { value: response });\n                throw err;\n              } finally {\n                Object.defineProperty(response, 'body', { value, configurable: true });\n              }\n              return value;\n            },\n            configurable: true,\n          });\n          break;\n        }\n        case undefined:\n        case 'buffer': {\n          Object.defineProperty(response, 'body', {\n            get() {\n              const value = Buffer.concat(parts);\n              Object.defineProperty(response, 'body', { value, configurable: true });\n              return value;\n            },\n            configurable: true,\n          });\n          break;\n        }\n        default:\n          throw new TypeError('unsupported responseType request option');\n      }\n    }\n\n    return response;\n  })()\n    .catch((err) => {\n      if (response) Object.defineProperty(err, 'response', { value: response });\n      throw err;\n    })\n    .finally(() => {\n      const dpopNonce = response && response.headers['dpop-nonce'];\n      if (dpopNonce && NQCHAR.test(dpopNonce)) {\n        nonces.set(nonceKey, dpopNonce);\n      }\n    });\n};\n\nmodule.exports.setDefaults = setDefaults.bind(undefined, allowed);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/request.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/unix_timestamp.js":
/*!******************************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/unix_timestamp.js ***!
  \******************************************************************/
/***/ ((module) => {

eval("module.exports = () => Math.floor(Date.now() / 1000);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy91bml4X3RpbWVzdGFtcC5qcyIsIm1hcHBpbmdzIjoiQUFBQSIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy91bml4X3RpbWVzdGFtcC5qcz85ZGEzIl0sInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0gKCkgPT4gTWF0aC5mbG9vcihEYXRlLm5vdygpIC8gMTAwMCk7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/unix_timestamp.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/weak_cache.js":
/*!**************************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/weak_cache.js ***!
  \**************************************************************/
/***/ ((module) => {

eval("module.exports.keystores = new WeakMap();\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy93ZWFrX2NhY2hlLmpzIiwibWFwcGluZ3MiOiJBQUFBLHdCQUF3QiIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy93ZWFrX2NhY2hlLmpzPzY5M2QiXSwic291cmNlc0NvbnRlbnQiOlsibW9kdWxlLmV4cG9ydHMua2V5c3RvcmVzID0gbmV3IFdlYWtNYXAoKTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/weak_cache.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/webfinger_normalize.js":
/*!***********************************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/webfinger_normalize.js ***!
  \***********************************************************************/
/***/ ((module) => {

eval("// Credit: https://github.com/rohe/pyoidc/blob/master/src/oic/utils/webfinger.py\n\n// -- Normalization --\n// A string of any other type is interpreted as a URI either the form of scheme\n// \"://\" authority path-abempty [ \"?\" query ] [ \"#\" fragment ] or authority\n// path-abempty [ \"?\" query ] [ \"#\" fragment ] per RFC 3986 [RFC3986] and is\n// normalized according to the following rules:\n//\n// If the user input Identifier does not have an RFC 3986 [RFC3986] scheme\n// portion, the string is interpreted as [userinfo \"@\"] host [\":\" port]\n// path-abempty [ \"?\" query ] [ \"#\" fragment ] per RFC 3986 [RFC3986].\n// If the userinfo component is present and all of the path component, query\n// component, and port component are empty, the acct scheme is assumed. In this\n// case, the normalized URI is formed by prefixing acct: to the string as the\n// scheme. Per the 'acct' URI Scheme [I‑D.ietf‑appsawg‑acct‑uri], if there is an\n// at-sign character ('@') in the userinfo component, it needs to be\n// percent-encoded as described in RFC 3986 [RFC3986].\n// For all other inputs without a scheme portion, the https scheme is assumed,\n// and the normalized URI is formed by prefixing https:// to the string as the\n// scheme.\n// If the resulting URI contains a fragment portion, it MUST be stripped off\n// together with the fragment delimiter character \"#\".\n// The WebFinger [I‑D.ietf‑appsawg‑webfinger] Resource in this case is the\n// resulting URI, and the WebFinger Host is the authority component.\n//\n// Note: Since the definition of authority in RFC 3986 [RFC3986] is\n// [ userinfo \"@\" ] host [ \":\" port ], it is legal to have a user input\n// identifier like userinfo@host:port, e.g., alice@example.com:8080.\n\nconst PORT = /^\\d+$/;\n\nfunction hasScheme(input) {\n  if (input.includes('://')) return true;\n\n  const authority = input.replace(/(\\/|\\?)/g, '#').split('#')[0];\n  if (authority.includes(':')) {\n    const index = authority.indexOf(':');\n    const hostOrPort = authority.slice(index + 1);\n    if (!PORT.test(hostOrPort)) {\n      return true;\n    }\n  }\n\n  return false;\n}\n\nfunction acctSchemeAssumed(input) {\n  if (!input.includes('@')) return false;\n  const parts = input.split('@');\n  const host = parts[parts.length - 1];\n  return !(host.includes(':') || host.includes('/') || host.includes('?'));\n}\n\nfunction normalize(input) {\n  if (typeof input !== 'string') {\n    throw new TypeError('input must be a string');\n  }\n\n  let output;\n  if (hasScheme(input)) {\n    output = input;\n  } else if (acctSchemeAssumed(input)) {\n    output = `acct:${input}`;\n  } else {\n    output = `https://${input}`;\n  }\n\n  return output.split('#')[0];\n}\n\nmodule.exports = normalize;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/webfinger_normalize.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/helpers/www_authenticate_parser.js":
/*!***************************************************************************!*\
  !*** ./node_modules/openid-client/lib/helpers/www_authenticate_parser.js ***!
  \***************************************************************************/
/***/ ((module) => {

eval("const REGEXP = /(\\w+)=(\"[^\"]*\")/g;\n\nmodule.exports = (wwwAuthenticate) => {\n  const params = {};\n  try {\n    while (REGEXP.exec(wwwAuthenticate) !== null) {\n      if (RegExp.$1 && RegExp.$2) {\n        params[RegExp.$1] = RegExp.$2.slice(1, -1);\n      }\n    }\n  } catch (err) {}\n\n  return params;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaGVscGVycy93d3dfYXV0aGVudGljYXRlX3BhcnNlci5qcyIsIm1hcHBpbmdzIjoiQUFBQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsSUFBSTs7QUFFSjtBQUNBIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L2xpYi9oZWxwZXJzL3d3d19hdXRoZW50aWNhdGVfcGFyc2VyLmpzPzhmZTgiXSwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgUkVHRVhQID0gLyhcXHcrKT0oXCJbXlwiXSpcIikvZztcblxubW9kdWxlLmV4cG9ydHMgPSAod3d3QXV0aGVudGljYXRlKSA9PiB7XG4gIGNvbnN0IHBhcmFtcyA9IHt9O1xuICB0cnkge1xuICAgIHdoaWxlIChSRUdFWFAuZXhlYyh3d3dBdXRoZW50aWNhdGUpICE9PSBudWxsKSB7XG4gICAgICBpZiAoUmVnRXhwLiQxICYmIFJlZ0V4cC4kMikge1xuICAgICAgICBwYXJhbXNbUmVnRXhwLiQxXSA9IFJlZ0V4cC4kMi5zbGljZSgxLCAtMSk7XG4gICAgICB9XG4gICAgfVxuICB9IGNhdGNoIChlcnIpIHt9XG5cbiAgcmV0dXJuIHBhcmFtcztcbn07XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/helpers/www_authenticate_parser.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/index.js":
/*!*************************************************!*\
  !*** ./node_modules/openid-client/lib/index.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const Issuer = __webpack_require__(/*! ./issuer */ \"(ssr)/./node_modules/openid-client/lib/issuer.js\");\nconst { OPError, RPError } = __webpack_require__(/*! ./errors */ \"(ssr)/./node_modules/openid-client/lib/errors.js\");\nconst Strategy = __webpack_require__(/*! ./passport_strategy */ \"(ssr)/./node_modules/openid-client/lib/passport_strategy.js\");\nconst TokenSet = __webpack_require__(/*! ./token_set */ \"(ssr)/./node_modules/openid-client/lib/token_set.js\");\nconst { CLOCK_TOLERANCE, HTTP_OPTIONS } = __webpack_require__(/*! ./helpers/consts */ \"(ssr)/./node_modules/openid-client/lib/helpers/consts.js\");\nconst generators = __webpack_require__(/*! ./helpers/generators */ \"(ssr)/./node_modules/openid-client/lib/helpers/generators.js\");\nconst { setDefaults } = __webpack_require__(/*! ./helpers/request */ \"(ssr)/./node_modules/openid-client/lib/helpers/request.js\");\n\nmodule.exports = {\n  Issuer,\n  Strategy,\n  TokenSet,\n  errors: {\n    OPError,\n    RPError,\n  },\n  custom: {\n    setHttpOptionsDefaults: setDefaults,\n    http_options: HTTP_OPTIONS,\n    clock_tolerance: CLOCK_TOLERANCE,\n  },\n  generators,\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaW5kZXguanMiLCJtYXBwaW5ncyI6IkFBQUEsZUFBZSxtQkFBTyxDQUFDLGtFQUFVO0FBQ2pDLFFBQVEsbUJBQW1CLEVBQUUsbUJBQU8sQ0FBQyxrRUFBVTtBQUMvQyxpQkFBaUIsbUJBQU8sQ0FBQyx3RkFBcUI7QUFDOUMsaUJBQWlCLG1CQUFPLENBQUMsd0VBQWE7QUFDdEMsUUFBUSxnQ0FBZ0MsRUFBRSxtQkFBTyxDQUFDLGtGQUFrQjtBQUNwRSxtQkFBbUIsbUJBQU8sQ0FBQywwRkFBc0I7QUFDakQsUUFBUSxjQUFjLEVBQUUsbUJBQU8sQ0FBQyxvRkFBbUI7O0FBRW5EO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0EiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbGliL2luZGV4LmpzP2JiMDYiXSwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgSXNzdWVyID0gcmVxdWlyZSgnLi9pc3N1ZXInKTtcbmNvbnN0IHsgT1BFcnJvciwgUlBFcnJvciB9ID0gcmVxdWlyZSgnLi9lcnJvcnMnKTtcbmNvbnN0IFN0cmF0ZWd5ID0gcmVxdWlyZSgnLi9wYXNzcG9ydF9zdHJhdGVneScpO1xuY29uc3QgVG9rZW5TZXQgPSByZXF1aXJlKCcuL3Rva2VuX3NldCcpO1xuY29uc3QgeyBDTE9DS19UT0xFUkFOQ0UsIEhUVFBfT1BUSU9OUyB9ID0gcmVxdWlyZSgnLi9oZWxwZXJzL2NvbnN0cycpO1xuY29uc3QgZ2VuZXJhdG9ycyA9IHJlcXVpcmUoJy4vaGVscGVycy9nZW5lcmF0b3JzJyk7XG5jb25zdCB7IHNldERlZmF1bHRzIH0gPSByZXF1aXJlKCcuL2hlbHBlcnMvcmVxdWVzdCcpO1xuXG5tb2R1bGUuZXhwb3J0cyA9IHtcbiAgSXNzdWVyLFxuICBTdHJhdGVneSxcbiAgVG9rZW5TZXQsXG4gIGVycm9yczoge1xuICAgIE9QRXJyb3IsXG4gICAgUlBFcnJvcixcbiAgfSxcbiAgY3VzdG9tOiB7XG4gICAgc2V0SHR0cE9wdGlvbnNEZWZhdWx0czogc2V0RGVmYXVsdHMsXG4gICAgaHR0cF9vcHRpb25zOiBIVFRQX09QVElPTlMsXG4gICAgY2xvY2tfdG9sZXJhbmNlOiBDTE9DS19UT0xFUkFOQ0UsXG4gIH0sXG4gIGdlbmVyYXRvcnMsXG59O1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/issuer.js":
/*!**************************************************!*\
  !*** ./node_modules/openid-client/lib/issuer.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const { inspect } = __webpack_require__(/*! util */ \"util\");\nconst url = __webpack_require__(/*! url */ \"url\");\n\nconst { RPError } = __webpack_require__(/*! ./errors */ \"(ssr)/./node_modules/openid-client/lib/errors.js\");\nconst getClient = __webpack_require__(/*! ./client */ \"(ssr)/./node_modules/openid-client/lib/client.js\");\nconst registry = __webpack_require__(/*! ./issuer_registry */ \"(ssr)/./node_modules/openid-client/lib/issuer_registry.js\");\nconst processResponse = __webpack_require__(/*! ./helpers/process_response */ \"(ssr)/./node_modules/openid-client/lib/helpers/process_response.js\");\nconst webfingerNormalize = __webpack_require__(/*! ./helpers/webfinger_normalize */ \"(ssr)/./node_modules/openid-client/lib/helpers/webfinger_normalize.js\");\nconst request = __webpack_require__(/*! ./helpers/request */ \"(ssr)/./node_modules/openid-client/lib/helpers/request.js\");\nconst clone = __webpack_require__(/*! ./helpers/deep_clone */ \"(ssr)/./node_modules/openid-client/lib/helpers/deep_clone.js\");\nconst { keystore } = __webpack_require__(/*! ./helpers/issuer */ \"(ssr)/./node_modules/openid-client/lib/helpers/issuer.js\");\n\nconst AAD_MULTITENANT_DISCOVERY = [\n  'https://login.microsoftonline.com/common/.well-known/openid-configuration',\n  'https://login.microsoftonline.com/common/v2.0/.well-known/openid-configuration',\n  'https://login.microsoftonline.com/organizations/v2.0/.well-known/openid-configuration',\n  'https://login.microsoftonline.com/consumers/v2.0/.well-known/openid-configuration',\n];\nconst AAD_MULTITENANT = Symbol();\nconst ISSUER_DEFAULTS = {\n  claim_types_supported: ['normal'],\n  claims_parameter_supported: false,\n  grant_types_supported: ['authorization_code', 'implicit'],\n  request_parameter_supported: false,\n  request_uri_parameter_supported: true,\n  require_request_uri_registration: false,\n  response_modes_supported: ['query', 'fragment'],\n  token_endpoint_auth_methods_supported: ['client_secret_basic'],\n};\n\nclass Issuer {\n  #metadata;\n  constructor(meta = {}) {\n    const aadIssValidation = meta[AAD_MULTITENANT];\n    delete meta[AAD_MULTITENANT];\n    ['introspection', 'revocation'].forEach((endpoint) => {\n      // if intro/revocation endpoint auth specific meta is missing use the token ones if they\n      // are defined\n      if (\n        meta[`${endpoint}_endpoint`] &&\n        meta[`${endpoint}_endpoint_auth_methods_supported`] === undefined &&\n        meta[`${endpoint}_endpoint_auth_signing_alg_values_supported`] === undefined\n      ) {\n        if (meta.token_endpoint_auth_methods_supported) {\n          meta[`${endpoint}_endpoint_auth_methods_supported`] =\n            meta.token_endpoint_auth_methods_supported;\n        }\n        if (meta.token_endpoint_auth_signing_alg_values_supported) {\n          meta[`${endpoint}_endpoint_auth_signing_alg_values_supported`] =\n            meta.token_endpoint_auth_signing_alg_values_supported;\n        }\n      }\n    });\n\n    this.#metadata = new Map();\n\n    Object.entries(meta).forEach(([key, value]) => {\n      this.#metadata.set(key, value);\n      if (!this[key]) {\n        Object.defineProperty(this, key, {\n          get() {\n            return this.#metadata.get(key);\n          },\n          enumerable: true,\n        });\n      }\n    });\n\n    registry.set(this.issuer, this);\n\n    const Client = getClient(this, aadIssValidation);\n\n    Object.defineProperties(this, {\n      Client: { value: Client, enumerable: true },\n      FAPI1Client: { value: class FAPI1Client extends Client {}, enumerable: true },\n      FAPI2Client: { value: class FAPI2Client extends Client {}, enumerable: true },\n    });\n  }\n\n  get metadata() {\n    return clone(Object.fromEntries(this.#metadata.entries()));\n  }\n\n  static async webfinger(input) {\n    const resource = webfingerNormalize(input);\n    const { host } = url.parse(resource);\n    const webfingerUrl = `https://${host}/.well-known/webfinger`;\n\n    const response = await request.call(this, {\n      method: 'GET',\n      url: webfingerUrl,\n      responseType: 'json',\n      searchParams: { resource, rel: 'http://openid.net/specs/connect/1.0/issuer' },\n      headers: {\n        Accept: 'application/json',\n      },\n    });\n    const body = processResponse(response);\n\n    const location =\n      Array.isArray(body.links) &&\n      body.links.find(\n        (link) =>\n          typeof link === 'object' &&\n          link.rel === 'http://openid.net/specs/connect/1.0/issuer' &&\n          link.href,\n      );\n\n    if (!location) {\n      throw new RPError({\n        message: 'no issuer found in webfinger response',\n        body,\n      });\n    }\n\n    if (typeof location.href !== 'string' || !location.href.startsWith('https://')) {\n      throw new RPError({\n        printf: ['invalid issuer location %s', location.href],\n        body,\n      });\n    }\n\n    const expectedIssuer = location.href;\n    if (registry.has(expectedIssuer)) {\n      return registry.get(expectedIssuer);\n    }\n\n    const issuer = await this.discover(expectedIssuer);\n\n    if (issuer.issuer !== expectedIssuer) {\n      registry.del(issuer.issuer);\n      throw new RPError(\n        'discovered issuer mismatch, expected %s, got: %s',\n        expectedIssuer,\n        issuer.issuer,\n      );\n    }\n    return issuer;\n  }\n\n  static async discover(uri) {\n    const wellKnownUri = resolveWellKnownUri(uri);\n\n    const response = await request.call(this, {\n      method: 'GET',\n      responseType: 'json',\n      url: wellKnownUri,\n      headers: {\n        Accept: 'application/json',\n      },\n    });\n    const body = processResponse(response);\n    return new Issuer({\n      ...ISSUER_DEFAULTS,\n      ...body,\n      [AAD_MULTITENANT]: !!AAD_MULTITENANT_DISCOVERY.find((discoveryURL) =>\n        wellKnownUri.startsWith(discoveryURL),\n      ),\n    });\n  }\n\n  async reloadJwksUri() {\n    await keystore.call(this, true);\n  }\n\n  /* istanbul ignore next */\n  [inspect.custom]() {\n    return `${this.constructor.name} ${inspect(this.metadata, {\n      depth: Infinity,\n      colors: process.stdout.isTTY,\n      compact: false,\n      sorted: true,\n    })}`;\n  }\n}\n\nfunction resolveWellKnownUri(uri) {\n  const parsed = url.parse(uri);\n  if (parsed.pathname.includes('/.well-known/')) {\n    return uri;\n  } else {\n    let pathname;\n    if (parsed.pathname.endsWith('/')) {\n      pathname = `${parsed.pathname}.well-known/openid-configuration`;\n    } else {\n      pathname = `${parsed.pathname}/.well-known/openid-configuration`;\n    }\n    return url.format({ ...parsed, pathname });\n  }\n}\n\nmodule.exports = Issuer;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/issuer.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/issuer_registry.js":
/*!***********************************************************!*\
  !*** ./node_modules/openid-client/lib/issuer_registry.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const LRU = __webpack_require__(/*! lru-cache */ \"(ssr)/./node_modules/openid-client/node_modules/lru-cache/index.js\");\n\nmodule.exports = new LRU({ max: 100 });\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvaXNzdWVyX3JlZ2lzdHJ5LmpzIiwibWFwcGluZ3MiOiJBQUFBLFlBQVksbUJBQU8sQ0FBQyxxRkFBVzs7QUFFL0IsMkJBQTJCLFVBQVUiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbGliL2lzc3Vlcl9yZWdpc3RyeS5qcz80Y2M3Il0sInNvdXJjZXNDb250ZW50IjpbImNvbnN0IExSVSA9IHJlcXVpcmUoJ2xydS1jYWNoZScpO1xuXG5tb2R1bGUuZXhwb3J0cyA9IG5ldyBMUlUoeyBtYXg6IDEwMCB9KTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/issuer_registry.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/passport_strategy.js":
/*!*************************************************************!*\
  !*** ./node_modules/openid-client/lib/passport_strategy.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const url = __webpack_require__(/*! url */ \"url\");\nconst { format } = __webpack_require__(/*! util */ \"util\");\n\nconst cloneDeep = __webpack_require__(/*! ./helpers/deep_clone */ \"(ssr)/./node_modules/openid-client/lib/helpers/deep_clone.js\");\nconst { RPError, OPError } = __webpack_require__(/*! ./errors */ \"(ssr)/./node_modules/openid-client/lib/errors.js\");\nconst { BaseClient } = __webpack_require__(/*! ./client */ \"(ssr)/./node_modules/openid-client/lib/client.js\");\nconst { random, codeChallenge } = __webpack_require__(/*! ./helpers/generators */ \"(ssr)/./node_modules/openid-client/lib/helpers/generators.js\");\nconst pick = __webpack_require__(/*! ./helpers/pick */ \"(ssr)/./node_modules/openid-client/lib/helpers/pick.js\");\nconst { resolveResponseType, resolveRedirectUri } = __webpack_require__(/*! ./helpers/client */ \"(ssr)/./node_modules/openid-client/lib/helpers/client.js\");\n\nfunction verified(err, user, info = {}) {\n  if (err) {\n    this.error(err);\n  } else if (!user) {\n    this.fail(info);\n  } else {\n    this.success(user, info);\n  }\n}\n\nfunction OpenIDConnectStrategy(\n  { client, params = {}, passReqToCallback = false, sessionKey, usePKCE = true, extras = {} } = {},\n  verify,\n) {\n  if (!(client instanceof BaseClient)) {\n    throw new TypeError('client must be an instance of openid-client Client');\n  }\n\n  if (typeof verify !== 'function') {\n    throw new TypeError('verify callback must be a function');\n  }\n\n  if (!client.issuer || !client.issuer.issuer) {\n    throw new TypeError('client must have an issuer with an identifier');\n  }\n\n  this._client = client;\n  this._issuer = client.issuer;\n  this._verify = verify;\n  this._passReqToCallback = passReqToCallback;\n  this._usePKCE = usePKCE;\n  this._key = sessionKey || `oidc:${url.parse(this._issuer.issuer).hostname}`;\n  this._params = cloneDeep(params);\n\n  // state and nonce are handled in authenticate()\n  delete this._params.state;\n  delete this._params.nonce;\n\n  this._extras = cloneDeep(extras);\n\n  if (!this._params.response_type) this._params.response_type = resolveResponseType.call(client);\n  if (!this._params.redirect_uri) this._params.redirect_uri = resolveRedirectUri.call(client);\n  if (!this._params.scope) this._params.scope = 'openid';\n\n  if (this._usePKCE === true) {\n    const supportedMethods = Array.isArray(this._issuer.code_challenge_methods_supported)\n      ? this._issuer.code_challenge_methods_supported\n      : false;\n\n    if (supportedMethods && supportedMethods.includes('S256')) {\n      this._usePKCE = 'S256';\n    } else if (supportedMethods && supportedMethods.includes('plain')) {\n      this._usePKCE = 'plain';\n    } else if (supportedMethods) {\n      throw new TypeError(\n        'neither code_challenge_method supported by the client is supported by the issuer',\n      );\n    } else {\n      this._usePKCE = 'S256';\n    }\n  } else if (typeof this._usePKCE === 'string' && !['plain', 'S256'].includes(this._usePKCE)) {\n    throw new TypeError(`${this._usePKCE} is not valid/implemented PKCE code_challenge_method`);\n  }\n\n  this.name = url.parse(client.issuer.issuer).hostname;\n}\n\nOpenIDConnectStrategy.prototype.authenticate = function authenticate(req, options) {\n  (async () => {\n    const client = this._client;\n    if (!req.session) {\n      throw new TypeError('authentication requires session support');\n    }\n    const reqParams = client.callbackParams(req);\n    const sessionKey = this._key;\n\n    const { 0: parameter, length } = Object.keys(reqParams);\n\n    /**\n     * Start authentication request if this has no authorization response parameters or\n     * this might a login initiated from a third party as per\n     * https://openid.net/specs/openid-connect-core-1_0.html#ThirdPartyInitiatedLogin.\n     */\n    if (length === 0 || (length === 1 && parameter === 'iss')) {\n      // provide options object with extra authentication parameters\n      const params = {\n        state: random(),\n        ...this._params,\n        ...options,\n      };\n\n      if (!params.nonce && params.response_type.includes('id_token')) {\n        params.nonce = random();\n      }\n\n      req.session[sessionKey] = pick(params, 'nonce', 'state', 'max_age', 'response_type');\n\n      if (this._usePKCE && params.response_type.includes('code')) {\n        const verifier = random();\n        req.session[sessionKey].code_verifier = verifier;\n\n        switch (this._usePKCE) {\n          case 'S256':\n            params.code_challenge = codeChallenge(verifier);\n            params.code_challenge_method = 'S256';\n            break;\n          case 'plain':\n            params.code_challenge = verifier;\n            break;\n        }\n      }\n\n      this.redirect(client.authorizationUrl(params));\n      return;\n    }\n    /* end authentication request */\n\n    /* start authentication response */\n\n    const session = req.session[sessionKey];\n    if (Object.keys(session || {}).length === 0) {\n      throw new Error(\n        format(\n          'did not find expected authorization request details in session, req.session[\"%s\"] is %j',\n          sessionKey,\n          session,\n        ),\n      );\n    }\n\n    const {\n      state,\n      nonce,\n      max_age: maxAge,\n      code_verifier: codeVerifier,\n      response_type: responseType,\n    } = session;\n\n    try {\n      delete req.session[sessionKey];\n    } catch (err) {}\n\n    const opts = {\n      redirect_uri: this._params.redirect_uri,\n      ...options,\n    };\n\n    const checks = {\n      state,\n      nonce,\n      max_age: maxAge,\n      code_verifier: codeVerifier,\n      response_type: responseType,\n    };\n\n    const tokenset = await client.callback(opts.redirect_uri, reqParams, checks, this._extras);\n\n    const passReq = this._passReqToCallback;\n    const loadUserinfo = this._verify.length > (passReq ? 3 : 2) && client.issuer.userinfo_endpoint;\n\n    const args = [tokenset, verified.bind(this)];\n\n    if (loadUserinfo) {\n      if (!tokenset.access_token) {\n        throw new RPError({\n          message:\n            'expected access_token to be returned when asking for userinfo in verify callback',\n          tokenset,\n        });\n      }\n      const userinfo = await client.userinfo(tokenset);\n      args.splice(1, 0, userinfo);\n    }\n\n    if (passReq) {\n      args.unshift(req);\n    }\n\n    this._verify(...args);\n    /* end authentication response */\n  })().catch((error) => {\n    if (\n      (error instanceof OPError &&\n        error.error !== 'server_error' &&\n        !error.error.startsWith('invalid')) ||\n      error instanceof RPError\n    ) {\n      this.fail(error);\n    } else {\n      this.error(error);\n    }\n  });\n};\n\nmodule.exports = OpenIDConnectStrategy;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/passport_strategy.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/lib/token_set.js":
/*!*****************************************************!*\
  !*** ./node_modules/openid-client/lib/token_set.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("const base64url = __webpack_require__(/*! ./helpers/base64url */ \"(ssr)/./node_modules/openid-client/lib/helpers/base64url.js\");\nconst now = __webpack_require__(/*! ./helpers/unix_timestamp */ \"(ssr)/./node_modules/openid-client/lib/helpers/unix_timestamp.js\");\n\nclass TokenSet {\n  constructor(values) {\n    Object.assign(this, values);\n    const { constructor, ...properties } = Object.getOwnPropertyDescriptors(\n      this.constructor.prototype,\n    );\n\n    Object.defineProperties(this, properties);\n  }\n\n  set expires_in(value) {\n    this.expires_at = now() + Number(value);\n  }\n\n  get expires_in() {\n    return Math.max.apply(null, [this.expires_at - now(), 0]);\n  }\n\n  expired() {\n    return this.expires_in === 0;\n  }\n\n  claims() {\n    if (!this.id_token) {\n      throw new TypeError('id_token not present in TokenSet');\n    }\n\n    return JSON.parse(base64url.decode(this.id_token.split('.')[1]));\n  }\n}\n\nmodule.exports = TokenSet;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9saWIvdG9rZW5fc2V0LmpzIiwibWFwcGluZ3MiOiJBQUFBLGtCQUFrQixtQkFBTyxDQUFDLHdGQUFxQjtBQUMvQyxZQUFZLG1CQUFPLENBQUMsa0dBQTBCOztBQUU5QztBQUNBO0FBQ0E7QUFDQSxZQUFZLDZCQUE2QjtBQUN6QztBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L2xpYi90b2tlbl9zZXQuanM/OTE4NSJdLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBiYXNlNjR1cmwgPSByZXF1aXJlKCcuL2hlbHBlcnMvYmFzZTY0dXJsJyk7XG5jb25zdCBub3cgPSByZXF1aXJlKCcuL2hlbHBlcnMvdW5peF90aW1lc3RhbXAnKTtcblxuY2xhc3MgVG9rZW5TZXQge1xuICBjb25zdHJ1Y3Rvcih2YWx1ZXMpIHtcbiAgICBPYmplY3QuYXNzaWduKHRoaXMsIHZhbHVlcyk7XG4gICAgY29uc3QgeyBjb25zdHJ1Y3RvciwgLi4ucHJvcGVydGllcyB9ID0gT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcnMoXG4gICAgICB0aGlzLmNvbnN0cnVjdG9yLnByb3RvdHlwZSxcbiAgICApO1xuXG4gICAgT2JqZWN0LmRlZmluZVByb3BlcnRpZXModGhpcywgcHJvcGVydGllcyk7XG4gIH1cblxuICBzZXQgZXhwaXJlc19pbih2YWx1ZSkge1xuICAgIHRoaXMuZXhwaXJlc19hdCA9IG5vdygpICsgTnVtYmVyKHZhbHVlKTtcbiAgfVxuXG4gIGdldCBleHBpcmVzX2luKCkge1xuICAgIHJldHVybiBNYXRoLm1heC5hcHBseShudWxsLCBbdGhpcy5leHBpcmVzX2F0IC0gbm93KCksIDBdKTtcbiAgfVxuXG4gIGV4cGlyZWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZXhwaXJlc19pbiA9PT0gMDtcbiAgfVxuXG4gIGNsYWltcygpIHtcbiAgICBpZiAoIXRoaXMuaWRfdG9rZW4pIHtcbiAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ2lkX3Rva2VuIG5vdCBwcmVzZW50IGluIFRva2VuU2V0Jyk7XG4gICAgfVxuXG4gICAgcmV0dXJuIEpTT04ucGFyc2UoYmFzZTY0dXJsLmRlY29kZSh0aGlzLmlkX3Rva2VuLnNwbGl0KCcuJylbMV0pKTtcbiAgfVxufVxuXG5tb2R1bGUuZXhwb3J0cyA9IFRva2VuU2V0O1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/lib/token_set.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/index.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/index.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.cryptoRuntime = exports.base64url = exports.generateSecret = exports.generateKeyPair = exports.errors = exports.decodeJwt = exports.decodeProtectedHeader = exports.importJWK = exports.importX509 = exports.importPKCS8 = exports.importSPKI = exports.exportJWK = exports.exportSPKI = exports.exportPKCS8 = exports.UnsecuredJWT = exports.createRemoteJWKSet = exports.createLocalJWKSet = exports.EmbeddedJWK = exports.calculateJwkThumbprintUri = exports.calculateJwkThumbprint = exports.EncryptJWT = exports.SignJWT = exports.GeneralSign = exports.FlattenedSign = exports.CompactSign = exports.FlattenedEncrypt = exports.CompactEncrypt = exports.jwtDecrypt = exports.jwtVerify = exports.generalVerify = exports.flattenedVerify = exports.compactVerify = exports.GeneralEncrypt = exports.generalDecrypt = exports.flattenedDecrypt = exports.compactDecrypt = void 0;\nvar decrypt_js_1 = __webpack_require__(/*! ./jwe/compact/decrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/compact/decrypt.js\");\nObject.defineProperty(exports, \"compactDecrypt\", ({ enumerable: true, get: function () { return decrypt_js_1.compactDecrypt; } }));\nvar decrypt_js_2 = __webpack_require__(/*! ./jwe/flattened/decrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/flattened/decrypt.js\");\nObject.defineProperty(exports, \"flattenedDecrypt\", ({ enumerable: true, get: function () { return decrypt_js_2.flattenedDecrypt; } }));\nvar decrypt_js_3 = __webpack_require__(/*! ./jwe/general/decrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/general/decrypt.js\");\nObject.defineProperty(exports, \"generalDecrypt\", ({ enumerable: true, get: function () { return decrypt_js_3.generalDecrypt; } }));\nvar encrypt_js_1 = __webpack_require__(/*! ./jwe/general/encrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/general/encrypt.js\");\nObject.defineProperty(exports, \"GeneralEncrypt\", ({ enumerable: true, get: function () { return encrypt_js_1.GeneralEncrypt; } }));\nvar verify_js_1 = __webpack_require__(/*! ./jws/compact/verify.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/compact/verify.js\");\nObject.defineProperty(exports, \"compactVerify\", ({ enumerable: true, get: function () { return verify_js_1.compactVerify; } }));\nvar verify_js_2 = __webpack_require__(/*! ./jws/flattened/verify.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/flattened/verify.js\");\nObject.defineProperty(exports, \"flattenedVerify\", ({ enumerable: true, get: function () { return verify_js_2.flattenedVerify; } }));\nvar verify_js_3 = __webpack_require__(/*! ./jws/general/verify.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/general/verify.js\");\nObject.defineProperty(exports, \"generalVerify\", ({ enumerable: true, get: function () { return verify_js_3.generalVerify; } }));\nvar verify_js_4 = __webpack_require__(/*! ./jwt/verify.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/verify.js\");\nObject.defineProperty(exports, \"jwtVerify\", ({ enumerable: true, get: function () { return verify_js_4.jwtVerify; } }));\nvar decrypt_js_4 = __webpack_require__(/*! ./jwt/decrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/decrypt.js\");\nObject.defineProperty(exports, \"jwtDecrypt\", ({ enumerable: true, get: function () { return decrypt_js_4.jwtDecrypt; } }));\nvar encrypt_js_2 = __webpack_require__(/*! ./jwe/compact/encrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/compact/encrypt.js\");\nObject.defineProperty(exports, \"CompactEncrypt\", ({ enumerable: true, get: function () { return encrypt_js_2.CompactEncrypt; } }));\nvar encrypt_js_3 = __webpack_require__(/*! ./jwe/flattened/encrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/flattened/encrypt.js\");\nObject.defineProperty(exports, \"FlattenedEncrypt\", ({ enumerable: true, get: function () { return encrypt_js_3.FlattenedEncrypt; } }));\nvar sign_js_1 = __webpack_require__(/*! ./jws/compact/sign.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/compact/sign.js\");\nObject.defineProperty(exports, \"CompactSign\", ({ enumerable: true, get: function () { return sign_js_1.CompactSign; } }));\nvar sign_js_2 = __webpack_require__(/*! ./jws/flattened/sign.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/flattened/sign.js\");\nObject.defineProperty(exports, \"FlattenedSign\", ({ enumerable: true, get: function () { return sign_js_2.FlattenedSign; } }));\nvar sign_js_3 = __webpack_require__(/*! ./jws/general/sign.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/general/sign.js\");\nObject.defineProperty(exports, \"GeneralSign\", ({ enumerable: true, get: function () { return sign_js_3.GeneralSign; } }));\nvar sign_js_4 = __webpack_require__(/*! ./jwt/sign.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/sign.js\");\nObject.defineProperty(exports, \"SignJWT\", ({ enumerable: true, get: function () { return sign_js_4.SignJWT; } }));\nvar encrypt_js_4 = __webpack_require__(/*! ./jwt/encrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/encrypt.js\");\nObject.defineProperty(exports, \"EncryptJWT\", ({ enumerable: true, get: function () { return encrypt_js_4.EncryptJWT; } }));\nvar thumbprint_js_1 = __webpack_require__(/*! ./jwk/thumbprint.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwk/thumbprint.js\");\nObject.defineProperty(exports, \"calculateJwkThumbprint\", ({ enumerable: true, get: function () { return thumbprint_js_1.calculateJwkThumbprint; } }));\nObject.defineProperty(exports, \"calculateJwkThumbprintUri\", ({ enumerable: true, get: function () { return thumbprint_js_1.calculateJwkThumbprintUri; } }));\nvar embedded_js_1 = __webpack_require__(/*! ./jwk/embedded.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwk/embedded.js\");\nObject.defineProperty(exports, \"EmbeddedJWK\", ({ enumerable: true, get: function () { return embedded_js_1.EmbeddedJWK; } }));\nvar local_js_1 = __webpack_require__(/*! ./jwks/local.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwks/local.js\");\nObject.defineProperty(exports, \"createLocalJWKSet\", ({ enumerable: true, get: function () { return local_js_1.createLocalJWKSet; } }));\nvar remote_js_1 = __webpack_require__(/*! ./jwks/remote.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwks/remote.js\");\nObject.defineProperty(exports, \"createRemoteJWKSet\", ({ enumerable: true, get: function () { return remote_js_1.createRemoteJWKSet; } }));\nvar unsecured_js_1 = __webpack_require__(/*! ./jwt/unsecured.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/unsecured.js\");\nObject.defineProperty(exports, \"UnsecuredJWT\", ({ enumerable: true, get: function () { return unsecured_js_1.UnsecuredJWT; } }));\nvar export_js_1 = __webpack_require__(/*! ./key/export.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/export.js\");\nObject.defineProperty(exports, \"exportPKCS8\", ({ enumerable: true, get: function () { return export_js_1.exportPKCS8; } }));\nObject.defineProperty(exports, \"exportSPKI\", ({ enumerable: true, get: function () { return export_js_1.exportSPKI; } }));\nObject.defineProperty(exports, \"exportJWK\", ({ enumerable: true, get: function () { return export_js_1.exportJWK; } }));\nvar import_js_1 = __webpack_require__(/*! ./key/import.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/import.js\");\nObject.defineProperty(exports, \"importSPKI\", ({ enumerable: true, get: function () { return import_js_1.importSPKI; } }));\nObject.defineProperty(exports, \"importPKCS8\", ({ enumerable: true, get: function () { return import_js_1.importPKCS8; } }));\nObject.defineProperty(exports, \"importX509\", ({ enumerable: true, get: function () { return import_js_1.importX509; } }));\nObject.defineProperty(exports, \"importJWK\", ({ enumerable: true, get: function () { return import_js_1.importJWK; } }));\nvar decode_protected_header_js_1 = __webpack_require__(/*! ./util/decode_protected_header.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/decode_protected_header.js\");\nObject.defineProperty(exports, \"decodeProtectedHeader\", ({ enumerable: true, get: function () { return decode_protected_header_js_1.decodeProtectedHeader; } }));\nvar decode_jwt_js_1 = __webpack_require__(/*! ./util/decode_jwt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/decode_jwt.js\");\nObject.defineProperty(exports, \"decodeJwt\", ({ enumerable: true, get: function () { return decode_jwt_js_1.decodeJwt; } }));\nexports.errors = __webpack_require__(/*! ./util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nvar generate_key_pair_js_1 = __webpack_require__(/*! ./key/generate_key_pair.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/generate_key_pair.js\");\nObject.defineProperty(exports, \"generateKeyPair\", ({ enumerable: true, get: function () { return generate_key_pair_js_1.generateKeyPair; } }));\nvar generate_secret_js_1 = __webpack_require__(/*! ./key/generate_secret.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/generate_secret.js\");\nObject.defineProperty(exports, \"generateSecret\", ({ enumerable: true, get: function () { return generate_secret_js_1.generateSecret; } }));\nexports.base64url = __webpack_require__(/*! ./util/base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/base64url.js\");\nvar runtime_js_1 = __webpack_require__(/*! ./util/runtime.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/runtime.js\");\nObject.defineProperty(exports, \"cryptoRuntime\", ({ enumerable: true, get: function () { return runtime_js_1.default; } }));\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/compact/decrypt.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/compact/decrypt.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.compactDecrypt = void 0;\nconst decrypt_js_1 = __webpack_require__(/*! ../flattened/decrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/flattened/decrypt.js\");\nconst errors_js_1 = __webpack_require__(/*! ../../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nasync function compactDecrypt(jwe, key, options) {\n    if (jwe instanceof Uint8Array) {\n        jwe = buffer_utils_js_1.decoder.decode(jwe);\n    }\n    if (typeof jwe !== 'string') {\n        throw new errors_js_1.JWEInvalid('Compact JWE must be a string or Uint8Array');\n    }\n    const { 0: protectedHeader, 1: encryptedKey, 2: iv, 3: ciphertext, 4: tag, length, } = jwe.split('.');\n    if (length !== 5) {\n        throw new errors_js_1.JWEInvalid('Invalid Compact JWE');\n    }\n    const decrypted = await (0, decrypt_js_1.flattenedDecrypt)({\n        ciphertext,\n        iv: (iv || undefined),\n        protected: protectedHeader || undefined,\n        tag: (tag || undefined),\n        encrypted_key: encryptedKey || undefined,\n    }, key, options);\n    const result = { plaintext: decrypted.plaintext, protectedHeader: decrypted.protectedHeader };\n    if (typeof key === 'function') {\n        return { ...result, key: decrypted.key };\n    }\n    return result;\n}\nexports.compactDecrypt = compactDecrypt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/compact/decrypt.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/compact/encrypt.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/compact/encrypt.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.CompactEncrypt = void 0;\nconst encrypt_js_1 = __webpack_require__(/*! ../flattened/encrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/flattened/encrypt.js\");\nclass CompactEncrypt {\n    constructor(plaintext) {\n        this._flattened = new encrypt_js_1.FlattenedEncrypt(plaintext);\n    }\n    setContentEncryptionKey(cek) {\n        this._flattened.setContentEncryptionKey(cek);\n        return this;\n    }\n    setInitializationVector(iv) {\n        this._flattened.setInitializationVector(iv);\n        return this;\n    }\n    setProtectedHeader(protectedHeader) {\n        this._flattened.setProtectedHeader(protectedHeader);\n        return this;\n    }\n    setKeyManagementParameters(parameters) {\n        this._flattened.setKeyManagementParameters(parameters);\n        return this;\n    }\n    async encrypt(key, options) {\n        const jwe = await this._flattened.encrypt(key, options);\n        return [jwe.protected, jwe.encrypted_key, jwe.iv, jwe.ciphertext, jwe.tag].join('.');\n    }\n}\nexports.CompactEncrypt = CompactEncrypt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/compact/encrypt.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/flattened/decrypt.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/flattened/decrypt.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.flattenedDecrypt = void 0;\nconst base64url_js_1 = __webpack_require__(/*! ../../runtime/base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nconst decrypt_js_1 = __webpack_require__(/*! ../../runtime/decrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/decrypt.js\");\nconst zlib_js_1 = __webpack_require__(/*! ../../runtime/zlib.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/zlib.js\");\nconst errors_js_1 = __webpack_require__(/*! ../../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst is_disjoint_js_1 = __webpack_require__(/*! ../../lib/is_disjoint.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_disjoint.js\");\nconst is_object_js_1 = __webpack_require__(/*! ../../lib/is_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js\");\nconst decrypt_key_management_js_1 = __webpack_require__(/*! ../../lib/decrypt_key_management.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/decrypt_key_management.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst cek_js_1 = __webpack_require__(/*! ../../lib/cek.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/cek.js\");\nconst validate_crit_js_1 = __webpack_require__(/*! ../../lib/validate_crit.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/validate_crit.js\");\nconst validate_algorithms_js_1 = __webpack_require__(/*! ../../lib/validate_algorithms.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/validate_algorithms.js\");\nasync function flattenedDecrypt(jwe, key, options) {\n    var _a;\n    if (!(0, is_object_js_1.default)(jwe)) {\n        throw new errors_js_1.JWEInvalid('Flattened JWE must be an object');\n    }\n    if (jwe.protected === undefined && jwe.header === undefined && jwe.unprotected === undefined) {\n        throw new errors_js_1.JWEInvalid('JOSE Header missing');\n    }\n    if (typeof jwe.iv !== 'string') {\n        throw new errors_js_1.JWEInvalid('JWE Initialization Vector missing or incorrect type');\n    }\n    if (typeof jwe.ciphertext !== 'string') {\n        throw new errors_js_1.JWEInvalid('JWE Ciphertext missing or incorrect type');\n    }\n    if (typeof jwe.tag !== 'string') {\n        throw new errors_js_1.JWEInvalid('JWE Authentication Tag missing or incorrect type');\n    }\n    if (jwe.protected !== undefined && typeof jwe.protected !== 'string') {\n        throw new errors_js_1.JWEInvalid('JWE Protected Header incorrect type');\n    }\n    if (jwe.encrypted_key !== undefined && typeof jwe.encrypted_key !== 'string') {\n        throw new errors_js_1.JWEInvalid('JWE Encrypted Key incorrect type');\n    }\n    if (jwe.aad !== undefined && typeof jwe.aad !== 'string') {\n        throw new errors_js_1.JWEInvalid('JWE AAD incorrect type');\n    }\n    if (jwe.header !== undefined && !(0, is_object_js_1.default)(jwe.header)) {\n        throw new errors_js_1.JWEInvalid('JWE Shared Unprotected Header incorrect type');\n    }\n    if (jwe.unprotected !== undefined && !(0, is_object_js_1.default)(jwe.unprotected)) {\n        throw new errors_js_1.JWEInvalid('JWE Per-Recipient Unprotected Header incorrect type');\n    }\n    let parsedProt;\n    if (jwe.protected) {\n        try {\n            const protectedHeader = (0, base64url_js_1.decode)(jwe.protected);\n            parsedProt = JSON.parse(buffer_utils_js_1.decoder.decode(protectedHeader));\n        }\n        catch {\n            throw new errors_js_1.JWEInvalid('JWE Protected Header is invalid');\n        }\n    }\n    if (!(0, is_disjoint_js_1.default)(parsedProt, jwe.header, jwe.unprotected)) {\n        throw new errors_js_1.JWEInvalid('JWE Protected, JWE Unprotected Header, and JWE Per-Recipient Unprotected Header Parameter names must be disjoint');\n    }\n    const joseHeader = {\n        ...parsedProt,\n        ...jwe.header,\n        ...jwe.unprotected,\n    };\n    (0, validate_crit_js_1.default)(errors_js_1.JWEInvalid, new Map(), options === null || options === void 0 ? void 0 : options.crit, parsedProt, joseHeader);\n    if (joseHeader.zip !== undefined) {\n        if (!parsedProt || !parsedProt.zip) {\n            throw new errors_js_1.JWEInvalid('JWE \"zip\" (Compression Algorithm) Header MUST be integrity protected');\n        }\n        if (joseHeader.zip !== 'DEF') {\n            throw new errors_js_1.JOSENotSupported('Unsupported JWE \"zip\" (Compression Algorithm) Header Parameter value');\n        }\n    }\n    const { alg, enc } = joseHeader;\n    if (typeof alg !== 'string' || !alg) {\n        throw new errors_js_1.JWEInvalid('missing JWE Algorithm (alg) in JWE Header');\n    }\n    if (typeof enc !== 'string' || !enc) {\n        throw new errors_js_1.JWEInvalid('missing JWE Encryption Algorithm (enc) in JWE Header');\n    }\n    const keyManagementAlgorithms = options && (0, validate_algorithms_js_1.default)('keyManagementAlgorithms', options.keyManagementAlgorithms);\n    const contentEncryptionAlgorithms = options &&\n        (0, validate_algorithms_js_1.default)('contentEncryptionAlgorithms', options.contentEncryptionAlgorithms);\n    if (keyManagementAlgorithms && !keyManagementAlgorithms.has(alg)) {\n        throw new errors_js_1.JOSEAlgNotAllowed('\"alg\" (Algorithm) Header Parameter not allowed');\n    }\n    if (contentEncryptionAlgorithms && !contentEncryptionAlgorithms.has(enc)) {\n        throw new errors_js_1.JOSEAlgNotAllowed('\"enc\" (Encryption Algorithm) Header Parameter not allowed');\n    }\n    let encryptedKey;\n    if (jwe.encrypted_key !== undefined) {\n        try {\n            encryptedKey = (0, base64url_js_1.decode)(jwe.encrypted_key);\n        }\n        catch {\n            throw new errors_js_1.JWEInvalid('Failed to base64url decode the encrypted_key');\n        }\n    }\n    let resolvedKey = false;\n    if (typeof key === 'function') {\n        key = await key(parsedProt, jwe);\n        resolvedKey = true;\n    }\n    let cek;\n    try {\n        cek = await (0, decrypt_key_management_js_1.default)(alg, key, encryptedKey, joseHeader, options);\n    }\n    catch (err) {\n        if (err instanceof TypeError || err instanceof errors_js_1.JWEInvalid || err instanceof errors_js_1.JOSENotSupported) {\n            throw err;\n        }\n        cek = (0, cek_js_1.default)(enc);\n    }\n    let iv;\n    let tag;\n    try {\n        iv = (0, base64url_js_1.decode)(jwe.iv);\n    }\n    catch {\n        throw new errors_js_1.JWEInvalid('Failed to base64url decode the iv');\n    }\n    try {\n        tag = (0, base64url_js_1.decode)(jwe.tag);\n    }\n    catch {\n        throw new errors_js_1.JWEInvalid('Failed to base64url decode the tag');\n    }\n    const protectedHeader = buffer_utils_js_1.encoder.encode((_a = jwe.protected) !== null && _a !== void 0 ? _a : '');\n    let additionalData;\n    if (jwe.aad !== undefined) {\n        additionalData = (0, buffer_utils_js_1.concat)(protectedHeader, buffer_utils_js_1.encoder.encode('.'), buffer_utils_js_1.encoder.encode(jwe.aad));\n    }\n    else {\n        additionalData = protectedHeader;\n    }\n    let ciphertext;\n    try {\n        ciphertext = (0, base64url_js_1.decode)(jwe.ciphertext);\n    }\n    catch {\n        throw new errors_js_1.JWEInvalid('Failed to base64url decode the ciphertext');\n    }\n    let plaintext = await (0, decrypt_js_1.default)(enc, cek, ciphertext, iv, tag, additionalData);\n    if (joseHeader.zip === 'DEF') {\n        plaintext = await ((options === null || options === void 0 ? void 0 : options.inflateRaw) || zlib_js_1.inflate)(plaintext);\n    }\n    const result = { plaintext };\n    if (jwe.protected !== undefined) {\n        result.protectedHeader = parsedProt;\n    }\n    if (jwe.aad !== undefined) {\n        try {\n            result.additionalAuthenticatedData = (0, base64url_js_1.decode)(jwe.aad);\n        }\n        catch {\n            throw new errors_js_1.JWEInvalid('Failed to base64url decode the aad');\n        }\n    }\n    if (jwe.unprotected !== undefined) {\n        result.sharedUnprotectedHeader = jwe.unprotected;\n    }\n    if (jwe.header !== undefined) {\n        result.unprotectedHeader = jwe.header;\n    }\n    if (resolvedKey) {\n        return { ...result, key };\n    }\n    return result;\n}\nexports.flattenedDecrypt = flattenedDecrypt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/flattened/decrypt.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/flattened/encrypt.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/flattened/encrypt.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.FlattenedEncrypt = exports.unprotected = void 0;\nconst base64url_js_1 = __webpack_require__(/*! ../../runtime/base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nconst encrypt_js_1 = __webpack_require__(/*! ../../runtime/encrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/encrypt.js\");\nconst zlib_js_1 = __webpack_require__(/*! ../../runtime/zlib.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/zlib.js\");\nconst iv_js_1 = __webpack_require__(/*! ../../lib/iv.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/iv.js\");\nconst encrypt_key_management_js_1 = __webpack_require__(/*! ../../lib/encrypt_key_management.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/encrypt_key_management.js\");\nconst errors_js_1 = __webpack_require__(/*! ../../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst is_disjoint_js_1 = __webpack_require__(/*! ../../lib/is_disjoint.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_disjoint.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst validate_crit_js_1 = __webpack_require__(/*! ../../lib/validate_crit.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/validate_crit.js\");\nexports.unprotected = Symbol();\nclass FlattenedEncrypt {\n    constructor(plaintext) {\n        if (!(plaintext instanceof Uint8Array)) {\n            throw new TypeError('plaintext must be an instance of Uint8Array');\n        }\n        this._plaintext = plaintext;\n    }\n    setKeyManagementParameters(parameters) {\n        if (this._keyManagementParameters) {\n            throw new TypeError('setKeyManagementParameters can only be called once');\n        }\n        this._keyManagementParameters = parameters;\n        return this;\n    }\n    setProtectedHeader(protectedHeader) {\n        if (this._protectedHeader) {\n            throw new TypeError('setProtectedHeader can only be called once');\n        }\n        this._protectedHeader = protectedHeader;\n        return this;\n    }\n    setSharedUnprotectedHeader(sharedUnprotectedHeader) {\n        if (this._sharedUnprotectedHeader) {\n            throw new TypeError('setSharedUnprotectedHeader can only be called once');\n        }\n        this._sharedUnprotectedHeader = sharedUnprotectedHeader;\n        return this;\n    }\n    setUnprotectedHeader(unprotectedHeader) {\n        if (this._unprotectedHeader) {\n            throw new TypeError('setUnprotectedHeader can only be called once');\n        }\n        this._unprotectedHeader = unprotectedHeader;\n        return this;\n    }\n    setAdditionalAuthenticatedData(aad) {\n        this._aad = aad;\n        return this;\n    }\n    setContentEncryptionKey(cek) {\n        if (this._cek) {\n            throw new TypeError('setContentEncryptionKey can only be called once');\n        }\n        this._cek = cek;\n        return this;\n    }\n    setInitializationVector(iv) {\n        if (this._iv) {\n            throw new TypeError('setInitializationVector can only be called once');\n        }\n        this._iv = iv;\n        return this;\n    }\n    async encrypt(key, options) {\n        if (!this._protectedHeader && !this._unprotectedHeader && !this._sharedUnprotectedHeader) {\n            throw new errors_js_1.JWEInvalid('either setProtectedHeader, setUnprotectedHeader, or sharedUnprotectedHeader must be called before #encrypt()');\n        }\n        if (!(0, is_disjoint_js_1.default)(this._protectedHeader, this._unprotectedHeader, this._sharedUnprotectedHeader)) {\n            throw new errors_js_1.JWEInvalid('JWE Protected, JWE Shared Unprotected and JWE Per-Recipient Header Parameter names must be disjoint');\n        }\n        const joseHeader = {\n            ...this._protectedHeader,\n            ...this._unprotectedHeader,\n            ...this._sharedUnprotectedHeader,\n        };\n        (0, validate_crit_js_1.default)(errors_js_1.JWEInvalid, new Map(), options === null || options === void 0 ? void 0 : options.crit, this._protectedHeader, joseHeader);\n        if (joseHeader.zip !== undefined) {\n            if (!this._protectedHeader || !this._protectedHeader.zip) {\n                throw new errors_js_1.JWEInvalid('JWE \"zip\" (Compression Algorithm) Header MUST be integrity protected');\n            }\n            if (joseHeader.zip !== 'DEF') {\n                throw new errors_js_1.JOSENotSupported('Unsupported JWE \"zip\" (Compression Algorithm) Header Parameter value');\n            }\n        }\n        const { alg, enc } = joseHeader;\n        if (typeof alg !== 'string' || !alg) {\n            throw new errors_js_1.JWEInvalid('JWE \"alg\" (Algorithm) Header Parameter missing or invalid');\n        }\n        if (typeof enc !== 'string' || !enc) {\n            throw new errors_js_1.JWEInvalid('JWE \"enc\" (Encryption Algorithm) Header Parameter missing or invalid');\n        }\n        let encryptedKey;\n        if (alg === 'dir') {\n            if (this._cek) {\n                throw new TypeError('setContentEncryptionKey cannot be called when using Direct Encryption');\n            }\n        }\n        else if (alg === 'ECDH-ES') {\n            if (this._cek) {\n                throw new TypeError('setContentEncryptionKey cannot be called when using Direct Key Agreement');\n            }\n        }\n        let cek;\n        {\n            let parameters;\n            ({ cek, encryptedKey, parameters } = await (0, encrypt_key_management_js_1.default)(alg, enc, key, this._cek, this._keyManagementParameters));\n            if (parameters) {\n                if (options && exports.unprotected in options) {\n                    if (!this._unprotectedHeader) {\n                        this.setUnprotectedHeader(parameters);\n                    }\n                    else {\n                        this._unprotectedHeader = { ...this._unprotectedHeader, ...parameters };\n                    }\n                }\n                else {\n                    if (!this._protectedHeader) {\n                        this.setProtectedHeader(parameters);\n                    }\n                    else {\n                        this._protectedHeader = { ...this._protectedHeader, ...parameters };\n                    }\n                }\n            }\n        }\n        this._iv || (this._iv = (0, iv_js_1.default)(enc));\n        let additionalData;\n        let protectedHeader;\n        let aadMember;\n        if (this._protectedHeader) {\n            protectedHeader = buffer_utils_js_1.encoder.encode((0, base64url_js_1.encode)(JSON.stringify(this._protectedHeader)));\n        }\n        else {\n            protectedHeader = buffer_utils_js_1.encoder.encode('');\n        }\n        if (this._aad) {\n            aadMember = (0, base64url_js_1.encode)(this._aad);\n            additionalData = (0, buffer_utils_js_1.concat)(protectedHeader, buffer_utils_js_1.encoder.encode('.'), buffer_utils_js_1.encoder.encode(aadMember));\n        }\n        else {\n            additionalData = protectedHeader;\n        }\n        let ciphertext;\n        let tag;\n        if (joseHeader.zip === 'DEF') {\n            const deflated = await ((options === null || options === void 0 ? void 0 : options.deflateRaw) || zlib_js_1.deflate)(this._plaintext);\n            ({ ciphertext, tag } = await (0, encrypt_js_1.default)(enc, deflated, cek, this._iv, additionalData));\n        }\n        else {\n            ;\n            ({ ciphertext, tag } = await (0, encrypt_js_1.default)(enc, this._plaintext, cek, this._iv, additionalData));\n        }\n        const jwe = {\n            ciphertext: (0, base64url_js_1.encode)(ciphertext),\n            iv: (0, base64url_js_1.encode)(this._iv),\n            tag: (0, base64url_js_1.encode)(tag),\n        };\n        if (encryptedKey) {\n            jwe.encrypted_key = (0, base64url_js_1.encode)(encryptedKey);\n        }\n        if (aadMember) {\n            jwe.aad = aadMember;\n        }\n        if (this._protectedHeader) {\n            jwe.protected = buffer_utils_js_1.decoder.decode(protectedHeader);\n        }\n        if (this._sharedUnprotectedHeader) {\n            jwe.unprotected = this._sharedUnprotectedHeader;\n        }\n        if (this._unprotectedHeader) {\n            jwe.header = this._unprotectedHeader;\n        }\n        return jwe;\n    }\n}\nexports.FlattenedEncrypt = FlattenedEncrypt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/flattened/encrypt.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/general/decrypt.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/general/decrypt.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.generalDecrypt = void 0;\nconst decrypt_js_1 = __webpack_require__(/*! ../flattened/decrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/flattened/decrypt.js\");\nconst errors_js_1 = __webpack_require__(/*! ../../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst is_object_js_1 = __webpack_require__(/*! ../../lib/is_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js\");\nasync function generalDecrypt(jwe, key, options) {\n    if (!(0, is_object_js_1.default)(jwe)) {\n        throw new errors_js_1.JWEInvalid('General JWE must be an object');\n    }\n    if (!Array.isArray(jwe.recipients) || !jwe.recipients.every(is_object_js_1.default)) {\n        throw new errors_js_1.JWEInvalid('JWE Recipients missing or incorrect type');\n    }\n    if (!jwe.recipients.length) {\n        throw new errors_js_1.JWEInvalid('JWE Recipients has no members');\n    }\n    for (const recipient of jwe.recipients) {\n        try {\n            return await (0, decrypt_js_1.flattenedDecrypt)({\n                aad: jwe.aad,\n                ciphertext: jwe.ciphertext,\n                encrypted_key: recipient.encrypted_key,\n                header: recipient.header,\n                iv: jwe.iv,\n                protected: jwe.protected,\n                tag: jwe.tag,\n                unprotected: jwe.unprotected,\n            }, key, options);\n        }\n        catch {\n        }\n    }\n    throw new errors_js_1.JWEDecryptionFailed();\n}\nexports.generalDecrypt = generalDecrypt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/general/decrypt.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/general/encrypt.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/general/encrypt.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.GeneralEncrypt = void 0;\nconst encrypt_js_1 = __webpack_require__(/*! ../flattened/encrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/flattened/encrypt.js\");\nconst errors_js_1 = __webpack_require__(/*! ../../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst cek_js_1 = __webpack_require__(/*! ../../lib/cek.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/cek.js\");\nconst is_disjoint_js_1 = __webpack_require__(/*! ../../lib/is_disjoint.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_disjoint.js\");\nconst encrypt_key_management_js_1 = __webpack_require__(/*! ../../lib/encrypt_key_management.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/encrypt_key_management.js\");\nconst base64url_js_1 = __webpack_require__(/*! ../../runtime/base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nconst validate_crit_js_1 = __webpack_require__(/*! ../../lib/validate_crit.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/validate_crit.js\");\nclass IndividualRecipient {\n    constructor(enc, key, options) {\n        this.parent = enc;\n        this.key = key;\n        this.options = options;\n    }\n    setUnprotectedHeader(unprotectedHeader) {\n        if (this.unprotectedHeader) {\n            throw new TypeError('setUnprotectedHeader can only be called once');\n        }\n        this.unprotectedHeader = unprotectedHeader;\n        return this;\n    }\n    addRecipient(...args) {\n        return this.parent.addRecipient(...args);\n    }\n    encrypt(...args) {\n        return this.parent.encrypt(...args);\n    }\n    done() {\n        return this.parent;\n    }\n}\nclass GeneralEncrypt {\n    constructor(plaintext) {\n        this._recipients = [];\n        this._plaintext = plaintext;\n    }\n    addRecipient(key, options) {\n        const recipient = new IndividualRecipient(this, key, { crit: options === null || options === void 0 ? void 0 : options.crit });\n        this._recipients.push(recipient);\n        return recipient;\n    }\n    setProtectedHeader(protectedHeader) {\n        if (this._protectedHeader) {\n            throw new TypeError('setProtectedHeader can only be called once');\n        }\n        this._protectedHeader = protectedHeader;\n        return this;\n    }\n    setSharedUnprotectedHeader(sharedUnprotectedHeader) {\n        if (this._unprotectedHeader) {\n            throw new TypeError('setSharedUnprotectedHeader can only be called once');\n        }\n        this._unprotectedHeader = sharedUnprotectedHeader;\n        return this;\n    }\n    setAdditionalAuthenticatedData(aad) {\n        this._aad = aad;\n        return this;\n    }\n    async encrypt(options) {\n        var _a, _b, _c;\n        if (!this._recipients.length) {\n            throw new errors_js_1.JWEInvalid('at least one recipient must be added');\n        }\n        options = { deflateRaw: options === null || options === void 0 ? void 0 : options.deflateRaw };\n        if (this._recipients.length === 1) {\n            const [recipient] = this._recipients;\n            const flattened = await new encrypt_js_1.FlattenedEncrypt(this._plaintext)\n                .setAdditionalAuthenticatedData(this._aad)\n                .setProtectedHeader(this._protectedHeader)\n                .setSharedUnprotectedHeader(this._unprotectedHeader)\n                .setUnprotectedHeader(recipient.unprotectedHeader)\n                .encrypt(recipient.key, { ...recipient.options, ...options });\n            let jwe = {\n                ciphertext: flattened.ciphertext,\n                iv: flattened.iv,\n                recipients: [{}],\n                tag: flattened.tag,\n            };\n            if (flattened.aad)\n                jwe.aad = flattened.aad;\n            if (flattened.protected)\n                jwe.protected = flattened.protected;\n            if (flattened.unprotected)\n                jwe.unprotected = flattened.unprotected;\n            if (flattened.encrypted_key)\n                jwe.recipients[0].encrypted_key = flattened.encrypted_key;\n            if (flattened.header)\n                jwe.recipients[0].header = flattened.header;\n            return jwe;\n        }\n        let enc;\n        for (let i = 0; i < this._recipients.length; i++) {\n            const recipient = this._recipients[i];\n            if (!(0, is_disjoint_js_1.default)(this._protectedHeader, this._unprotectedHeader, recipient.unprotectedHeader)) {\n                throw new errors_js_1.JWEInvalid('JWE Protected, JWE Shared Unprotected and JWE Per-Recipient Header Parameter names must be disjoint');\n            }\n            const joseHeader = {\n                ...this._protectedHeader,\n                ...this._unprotectedHeader,\n                ...recipient.unprotectedHeader,\n            };\n            const { alg } = joseHeader;\n            if (typeof alg !== 'string' || !alg) {\n                throw new errors_js_1.JWEInvalid('JWE \"alg\" (Algorithm) Header Parameter missing or invalid');\n            }\n            if (alg === 'dir' || alg === 'ECDH-ES') {\n                throw new errors_js_1.JWEInvalid('\"dir\" and \"ECDH-ES\" alg may only be used with a single recipient');\n            }\n            if (typeof joseHeader.enc !== 'string' || !joseHeader.enc) {\n                throw new errors_js_1.JWEInvalid('JWE \"enc\" (Encryption Algorithm) Header Parameter missing or invalid');\n            }\n            if (!enc) {\n                enc = joseHeader.enc;\n            }\n            else if (enc !== joseHeader.enc) {\n                throw new errors_js_1.JWEInvalid('JWE \"enc\" (Encryption Algorithm) Header Parameter must be the same for all recipients');\n            }\n            (0, validate_crit_js_1.default)(errors_js_1.JWEInvalid, new Map(), recipient.options.crit, this._protectedHeader, joseHeader);\n            if (joseHeader.zip !== undefined) {\n                if (!this._protectedHeader || !this._protectedHeader.zip) {\n                    throw new errors_js_1.JWEInvalid('JWE \"zip\" (Compression Algorithm) Header MUST be integrity protected');\n                }\n            }\n        }\n        const cek = (0, cek_js_1.default)(enc);\n        let jwe = {\n            ciphertext: '',\n            iv: '',\n            recipients: [],\n            tag: '',\n        };\n        for (let i = 0; i < this._recipients.length; i++) {\n            const recipient = this._recipients[i];\n            const target = {};\n            jwe.recipients.push(target);\n            const joseHeader = {\n                ...this._protectedHeader,\n                ...this._unprotectedHeader,\n                ...recipient.unprotectedHeader,\n            };\n            const p2c = joseHeader.alg.startsWith('PBES2') ? 2048 + i : undefined;\n            if (i === 0) {\n                const flattened = await new encrypt_js_1.FlattenedEncrypt(this._plaintext)\n                    .setAdditionalAuthenticatedData(this._aad)\n                    .setContentEncryptionKey(cek)\n                    .setProtectedHeader(this._protectedHeader)\n                    .setSharedUnprotectedHeader(this._unprotectedHeader)\n                    .setUnprotectedHeader(recipient.unprotectedHeader)\n                    .setKeyManagementParameters({ p2c })\n                    .encrypt(recipient.key, {\n                    ...recipient.options,\n                    ...options,\n                    [encrypt_js_1.unprotected]: true,\n                });\n                jwe.ciphertext = flattened.ciphertext;\n                jwe.iv = flattened.iv;\n                jwe.tag = flattened.tag;\n                if (flattened.aad)\n                    jwe.aad = flattened.aad;\n                if (flattened.protected)\n                    jwe.protected = flattened.protected;\n                if (flattened.unprotected)\n                    jwe.unprotected = flattened.unprotected;\n                target.encrypted_key = flattened.encrypted_key;\n                if (flattened.header)\n                    target.header = flattened.header;\n                continue;\n            }\n            const { encryptedKey, parameters } = await (0, encrypt_key_management_js_1.default)(((_a = recipient.unprotectedHeader) === null || _a === void 0 ? void 0 : _a.alg) ||\n                ((_b = this._protectedHeader) === null || _b === void 0 ? void 0 : _b.alg) ||\n                ((_c = this._unprotectedHeader) === null || _c === void 0 ? void 0 : _c.alg), enc, recipient.key, cek, { p2c });\n            target.encrypted_key = (0, base64url_js_1.encode)(encryptedKey);\n            if (recipient.unprotectedHeader || parameters)\n                target.header = { ...recipient.unprotectedHeader, ...parameters };\n        }\n        return jwe;\n    }\n}\nexports.GeneralEncrypt = GeneralEncrypt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/general/encrypt.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwk/embedded.js":
/*!************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwk/embedded.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.EmbeddedJWK = void 0;\nconst import_js_1 = __webpack_require__(/*! ../key/import.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/import.js\");\nconst is_object_js_1 = __webpack_require__(/*! ../lib/is_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nasync function EmbeddedJWK(protectedHeader, token) {\n    const joseHeader = {\n        ...protectedHeader,\n        ...token === null || token === void 0 ? void 0 : token.header,\n    };\n    if (!(0, is_object_js_1.default)(joseHeader.jwk)) {\n        throw new errors_js_1.JWSInvalid('\"jwk\" (JSON Web Key) Header Parameter must be a JSON object');\n    }\n    const key = await (0, import_js_1.importJWK)({ ...joseHeader.jwk, ext: true }, joseHeader.alg, true);\n    if (key instanceof Uint8Array || key.type !== 'public') {\n        throw new errors_js_1.JWSInvalid('\"jwk\" (JSON Web Key) Header Parameter must be a public key');\n    }\n    return key;\n}\nexports.EmbeddedJWK = EmbeddedJWK;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwk/embedded.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwk/thumbprint.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwk/thumbprint.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.calculateJwkThumbprintUri = exports.calculateJwkThumbprint = void 0;\nconst digest_js_1 = __webpack_require__(/*! ../runtime/digest.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/digest.js\");\nconst base64url_js_1 = __webpack_require__(/*! ../runtime/base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst is_object_js_1 = __webpack_require__(/*! ../lib/is_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js\");\nconst check = (value, description) => {\n    if (typeof value !== 'string' || !value) {\n        throw new errors_js_1.JWKInvalid(`${description} missing or invalid`);\n    }\n};\nasync function calculateJwkThumbprint(jwk, digestAlgorithm) {\n    if (!(0, is_object_js_1.default)(jwk)) {\n        throw new TypeError('JWK must be an object');\n    }\n    digestAlgorithm !== null && digestAlgorithm !== void 0 ? digestAlgorithm : (digestAlgorithm = 'sha256');\n    if (digestAlgorithm !== 'sha256' &&\n        digestAlgorithm !== 'sha384' &&\n        digestAlgorithm !== 'sha512') {\n        throw new TypeError('digestAlgorithm must one of \"sha256\", \"sha384\", or \"sha512\"');\n    }\n    let components;\n    switch (jwk.kty) {\n        case 'EC':\n            check(jwk.crv, '\"crv\" (Curve) Parameter');\n            check(jwk.x, '\"x\" (X Coordinate) Parameter');\n            check(jwk.y, '\"y\" (Y Coordinate) Parameter');\n            components = { crv: jwk.crv, kty: jwk.kty, x: jwk.x, y: jwk.y };\n            break;\n        case 'OKP':\n            check(jwk.crv, '\"crv\" (Subtype of Key Pair) Parameter');\n            check(jwk.x, '\"x\" (Public Key) Parameter');\n            components = { crv: jwk.crv, kty: jwk.kty, x: jwk.x };\n            break;\n        case 'RSA':\n            check(jwk.e, '\"e\" (Exponent) Parameter');\n            check(jwk.n, '\"n\" (Modulus) Parameter');\n            components = { e: jwk.e, kty: jwk.kty, n: jwk.n };\n            break;\n        case 'oct':\n            check(jwk.k, '\"k\" (Key Value) Parameter');\n            components = { k: jwk.k, kty: jwk.kty };\n            break;\n        default:\n            throw new errors_js_1.JOSENotSupported('\"kty\" (Key Type) Parameter missing or unsupported');\n    }\n    const data = buffer_utils_js_1.encoder.encode(JSON.stringify(components));\n    return (0, base64url_js_1.encode)(await (0, digest_js_1.default)(digestAlgorithm, data));\n}\nexports.calculateJwkThumbprint = calculateJwkThumbprint;\nasync function calculateJwkThumbprintUri(jwk, digestAlgorithm) {\n    digestAlgorithm !== null && digestAlgorithm !== void 0 ? digestAlgorithm : (digestAlgorithm = 'sha256');\n    const thumbprint = await calculateJwkThumbprint(jwk, digestAlgorithm);\n    return `urn:ietf:params:oauth:jwk-thumbprint:sha-${digestAlgorithm.slice(-3)}:${thumbprint}`;\n}\nexports.calculateJwkThumbprintUri = calculateJwkThumbprintUri;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwk/thumbprint.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwks/local.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwks/local.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.createLocalJWKSet = exports.LocalJWKSet = exports.isJWKSLike = void 0;\nconst import_js_1 = __webpack_require__(/*! ../key/import.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/import.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst is_object_js_1 = __webpack_require__(/*! ../lib/is_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js\");\nfunction getKtyFromAlg(alg) {\n    switch (typeof alg === 'string' && alg.slice(0, 2)) {\n        case 'RS':\n        case 'PS':\n            return 'RSA';\n        case 'ES':\n            return 'EC';\n        case 'Ed':\n            return 'OKP';\n        default:\n            throw new errors_js_1.JOSENotSupported('Unsupported \"alg\" value for a JSON Web Key Set');\n    }\n}\nfunction isJWKSLike(jwks) {\n    return (jwks &&\n        typeof jwks === 'object' &&\n        Array.isArray(jwks.keys) &&\n        jwks.keys.every(isJWKLike));\n}\nexports.isJWKSLike = isJWKSLike;\nfunction isJWKLike(key) {\n    return (0, is_object_js_1.default)(key);\n}\nfunction clone(obj) {\n    if (typeof structuredClone === 'function') {\n        return structuredClone(obj);\n    }\n    return JSON.parse(JSON.stringify(obj));\n}\nclass LocalJWKSet {\n    constructor(jwks) {\n        this._cached = new WeakMap();\n        if (!isJWKSLike(jwks)) {\n            throw new errors_js_1.JWKSInvalid('JSON Web Key Set malformed');\n        }\n        this._jwks = clone(jwks);\n    }\n    async getKey(protectedHeader, token) {\n        const { alg, kid } = { ...protectedHeader, ...token === null || token === void 0 ? void 0 : token.header };\n        const kty = getKtyFromAlg(alg);\n        const candidates = this._jwks.keys.filter((jwk) => {\n            let candidate = kty === jwk.kty;\n            if (candidate && typeof kid === 'string') {\n                candidate = kid === jwk.kid;\n            }\n            if (candidate && typeof jwk.alg === 'string') {\n                candidate = alg === jwk.alg;\n            }\n            if (candidate && typeof jwk.use === 'string') {\n                candidate = jwk.use === 'sig';\n            }\n            if (candidate && Array.isArray(jwk.key_ops)) {\n                candidate = jwk.key_ops.includes('verify');\n            }\n            if (candidate && alg === 'EdDSA') {\n                candidate = jwk.crv === 'Ed25519' || jwk.crv === 'Ed448';\n            }\n            if (candidate) {\n                switch (alg) {\n                    case 'ES256':\n                        candidate = jwk.crv === 'P-256';\n                        break;\n                    case 'ES256K':\n                        candidate = jwk.crv === 'secp256k1';\n                        break;\n                    case 'ES384':\n                        candidate = jwk.crv === 'P-384';\n                        break;\n                    case 'ES512':\n                        candidate = jwk.crv === 'P-521';\n                        break;\n                }\n            }\n            return candidate;\n        });\n        const { 0: jwk, length } = candidates;\n        if (length === 0) {\n            throw new errors_js_1.JWKSNoMatchingKey();\n        }\n        else if (length !== 1) {\n            const error = new errors_js_1.JWKSMultipleMatchingKeys();\n            const { _cached } = this;\n            error[Symbol.asyncIterator] = async function* () {\n                for (const jwk of candidates) {\n                    try {\n                        yield await importWithAlgCache(_cached, jwk, alg);\n                    }\n                    catch {\n                        continue;\n                    }\n                }\n            };\n            throw error;\n        }\n        return importWithAlgCache(this._cached, jwk, alg);\n    }\n}\nexports.LocalJWKSet = LocalJWKSet;\nasync function importWithAlgCache(cache, jwk, alg) {\n    const cached = cache.get(jwk) || cache.set(jwk, {}).get(jwk);\n    if (cached[alg] === undefined) {\n        const key = await (0, import_js_1.importJWK)({ ...jwk, ext: true }, alg);\n        if (key instanceof Uint8Array || key.type !== 'public') {\n            throw new errors_js_1.JWKSInvalid('JSON Web Key Set members must be public keys');\n        }\n        cached[alg] = key;\n    }\n    return cached[alg];\n}\nfunction createLocalJWKSet(jwks) {\n    const set = new LocalJWKSet(jwks);\n    return async function (protectedHeader, token) {\n        return set.getKey(protectedHeader, token);\n    };\n}\nexports.createLocalJWKSet = createLocalJWKSet;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwks/local.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwks/remote.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwks/remote.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.createRemoteJWKSet = void 0;\nconst fetch_jwks_js_1 = __webpack_require__(/*! ../runtime/fetch_jwks.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/fetch_jwks.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst local_js_1 = __webpack_require__(/*! ./local.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwks/local.js\");\nfunction isCloudflareWorkers() {\n    return (typeof WebSocketPair !== 'undefined' ||\n        (typeof navigator !== 'undefined' && navigator.userAgent === 'Cloudflare-Workers') ||\n        (typeof EdgeRuntime !== 'undefined' && EdgeRuntime === 'vercel'));\n}\nclass RemoteJWKSet extends local_js_1.LocalJWKSet {\n    constructor(url, options) {\n        super({ keys: [] });\n        this._jwks = undefined;\n        if (!(url instanceof URL)) {\n            throw new TypeError('url must be an instance of URL');\n        }\n        this._url = new URL(url.href);\n        this._options = { agent: options === null || options === void 0 ? void 0 : options.agent, headers: options === null || options === void 0 ? void 0 : options.headers };\n        this._timeoutDuration =\n            typeof (options === null || options === void 0 ? void 0 : options.timeoutDuration) === 'number' ? options === null || options === void 0 ? void 0 : options.timeoutDuration : 5000;\n        this._cooldownDuration =\n            typeof (options === null || options === void 0 ? void 0 : options.cooldownDuration) === 'number' ? options === null || options === void 0 ? void 0 : options.cooldownDuration : 30000;\n        this._cacheMaxAge = typeof (options === null || options === void 0 ? void 0 : options.cacheMaxAge) === 'number' ? options === null || options === void 0 ? void 0 : options.cacheMaxAge : 600000;\n    }\n    coolingDown() {\n        return typeof this._jwksTimestamp === 'number'\n            ? Date.now() < this._jwksTimestamp + this._cooldownDuration\n            : false;\n    }\n    fresh() {\n        return typeof this._jwksTimestamp === 'number'\n            ? Date.now() < this._jwksTimestamp + this._cacheMaxAge\n            : false;\n    }\n    async getKey(protectedHeader, token) {\n        if (!this._jwks || !this.fresh()) {\n            await this.reload();\n        }\n        try {\n            return await super.getKey(protectedHeader, token);\n        }\n        catch (err) {\n            if (err instanceof errors_js_1.JWKSNoMatchingKey) {\n                if (this.coolingDown() === false) {\n                    await this.reload();\n                    return super.getKey(protectedHeader, token);\n                }\n            }\n            throw err;\n        }\n    }\n    async reload() {\n        if (this._pendingFetch && isCloudflareWorkers()) {\n            this._pendingFetch = undefined;\n        }\n        this._pendingFetch || (this._pendingFetch = (0, fetch_jwks_js_1.default)(this._url, this._timeoutDuration, this._options)\n            .then((json) => {\n            if (!(0, local_js_1.isJWKSLike)(json)) {\n                throw new errors_js_1.JWKSInvalid('JSON Web Key Set malformed');\n            }\n            this._jwks = { keys: json.keys };\n            this._jwksTimestamp = Date.now();\n            this._pendingFetch = undefined;\n        })\n            .catch((err) => {\n            this._pendingFetch = undefined;\n            throw err;\n        }));\n        await this._pendingFetch;\n    }\n}\nfunction createRemoteJWKSet(url, options) {\n    const set = new RemoteJWKSet(url, options);\n    return async function (protectedHeader, token) {\n        return set.getKey(protectedHeader, token);\n    };\n}\nexports.createRemoteJWKSet = createRemoteJWKSet;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwks/remote.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/compact/sign.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/compact/sign.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.CompactSign = void 0;\nconst sign_js_1 = __webpack_require__(/*! ../flattened/sign.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/flattened/sign.js\");\nclass CompactSign {\n    constructor(payload) {\n        this._flattened = new sign_js_1.FlattenedSign(payload);\n    }\n    setProtectedHeader(protectedHeader) {\n        this._flattened.setProtectedHeader(protectedHeader);\n        return this;\n    }\n    async sign(key, options) {\n        const jws = await this._flattened.sign(key, options);\n        if (jws.payload === undefined) {\n            throw new TypeError('use the flattened module for creating JWS with b64: false');\n        }\n        return `${jws.protected}.${jws.payload}.${jws.signature}`;\n    }\n}\nexports.CompactSign = CompactSign;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2p3cy9jb21wYWN0L3NpZ24uanMiLCJtYXBwaW5ncyI6IkFBQWE7QUFDYiw4Q0FBNkMsRUFBRSxhQUFhLEVBQUM7QUFDN0QsbUJBQW1CO0FBQ25CLGtCQUFrQixtQkFBTyxDQUFDLHNIQUFzQjtBQUNoRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQixjQUFjLEdBQUcsWUFBWSxHQUFHLGNBQWM7QUFDaEU7QUFDQTtBQUNBLG1CQUFtQiIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2p3cy9jb21wYWN0L3NpZ24uanM/NGU0NiJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbmV4cG9ydHMuQ29tcGFjdFNpZ24gPSB2b2lkIDA7XG5jb25zdCBzaWduX2pzXzEgPSByZXF1aXJlKFwiLi4vZmxhdHRlbmVkL3NpZ24uanNcIik7XG5jbGFzcyBDb21wYWN0U2lnbiB7XG4gICAgY29uc3RydWN0b3IocGF5bG9hZCkge1xuICAgICAgICB0aGlzLl9mbGF0dGVuZWQgPSBuZXcgc2lnbl9qc18xLkZsYXR0ZW5lZFNpZ24ocGF5bG9hZCk7XG4gICAgfVxuICAgIHNldFByb3RlY3RlZEhlYWRlcihwcm90ZWN0ZWRIZWFkZXIpIHtcbiAgICAgICAgdGhpcy5fZmxhdHRlbmVkLnNldFByb3RlY3RlZEhlYWRlcihwcm90ZWN0ZWRIZWFkZXIpO1xuICAgICAgICByZXR1cm4gdGhpcztcbiAgICB9XG4gICAgYXN5bmMgc2lnbihrZXksIG9wdGlvbnMpIHtcbiAgICAgICAgY29uc3QgandzID0gYXdhaXQgdGhpcy5fZmxhdHRlbmVkLnNpZ24oa2V5LCBvcHRpb25zKTtcbiAgICAgICAgaWYgKGp3cy5wYXlsb2FkID09PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ3VzZSB0aGUgZmxhdHRlbmVkIG1vZHVsZSBmb3IgY3JlYXRpbmcgSldTIHdpdGggYjY0OiBmYWxzZScpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiBgJHtqd3MucHJvdGVjdGVkfS4ke2p3cy5wYXlsb2FkfS4ke2p3cy5zaWduYXR1cmV9YDtcbiAgICB9XG59XG5leHBvcnRzLkNvbXBhY3RTaWduID0gQ29tcGFjdFNpZ247XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/compact/sign.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/compact/verify.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/compact/verify.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.compactVerify = void 0;\nconst verify_js_1 = __webpack_require__(/*! ../flattened/verify.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/flattened/verify.js\");\nconst errors_js_1 = __webpack_require__(/*! ../../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nasync function compactVerify(jws, key, options) {\n    if (jws instanceof Uint8Array) {\n        jws = buffer_utils_js_1.decoder.decode(jws);\n    }\n    if (typeof jws !== 'string') {\n        throw new errors_js_1.JWSInvalid('Compact JWS must be a string or Uint8Array');\n    }\n    const { 0: protectedHeader, 1: payload, 2: signature, length } = jws.split('.');\n    if (length !== 3) {\n        throw new errors_js_1.JWSInvalid('Invalid Compact JWS');\n    }\n    const verified = await (0, verify_js_1.flattenedVerify)({ payload, protected: protectedHeader, signature }, key, options);\n    const result = { payload: verified.payload, protectedHeader: verified.protectedHeader };\n    if (typeof key === 'function') {\n        return { ...result, key: verified.key };\n    }\n    return result;\n}\nexports.compactVerify = compactVerify;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/compact/verify.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/flattened/sign.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/flattened/sign.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.FlattenedSign = void 0;\nconst base64url_js_1 = __webpack_require__(/*! ../../runtime/base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nconst sign_js_1 = __webpack_require__(/*! ../../runtime/sign.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/sign.js\");\nconst is_disjoint_js_1 = __webpack_require__(/*! ../../lib/is_disjoint.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_disjoint.js\");\nconst errors_js_1 = __webpack_require__(/*! ../../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst check_key_type_js_1 = __webpack_require__(/*! ../../lib/check_key_type.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_key_type.js\");\nconst validate_crit_js_1 = __webpack_require__(/*! ../../lib/validate_crit.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/validate_crit.js\");\nclass FlattenedSign {\n    constructor(payload) {\n        if (!(payload instanceof Uint8Array)) {\n            throw new TypeError('payload must be an instance of Uint8Array');\n        }\n        this._payload = payload;\n    }\n    setProtectedHeader(protectedHeader) {\n        if (this._protectedHeader) {\n            throw new TypeError('setProtectedHeader can only be called once');\n        }\n        this._protectedHeader = protectedHeader;\n        return this;\n    }\n    setUnprotectedHeader(unprotectedHeader) {\n        if (this._unprotectedHeader) {\n            throw new TypeError('setUnprotectedHeader can only be called once');\n        }\n        this._unprotectedHeader = unprotectedHeader;\n        return this;\n    }\n    async sign(key, options) {\n        if (!this._protectedHeader && !this._unprotectedHeader) {\n            throw new errors_js_1.JWSInvalid('either setProtectedHeader or setUnprotectedHeader must be called before #sign()');\n        }\n        if (!(0, is_disjoint_js_1.default)(this._protectedHeader, this._unprotectedHeader)) {\n            throw new errors_js_1.JWSInvalid('JWS Protected and JWS Unprotected Header Parameter names must be disjoint');\n        }\n        const joseHeader = {\n            ...this._protectedHeader,\n            ...this._unprotectedHeader,\n        };\n        const extensions = (0, validate_crit_js_1.default)(errors_js_1.JWSInvalid, new Map([['b64', true]]), options === null || options === void 0 ? void 0 : options.crit, this._protectedHeader, joseHeader);\n        let b64 = true;\n        if (extensions.has('b64')) {\n            b64 = this._protectedHeader.b64;\n            if (typeof b64 !== 'boolean') {\n                throw new errors_js_1.JWSInvalid('The \"b64\" (base64url-encode payload) Header Parameter must be a boolean');\n            }\n        }\n        const { alg } = joseHeader;\n        if (typeof alg !== 'string' || !alg) {\n            throw new errors_js_1.JWSInvalid('JWS \"alg\" (Algorithm) Header Parameter missing or invalid');\n        }\n        (0, check_key_type_js_1.default)(alg, key, 'sign');\n        let payload = this._payload;\n        if (b64) {\n            payload = buffer_utils_js_1.encoder.encode((0, base64url_js_1.encode)(payload));\n        }\n        let protectedHeader;\n        if (this._protectedHeader) {\n            protectedHeader = buffer_utils_js_1.encoder.encode((0, base64url_js_1.encode)(JSON.stringify(this._protectedHeader)));\n        }\n        else {\n            protectedHeader = buffer_utils_js_1.encoder.encode('');\n        }\n        const data = (0, buffer_utils_js_1.concat)(protectedHeader, buffer_utils_js_1.encoder.encode('.'), payload);\n        const signature = await (0, sign_js_1.default)(alg, key, data);\n        const jws = {\n            signature: (0, base64url_js_1.encode)(signature),\n            payload: '',\n        };\n        if (b64) {\n            jws.payload = buffer_utils_js_1.decoder.decode(payload);\n        }\n        if (this._unprotectedHeader) {\n            jws.header = this._unprotectedHeader;\n        }\n        if (this._protectedHeader) {\n            jws.protected = buffer_utils_js_1.decoder.decode(protectedHeader);\n        }\n        return jws;\n    }\n}\nexports.FlattenedSign = FlattenedSign;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/flattened/sign.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/flattened/verify.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/flattened/verify.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.flattenedVerify = void 0;\nconst base64url_js_1 = __webpack_require__(/*! ../../runtime/base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nconst verify_js_1 = __webpack_require__(/*! ../../runtime/verify.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/verify.js\");\nconst errors_js_1 = __webpack_require__(/*! ../../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst is_disjoint_js_1 = __webpack_require__(/*! ../../lib/is_disjoint.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_disjoint.js\");\nconst is_object_js_1 = __webpack_require__(/*! ../../lib/is_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js\");\nconst check_key_type_js_1 = __webpack_require__(/*! ../../lib/check_key_type.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_key_type.js\");\nconst validate_crit_js_1 = __webpack_require__(/*! ../../lib/validate_crit.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/validate_crit.js\");\nconst validate_algorithms_js_1 = __webpack_require__(/*! ../../lib/validate_algorithms.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/validate_algorithms.js\");\nasync function flattenedVerify(jws, key, options) {\n    var _a;\n    if (!(0, is_object_js_1.default)(jws)) {\n        throw new errors_js_1.JWSInvalid('Flattened JWS must be an object');\n    }\n    if (jws.protected === undefined && jws.header === undefined) {\n        throw new errors_js_1.JWSInvalid('Flattened JWS must have either of the \"protected\" or \"header\" members');\n    }\n    if (jws.protected !== undefined && typeof jws.protected !== 'string') {\n        throw new errors_js_1.JWSInvalid('JWS Protected Header incorrect type');\n    }\n    if (jws.payload === undefined) {\n        throw new errors_js_1.JWSInvalid('JWS Payload missing');\n    }\n    if (typeof jws.signature !== 'string') {\n        throw new errors_js_1.JWSInvalid('JWS Signature missing or incorrect type');\n    }\n    if (jws.header !== undefined && !(0, is_object_js_1.default)(jws.header)) {\n        throw new errors_js_1.JWSInvalid('JWS Unprotected Header incorrect type');\n    }\n    let parsedProt = {};\n    if (jws.protected) {\n        try {\n            const protectedHeader = (0, base64url_js_1.decode)(jws.protected);\n            parsedProt = JSON.parse(buffer_utils_js_1.decoder.decode(protectedHeader));\n        }\n        catch {\n            throw new errors_js_1.JWSInvalid('JWS Protected Header is invalid');\n        }\n    }\n    if (!(0, is_disjoint_js_1.default)(parsedProt, jws.header)) {\n        throw new errors_js_1.JWSInvalid('JWS Protected and JWS Unprotected Header Parameter names must be disjoint');\n    }\n    const joseHeader = {\n        ...parsedProt,\n        ...jws.header,\n    };\n    const extensions = (0, validate_crit_js_1.default)(errors_js_1.JWSInvalid, new Map([['b64', true]]), options === null || options === void 0 ? void 0 : options.crit, parsedProt, joseHeader);\n    let b64 = true;\n    if (extensions.has('b64')) {\n        b64 = parsedProt.b64;\n        if (typeof b64 !== 'boolean') {\n            throw new errors_js_1.JWSInvalid('The \"b64\" (base64url-encode payload) Header Parameter must be a boolean');\n        }\n    }\n    const { alg } = joseHeader;\n    if (typeof alg !== 'string' || !alg) {\n        throw new errors_js_1.JWSInvalid('JWS \"alg\" (Algorithm) Header Parameter missing or invalid');\n    }\n    const algorithms = options && (0, validate_algorithms_js_1.default)('algorithms', options.algorithms);\n    if (algorithms && !algorithms.has(alg)) {\n        throw new errors_js_1.JOSEAlgNotAllowed('\"alg\" (Algorithm) Header Parameter not allowed');\n    }\n    if (b64) {\n        if (typeof jws.payload !== 'string') {\n            throw new errors_js_1.JWSInvalid('JWS Payload must be a string');\n        }\n    }\n    else if (typeof jws.payload !== 'string' && !(jws.payload instanceof Uint8Array)) {\n        throw new errors_js_1.JWSInvalid('JWS Payload must be a string or an Uint8Array instance');\n    }\n    let resolvedKey = false;\n    if (typeof key === 'function') {\n        key = await key(parsedProt, jws);\n        resolvedKey = true;\n    }\n    (0, check_key_type_js_1.default)(alg, key, 'verify');\n    const data = (0, buffer_utils_js_1.concat)(buffer_utils_js_1.encoder.encode((_a = jws.protected) !== null && _a !== void 0 ? _a : ''), buffer_utils_js_1.encoder.encode('.'), typeof jws.payload === 'string' ? buffer_utils_js_1.encoder.encode(jws.payload) : jws.payload);\n    let signature;\n    try {\n        signature = (0, base64url_js_1.decode)(jws.signature);\n    }\n    catch {\n        throw new errors_js_1.JWSInvalid('Failed to base64url decode the signature');\n    }\n    const verified = await (0, verify_js_1.default)(alg, key, signature, data);\n    if (!verified) {\n        throw new errors_js_1.JWSSignatureVerificationFailed();\n    }\n    let payload;\n    if (b64) {\n        try {\n            payload = (0, base64url_js_1.decode)(jws.payload);\n        }\n        catch {\n            throw new errors_js_1.JWSInvalid('Failed to base64url decode the payload');\n        }\n    }\n    else if (typeof jws.payload === 'string') {\n        payload = buffer_utils_js_1.encoder.encode(jws.payload);\n    }\n    else {\n        payload = jws.payload;\n    }\n    const result = { payload };\n    if (jws.protected !== undefined) {\n        result.protectedHeader = parsedProt;\n    }\n    if (jws.header !== undefined) {\n        result.unprotectedHeader = jws.header;\n    }\n    if (resolvedKey) {\n        return { ...result, key };\n    }\n    return result;\n}\nexports.flattenedVerify = flattenedVerify;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/flattened/verify.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/general/sign.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/general/sign.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.GeneralSign = void 0;\nconst sign_js_1 = __webpack_require__(/*! ../flattened/sign.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/flattened/sign.js\");\nconst errors_js_1 = __webpack_require__(/*! ../../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nclass IndividualSignature {\n    constructor(sig, key, options) {\n        this.parent = sig;\n        this.key = key;\n        this.options = options;\n    }\n    setProtectedHeader(protectedHeader) {\n        if (this.protectedHeader) {\n            throw new TypeError('setProtectedHeader can only be called once');\n        }\n        this.protectedHeader = protectedHeader;\n        return this;\n    }\n    setUnprotectedHeader(unprotectedHeader) {\n        if (this.unprotectedHeader) {\n            throw new TypeError('setUnprotectedHeader can only be called once');\n        }\n        this.unprotectedHeader = unprotectedHeader;\n        return this;\n    }\n    addSignature(...args) {\n        return this.parent.addSignature(...args);\n    }\n    sign(...args) {\n        return this.parent.sign(...args);\n    }\n    done() {\n        return this.parent;\n    }\n}\nclass GeneralSign {\n    constructor(payload) {\n        this._signatures = [];\n        this._payload = payload;\n    }\n    addSignature(key, options) {\n        const signature = new IndividualSignature(this, key, options);\n        this._signatures.push(signature);\n        return signature;\n    }\n    async sign() {\n        if (!this._signatures.length) {\n            throw new errors_js_1.JWSInvalid('at least one signature must be added');\n        }\n        const jws = {\n            signatures: [],\n            payload: '',\n        };\n        for (let i = 0; i < this._signatures.length; i++) {\n            const signature = this._signatures[i];\n            const flattened = new sign_js_1.FlattenedSign(this._payload);\n            flattened.setProtectedHeader(signature.protectedHeader);\n            flattened.setUnprotectedHeader(signature.unprotectedHeader);\n            const { payload, ...rest } = await flattened.sign(signature.key, signature.options);\n            if (i === 0) {\n                jws.payload = payload;\n            }\n            else if (jws.payload !== payload) {\n                throw new errors_js_1.JWSInvalid('inconsistent use of JWS Unencoded Payload (RFC7797)');\n            }\n            jws.signatures.push(rest);\n        }\n        return jws;\n    }\n}\nexports.GeneralSign = GeneralSign;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/general/sign.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/general/verify.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/general/verify.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.generalVerify = void 0;\nconst verify_js_1 = __webpack_require__(/*! ../flattened/verify.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/flattened/verify.js\");\nconst errors_js_1 = __webpack_require__(/*! ../../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst is_object_js_1 = __webpack_require__(/*! ../../lib/is_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js\");\nasync function generalVerify(jws, key, options) {\n    if (!(0, is_object_js_1.default)(jws)) {\n        throw new errors_js_1.JWSInvalid('General JWS must be an object');\n    }\n    if (!Array.isArray(jws.signatures) || !jws.signatures.every(is_object_js_1.default)) {\n        throw new errors_js_1.JWSInvalid('JWS Signatures missing or incorrect type');\n    }\n    for (const signature of jws.signatures) {\n        try {\n            return await (0, verify_js_1.flattenedVerify)({\n                header: signature.header,\n                payload: jws.payload,\n                protected: signature.protected,\n                signature: signature.signature,\n            }, key, options);\n        }\n        catch {\n        }\n    }\n    throw new errors_js_1.JWSSignatureVerificationFailed();\n}\nexports.generalVerify = generalVerify;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2p3cy9nZW5lcmFsL3ZlcmlmeS5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxxQkFBcUI7QUFDckIsb0JBQW9CLG1CQUFPLENBQUMsMEhBQXdCO0FBQ3BELG9CQUFvQixtQkFBTyxDQUFDLCtHQUFzQjtBQUNsRCx1QkFBdUIsbUJBQU8sQ0FBQyxtSEFBd0I7QUFDdkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGFBQWE7QUFDYjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxxQkFBcUIiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbm9kZV9tb2R1bGVzL2pvc2UvZGlzdC9ub2RlL2Nqcy9qd3MvZ2VuZXJhbC92ZXJpZnkuanM/ZjY3OSJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbmV4cG9ydHMuZ2VuZXJhbFZlcmlmeSA9IHZvaWQgMDtcbmNvbnN0IHZlcmlmeV9qc18xID0gcmVxdWlyZShcIi4uL2ZsYXR0ZW5lZC92ZXJpZnkuanNcIik7XG5jb25zdCBlcnJvcnNfanNfMSA9IHJlcXVpcmUoXCIuLi8uLi91dGlsL2Vycm9ycy5qc1wiKTtcbmNvbnN0IGlzX29iamVjdF9qc18xID0gcmVxdWlyZShcIi4uLy4uL2xpYi9pc19vYmplY3QuanNcIik7XG5hc3luYyBmdW5jdGlvbiBnZW5lcmFsVmVyaWZ5KGp3cywga2V5LCBvcHRpb25zKSB7XG4gICAgaWYgKCEoMCwgaXNfb2JqZWN0X2pzXzEuZGVmYXVsdCkoandzKSkge1xuICAgICAgICB0aHJvdyBuZXcgZXJyb3JzX2pzXzEuSldTSW52YWxpZCgnR2VuZXJhbCBKV1MgbXVzdCBiZSBhbiBvYmplY3QnKTtcbiAgICB9XG4gICAgaWYgKCFBcnJheS5pc0FycmF5KGp3cy5zaWduYXR1cmVzKSB8fCAhandzLnNpZ25hdHVyZXMuZXZlcnkoaXNfb2JqZWN0X2pzXzEuZGVmYXVsdCkpIHtcbiAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpXU0ludmFsaWQoJ0pXUyBTaWduYXR1cmVzIG1pc3Npbmcgb3IgaW5jb3JyZWN0IHR5cGUnKTtcbiAgICB9XG4gICAgZm9yIChjb25zdCBzaWduYXR1cmUgb2YgandzLnNpZ25hdHVyZXMpIHtcbiAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgIHJldHVybiBhd2FpdCAoMCwgdmVyaWZ5X2pzXzEuZmxhdHRlbmVkVmVyaWZ5KSh7XG4gICAgICAgICAgICAgICAgaGVhZGVyOiBzaWduYXR1cmUuaGVhZGVyLFxuICAgICAgICAgICAgICAgIHBheWxvYWQ6IGp3cy5wYXlsb2FkLFxuICAgICAgICAgICAgICAgIHByb3RlY3RlZDogc2lnbmF0dXJlLnByb3RlY3RlZCxcbiAgICAgICAgICAgICAgICBzaWduYXR1cmU6IHNpZ25hdHVyZS5zaWduYXR1cmUsXG4gICAgICAgICAgICB9LCBrZXksIG9wdGlvbnMpO1xuICAgICAgICB9XG4gICAgICAgIGNhdGNoIHtcbiAgICAgICAgfVxuICAgIH1cbiAgICB0aHJvdyBuZXcgZXJyb3JzX2pzXzEuSldTU2lnbmF0dXJlVmVyaWZpY2F0aW9uRmFpbGVkKCk7XG59XG5leHBvcnRzLmdlbmVyYWxWZXJpZnkgPSBnZW5lcmFsVmVyaWZ5O1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/general/verify.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/decrypt.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/decrypt.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.jwtDecrypt = void 0;\nconst decrypt_js_1 = __webpack_require__(/*! ../jwe/compact/decrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/compact/decrypt.js\");\nconst jwt_claims_set_js_1 = __webpack_require__(/*! ../lib/jwt_claims_set.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/jwt_claims_set.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nasync function jwtDecrypt(jwt, key, options) {\n    const decrypted = await (0, decrypt_js_1.compactDecrypt)(jwt, key, options);\n    const payload = (0, jwt_claims_set_js_1.default)(decrypted.protectedHeader, decrypted.plaintext, options);\n    const { protectedHeader } = decrypted;\n    if (protectedHeader.iss !== undefined && protectedHeader.iss !== payload.iss) {\n        throw new errors_js_1.JWTClaimValidationFailed('replicated \"iss\" claim header parameter mismatch', 'iss', 'mismatch');\n    }\n    if (protectedHeader.sub !== undefined && protectedHeader.sub !== payload.sub) {\n        throw new errors_js_1.JWTClaimValidationFailed('replicated \"sub\" claim header parameter mismatch', 'sub', 'mismatch');\n    }\n    if (protectedHeader.aud !== undefined &&\n        JSON.stringify(protectedHeader.aud) !== JSON.stringify(payload.aud)) {\n        throw new errors_js_1.JWTClaimValidationFailed('replicated \"aud\" claim header parameter mismatch', 'aud', 'mismatch');\n    }\n    const result = { payload, protectedHeader };\n    if (typeof key === 'function') {\n        return { ...result, key: decrypted.key };\n    }\n    return result;\n}\nexports.jwtDecrypt = jwtDecrypt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2p3dC9kZWNyeXB0LmpzIiwibWFwcGluZ3MiOiJBQUFhO0FBQ2IsOENBQTZDLEVBQUUsYUFBYSxFQUFDO0FBQzdELGtCQUFrQjtBQUNsQixxQkFBcUIsbUJBQU8sQ0FBQyw0SEFBMkI7QUFDeEQsNEJBQTRCLG1CQUFPLENBQUMsMEhBQTBCO0FBQzlELG9CQUFvQixtQkFBTyxDQUFDLDRHQUFtQjtBQUMvQztBQUNBO0FBQ0E7QUFDQSxZQUFZLGtCQUFrQjtBQUM5QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHFCQUFxQjtBQUNyQjtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0E7QUFDQSxrQkFBa0IiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbm9kZV9tb2R1bGVzL2pvc2UvZGlzdC9ub2RlL2Nqcy9qd3QvZGVjcnlwdC5qcz9lOTRkIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZXhwb3J0cy5qd3REZWNyeXB0ID0gdm9pZCAwO1xuY29uc3QgZGVjcnlwdF9qc18xID0gcmVxdWlyZShcIi4uL2p3ZS9jb21wYWN0L2RlY3J5cHQuanNcIik7XG5jb25zdCBqd3RfY2xhaW1zX3NldF9qc18xID0gcmVxdWlyZShcIi4uL2xpYi9qd3RfY2xhaW1zX3NldC5qc1wiKTtcbmNvbnN0IGVycm9yc19qc18xID0gcmVxdWlyZShcIi4uL3V0aWwvZXJyb3JzLmpzXCIpO1xuYXN5bmMgZnVuY3Rpb24gand0RGVjcnlwdChqd3QsIGtleSwgb3B0aW9ucykge1xuICAgIGNvbnN0IGRlY3J5cHRlZCA9IGF3YWl0ICgwLCBkZWNyeXB0X2pzXzEuY29tcGFjdERlY3J5cHQpKGp3dCwga2V5LCBvcHRpb25zKTtcbiAgICBjb25zdCBwYXlsb2FkID0gKDAsIGp3dF9jbGFpbXNfc2V0X2pzXzEuZGVmYXVsdCkoZGVjcnlwdGVkLnByb3RlY3RlZEhlYWRlciwgZGVjcnlwdGVkLnBsYWludGV4dCwgb3B0aW9ucyk7XG4gICAgY29uc3QgeyBwcm90ZWN0ZWRIZWFkZXIgfSA9IGRlY3J5cHRlZDtcbiAgICBpZiAocHJvdGVjdGVkSGVhZGVyLmlzcyAhPT0gdW5kZWZpbmVkICYmIHByb3RlY3RlZEhlYWRlci5pc3MgIT09IHBheWxvYWQuaXNzKSB7XG4gICAgICAgIHRocm93IG5ldyBlcnJvcnNfanNfMS5KV1RDbGFpbVZhbGlkYXRpb25GYWlsZWQoJ3JlcGxpY2F0ZWQgXCJpc3NcIiBjbGFpbSBoZWFkZXIgcGFyYW1ldGVyIG1pc21hdGNoJywgJ2lzcycsICdtaXNtYXRjaCcpO1xuICAgIH1cbiAgICBpZiAocHJvdGVjdGVkSGVhZGVyLnN1YiAhPT0gdW5kZWZpbmVkICYmIHByb3RlY3RlZEhlYWRlci5zdWIgIT09IHBheWxvYWQuc3ViKSB7XG4gICAgICAgIHRocm93IG5ldyBlcnJvcnNfanNfMS5KV1RDbGFpbVZhbGlkYXRpb25GYWlsZWQoJ3JlcGxpY2F0ZWQgXCJzdWJcIiBjbGFpbSBoZWFkZXIgcGFyYW1ldGVyIG1pc21hdGNoJywgJ3N1YicsICdtaXNtYXRjaCcpO1xuICAgIH1cbiAgICBpZiAocHJvdGVjdGVkSGVhZGVyLmF1ZCAhPT0gdW5kZWZpbmVkICYmXG4gICAgICAgIEpTT04uc3RyaW5naWZ5KHByb3RlY3RlZEhlYWRlci5hdWQpICE9PSBKU09OLnN0cmluZ2lmeShwYXlsb2FkLmF1ZCkpIHtcbiAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpXVENsYWltVmFsaWRhdGlvbkZhaWxlZCgncmVwbGljYXRlZCBcImF1ZFwiIGNsYWltIGhlYWRlciBwYXJhbWV0ZXIgbWlzbWF0Y2gnLCAnYXVkJywgJ21pc21hdGNoJyk7XG4gICAgfVxuICAgIGNvbnN0IHJlc3VsdCA9IHsgcGF5bG9hZCwgcHJvdGVjdGVkSGVhZGVyIH07XG4gICAgaWYgKHR5cGVvZiBrZXkgPT09ICdmdW5jdGlvbicpIHtcbiAgICAgICAgcmV0dXJuIHsgLi4ucmVzdWx0LCBrZXk6IGRlY3J5cHRlZC5rZXkgfTtcbiAgICB9XG4gICAgcmV0dXJuIHJlc3VsdDtcbn1cbmV4cG9ydHMuand0RGVjcnlwdCA9IGp3dERlY3J5cHQ7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/decrypt.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/encrypt.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/encrypt.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.EncryptJWT = void 0;\nconst encrypt_js_1 = __webpack_require__(/*! ../jwe/compact/encrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwe/compact/encrypt.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst produce_js_1 = __webpack_require__(/*! ./produce.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/produce.js\");\nclass EncryptJWT extends produce_js_1.ProduceJWT {\n    setProtectedHeader(protectedHeader) {\n        if (this._protectedHeader) {\n            throw new TypeError('setProtectedHeader can only be called once');\n        }\n        this._protectedHeader = protectedHeader;\n        return this;\n    }\n    setKeyManagementParameters(parameters) {\n        if (this._keyManagementParameters) {\n            throw new TypeError('setKeyManagementParameters can only be called once');\n        }\n        this._keyManagementParameters = parameters;\n        return this;\n    }\n    setContentEncryptionKey(cek) {\n        if (this._cek) {\n            throw new TypeError('setContentEncryptionKey can only be called once');\n        }\n        this._cek = cek;\n        return this;\n    }\n    setInitializationVector(iv) {\n        if (this._iv) {\n            throw new TypeError('setInitializationVector can only be called once');\n        }\n        this._iv = iv;\n        return this;\n    }\n    replicateIssuerAsHeader() {\n        this._replicateIssuerAsHeader = true;\n        return this;\n    }\n    replicateSubjectAsHeader() {\n        this._replicateSubjectAsHeader = true;\n        return this;\n    }\n    replicateAudienceAsHeader() {\n        this._replicateAudienceAsHeader = true;\n        return this;\n    }\n    async encrypt(key, options) {\n        const enc = new encrypt_js_1.CompactEncrypt(buffer_utils_js_1.encoder.encode(JSON.stringify(this._payload)));\n        if (this._replicateIssuerAsHeader) {\n            this._protectedHeader = { ...this._protectedHeader, iss: this._payload.iss };\n        }\n        if (this._replicateSubjectAsHeader) {\n            this._protectedHeader = { ...this._protectedHeader, sub: this._payload.sub };\n        }\n        if (this._replicateAudienceAsHeader) {\n            this._protectedHeader = { ...this._protectedHeader, aud: this._payload.aud };\n        }\n        enc.setProtectedHeader(this._protectedHeader);\n        if (this._iv) {\n            enc.setInitializationVector(this._iv);\n        }\n        if (this._cek) {\n            enc.setContentEncryptionKey(this._cek);\n        }\n        if (this._keyManagementParameters) {\n            enc.setKeyManagementParameters(this._keyManagementParameters);\n        }\n        return enc.encrypt(key, options);\n    }\n}\nexports.EncryptJWT = EncryptJWT;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/encrypt.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/produce.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/produce.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.ProduceJWT = void 0;\nconst epoch_js_1 = __webpack_require__(/*! ../lib/epoch.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/epoch.js\");\nconst is_object_js_1 = __webpack_require__(/*! ../lib/is_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js\");\nconst secs_js_1 = __webpack_require__(/*! ../lib/secs.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/secs.js\");\nclass ProduceJWT {\n    constructor(payload) {\n        if (!(0, is_object_js_1.default)(payload)) {\n            throw new TypeError('JWT Claims Set MUST be an object');\n        }\n        this._payload = payload;\n    }\n    setIssuer(issuer) {\n        this._payload = { ...this._payload, iss: issuer };\n        return this;\n    }\n    setSubject(subject) {\n        this._payload = { ...this._payload, sub: subject };\n        return this;\n    }\n    setAudience(audience) {\n        this._payload = { ...this._payload, aud: audience };\n        return this;\n    }\n    setJti(jwtId) {\n        this._payload = { ...this._payload, jti: jwtId };\n        return this;\n    }\n    setNotBefore(input) {\n        if (typeof input === 'number') {\n            this._payload = { ...this._payload, nbf: input };\n        }\n        else {\n            this._payload = { ...this._payload, nbf: (0, epoch_js_1.default)(new Date()) + (0, secs_js_1.default)(input) };\n        }\n        return this;\n    }\n    setExpirationTime(input) {\n        if (typeof input === 'number') {\n            this._payload = { ...this._payload, exp: input };\n        }\n        else {\n            this._payload = { ...this._payload, exp: (0, epoch_js_1.default)(new Date()) + (0, secs_js_1.default)(input) };\n        }\n        return this;\n    }\n    setIssuedAt(input) {\n        if (typeof input === 'undefined') {\n            this._payload = { ...this._payload, iat: (0, epoch_js_1.default)(new Date()) };\n        }\n        else {\n            this._payload = { ...this._payload, iat: input };\n        }\n        return this;\n    }\n}\nexports.ProduceJWT = ProduceJWT;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/produce.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/sign.js":
/*!********************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/sign.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.SignJWT = void 0;\nconst sign_js_1 = __webpack_require__(/*! ../jws/compact/sign.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/compact/sign.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst produce_js_1 = __webpack_require__(/*! ./produce.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/produce.js\");\nclass SignJWT extends produce_js_1.ProduceJWT {\n    setProtectedHeader(protectedHeader) {\n        this._protectedHeader = protectedHeader;\n        return this;\n    }\n    async sign(key, options) {\n        var _a;\n        const sig = new sign_js_1.CompactSign(buffer_utils_js_1.encoder.encode(JSON.stringify(this._payload)));\n        sig.setProtectedHeader(this._protectedHeader);\n        if (Array.isArray((_a = this._protectedHeader) === null || _a === void 0 ? void 0 : _a.crit) &&\n            this._protectedHeader.crit.includes('b64') &&\n            this._protectedHeader.b64 === false) {\n            throw new errors_js_1.JWTInvalid('JWTs MUST NOT use unencoded payload');\n        }\n        return sig.sign(key, options);\n    }\n}\nexports.SignJWT = SignJWT;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2p3dC9zaWduLmpzIiwibWFwcGluZ3MiOiJBQUFhO0FBQ2IsOENBQTZDLEVBQUUsYUFBYSxFQUFDO0FBQzdELGVBQWU7QUFDZixrQkFBa0IsbUJBQU8sQ0FBQyxzSEFBd0I7QUFDbEQsb0JBQW9CLG1CQUFPLENBQUMsNEdBQW1CO0FBQy9DLDBCQUEwQixtQkFBTyxDQUFDLHNIQUF3QjtBQUMxRCxxQkFBcUIsbUJBQU8sQ0FBQyx1R0FBYztBQUMzQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsZUFBZSIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2p3dC9zaWduLmpzPzMyMDgiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG5leHBvcnRzLlNpZ25KV1QgPSB2b2lkIDA7XG5jb25zdCBzaWduX2pzXzEgPSByZXF1aXJlKFwiLi4vandzL2NvbXBhY3Qvc2lnbi5qc1wiKTtcbmNvbnN0IGVycm9yc19qc18xID0gcmVxdWlyZShcIi4uL3V0aWwvZXJyb3JzLmpzXCIpO1xuY29uc3QgYnVmZmVyX3V0aWxzX2pzXzEgPSByZXF1aXJlKFwiLi4vbGliL2J1ZmZlcl91dGlscy5qc1wiKTtcbmNvbnN0IHByb2R1Y2VfanNfMSA9IHJlcXVpcmUoXCIuL3Byb2R1Y2UuanNcIik7XG5jbGFzcyBTaWduSldUIGV4dGVuZHMgcHJvZHVjZV9qc18xLlByb2R1Y2VKV1Qge1xuICAgIHNldFByb3RlY3RlZEhlYWRlcihwcm90ZWN0ZWRIZWFkZXIpIHtcbiAgICAgICAgdGhpcy5fcHJvdGVjdGVkSGVhZGVyID0gcHJvdGVjdGVkSGVhZGVyO1xuICAgICAgICByZXR1cm4gdGhpcztcbiAgICB9XG4gICAgYXN5bmMgc2lnbihrZXksIG9wdGlvbnMpIHtcbiAgICAgICAgdmFyIF9hO1xuICAgICAgICBjb25zdCBzaWcgPSBuZXcgc2lnbl9qc18xLkNvbXBhY3RTaWduKGJ1ZmZlcl91dGlsc19qc18xLmVuY29kZXIuZW5jb2RlKEpTT04uc3RyaW5naWZ5KHRoaXMuX3BheWxvYWQpKSk7XG4gICAgICAgIHNpZy5zZXRQcm90ZWN0ZWRIZWFkZXIodGhpcy5fcHJvdGVjdGVkSGVhZGVyKTtcbiAgICAgICAgaWYgKEFycmF5LmlzQXJyYXkoKF9hID0gdGhpcy5fcHJvdGVjdGVkSGVhZGVyKSA9PT0gbnVsbCB8fCBfYSA9PT0gdm9pZCAwID8gdm9pZCAwIDogX2EuY3JpdCkgJiZcbiAgICAgICAgICAgIHRoaXMuX3Byb3RlY3RlZEhlYWRlci5jcml0LmluY2x1ZGVzKCdiNjQnKSAmJlxuICAgICAgICAgICAgdGhpcy5fcHJvdGVjdGVkSGVhZGVyLmI2NCA9PT0gZmFsc2UpIHtcbiAgICAgICAgICAgIHRocm93IG5ldyBlcnJvcnNfanNfMS5KV1RJbnZhbGlkKCdKV1RzIE1VU1QgTk9UIHVzZSB1bmVuY29kZWQgcGF5bG9hZCcpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiBzaWcuc2lnbihrZXksIG9wdGlvbnMpO1xuICAgIH1cbn1cbmV4cG9ydHMuU2lnbkpXVCA9IFNpZ25KV1Q7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/sign.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/unsecured.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/unsecured.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.UnsecuredJWT = void 0;\nconst base64url = __webpack_require__(/*! ../runtime/base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst jwt_claims_set_js_1 = __webpack_require__(/*! ../lib/jwt_claims_set.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/jwt_claims_set.js\");\nconst produce_js_1 = __webpack_require__(/*! ./produce.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/produce.js\");\nclass UnsecuredJWT extends produce_js_1.ProduceJWT {\n    encode() {\n        const header = base64url.encode(JSON.stringify({ alg: 'none' }));\n        const payload = base64url.encode(JSON.stringify(this._payload));\n        return `${header}.${payload}.`;\n    }\n    static decode(jwt, options) {\n        if (typeof jwt !== 'string') {\n            throw new errors_js_1.JWTInvalid('Unsecured JWT must be a string');\n        }\n        const { 0: encodedHeader, 1: encodedPayload, 2: signature, length } = jwt.split('.');\n        if (length !== 3 || signature !== '') {\n            throw new errors_js_1.JWTInvalid('Invalid Unsecured JWT');\n        }\n        let header;\n        try {\n            header = JSON.parse(buffer_utils_js_1.decoder.decode(base64url.decode(encodedHeader)));\n            if (header.alg !== 'none')\n                throw new Error();\n        }\n        catch {\n            throw new errors_js_1.JWTInvalid('Invalid Unsecured JWT');\n        }\n        const payload = (0, jwt_claims_set_js_1.default)(header, base64url.decode(encodedPayload), options);\n        return { payload, header };\n    }\n}\nexports.UnsecuredJWT = UnsecuredJWT;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/unsecured.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/verify.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/verify.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.jwtVerify = void 0;\nconst verify_js_1 = __webpack_require__(/*! ../jws/compact/verify.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jws/compact/verify.js\");\nconst jwt_claims_set_js_1 = __webpack_require__(/*! ../lib/jwt_claims_set.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/jwt_claims_set.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nasync function jwtVerify(jwt, key, options) {\n    var _a;\n    const verified = await (0, verify_js_1.compactVerify)(jwt, key, options);\n    if (((_a = verified.protectedHeader.crit) === null || _a === void 0 ? void 0 : _a.includes('b64')) && verified.protectedHeader.b64 === false) {\n        throw new errors_js_1.JWTInvalid('JWTs MUST NOT use unencoded payload');\n    }\n    const payload = (0, jwt_claims_set_js_1.default)(verified.protectedHeader, verified.payload, options);\n    const result = { payload, protectedHeader: verified.protectedHeader };\n    if (typeof key === 'function') {\n        return { ...result, key: verified.key };\n    }\n    return result;\n}\nexports.jwtVerify = jwtVerify;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/jwt/verify.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/export.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/export.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.exportJWK = exports.exportPKCS8 = exports.exportSPKI = void 0;\nconst asn1_js_1 = __webpack_require__(/*! ../runtime/asn1.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/asn1.js\");\nconst asn1_js_2 = __webpack_require__(/*! ../runtime/asn1.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/asn1.js\");\nconst key_to_jwk_js_1 = __webpack_require__(/*! ../runtime/key_to_jwk.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/key_to_jwk.js\");\nasync function exportSPKI(key) {\n    return (0, asn1_js_1.toSPKI)(key);\n}\nexports.exportSPKI = exportSPKI;\nasync function exportPKCS8(key) {\n    return (0, asn1_js_2.toPKCS8)(key);\n}\nexports.exportPKCS8 = exportPKCS8;\nasync function exportJWK(key) {\n    return (0, key_to_jwk_js_1.default)(key);\n}\nexports.exportJWK = exportJWK;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2tleS9leHBvcnQuanMiLCJtYXBwaW5ncyI6IkFBQWE7QUFDYiw4Q0FBNkMsRUFBRSxhQUFhLEVBQUM7QUFDN0QsaUJBQWlCLEdBQUcsbUJBQW1CLEdBQUcsa0JBQWtCO0FBQzVELGtCQUFrQixtQkFBTyxDQUFDLDhHQUFvQjtBQUM5QyxrQkFBa0IsbUJBQU8sQ0FBQyw4R0FBb0I7QUFDOUMsd0JBQXdCLG1CQUFPLENBQUMsMEhBQTBCO0FBQzFEO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQSxtQkFBbUI7QUFDbkI7QUFDQTtBQUNBO0FBQ0EsaUJBQWlCIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L25vZGVfbW9kdWxlcy9qb3NlL2Rpc3Qvbm9kZS9janMva2V5L2V4cG9ydC5qcz8yOTNhIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZXhwb3J0cy5leHBvcnRKV0sgPSBleHBvcnRzLmV4cG9ydFBLQ1M4ID0gZXhwb3J0cy5leHBvcnRTUEtJID0gdm9pZCAwO1xuY29uc3QgYXNuMV9qc18xID0gcmVxdWlyZShcIi4uL3J1bnRpbWUvYXNuMS5qc1wiKTtcbmNvbnN0IGFzbjFfanNfMiA9IHJlcXVpcmUoXCIuLi9ydW50aW1lL2FzbjEuanNcIik7XG5jb25zdCBrZXlfdG9fandrX2pzXzEgPSByZXF1aXJlKFwiLi4vcnVudGltZS9rZXlfdG9fandrLmpzXCIpO1xuYXN5bmMgZnVuY3Rpb24gZXhwb3J0U1BLSShrZXkpIHtcbiAgICByZXR1cm4gKDAsIGFzbjFfanNfMS50b1NQS0kpKGtleSk7XG59XG5leHBvcnRzLmV4cG9ydFNQS0kgPSBleHBvcnRTUEtJO1xuYXN5bmMgZnVuY3Rpb24gZXhwb3J0UEtDUzgoa2V5KSB7XG4gICAgcmV0dXJuICgwLCBhc24xX2pzXzIudG9QS0NTOCkoa2V5KTtcbn1cbmV4cG9ydHMuZXhwb3J0UEtDUzggPSBleHBvcnRQS0NTODtcbmFzeW5jIGZ1bmN0aW9uIGV4cG9ydEpXSyhrZXkpIHtcbiAgICByZXR1cm4gKDAsIGtleV90b19qd2tfanNfMS5kZWZhdWx0KShrZXkpO1xufVxuZXhwb3J0cy5leHBvcnRKV0sgPSBleHBvcnRKV0s7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/export.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/generate_key_pair.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/generate_key_pair.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.generateKeyPair = void 0;\nconst generate_js_1 = __webpack_require__(/*! ../runtime/generate.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/generate.js\");\nasync function generateKeyPair(alg, options) {\n    return (0, generate_js_1.generateKeyPair)(alg, options);\n}\nexports.generateKeyPair = generateKeyPair;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2tleS9nZW5lcmF0ZV9rZXlfcGFpci5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCx1QkFBdUI7QUFDdkIsc0JBQXNCLG1CQUFPLENBQUMsc0hBQXdCO0FBQ3REO0FBQ0E7QUFDQTtBQUNBLHVCQUF1QiIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2tleS9nZW5lcmF0ZV9rZXlfcGFpci5qcz8wNmY5Il0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZXhwb3J0cy5nZW5lcmF0ZUtleVBhaXIgPSB2b2lkIDA7XG5jb25zdCBnZW5lcmF0ZV9qc18xID0gcmVxdWlyZShcIi4uL3J1bnRpbWUvZ2VuZXJhdGUuanNcIik7XG5hc3luYyBmdW5jdGlvbiBnZW5lcmF0ZUtleVBhaXIoYWxnLCBvcHRpb25zKSB7XG4gICAgcmV0dXJuICgwLCBnZW5lcmF0ZV9qc18xLmdlbmVyYXRlS2V5UGFpcikoYWxnLCBvcHRpb25zKTtcbn1cbmV4cG9ydHMuZ2VuZXJhdGVLZXlQYWlyID0gZ2VuZXJhdGVLZXlQYWlyO1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/generate_key_pair.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/generate_secret.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/generate_secret.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.generateSecret = void 0;\nconst generate_js_1 = __webpack_require__(/*! ../runtime/generate.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/generate.js\");\nasync function generateSecret(alg, options) {\n    return (0, generate_js_1.generateSecret)(alg, options);\n}\nexports.generateSecret = generateSecret;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2tleS9nZW5lcmF0ZV9zZWNyZXQuanMiLCJtYXBwaW5ncyI6IkFBQWE7QUFDYiw4Q0FBNkMsRUFBRSxhQUFhLEVBQUM7QUFDN0Qsc0JBQXNCO0FBQ3RCLHNCQUFzQixtQkFBTyxDQUFDLHNIQUF3QjtBQUN0RDtBQUNBO0FBQ0E7QUFDQSxzQkFBc0IiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbm9kZV9tb2R1bGVzL2pvc2UvZGlzdC9ub2RlL2Nqcy9rZXkvZ2VuZXJhdGVfc2VjcmV0LmpzPzMzYzgiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG5leHBvcnRzLmdlbmVyYXRlU2VjcmV0ID0gdm9pZCAwO1xuY29uc3QgZ2VuZXJhdGVfanNfMSA9IHJlcXVpcmUoXCIuLi9ydW50aW1lL2dlbmVyYXRlLmpzXCIpO1xuYXN5bmMgZnVuY3Rpb24gZ2VuZXJhdGVTZWNyZXQoYWxnLCBvcHRpb25zKSB7XG4gICAgcmV0dXJuICgwLCBnZW5lcmF0ZV9qc18xLmdlbmVyYXRlU2VjcmV0KShhbGcsIG9wdGlvbnMpO1xufVxuZXhwb3J0cy5nZW5lcmF0ZVNlY3JldCA9IGdlbmVyYXRlU2VjcmV0O1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/generate_secret.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/import.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/import.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.importJWK = exports.importPKCS8 = exports.importX509 = exports.importSPKI = void 0;\nconst base64url_js_1 = __webpack_require__(/*! ../runtime/base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nconst asn1_js_1 = __webpack_require__(/*! ../runtime/asn1.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/asn1.js\");\nconst jwk_to_key_js_1 = __webpack_require__(/*! ../runtime/jwk_to_key.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/jwk_to_key.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst is_object_js_1 = __webpack_require__(/*! ../lib/is_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js\");\nasync function importSPKI(spki, alg, options) {\n    if (typeof spki !== 'string' || spki.indexOf('-----BEGIN PUBLIC KEY-----') !== 0) {\n        throw new TypeError('\"spki\" must be SPKI formatted string');\n    }\n    return (0, asn1_js_1.fromSPKI)(spki, alg, options);\n}\nexports.importSPKI = importSPKI;\nasync function importX509(x509, alg, options) {\n    if (typeof x509 !== 'string' || x509.indexOf('-----BEGIN CERTIFICATE-----') !== 0) {\n        throw new TypeError('\"x509\" must be X.509 formatted string');\n    }\n    return (0, asn1_js_1.fromX509)(x509, alg, options);\n}\nexports.importX509 = importX509;\nasync function importPKCS8(pkcs8, alg, options) {\n    if (typeof pkcs8 !== 'string' || pkcs8.indexOf('-----BEGIN PRIVATE KEY-----') !== 0) {\n        throw new TypeError('\"pkcs8\" must be PKCS#8 formatted string');\n    }\n    return (0, asn1_js_1.fromPKCS8)(pkcs8, alg, options);\n}\nexports.importPKCS8 = importPKCS8;\nasync function importJWK(jwk, alg, octAsKeyObject) {\n    var _a;\n    if (!(0, is_object_js_1.default)(jwk)) {\n        throw new TypeError('JWK must be an object');\n    }\n    alg || (alg = jwk.alg);\n    switch (jwk.kty) {\n        case 'oct':\n            if (typeof jwk.k !== 'string' || !jwk.k) {\n                throw new TypeError('missing \"k\" (Key Value) Parameter value');\n            }\n            octAsKeyObject !== null && octAsKeyObject !== void 0 ? octAsKeyObject : (octAsKeyObject = jwk.ext !== true);\n            if (octAsKeyObject) {\n                return (0, jwk_to_key_js_1.default)({ ...jwk, alg, ext: (_a = jwk.ext) !== null && _a !== void 0 ? _a : false });\n            }\n            return (0, base64url_js_1.decode)(jwk.k);\n        case 'RSA':\n            if (jwk.oth !== undefined) {\n                throw new errors_js_1.JOSENotSupported('RSA JWK \"oth\" (Other Primes Info) Parameter value is not supported');\n            }\n        case 'EC':\n        case 'OKP':\n            return (0, jwk_to_key_js_1.default)({ ...jwk, alg });\n        default:\n            throw new errors_js_1.JOSENotSupported('Unsupported \"kty\" (Key Type) Parameter value');\n    }\n}\nexports.importJWK = importJWK;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/import.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/aesgcmkw.js":
/*!************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/aesgcmkw.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.unwrap = exports.wrap = void 0;\nconst encrypt_js_1 = __webpack_require__(/*! ../runtime/encrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/encrypt.js\");\nconst decrypt_js_1 = __webpack_require__(/*! ../runtime/decrypt.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/decrypt.js\");\nconst iv_js_1 = __webpack_require__(/*! ./iv.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/iv.js\");\nconst base64url_js_1 = __webpack_require__(/*! ../runtime/base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nasync function wrap(alg, key, cek, iv) {\n    const jweAlgorithm = alg.slice(0, 7);\n    iv || (iv = (0, iv_js_1.default)(jweAlgorithm));\n    const { ciphertext: encryptedKey, tag } = await (0, encrypt_js_1.default)(jweAlgorithm, cek, key, iv, new Uint8Array(0));\n    return { encryptedKey, iv: (0, base64url_js_1.encode)(iv), tag: (0, base64url_js_1.encode)(tag) };\n}\nexports.wrap = wrap;\nasync function unwrap(alg, key, encryptedKey, iv, tag) {\n    const jweAlgorithm = alg.slice(0, 7);\n    return (0, decrypt_js_1.default)(jweAlgorithm, key, encryptedKey, iv, tag, new Uint8Array(0));\n}\nexports.unwrap = unwrap;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/aesgcmkw.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.concatKdf = exports.lengthAndInput = exports.uint32be = exports.uint64be = exports.p2s = exports.concat = exports.decoder = exports.encoder = void 0;\nconst digest_js_1 = __webpack_require__(/*! ../runtime/digest.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/digest.js\");\nexports.encoder = new TextEncoder();\nexports.decoder = new TextDecoder();\nconst MAX_INT32 = 2 ** 32;\nfunction concat(...buffers) {\n    const size = buffers.reduce((acc, { length }) => acc + length, 0);\n    const buf = new Uint8Array(size);\n    let i = 0;\n    buffers.forEach((buffer) => {\n        buf.set(buffer, i);\n        i += buffer.length;\n    });\n    return buf;\n}\nexports.concat = concat;\nfunction p2s(alg, p2sInput) {\n    return concat(exports.encoder.encode(alg), new Uint8Array([0]), p2sInput);\n}\nexports.p2s = p2s;\nfunction writeUInt32BE(buf, value, offset) {\n    if (value < 0 || value >= MAX_INT32) {\n        throw new RangeError(`value must be >= 0 and <= ${MAX_INT32 - 1}. Received ${value}`);\n    }\n    buf.set([value >>> 24, value >>> 16, value >>> 8, value & 0xff], offset);\n}\nfunction uint64be(value) {\n    const high = Math.floor(value / MAX_INT32);\n    const low = value % MAX_INT32;\n    const buf = new Uint8Array(8);\n    writeUInt32BE(buf, high, 0);\n    writeUInt32BE(buf, low, 4);\n    return buf;\n}\nexports.uint64be = uint64be;\nfunction uint32be(value) {\n    const buf = new Uint8Array(4);\n    writeUInt32BE(buf, value);\n    return buf;\n}\nexports.uint32be = uint32be;\nfunction lengthAndInput(input) {\n    return concat(uint32be(input.length), input);\n}\nexports.lengthAndInput = lengthAndInput;\nasync function concatKdf(secret, bits, value) {\n    const iterations = Math.ceil((bits >> 3) / 32);\n    const res = new Uint8Array(iterations * 32);\n    for (let iter = 0; iter < iterations; iter++) {\n        const buf = new Uint8Array(4 + secret.length + value.length);\n        buf.set(uint32be(iter + 1));\n        buf.set(secret, 4);\n        buf.set(value, 4 + secret.length);\n        res.set(await (0, digest_js_1.default)('sha256', buf), iter * 32);\n    }\n    return res.slice(0, bits >> 3);\n}\nexports.concatKdf = concatKdf;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/cek.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/cek.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.bitLength = void 0;\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst random_js_1 = __webpack_require__(/*! ../runtime/random.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/random.js\");\nfunction bitLength(alg) {\n    switch (alg) {\n        case 'A128GCM':\n            return 128;\n        case 'A192GCM':\n            return 192;\n        case 'A256GCM':\n        case 'A128CBC-HS256':\n            return 256;\n        case 'A192CBC-HS384':\n            return 384;\n        case 'A256CBC-HS512':\n            return 512;\n        default:\n            throw new errors_js_1.JOSENotSupported(`Unsupported JWE Algorithm: ${alg}`);\n    }\n}\nexports.bitLength = bitLength;\nexports[\"default\"] = (alg) => (0, random_js_1.default)(new Uint8Array(bitLength(alg) >> 3));\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi9jZWsuanMiLCJtYXBwaW5ncyI6IkFBQWE7QUFDYiw4Q0FBNkMsRUFBRSxhQUFhLEVBQUM7QUFDN0QsaUJBQWlCO0FBQ2pCLG9CQUFvQixtQkFBTyxDQUFDLDRHQUFtQjtBQUMvQyxvQkFBb0IsbUJBQU8sQ0FBQyxrSEFBc0I7QUFDbEQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlGQUFpRixJQUFJO0FBQ3JGO0FBQ0E7QUFDQSxpQkFBaUI7QUFDakIsa0JBQWUiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbm9kZV9tb2R1bGVzL2pvc2UvZGlzdC9ub2RlL2Nqcy9saWIvY2VrLmpzPzA0ZjYiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG5leHBvcnRzLmJpdExlbmd0aCA9IHZvaWQgMDtcbmNvbnN0IGVycm9yc19qc18xID0gcmVxdWlyZShcIi4uL3V0aWwvZXJyb3JzLmpzXCIpO1xuY29uc3QgcmFuZG9tX2pzXzEgPSByZXF1aXJlKFwiLi4vcnVudGltZS9yYW5kb20uanNcIik7XG5mdW5jdGlvbiBiaXRMZW5ndGgoYWxnKSB7XG4gICAgc3dpdGNoIChhbGcpIHtcbiAgICAgICAgY2FzZSAnQTEyOEdDTSc6XG4gICAgICAgICAgICByZXR1cm4gMTI4O1xuICAgICAgICBjYXNlICdBMTkyR0NNJzpcbiAgICAgICAgICAgIHJldHVybiAxOTI7XG4gICAgICAgIGNhc2UgJ0EyNTZHQ00nOlxuICAgICAgICBjYXNlICdBMTI4Q0JDLUhTMjU2JzpcbiAgICAgICAgICAgIHJldHVybiAyNTY7XG4gICAgICAgIGNhc2UgJ0ExOTJDQkMtSFMzODQnOlxuICAgICAgICAgICAgcmV0dXJuIDM4NDtcbiAgICAgICAgY2FzZSAnQTI1NkNCQy1IUzUxMic6XG4gICAgICAgICAgICByZXR1cm4gNTEyO1xuICAgICAgICBkZWZhdWx0OlxuICAgICAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpPU0VOb3RTdXBwb3J0ZWQoYFVuc3VwcG9ydGVkIEpXRSBBbGdvcml0aG06ICR7YWxnfWApO1xuICAgIH1cbn1cbmV4cG9ydHMuYml0TGVuZ3RoID0gYml0TGVuZ3RoO1xuZXhwb3J0cy5kZWZhdWx0ID0gKGFsZykgPT4gKDAsIHJhbmRvbV9qc18xLmRlZmF1bHQpKG5ldyBVaW50OEFycmF5KGJpdExlbmd0aChhbGcpID4+IDMpKTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/cek.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_iv_length.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_iv_length.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst iv_js_1 = __webpack_require__(/*! ./iv.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/iv.js\");\nconst checkIvLength = (enc, iv) => {\n    if (iv.length << 3 !== (0, iv_js_1.bitLength)(enc)) {\n        throw new errors_js_1.JWEInvalid('Invalid Initialization Vector length');\n    }\n};\nexports[\"default\"] = checkIvLength;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi9jaGVja19pdl9sZW5ndGguanMiLCJtYXBwaW5ncyI6IkFBQWE7QUFDYiw4Q0FBNkMsRUFBRSxhQUFhLEVBQUM7QUFDN0Qsb0JBQW9CLG1CQUFPLENBQUMsNEdBQW1CO0FBQy9DLGdCQUFnQixtQkFBTyxDQUFDLDZGQUFTO0FBQ2pDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBZSIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi9jaGVja19pdl9sZW5ndGguanM/OGU4OSJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbmNvbnN0IGVycm9yc19qc18xID0gcmVxdWlyZShcIi4uL3V0aWwvZXJyb3JzLmpzXCIpO1xuY29uc3QgaXZfanNfMSA9IHJlcXVpcmUoXCIuL2l2LmpzXCIpO1xuY29uc3QgY2hlY2tJdkxlbmd0aCA9IChlbmMsIGl2KSA9PiB7XG4gICAgaWYgKGl2Lmxlbmd0aCA8PCAzICE9PSAoMCwgaXZfanNfMS5iaXRMZW5ndGgpKGVuYykpIHtcbiAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpXRUludmFsaWQoJ0ludmFsaWQgSW5pdGlhbGl6YXRpb24gVmVjdG9yIGxlbmd0aCcpO1xuICAgIH1cbn07XG5leHBvcnRzLmRlZmF1bHQgPSBjaGVja0l2TGVuZ3RoO1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_iv_length.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_key_type.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_key_type.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst invalid_key_input_js_1 = __webpack_require__(/*! ./invalid_key_input.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/invalid_key_input.js\");\nconst is_key_like_js_1 = __webpack_require__(/*! ../runtime/is_key_like.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_like.js\");\nconst symmetricTypeCheck = (alg, key) => {\n    if (key instanceof Uint8Array)\n        return;\n    if (!(0, is_key_like_js_1.default)(key)) {\n        throw new TypeError((0, invalid_key_input_js_1.withAlg)(alg, key, ...is_key_like_js_1.types, 'Uint8Array'));\n    }\n    if (key.type !== 'secret') {\n        throw new TypeError(`${is_key_like_js_1.types.join(' or ')} instances for symmetric algorithms must be of type \"secret\"`);\n    }\n};\nconst asymmetricTypeCheck = (alg, key, usage) => {\n    if (!(0, is_key_like_js_1.default)(key)) {\n        throw new TypeError((0, invalid_key_input_js_1.withAlg)(alg, key, ...is_key_like_js_1.types));\n    }\n    if (key.type === 'secret') {\n        throw new TypeError(`${is_key_like_js_1.types.join(' or ')} instances for asymmetric algorithms must not be of type \"secret\"`);\n    }\n    if (usage === 'sign' && key.type === 'public') {\n        throw new TypeError(`${is_key_like_js_1.types.join(' or ')} instances for asymmetric algorithm signing must be of type \"private\"`);\n    }\n    if (usage === 'decrypt' && key.type === 'public') {\n        throw new TypeError(`${is_key_like_js_1.types.join(' or ')} instances for asymmetric algorithm decryption must be of type \"private\"`);\n    }\n    if (key.algorithm && usage === 'verify' && key.type === 'private') {\n        throw new TypeError(`${is_key_like_js_1.types.join(' or ')} instances for asymmetric algorithm verifying must be of type \"public\"`);\n    }\n    if (key.algorithm && usage === 'encrypt' && key.type === 'private') {\n        throw new TypeError(`${is_key_like_js_1.types.join(' or ')} instances for asymmetric algorithm encryption must be of type \"public\"`);\n    }\n};\nconst checkKeyType = (alg, key, usage) => {\n    const symmetric = alg.startsWith('HS') ||\n        alg === 'dir' ||\n        alg.startsWith('PBES2') ||\n        /^A\\d{3}(?:GCM)?KW$/.test(alg);\n    if (symmetric) {\n        symmetricTypeCheck(alg, key);\n    }\n    else {\n        asymmetricTypeCheck(alg, key, usage);\n    }\n};\nexports[\"default\"] = checkKeyType;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_key_type.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_p2s.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_p2s.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nfunction checkP2s(p2s) {\n    if (!(p2s instanceof Uint8Array) || p2s.length < 8) {\n        throw new errors_js_1.JWEInvalid('PBES2 Salt Input must be 8 or more octets');\n    }\n}\nexports[\"default\"] = checkP2s;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi9jaGVja19wMnMuanMiLCJtYXBwaW5ncyI6IkFBQWE7QUFDYiw4Q0FBNkMsRUFBRSxhQUFhLEVBQUM7QUFDN0Qsb0JBQW9CLG1CQUFPLENBQUMsNEdBQW1CO0FBQy9DO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBZSIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi9jaGVja19wMnMuanM/NGM4MCJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbmNvbnN0IGVycm9yc19qc18xID0gcmVxdWlyZShcIi4uL3V0aWwvZXJyb3JzLmpzXCIpO1xuZnVuY3Rpb24gY2hlY2tQMnMocDJzKSB7XG4gICAgaWYgKCEocDJzIGluc3RhbmNlb2YgVWludDhBcnJheSkgfHwgcDJzLmxlbmd0aCA8IDgpIHtcbiAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpXRUludmFsaWQoJ1BCRVMyIFNhbHQgSW5wdXQgbXVzdCBiZSA4IG9yIG1vcmUgb2N0ZXRzJyk7XG4gICAgfVxufVxuZXhwb3J0cy5kZWZhdWx0ID0gY2hlY2tQMnM7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_p2s.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/crypto_key.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/crypto_key.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.checkEncCryptoKey = exports.checkSigCryptoKey = void 0;\nfunction unusable(name, prop = 'algorithm.name') {\n    return new TypeError(`CryptoKey does not support this operation, its ${prop} must be ${name}`);\n}\nfunction isAlgorithm(algorithm, name) {\n    return algorithm.name === name;\n}\nfunction getHashLength(hash) {\n    return parseInt(hash.name.slice(4), 10);\n}\nfunction getNamedCurve(alg) {\n    switch (alg) {\n        case 'ES256':\n            return 'P-256';\n        case 'ES384':\n            return 'P-384';\n        case 'ES512':\n            return 'P-521';\n        default:\n            throw new Error('unreachable');\n    }\n}\nfunction checkUsage(key, usages) {\n    if (usages.length && !usages.some((expected) => key.usages.includes(expected))) {\n        let msg = 'CryptoKey does not support this operation, its usages must include ';\n        if (usages.length > 2) {\n            const last = usages.pop();\n            msg += `one of ${usages.join(', ')}, or ${last}.`;\n        }\n        else if (usages.length === 2) {\n            msg += `one of ${usages[0]} or ${usages[1]}.`;\n        }\n        else {\n            msg += `${usages[0]}.`;\n        }\n        throw new TypeError(msg);\n    }\n}\nfunction checkSigCryptoKey(key, alg, ...usages) {\n    switch (alg) {\n        case 'HS256':\n        case 'HS384':\n        case 'HS512': {\n            if (!isAlgorithm(key.algorithm, 'HMAC'))\n                throw unusable('HMAC');\n            const expected = parseInt(alg.slice(2), 10);\n            const actual = getHashLength(key.algorithm.hash);\n            if (actual !== expected)\n                throw unusable(`SHA-${expected}`, 'algorithm.hash');\n            break;\n        }\n        case 'RS256':\n        case 'RS384':\n        case 'RS512': {\n            if (!isAlgorithm(key.algorithm, 'RSASSA-PKCS1-v1_5'))\n                throw unusable('RSASSA-PKCS1-v1_5');\n            const expected = parseInt(alg.slice(2), 10);\n            const actual = getHashLength(key.algorithm.hash);\n            if (actual !== expected)\n                throw unusable(`SHA-${expected}`, 'algorithm.hash');\n            break;\n        }\n        case 'PS256':\n        case 'PS384':\n        case 'PS512': {\n            if (!isAlgorithm(key.algorithm, 'RSA-PSS'))\n                throw unusable('RSA-PSS');\n            const expected = parseInt(alg.slice(2), 10);\n            const actual = getHashLength(key.algorithm.hash);\n            if (actual !== expected)\n                throw unusable(`SHA-${expected}`, 'algorithm.hash');\n            break;\n        }\n        case 'EdDSA': {\n            if (key.algorithm.name !== 'Ed25519' && key.algorithm.name !== 'Ed448') {\n                throw unusable('Ed25519 or Ed448');\n            }\n            break;\n        }\n        case 'ES256':\n        case 'ES384':\n        case 'ES512': {\n            if (!isAlgorithm(key.algorithm, 'ECDSA'))\n                throw unusable('ECDSA');\n            const expected = getNamedCurve(alg);\n            const actual = key.algorithm.namedCurve;\n            if (actual !== expected)\n                throw unusable(expected, 'algorithm.namedCurve');\n            break;\n        }\n        default:\n            throw new TypeError('CryptoKey does not support this operation');\n    }\n    checkUsage(key, usages);\n}\nexports.checkSigCryptoKey = checkSigCryptoKey;\nfunction checkEncCryptoKey(key, alg, ...usages) {\n    switch (alg) {\n        case 'A128GCM':\n        case 'A192GCM':\n        case 'A256GCM': {\n            if (!isAlgorithm(key.algorithm, 'AES-GCM'))\n                throw unusable('AES-GCM');\n            const expected = parseInt(alg.slice(1, 4), 10);\n            const actual = key.algorithm.length;\n            if (actual !== expected)\n                throw unusable(expected, 'algorithm.length');\n            break;\n        }\n        case 'A128KW':\n        case 'A192KW':\n        case 'A256KW': {\n            if (!isAlgorithm(key.algorithm, 'AES-KW'))\n                throw unusable('AES-KW');\n            const expected = parseInt(alg.slice(1, 4), 10);\n            const actual = key.algorithm.length;\n            if (actual !== expected)\n                throw unusable(expected, 'algorithm.length');\n            break;\n        }\n        case 'ECDH': {\n            switch (key.algorithm.name) {\n                case 'ECDH':\n                case 'X25519':\n                case 'X448':\n                    break;\n                default:\n                    throw unusable('ECDH, X25519, or X448');\n            }\n            break;\n        }\n        case 'PBES2-HS256+A128KW':\n        case 'PBES2-HS384+A192KW':\n        case 'PBES2-HS512+A256KW':\n            if (!isAlgorithm(key.algorithm, 'PBKDF2'))\n                throw unusable('PBKDF2');\n            break;\n        case 'RSA-OAEP':\n        case 'RSA-OAEP-256':\n        case 'RSA-OAEP-384':\n        case 'RSA-OAEP-512': {\n            if (!isAlgorithm(key.algorithm, 'RSA-OAEP'))\n                throw unusable('RSA-OAEP');\n            const expected = parseInt(alg.slice(9), 10) || 1;\n            const actual = getHashLength(key.algorithm.hash);\n            if (actual !== expected)\n                throw unusable(`SHA-${expected}`, 'algorithm.hash');\n            break;\n        }\n        default:\n            throw new TypeError('CryptoKey does not support this operation');\n    }\n    checkUsage(key, usages);\n}\nexports.checkEncCryptoKey = checkEncCryptoKey;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/crypto_key.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/decrypt_key_management.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/decrypt_key_management.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst aeskw_js_1 = __webpack_require__(/*! ../runtime/aeskw.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/aeskw.js\");\nconst ECDH = __webpack_require__(/*! ../runtime/ecdhes.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/ecdhes.js\");\nconst pbes2kw_js_1 = __webpack_require__(/*! ../runtime/pbes2kw.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/pbes2kw.js\");\nconst rsaes_js_1 = __webpack_require__(/*! ../runtime/rsaes.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/rsaes.js\");\nconst base64url_js_1 = __webpack_require__(/*! ../runtime/base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst cek_js_1 = __webpack_require__(/*! ../lib/cek.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/cek.js\");\nconst import_js_1 = __webpack_require__(/*! ../key/import.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/import.js\");\nconst check_key_type_js_1 = __webpack_require__(/*! ./check_key_type.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_key_type.js\");\nconst is_object_js_1 = __webpack_require__(/*! ./is_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js\");\nconst aesgcmkw_js_1 = __webpack_require__(/*! ./aesgcmkw.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/aesgcmkw.js\");\nasync function decryptKeyManagement(alg, key, encryptedKey, joseHeader, options) {\n    (0, check_key_type_js_1.default)(alg, key, 'decrypt');\n    switch (alg) {\n        case 'dir': {\n            if (encryptedKey !== undefined)\n                throw new errors_js_1.JWEInvalid('Encountered unexpected JWE Encrypted Key');\n            return key;\n        }\n        case 'ECDH-ES':\n            if (encryptedKey !== undefined)\n                throw new errors_js_1.JWEInvalid('Encountered unexpected JWE Encrypted Key');\n        case 'ECDH-ES+A128KW':\n        case 'ECDH-ES+A192KW':\n        case 'ECDH-ES+A256KW': {\n            if (!(0, is_object_js_1.default)(joseHeader.epk))\n                throw new errors_js_1.JWEInvalid(`JOSE Header \"epk\" (Ephemeral Public Key) missing or invalid`);\n            if (!ECDH.ecdhAllowed(key))\n                throw new errors_js_1.JOSENotSupported('ECDH with the provided key is not allowed or not supported by your javascript runtime');\n            const epk = await (0, import_js_1.importJWK)(joseHeader.epk, alg);\n            let partyUInfo;\n            let partyVInfo;\n            if (joseHeader.apu !== undefined) {\n                if (typeof joseHeader.apu !== 'string')\n                    throw new errors_js_1.JWEInvalid(`JOSE Header \"apu\" (Agreement PartyUInfo) invalid`);\n                try {\n                    partyUInfo = (0, base64url_js_1.decode)(joseHeader.apu);\n                }\n                catch {\n                    throw new errors_js_1.JWEInvalid('Failed to base64url decode the apu');\n                }\n            }\n            if (joseHeader.apv !== undefined) {\n                if (typeof joseHeader.apv !== 'string')\n                    throw new errors_js_1.JWEInvalid(`JOSE Header \"apv\" (Agreement PartyVInfo) invalid`);\n                try {\n                    partyVInfo = (0, base64url_js_1.decode)(joseHeader.apv);\n                }\n                catch {\n                    throw new errors_js_1.JWEInvalid('Failed to base64url decode the apv');\n                }\n            }\n            const sharedSecret = await ECDH.deriveKey(epk, key, alg === 'ECDH-ES' ? joseHeader.enc : alg, alg === 'ECDH-ES' ? (0, cek_js_1.bitLength)(joseHeader.enc) : parseInt(alg.slice(-5, -2), 10), partyUInfo, partyVInfo);\n            if (alg === 'ECDH-ES')\n                return sharedSecret;\n            if (encryptedKey === undefined)\n                throw new errors_js_1.JWEInvalid('JWE Encrypted Key missing');\n            return (0, aeskw_js_1.unwrap)(alg.slice(-6), sharedSecret, encryptedKey);\n        }\n        case 'RSA1_5':\n        case 'RSA-OAEP':\n        case 'RSA-OAEP-256':\n        case 'RSA-OAEP-384':\n        case 'RSA-OAEP-512': {\n            if (encryptedKey === undefined)\n                throw new errors_js_1.JWEInvalid('JWE Encrypted Key missing');\n            return (0, rsaes_js_1.decrypt)(alg, key, encryptedKey);\n        }\n        case 'PBES2-HS256+A128KW':\n        case 'PBES2-HS384+A192KW':\n        case 'PBES2-HS512+A256KW': {\n            if (encryptedKey === undefined)\n                throw new errors_js_1.JWEInvalid('JWE Encrypted Key missing');\n            if (typeof joseHeader.p2c !== 'number')\n                throw new errors_js_1.JWEInvalid(`JOSE Header \"p2c\" (PBES2 Count) missing or invalid`);\n            const p2cLimit = (options === null || options === void 0 ? void 0 : options.maxPBES2Count) || 10000;\n            if (joseHeader.p2c > p2cLimit)\n                throw new errors_js_1.JWEInvalid(`JOSE Header \"p2c\" (PBES2 Count) out is of acceptable bounds`);\n            if (typeof joseHeader.p2s !== 'string')\n                throw new errors_js_1.JWEInvalid(`JOSE Header \"p2s\" (PBES2 Salt) missing or invalid`);\n            let p2s;\n            try {\n                p2s = (0, base64url_js_1.decode)(joseHeader.p2s);\n            }\n            catch {\n                throw new errors_js_1.JWEInvalid('Failed to base64url decode the p2s');\n            }\n            return (0, pbes2kw_js_1.decrypt)(alg, key, encryptedKey, joseHeader.p2c, p2s);\n        }\n        case 'A128KW':\n        case 'A192KW':\n        case 'A256KW': {\n            if (encryptedKey === undefined)\n                throw new errors_js_1.JWEInvalid('JWE Encrypted Key missing');\n            return (0, aeskw_js_1.unwrap)(alg, key, encryptedKey);\n        }\n        case 'A128GCMKW':\n        case 'A192GCMKW':\n        case 'A256GCMKW': {\n            if (encryptedKey === undefined)\n                throw new errors_js_1.JWEInvalid('JWE Encrypted Key missing');\n            if (typeof joseHeader.iv !== 'string')\n                throw new errors_js_1.JWEInvalid(`JOSE Header \"iv\" (Initialization Vector) missing or invalid`);\n            if (typeof joseHeader.tag !== 'string')\n                throw new errors_js_1.JWEInvalid(`JOSE Header \"tag\" (Authentication Tag) missing or invalid`);\n            let iv;\n            try {\n                iv = (0, base64url_js_1.decode)(joseHeader.iv);\n            }\n            catch {\n                throw new errors_js_1.JWEInvalid('Failed to base64url decode the iv');\n            }\n            let tag;\n            try {\n                tag = (0, base64url_js_1.decode)(joseHeader.tag);\n            }\n            catch {\n                throw new errors_js_1.JWEInvalid('Failed to base64url decode the tag');\n            }\n            return (0, aesgcmkw_js_1.unwrap)(alg, key, encryptedKey, iv, tag);\n        }\n        default: {\n            throw new errors_js_1.JOSENotSupported('Invalid or unsupported \"alg\" (JWE Algorithm) header value');\n        }\n    }\n}\nexports[\"default\"] = decryptKeyManagement;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi9kZWNyeXB0X2tleV9tYW5hZ2VtZW50LmpzIiwibWFwcGluZ3MiOiJBQUFhO0FBQ2IsOENBQTZDLEVBQUUsYUFBYSxFQUFDO0FBQzdELG1CQUFtQixtQkFBTyxDQUFDLGdIQUFxQjtBQUNoRCxhQUFhLG1CQUFPLENBQUMsa0hBQXNCO0FBQzNDLHFCQUFxQixtQkFBTyxDQUFDLG9IQUF1QjtBQUNwRCxtQkFBbUIsbUJBQU8sQ0FBQyxnSEFBcUI7QUFDaEQsdUJBQXVCLG1CQUFPLENBQUMsd0hBQXlCO0FBQ3hELG9CQUFvQixtQkFBTyxDQUFDLDRHQUFtQjtBQUMvQyxpQkFBaUIsbUJBQU8sQ0FBQyxvR0FBZTtBQUN4QyxvQkFBb0IsbUJBQU8sQ0FBQywwR0FBa0I7QUFDOUMsNEJBQTRCLG1CQUFPLENBQUMscUhBQXFCO0FBQ3pELHVCQUF1QixtQkFBTyxDQUFDLDJHQUFnQjtBQUMvQyxzQkFBc0IsbUJBQU8sQ0FBQyx5R0FBZTtBQUM3QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFlIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L25vZGVfbW9kdWxlcy9qb3NlL2Rpc3Qvbm9kZS9janMvbGliL2RlY3J5cHRfa2V5X21hbmFnZW1lbnQuanM/NmU1MCJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbmNvbnN0IGFlc2t3X2pzXzEgPSByZXF1aXJlKFwiLi4vcnVudGltZS9hZXNrdy5qc1wiKTtcbmNvbnN0IEVDREggPSByZXF1aXJlKFwiLi4vcnVudGltZS9lY2RoZXMuanNcIik7XG5jb25zdCBwYmVzMmt3X2pzXzEgPSByZXF1aXJlKFwiLi4vcnVudGltZS9wYmVzMmt3LmpzXCIpO1xuY29uc3QgcnNhZXNfanNfMSA9IHJlcXVpcmUoXCIuLi9ydW50aW1lL3JzYWVzLmpzXCIpO1xuY29uc3QgYmFzZTY0dXJsX2pzXzEgPSByZXF1aXJlKFwiLi4vcnVudGltZS9iYXNlNjR1cmwuanNcIik7XG5jb25zdCBlcnJvcnNfanNfMSA9IHJlcXVpcmUoXCIuLi91dGlsL2Vycm9ycy5qc1wiKTtcbmNvbnN0IGNla19qc18xID0gcmVxdWlyZShcIi4uL2xpYi9jZWsuanNcIik7XG5jb25zdCBpbXBvcnRfanNfMSA9IHJlcXVpcmUoXCIuLi9rZXkvaW1wb3J0LmpzXCIpO1xuY29uc3QgY2hlY2tfa2V5X3R5cGVfanNfMSA9IHJlcXVpcmUoXCIuL2NoZWNrX2tleV90eXBlLmpzXCIpO1xuY29uc3QgaXNfb2JqZWN0X2pzXzEgPSByZXF1aXJlKFwiLi9pc19vYmplY3QuanNcIik7XG5jb25zdCBhZXNnY21rd19qc18xID0gcmVxdWlyZShcIi4vYWVzZ2Nta3cuanNcIik7XG5hc3luYyBmdW5jdGlvbiBkZWNyeXB0S2V5TWFuYWdlbWVudChhbGcsIGtleSwgZW5jcnlwdGVkS2V5LCBqb3NlSGVhZGVyLCBvcHRpb25zKSB7XG4gICAgKDAsIGNoZWNrX2tleV90eXBlX2pzXzEuZGVmYXVsdCkoYWxnLCBrZXksICdkZWNyeXB0Jyk7XG4gICAgc3dpdGNoIChhbGcpIHtcbiAgICAgICAgY2FzZSAnZGlyJzoge1xuICAgICAgICAgICAgaWYgKGVuY3J5cHRlZEtleSAhPT0gdW5kZWZpbmVkKVxuICAgICAgICAgICAgICAgIHRocm93IG5ldyBlcnJvcnNfanNfMS5KV0VJbnZhbGlkKCdFbmNvdW50ZXJlZCB1bmV4cGVjdGVkIEpXRSBFbmNyeXB0ZWQgS2V5Jyk7XG4gICAgICAgICAgICByZXR1cm4ga2V5O1xuICAgICAgICB9XG4gICAgICAgIGNhc2UgJ0VDREgtRVMnOlxuICAgICAgICAgICAgaWYgKGVuY3J5cHRlZEtleSAhPT0gdW5kZWZpbmVkKVxuICAgICAgICAgICAgICAgIHRocm93IG5ldyBlcnJvcnNfanNfMS5KV0VJbnZhbGlkKCdFbmNvdW50ZXJlZCB1bmV4cGVjdGVkIEpXRSBFbmNyeXB0ZWQgS2V5Jyk7XG4gICAgICAgIGNhc2UgJ0VDREgtRVMrQTEyOEtXJzpcbiAgICAgICAgY2FzZSAnRUNESC1FUytBMTkyS1cnOlxuICAgICAgICBjYXNlICdFQ0RILUVTK0EyNTZLVyc6IHtcbiAgICAgICAgICAgIGlmICghKDAsIGlzX29iamVjdF9qc18xLmRlZmF1bHQpKGpvc2VIZWFkZXIuZXBrKSlcbiAgICAgICAgICAgICAgICB0aHJvdyBuZXcgZXJyb3JzX2pzXzEuSldFSW52YWxpZChgSk9TRSBIZWFkZXIgXCJlcGtcIiAoRXBoZW1lcmFsIFB1YmxpYyBLZXkpIG1pc3Npbmcgb3IgaW52YWxpZGApO1xuICAgICAgICAgICAgaWYgKCFFQ0RILmVjZGhBbGxvd2VkKGtleSkpXG4gICAgICAgICAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpPU0VOb3RTdXBwb3J0ZWQoJ0VDREggd2l0aCB0aGUgcHJvdmlkZWQga2V5IGlzIG5vdCBhbGxvd2VkIG9yIG5vdCBzdXBwb3J0ZWQgYnkgeW91ciBqYXZhc2NyaXB0IHJ1bnRpbWUnKTtcbiAgICAgICAgICAgIGNvbnN0IGVwayA9IGF3YWl0ICgwLCBpbXBvcnRfanNfMS5pbXBvcnRKV0spKGpvc2VIZWFkZXIuZXBrLCBhbGcpO1xuICAgICAgICAgICAgbGV0IHBhcnR5VUluZm87XG4gICAgICAgICAgICBsZXQgcGFydHlWSW5mbztcbiAgICAgICAgICAgIGlmIChqb3NlSGVhZGVyLmFwdSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICAgICAgaWYgKHR5cGVvZiBqb3NlSGVhZGVyLmFwdSAhPT0gJ3N0cmluZycpXG4gICAgICAgICAgICAgICAgICAgIHRocm93IG5ldyBlcnJvcnNfanNfMS5KV0VJbnZhbGlkKGBKT1NFIEhlYWRlciBcImFwdVwiIChBZ3JlZW1lbnQgUGFydHlVSW5mbykgaW52YWxpZGApO1xuICAgICAgICAgICAgICAgIHRyeSB7XG4gICAgICAgICAgICAgICAgICAgIHBhcnR5VUluZm8gPSAoMCwgYmFzZTY0dXJsX2pzXzEuZGVjb2RlKShqb3NlSGVhZGVyLmFwdSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIGNhdGNoIHtcbiAgICAgICAgICAgICAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpXRUludmFsaWQoJ0ZhaWxlZCB0byBiYXNlNjR1cmwgZGVjb2RlIHRoZSBhcHUnKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAoam9zZUhlYWRlci5hcHYgIT09IHVuZGVmaW5lZCkge1xuICAgICAgICAgICAgICAgIGlmICh0eXBlb2Ygam9zZUhlYWRlci5hcHYgIT09ICdzdHJpbmcnKVxuICAgICAgICAgICAgICAgICAgICB0aHJvdyBuZXcgZXJyb3JzX2pzXzEuSldFSW52YWxpZChgSk9TRSBIZWFkZXIgXCJhcHZcIiAoQWdyZWVtZW50IFBhcnR5VkluZm8pIGludmFsaWRgKTtcbiAgICAgICAgICAgICAgICB0cnkge1xuICAgICAgICAgICAgICAgICAgICBwYXJ0eVZJbmZvID0gKDAsIGJhc2U2NHVybF9qc18xLmRlY29kZSkoam9zZUhlYWRlci5hcHYpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBjYXRjaCB7XG4gICAgICAgICAgICAgICAgICAgIHRocm93IG5ldyBlcnJvcnNfanNfMS5KV0VJbnZhbGlkKCdGYWlsZWQgdG8gYmFzZTY0dXJsIGRlY29kZSB0aGUgYXB2Jyk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgY29uc3Qgc2hhcmVkU2VjcmV0ID0gYXdhaXQgRUNESC5kZXJpdmVLZXkoZXBrLCBrZXksIGFsZyA9PT0gJ0VDREgtRVMnID8gam9zZUhlYWRlci5lbmMgOiBhbGcsIGFsZyA9PT0gJ0VDREgtRVMnID8gKDAsIGNla19qc18xLmJpdExlbmd0aCkoam9zZUhlYWRlci5lbmMpIDogcGFyc2VJbnQoYWxnLnNsaWNlKC01LCAtMiksIDEwKSwgcGFydHlVSW5mbywgcGFydHlWSW5mbyk7XG4gICAgICAgICAgICBpZiAoYWxnID09PSAnRUNESC1FUycpXG4gICAgICAgICAgICAgICAgcmV0dXJuIHNoYXJlZFNlY3JldDtcbiAgICAgICAgICAgIGlmIChlbmNyeXB0ZWRLZXkgPT09IHVuZGVmaW5lZClcbiAgICAgICAgICAgICAgICB0aHJvdyBuZXcgZXJyb3JzX2pzXzEuSldFSW52YWxpZCgnSldFIEVuY3J5cHRlZCBLZXkgbWlzc2luZycpO1xuICAgICAgICAgICAgcmV0dXJuICgwLCBhZXNrd19qc18xLnVud3JhcCkoYWxnLnNsaWNlKC02KSwgc2hhcmVkU2VjcmV0LCBlbmNyeXB0ZWRLZXkpO1xuICAgICAgICB9XG4gICAgICAgIGNhc2UgJ1JTQTFfNSc6XG4gICAgICAgIGNhc2UgJ1JTQS1PQUVQJzpcbiAgICAgICAgY2FzZSAnUlNBLU9BRVAtMjU2JzpcbiAgICAgICAgY2FzZSAnUlNBLU9BRVAtMzg0JzpcbiAgICAgICAgY2FzZSAnUlNBLU9BRVAtNTEyJzoge1xuICAgICAgICAgICAgaWYgKGVuY3J5cHRlZEtleSA9PT0gdW5kZWZpbmVkKVxuICAgICAgICAgICAgICAgIHRocm93IG5ldyBlcnJvcnNfanNfMS5KV0VJbnZhbGlkKCdKV0UgRW5jcnlwdGVkIEtleSBtaXNzaW5nJyk7XG4gICAgICAgICAgICByZXR1cm4gKDAsIHJzYWVzX2pzXzEuZGVjcnlwdCkoYWxnLCBrZXksIGVuY3J5cHRlZEtleSk7XG4gICAgICAgIH1cbiAgICAgICAgY2FzZSAnUEJFUzItSFMyNTYrQTEyOEtXJzpcbiAgICAgICAgY2FzZSAnUEJFUzItSFMzODQrQTE5MktXJzpcbiAgICAgICAgY2FzZSAnUEJFUzItSFM1MTIrQTI1NktXJzoge1xuICAgICAgICAgICAgaWYgKGVuY3J5cHRlZEtleSA9PT0gdW5kZWZpbmVkKVxuICAgICAgICAgICAgICAgIHRocm93IG5ldyBlcnJvcnNfanNfMS5KV0VJbnZhbGlkKCdKV0UgRW5jcnlwdGVkIEtleSBtaXNzaW5nJyk7XG4gICAgICAgICAgICBpZiAodHlwZW9mIGpvc2VIZWFkZXIucDJjICE9PSAnbnVtYmVyJylcbiAgICAgICAgICAgICAgICB0aHJvdyBuZXcgZXJyb3JzX2pzXzEuSldFSW52YWxpZChgSk9TRSBIZWFkZXIgXCJwMmNcIiAoUEJFUzIgQ291bnQpIG1pc3Npbmcgb3IgaW52YWxpZGApO1xuICAgICAgICAgICAgY29uc3QgcDJjTGltaXQgPSAob3B0aW9ucyA9PT0gbnVsbCB8fCBvcHRpb25zID09PSB2b2lkIDAgPyB2b2lkIDAgOiBvcHRpb25zLm1heFBCRVMyQ291bnQpIHx8IDEwMDAwO1xuICAgICAgICAgICAgaWYgKGpvc2VIZWFkZXIucDJjID4gcDJjTGltaXQpXG4gICAgICAgICAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpXRUludmFsaWQoYEpPU0UgSGVhZGVyIFwicDJjXCIgKFBCRVMyIENvdW50KSBvdXQgaXMgb2YgYWNjZXB0YWJsZSBib3VuZHNgKTtcbiAgICAgICAgICAgIGlmICh0eXBlb2Ygam9zZUhlYWRlci5wMnMgIT09ICdzdHJpbmcnKVxuICAgICAgICAgICAgICAgIHRocm93IG5ldyBlcnJvcnNfanNfMS5KV0VJbnZhbGlkKGBKT1NFIEhlYWRlciBcInAyc1wiIChQQkVTMiBTYWx0KSBtaXNzaW5nIG9yIGludmFsaWRgKTtcbiAgICAgICAgICAgIGxldCBwMnM7XG4gICAgICAgICAgICB0cnkge1xuICAgICAgICAgICAgICAgIHAycyA9ICgwLCBiYXNlNjR1cmxfanNfMS5kZWNvZGUpKGpvc2VIZWFkZXIucDJzKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGNhdGNoIHtcbiAgICAgICAgICAgICAgICB0aHJvdyBuZXcgZXJyb3JzX2pzXzEuSldFSW52YWxpZCgnRmFpbGVkIHRvIGJhc2U2NHVybCBkZWNvZGUgdGhlIHAycycpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuICgwLCBwYmVzMmt3X2pzXzEuZGVjcnlwdCkoYWxnLCBrZXksIGVuY3J5cHRlZEtleSwgam9zZUhlYWRlci5wMmMsIHAycyk7XG4gICAgICAgIH1cbiAgICAgICAgY2FzZSAnQTEyOEtXJzpcbiAgICAgICAgY2FzZSAnQTE5MktXJzpcbiAgICAgICAgY2FzZSAnQTI1NktXJzoge1xuICAgICAgICAgICAgaWYgKGVuY3J5cHRlZEtleSA9PT0gdW5kZWZpbmVkKVxuICAgICAgICAgICAgICAgIHRocm93IG5ldyBlcnJvcnNfanNfMS5KV0VJbnZhbGlkKCdKV0UgRW5jcnlwdGVkIEtleSBtaXNzaW5nJyk7XG4gICAgICAgICAgICByZXR1cm4gKDAsIGFlc2t3X2pzXzEudW53cmFwKShhbGcsIGtleSwgZW5jcnlwdGVkS2V5KTtcbiAgICAgICAgfVxuICAgICAgICBjYXNlICdBMTI4R0NNS1cnOlxuICAgICAgICBjYXNlICdBMTkyR0NNS1cnOlxuICAgICAgICBjYXNlICdBMjU2R0NNS1cnOiB7XG4gICAgICAgICAgICBpZiAoZW5jcnlwdGVkS2V5ID09PSB1bmRlZmluZWQpXG4gICAgICAgICAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpXRUludmFsaWQoJ0pXRSBFbmNyeXB0ZWQgS2V5IG1pc3NpbmcnKTtcbiAgICAgICAgICAgIGlmICh0eXBlb2Ygam9zZUhlYWRlci5pdiAhPT0gJ3N0cmluZycpXG4gICAgICAgICAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpXRUludmFsaWQoYEpPU0UgSGVhZGVyIFwiaXZcIiAoSW5pdGlhbGl6YXRpb24gVmVjdG9yKSBtaXNzaW5nIG9yIGludmFsaWRgKTtcbiAgICAgICAgICAgIGlmICh0eXBlb2Ygam9zZUhlYWRlci50YWcgIT09ICdzdHJpbmcnKVxuICAgICAgICAgICAgICAgIHRocm93IG5ldyBlcnJvcnNfanNfMS5KV0VJbnZhbGlkKGBKT1NFIEhlYWRlciBcInRhZ1wiIChBdXRoZW50aWNhdGlvbiBUYWcpIG1pc3Npbmcgb3IgaW52YWxpZGApO1xuICAgICAgICAgICAgbGV0IGl2O1xuICAgICAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgICAgICBpdiA9ICgwLCBiYXNlNjR1cmxfanNfMS5kZWNvZGUpKGpvc2VIZWFkZXIuaXYpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgY2F0Y2gge1xuICAgICAgICAgICAgICAgIHRocm93IG5ldyBlcnJvcnNfanNfMS5KV0VJbnZhbGlkKCdGYWlsZWQgdG8gYmFzZTY0dXJsIGRlY29kZSB0aGUgaXYnKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGxldCB0YWc7XG4gICAgICAgICAgICB0cnkge1xuICAgICAgICAgICAgICAgIHRhZyA9ICgwLCBiYXNlNjR1cmxfanNfMS5kZWNvZGUpKGpvc2VIZWFkZXIudGFnKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGNhdGNoIHtcbiAgICAgICAgICAgICAgICB0aHJvdyBuZXcgZXJyb3JzX2pzXzEuSldFSW52YWxpZCgnRmFpbGVkIHRvIGJhc2U2NHVybCBkZWNvZGUgdGhlIHRhZycpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuICgwLCBhZXNnY21rd19qc18xLnVud3JhcCkoYWxnLCBrZXksIGVuY3J5cHRlZEtleSwgaXYsIHRhZyk7XG4gICAgICAgIH1cbiAgICAgICAgZGVmYXVsdDoge1xuICAgICAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpPU0VOb3RTdXBwb3J0ZWQoJ0ludmFsaWQgb3IgdW5zdXBwb3J0ZWQgXCJhbGdcIiAoSldFIEFsZ29yaXRobSkgaGVhZGVyIHZhbHVlJyk7XG4gICAgICAgIH1cbiAgICB9XG59XG5leHBvcnRzLmRlZmF1bHQgPSBkZWNyeXB0S2V5TWFuYWdlbWVudDtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/decrypt_key_management.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/encrypt_key_management.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/encrypt_key_management.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst aeskw_js_1 = __webpack_require__(/*! ../runtime/aeskw.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/aeskw.js\");\nconst ECDH = __webpack_require__(/*! ../runtime/ecdhes.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/ecdhes.js\");\nconst pbes2kw_js_1 = __webpack_require__(/*! ../runtime/pbes2kw.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/pbes2kw.js\");\nconst rsaes_js_1 = __webpack_require__(/*! ../runtime/rsaes.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/rsaes.js\");\nconst base64url_js_1 = __webpack_require__(/*! ../runtime/base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nconst cek_js_1 = __webpack_require__(/*! ../lib/cek.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/cek.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst export_js_1 = __webpack_require__(/*! ../key/export.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/key/export.js\");\nconst check_key_type_js_1 = __webpack_require__(/*! ./check_key_type.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_key_type.js\");\nconst aesgcmkw_js_1 = __webpack_require__(/*! ./aesgcmkw.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/aesgcmkw.js\");\nasync function encryptKeyManagement(alg, enc, key, providedCek, providedParameters = {}) {\n    let encryptedKey;\n    let parameters;\n    let cek;\n    (0, check_key_type_js_1.default)(alg, key, 'encrypt');\n    switch (alg) {\n        case 'dir': {\n            cek = key;\n            break;\n        }\n        case 'ECDH-ES':\n        case 'ECDH-ES+A128KW':\n        case 'ECDH-ES+A192KW':\n        case 'ECDH-ES+A256KW': {\n            if (!ECDH.ecdhAllowed(key)) {\n                throw new errors_js_1.JOSENotSupported('ECDH with the provided key is not allowed or not supported by your javascript runtime');\n            }\n            const { apu, apv } = providedParameters;\n            let { epk: ephemeralKey } = providedParameters;\n            ephemeralKey || (ephemeralKey = (await ECDH.generateEpk(key)).privateKey);\n            const { x, y, crv, kty } = await (0, export_js_1.exportJWK)(ephemeralKey);\n            const sharedSecret = await ECDH.deriveKey(key, ephemeralKey, alg === 'ECDH-ES' ? enc : alg, alg === 'ECDH-ES' ? (0, cek_js_1.bitLength)(enc) : parseInt(alg.slice(-5, -2), 10), apu, apv);\n            parameters = { epk: { x, crv, kty } };\n            if (kty === 'EC')\n                parameters.epk.y = y;\n            if (apu)\n                parameters.apu = (0, base64url_js_1.encode)(apu);\n            if (apv)\n                parameters.apv = (0, base64url_js_1.encode)(apv);\n            if (alg === 'ECDH-ES') {\n                cek = sharedSecret;\n                break;\n            }\n            cek = providedCek || (0, cek_js_1.default)(enc);\n            const kwAlg = alg.slice(-6);\n            encryptedKey = await (0, aeskw_js_1.wrap)(kwAlg, sharedSecret, cek);\n            break;\n        }\n        case 'RSA1_5':\n        case 'RSA-OAEP':\n        case 'RSA-OAEP-256':\n        case 'RSA-OAEP-384':\n        case 'RSA-OAEP-512': {\n            cek = providedCek || (0, cek_js_1.default)(enc);\n            encryptedKey = await (0, rsaes_js_1.encrypt)(alg, key, cek);\n            break;\n        }\n        case 'PBES2-HS256+A128KW':\n        case 'PBES2-HS384+A192KW':\n        case 'PBES2-HS512+A256KW': {\n            cek = providedCek || (0, cek_js_1.default)(enc);\n            const { p2c, p2s } = providedParameters;\n            ({ encryptedKey, ...parameters } = await (0, pbes2kw_js_1.encrypt)(alg, key, cek, p2c, p2s));\n            break;\n        }\n        case 'A128KW':\n        case 'A192KW':\n        case 'A256KW': {\n            cek = providedCek || (0, cek_js_1.default)(enc);\n            encryptedKey = await (0, aeskw_js_1.wrap)(alg, key, cek);\n            break;\n        }\n        case 'A128GCMKW':\n        case 'A192GCMKW':\n        case 'A256GCMKW': {\n            cek = providedCek || (0, cek_js_1.default)(enc);\n            const { iv } = providedParameters;\n            ({ encryptedKey, ...parameters } = await (0, aesgcmkw_js_1.wrap)(alg, key, cek, iv));\n            break;\n        }\n        default: {\n            throw new errors_js_1.JOSENotSupported('Invalid or unsupported \"alg\" (JWE Algorithm) header value');\n        }\n    }\n    return { cek, encryptedKey, parameters };\n}\nexports[\"default\"] = encryptKeyManagement;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/encrypt_key_management.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/epoch.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/epoch.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports[\"default\"] = (date) => Math.floor(date.getTime() / 1000);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi9lcG9jaC5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxrQkFBZSIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi9lcG9jaC5qcz85MzVkIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZXhwb3J0cy5kZWZhdWx0ID0gKGRhdGUpID0+IE1hdGguZmxvb3IoZGF0ZS5nZXRUaW1lKCkgLyAxMDAwKTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/epoch.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/invalid_key_input.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/invalid_key_input.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.withAlg = void 0;\nfunction message(msg, actual, ...types) {\n    if (types.length > 2) {\n        const last = types.pop();\n        msg += `one of type ${types.join(', ')}, or ${last}.`;\n    }\n    else if (types.length === 2) {\n        msg += `one of type ${types[0]} or ${types[1]}.`;\n    }\n    else {\n        msg += `of type ${types[0]}.`;\n    }\n    if (actual == null) {\n        msg += ` Received ${actual}`;\n    }\n    else if (typeof actual === 'function' && actual.name) {\n        msg += ` Received function ${actual.name}`;\n    }\n    else if (typeof actual === 'object' && actual != null) {\n        if (actual.constructor && actual.constructor.name) {\n            msg += ` Received an instance of ${actual.constructor.name}`;\n        }\n    }\n    return msg;\n}\nexports[\"default\"] = (actual, ...types) => {\n    return message('Key must be ', actual, ...types);\n};\nfunction withAlg(alg, actual, ...types) {\n    return message(`Key for the ${alg} algorithm must be `, actual, ...types);\n}\nexports.withAlg = withAlg;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/invalid_key_input.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_disjoint.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_disjoint.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst isDisjoint = (...headers) => {\n    const sources = headers.filter(Boolean);\n    if (sources.length === 0 || sources.length === 1) {\n        return true;\n    }\n    let acc;\n    for (const header of sources) {\n        const parameters = Object.keys(header);\n        if (!acc || acc.size === 0) {\n            acc = new Set(parameters);\n            continue;\n        }\n        for (const parameter of parameters) {\n            if (acc.has(parameter)) {\n                return false;\n            }\n            acc.add(parameter);\n        }\n    }\n    return true;\n};\nexports[\"default\"] = isDisjoint;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi9pc19kaXNqb2ludC5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBZSIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi9pc19kaXNqb2ludC5qcz81YmUzIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuY29uc3QgaXNEaXNqb2ludCA9ICguLi5oZWFkZXJzKSA9PiB7XG4gICAgY29uc3Qgc291cmNlcyA9IGhlYWRlcnMuZmlsdGVyKEJvb2xlYW4pO1xuICAgIGlmIChzb3VyY2VzLmxlbmd0aCA9PT0gMCB8fCBzb3VyY2VzLmxlbmd0aCA9PT0gMSkge1xuICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICB9XG4gICAgbGV0IGFjYztcbiAgICBmb3IgKGNvbnN0IGhlYWRlciBvZiBzb3VyY2VzKSB7XG4gICAgICAgIGNvbnN0IHBhcmFtZXRlcnMgPSBPYmplY3Qua2V5cyhoZWFkZXIpO1xuICAgICAgICBpZiAoIWFjYyB8fCBhY2Muc2l6ZSA9PT0gMCkge1xuICAgICAgICAgICAgYWNjID0gbmV3IFNldChwYXJhbWV0ZXJzKTtcbiAgICAgICAgICAgIGNvbnRpbnVlO1xuICAgICAgICB9XG4gICAgICAgIGZvciAoY29uc3QgcGFyYW1ldGVyIG9mIHBhcmFtZXRlcnMpIHtcbiAgICAgICAgICAgIGlmIChhY2MuaGFzKHBhcmFtZXRlcikpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBhY2MuYWRkKHBhcmFtZXRlcik7XG4gICAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIHRydWU7XG59O1xuZXhwb3J0cy5kZWZhdWx0ID0gaXNEaXNqb2ludDtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_disjoint.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nfunction isObjectLike(value) {\n    return typeof value === 'object' && value !== null;\n}\nfunction isObject(input) {\n    if (!isObjectLike(input) || Object.prototype.toString.call(input) !== '[object Object]') {\n        return false;\n    }\n    if (Object.getPrototypeOf(input) === null) {\n        return true;\n    }\n    let proto = input;\n    while (Object.getPrototypeOf(proto) !== null) {\n        proto = Object.getPrototypeOf(proto);\n    }\n    return Object.getPrototypeOf(input) === proto;\n}\nexports[\"default\"] = isObject;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi9pc19vYmplY3QuanMiLCJtYXBwaW5ncyI6IkFBQWE7QUFDYiw4Q0FBNkMsRUFBRSxhQUFhLEVBQUM7QUFDN0Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBZSIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi9pc19vYmplY3QuanM/MWI3MyJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbmZ1bmN0aW9uIGlzT2JqZWN0TGlrZSh2YWx1ZSkge1xuICAgIHJldHVybiB0eXBlb2YgdmFsdWUgPT09ICdvYmplY3QnICYmIHZhbHVlICE9PSBudWxsO1xufVxuZnVuY3Rpb24gaXNPYmplY3QoaW5wdXQpIHtcbiAgICBpZiAoIWlzT2JqZWN0TGlrZShpbnB1dCkgfHwgT2JqZWN0LnByb3RvdHlwZS50b1N0cmluZy5jYWxsKGlucHV0KSAhPT0gJ1tvYmplY3QgT2JqZWN0XScpIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgICBpZiAoT2JqZWN0LmdldFByb3RvdHlwZU9mKGlucHV0KSA9PT0gbnVsbCkge1xuICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICB9XG4gICAgbGV0IHByb3RvID0gaW5wdXQ7XG4gICAgd2hpbGUgKE9iamVjdC5nZXRQcm90b3R5cGVPZihwcm90bykgIT09IG51bGwpIHtcbiAgICAgICAgcHJvdG8gPSBPYmplY3QuZ2V0UHJvdG90eXBlT2YocHJvdG8pO1xuICAgIH1cbiAgICByZXR1cm4gT2JqZWN0LmdldFByb3RvdHlwZU9mKGlucHV0KSA9PT0gcHJvdG87XG59XG5leHBvcnRzLmRlZmF1bHQgPSBpc09iamVjdDtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/iv.js":
/*!******************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/iv.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.bitLength = void 0;\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst random_js_1 = __webpack_require__(/*! ../runtime/random.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/random.js\");\nfunction bitLength(alg) {\n    switch (alg) {\n        case 'A128GCM':\n        case 'A128GCMKW':\n        case 'A192GCM':\n        case 'A192GCMKW':\n        case 'A256GCM':\n        case 'A256GCMKW':\n            return 96;\n        case 'A128CBC-HS256':\n        case 'A192CBC-HS384':\n        case 'A256CBC-HS512':\n            return 128;\n        default:\n            throw new errors_js_1.JOSENotSupported(`Unsupported JWE Algorithm: ${alg}`);\n    }\n}\nexports.bitLength = bitLength;\nexports[\"default\"] = (alg) => (0, random_js_1.default)(new Uint8Array(bitLength(alg) >> 3));\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi9pdi5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxpQkFBaUI7QUFDakIsb0JBQW9CLG1CQUFPLENBQUMsNEdBQW1CO0FBQy9DLG9CQUFvQixtQkFBTyxDQUFDLGtIQUFzQjtBQUNsRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsaUZBQWlGLElBQUk7QUFDckY7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQixrQkFBZSIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi9pdi5qcz8wMDFmIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZXhwb3J0cy5iaXRMZW5ndGggPSB2b2lkIDA7XG5jb25zdCBlcnJvcnNfanNfMSA9IHJlcXVpcmUoXCIuLi91dGlsL2Vycm9ycy5qc1wiKTtcbmNvbnN0IHJhbmRvbV9qc18xID0gcmVxdWlyZShcIi4uL3J1bnRpbWUvcmFuZG9tLmpzXCIpO1xuZnVuY3Rpb24gYml0TGVuZ3RoKGFsZykge1xuICAgIHN3aXRjaCAoYWxnKSB7XG4gICAgICAgIGNhc2UgJ0ExMjhHQ00nOlxuICAgICAgICBjYXNlICdBMTI4R0NNS1cnOlxuICAgICAgICBjYXNlICdBMTkyR0NNJzpcbiAgICAgICAgY2FzZSAnQTE5MkdDTUtXJzpcbiAgICAgICAgY2FzZSAnQTI1NkdDTSc6XG4gICAgICAgIGNhc2UgJ0EyNTZHQ01LVyc6XG4gICAgICAgICAgICByZXR1cm4gOTY7XG4gICAgICAgIGNhc2UgJ0ExMjhDQkMtSFMyNTYnOlxuICAgICAgICBjYXNlICdBMTkyQ0JDLUhTMzg0JzpcbiAgICAgICAgY2FzZSAnQTI1NkNCQy1IUzUxMic6XG4gICAgICAgICAgICByZXR1cm4gMTI4O1xuICAgICAgICBkZWZhdWx0OlxuICAgICAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpPU0VOb3RTdXBwb3J0ZWQoYFVuc3VwcG9ydGVkIEpXRSBBbGdvcml0aG06ICR7YWxnfWApO1xuICAgIH1cbn1cbmV4cG9ydHMuYml0TGVuZ3RoID0gYml0TGVuZ3RoO1xuZXhwb3J0cy5kZWZhdWx0ID0gKGFsZykgPT4gKDAsIHJhbmRvbV9qc18xLmRlZmF1bHQpKG5ldyBVaW50OEFycmF5KGJpdExlbmd0aChhbGcpID4+IDMpKTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/iv.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/jwt_claims_set.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/jwt_claims_set.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ./buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst epoch_js_1 = __webpack_require__(/*! ./epoch.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/epoch.js\");\nconst secs_js_1 = __webpack_require__(/*! ./secs.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/secs.js\");\nconst is_object_js_1 = __webpack_require__(/*! ./is_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js\");\nconst normalizeTyp = (value) => value.toLowerCase().replace(/^application\\//, '');\nconst checkAudiencePresence = (audPayload, audOption) => {\n    if (typeof audPayload === 'string') {\n        return audOption.includes(audPayload);\n    }\n    if (Array.isArray(audPayload)) {\n        return audOption.some(Set.prototype.has.bind(new Set(audPayload)));\n    }\n    return false;\n};\nexports[\"default\"] = (protectedHeader, encodedPayload, options = {}) => {\n    const { typ } = options;\n    if (typ &&\n        (typeof protectedHeader.typ !== 'string' ||\n            normalizeTyp(protectedHeader.typ) !== normalizeTyp(typ))) {\n        throw new errors_js_1.JWTClaimValidationFailed('unexpected \"typ\" JWT header value', 'typ', 'check_failed');\n    }\n    let payload;\n    try {\n        payload = JSON.parse(buffer_utils_js_1.decoder.decode(encodedPayload));\n    }\n    catch {\n    }\n    if (!(0, is_object_js_1.default)(payload)) {\n        throw new errors_js_1.JWTInvalid('JWT Claims Set must be a top-level JSON object');\n    }\n    const { requiredClaims = [], issuer, subject, audience, maxTokenAge } = options;\n    if (maxTokenAge !== undefined)\n        requiredClaims.push('iat');\n    if (audience !== undefined)\n        requiredClaims.push('aud');\n    if (subject !== undefined)\n        requiredClaims.push('sub');\n    if (issuer !== undefined)\n        requiredClaims.push('iss');\n    for (const claim of new Set(requiredClaims.reverse())) {\n        if (!(claim in payload)) {\n            throw new errors_js_1.JWTClaimValidationFailed(`missing required \"${claim}\" claim`, claim, 'missing');\n        }\n    }\n    if (issuer && !(Array.isArray(issuer) ? issuer : [issuer]).includes(payload.iss)) {\n        throw new errors_js_1.JWTClaimValidationFailed('unexpected \"iss\" claim value', 'iss', 'check_failed');\n    }\n    if (subject && payload.sub !== subject) {\n        throw new errors_js_1.JWTClaimValidationFailed('unexpected \"sub\" claim value', 'sub', 'check_failed');\n    }\n    if (audience &&\n        !checkAudiencePresence(payload.aud, typeof audience === 'string' ? [audience] : audience)) {\n        throw new errors_js_1.JWTClaimValidationFailed('unexpected \"aud\" claim value', 'aud', 'check_failed');\n    }\n    let tolerance;\n    switch (typeof options.clockTolerance) {\n        case 'string':\n            tolerance = (0, secs_js_1.default)(options.clockTolerance);\n            break;\n        case 'number':\n            tolerance = options.clockTolerance;\n            break;\n        case 'undefined':\n            tolerance = 0;\n            break;\n        default:\n            throw new TypeError('Invalid clockTolerance option type');\n    }\n    const { currentDate } = options;\n    const now = (0, epoch_js_1.default)(currentDate || new Date());\n    if ((payload.iat !== undefined || maxTokenAge) && typeof payload.iat !== 'number') {\n        throw new errors_js_1.JWTClaimValidationFailed('\"iat\" claim must be a number', 'iat', 'invalid');\n    }\n    if (payload.nbf !== undefined) {\n        if (typeof payload.nbf !== 'number') {\n            throw new errors_js_1.JWTClaimValidationFailed('\"nbf\" claim must be a number', 'nbf', 'invalid');\n        }\n        if (payload.nbf > now + tolerance) {\n            throw new errors_js_1.JWTClaimValidationFailed('\"nbf\" claim timestamp check failed', 'nbf', 'check_failed');\n        }\n    }\n    if (payload.exp !== undefined) {\n        if (typeof payload.exp !== 'number') {\n            throw new errors_js_1.JWTClaimValidationFailed('\"exp\" claim must be a number', 'exp', 'invalid');\n        }\n        if (payload.exp <= now - tolerance) {\n            throw new errors_js_1.JWTExpired('\"exp\" claim timestamp check failed', 'exp', 'check_failed');\n        }\n    }\n    if (maxTokenAge) {\n        const age = now - payload.iat;\n        const max = typeof maxTokenAge === 'number' ? maxTokenAge : (0, secs_js_1.default)(maxTokenAge);\n        if (age - tolerance > max) {\n            throw new errors_js_1.JWTExpired('\"iat\" claim timestamp check failed (too far in the past)', 'iat', 'check_failed');\n        }\n        if (age < 0 - tolerance) {\n            throw new errors_js_1.JWTClaimValidationFailed('\"iat\" claim timestamp check failed (it should be in the past)', 'iat', 'check_failed');\n        }\n    }\n    return payload;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/jwt_claims_set.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/secs.js":
/*!********************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/secs.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst minute = 60;\nconst hour = minute * 60;\nconst day = hour * 24;\nconst week = day * 7;\nconst year = day * 365.25;\nconst REGEX = /^(\\d+|\\d+\\.\\d+) ?(seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)$/i;\nexports[\"default\"] = (str) => {\n    const matched = REGEX.exec(str);\n    if (!matched) {\n        throw new TypeError('Invalid time period format');\n    }\n    const value = parseFloat(matched[1]);\n    const unit = matched[2].toLowerCase();\n    switch (unit) {\n        case 'sec':\n        case 'secs':\n        case 'second':\n        case 'seconds':\n        case 's':\n            return Math.round(value);\n        case 'minute':\n        case 'minutes':\n        case 'min':\n        case 'mins':\n        case 'm':\n            return Math.round(value * minute);\n        case 'hour':\n        case 'hours':\n        case 'hr':\n        case 'hrs':\n        case 'h':\n            return Math.round(value * hour);\n        case 'day':\n        case 'days':\n        case 'd':\n            return Math.round(value * day);\n        case 'week':\n        case 'weeks':\n        case 'w':\n            return Math.round(value * week);\n        default:\n            return Math.round(value * year);\n    }\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/secs.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/validate_algorithms.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/validate_algorithms.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst validateAlgorithms = (option, algorithms) => {\n    if (algorithms !== undefined &&\n        (!Array.isArray(algorithms) || algorithms.some((s) => typeof s !== 'string'))) {\n        throw new TypeError(`\"${option}\" option must be an array of strings`);\n    }\n    if (!algorithms) {\n        return undefined;\n    }\n    return new Set(algorithms);\n};\nexports[\"default\"] = validateAlgorithms;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL2xpYi92YWxpZGF0ZV9hbGdvcml0aG1zLmpzIiwibWFwcGluZ3MiOiJBQUFhO0FBQ2IsOENBQTZDLEVBQUUsYUFBYSxFQUFDO0FBQzdEO0FBQ0E7QUFDQTtBQUNBLGdDQUFnQyxPQUFPO0FBQ3ZDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFlIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L25vZGVfbW9kdWxlcy9qb3NlL2Rpc3Qvbm9kZS9janMvbGliL3ZhbGlkYXRlX2FsZ29yaXRobXMuanM/OGNlZCJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbmNvbnN0IHZhbGlkYXRlQWxnb3JpdGhtcyA9IChvcHRpb24sIGFsZ29yaXRobXMpID0+IHtcbiAgICBpZiAoYWxnb3JpdGhtcyAhPT0gdW5kZWZpbmVkICYmXG4gICAgICAgICghQXJyYXkuaXNBcnJheShhbGdvcml0aG1zKSB8fCBhbGdvcml0aG1zLnNvbWUoKHMpID0+IHR5cGVvZiBzICE9PSAnc3RyaW5nJykpKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoYFwiJHtvcHRpb259XCIgb3B0aW9uIG11c3QgYmUgYW4gYXJyYXkgb2Ygc3RyaW5nc2ApO1xuICAgIH1cbiAgICBpZiAoIWFsZ29yaXRobXMpIHtcbiAgICAgICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICB9XG4gICAgcmV0dXJuIG5ldyBTZXQoYWxnb3JpdGhtcyk7XG59O1xuZXhwb3J0cy5kZWZhdWx0ID0gdmFsaWRhdGVBbGdvcml0aG1zO1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/validate_algorithms.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/validate_crit.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/validate_crit.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nfunction validateCrit(Err, recognizedDefault, recognizedOption, protectedHeader, joseHeader) {\n    if (joseHeader.crit !== undefined && protectedHeader.crit === undefined) {\n        throw new Err('\"crit\" (Critical) Header Parameter MUST be integrity protected');\n    }\n    if (!protectedHeader || protectedHeader.crit === undefined) {\n        return new Set();\n    }\n    if (!Array.isArray(protectedHeader.crit) ||\n        protectedHeader.crit.length === 0 ||\n        protectedHeader.crit.some((input) => typeof input !== 'string' || input.length === 0)) {\n        throw new Err('\"crit\" (Critical) Header Parameter MUST be an array of non-empty strings when present');\n    }\n    let recognized;\n    if (recognizedOption !== undefined) {\n        recognized = new Map([...Object.entries(recognizedOption), ...recognizedDefault.entries()]);\n    }\n    else {\n        recognized = recognizedDefault;\n    }\n    for (const parameter of protectedHeader.crit) {\n        if (!recognized.has(parameter)) {\n            throw new errors_js_1.JOSENotSupported(`Extension Header Parameter \"${parameter}\" is not recognized`);\n        }\n        if (joseHeader[parameter] === undefined) {\n            throw new Err(`Extension Header Parameter \"${parameter}\" is missing`);\n        }\n        else if (recognized.get(parameter) && protectedHeader[parameter] === undefined) {\n            throw new Err(`Extension Header Parameter \"${parameter}\" MUST be integrity protected`);\n        }\n    }\n    return new Set(protectedHeader.crit);\n}\nexports[\"default\"] = validateCrit;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/validate_crit.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/aeskw.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/aeskw.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.unwrap = exports.wrap = void 0;\nconst buffer_1 = __webpack_require__(/*! buffer */ \"buffer\");\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst webcrypto_js_1 = __webpack_require__(/*! ./webcrypto.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/webcrypto.js\");\nconst crypto_key_js_1 = __webpack_require__(/*! ../lib/crypto_key.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/crypto_key.js\");\nconst is_key_object_js_1 = __webpack_require__(/*! ./is_key_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_object.js\");\nconst invalid_key_input_js_1 = __webpack_require__(/*! ../lib/invalid_key_input.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/invalid_key_input.js\");\nconst ciphers_js_1 = __webpack_require__(/*! ./ciphers.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/ciphers.js\");\nconst is_key_like_js_1 = __webpack_require__(/*! ./is_key_like.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_like.js\");\nfunction checkKeySize(key, alg) {\n    if (key.symmetricKeySize << 3 !== parseInt(alg.slice(1, 4), 10)) {\n        throw new TypeError(`Invalid key size for alg: ${alg}`);\n    }\n}\nfunction ensureKeyObject(key, alg, usage) {\n    if ((0, is_key_object_js_1.default)(key)) {\n        return key;\n    }\n    if (key instanceof Uint8Array) {\n        return (0, crypto_1.createSecretKey)(key);\n    }\n    if ((0, webcrypto_js_1.isCryptoKey)(key)) {\n        (0, crypto_key_js_1.checkEncCryptoKey)(key, alg, usage);\n        return crypto_1.KeyObject.from(key);\n    }\n    throw new TypeError((0, invalid_key_input_js_1.default)(key, ...is_key_like_js_1.types, 'Uint8Array'));\n}\nconst wrap = (alg, key, cek) => {\n    const size = parseInt(alg.slice(1, 4), 10);\n    const algorithm = `aes${size}-wrap`;\n    if (!(0, ciphers_js_1.default)(algorithm)) {\n        throw new errors_js_1.JOSENotSupported(`alg ${alg} is not supported either by JOSE or your javascript runtime`);\n    }\n    const keyObject = ensureKeyObject(key, alg, 'wrapKey');\n    checkKeySize(keyObject, alg);\n    const cipher = (0, crypto_1.createCipheriv)(algorithm, keyObject, buffer_1.Buffer.alloc(8, 0xa6));\n    return (0, buffer_utils_js_1.concat)(cipher.update(cek), cipher.final());\n};\nexports.wrap = wrap;\nconst unwrap = (alg, key, encryptedKey) => {\n    const size = parseInt(alg.slice(1, 4), 10);\n    const algorithm = `aes${size}-wrap`;\n    if (!(0, ciphers_js_1.default)(algorithm)) {\n        throw new errors_js_1.JOSENotSupported(`alg ${alg} is not supported either by JOSE or your javascript runtime`);\n    }\n    const keyObject = ensureKeyObject(key, alg, 'unwrapKey');\n    checkKeySize(keyObject, alg);\n    const cipher = (0, crypto_1.createDecipheriv)(algorithm, keyObject, buffer_1.Buffer.alloc(8, 0xa6));\n    return (0, buffer_utils_js_1.concat)(cipher.update(encryptedKey), cipher.final());\n};\nexports.unwrap = unwrap;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/aeskw.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/asn1.js":
/*!************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/asn1.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.fromX509 = exports.fromSPKI = exports.fromPKCS8 = exports.toPKCS8 = exports.toSPKI = void 0;\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst buffer_1 = __webpack_require__(/*! buffer */ \"buffer\");\nconst webcrypto_js_1 = __webpack_require__(/*! ./webcrypto.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/webcrypto.js\");\nconst is_key_object_js_1 = __webpack_require__(/*! ./is_key_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_object.js\");\nconst invalid_key_input_js_1 = __webpack_require__(/*! ../lib/invalid_key_input.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/invalid_key_input.js\");\nconst is_key_like_js_1 = __webpack_require__(/*! ./is_key_like.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_like.js\");\nconst genericExport = (keyType, keyFormat, key) => {\n    let keyObject;\n    if ((0, webcrypto_js_1.isCryptoKey)(key)) {\n        if (!key.extractable) {\n            throw new TypeError('CryptoKey is not extractable');\n        }\n        keyObject = crypto_1.KeyObject.from(key);\n    }\n    else if ((0, is_key_object_js_1.default)(key)) {\n        keyObject = key;\n    }\n    else {\n        throw new TypeError((0, invalid_key_input_js_1.default)(key, ...is_key_like_js_1.types));\n    }\n    if (keyObject.type !== keyType) {\n        throw new TypeError(`key is not a ${keyType} key`);\n    }\n    return keyObject.export({ format: 'pem', type: keyFormat });\n};\nconst toSPKI = (key) => {\n    return genericExport('public', 'spki', key);\n};\nexports.toSPKI = toSPKI;\nconst toPKCS8 = (key) => {\n    return genericExport('private', 'pkcs8', key);\n};\nexports.toPKCS8 = toPKCS8;\nconst fromPKCS8 = (pem) => (0, crypto_1.createPrivateKey)({\n    key: buffer_1.Buffer.from(pem.replace(/(?:-----(?:BEGIN|END) PRIVATE KEY-----|\\s)/g, ''), 'base64'),\n    type: 'pkcs8',\n    format: 'der',\n});\nexports.fromPKCS8 = fromPKCS8;\nconst fromSPKI = (pem) => (0, crypto_1.createPublicKey)({\n    key: buffer_1.Buffer.from(pem.replace(/(?:-----(?:BEGIN|END) PUBLIC KEY-----|\\s)/g, ''), 'base64'),\n    type: 'spki',\n    format: 'der',\n});\nexports.fromSPKI = fromSPKI;\nconst fromX509 = (pem) => (0, crypto_1.createPublicKey)({\n    key: pem,\n    type: 'spki',\n    format: 'pem',\n});\nexports.fromX509 = fromX509;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/asn1.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/asn1_sequence_decoder.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/asn1_sequence_decoder.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst tagInteger = 0x02;\nconst tagSequence = 0x30;\nclass Asn1SequenceDecoder {\n    constructor(buffer) {\n        if (buffer[0] !== tagSequence) {\n            throw new TypeError();\n        }\n        this.buffer = buffer;\n        this.offset = 1;\n        const len = this.decodeLength();\n        if (len !== buffer.length - this.offset) {\n            throw new TypeError();\n        }\n    }\n    decodeLength() {\n        let length = this.buffer[this.offset++];\n        if (length & 0x80) {\n            const nBytes = length & ~0x80;\n            length = 0;\n            for (let i = 0; i < nBytes; i++)\n                length = (length << 8) | this.buffer[this.offset + i];\n            this.offset += nBytes;\n        }\n        return length;\n    }\n    unsignedInteger() {\n        if (this.buffer[this.offset++] !== tagInteger) {\n            throw new TypeError();\n        }\n        let length = this.decodeLength();\n        if (this.buffer[this.offset] === 0) {\n            this.offset++;\n            length--;\n        }\n        const result = this.buffer.slice(this.offset, this.offset + length);\n        this.offset += length;\n        return result;\n    }\n    end() {\n        if (this.offset !== this.buffer.length) {\n            throw new TypeError();\n        }\n    }\n}\nexports[\"default\"] = Asn1SequenceDecoder;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/asn1_sequence_decoder.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/asn1_sequence_encoder.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/asn1_sequence_encoder.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst buffer_1 = __webpack_require__(/*! buffer */ \"buffer\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst tagInteger = 0x02;\nconst tagBitStr = 0x03;\nconst tagOctStr = 0x04;\nconst tagSequence = 0x30;\nconst bZero = buffer_1.Buffer.from([0x00]);\nconst bTagInteger = buffer_1.Buffer.from([tagInteger]);\nconst bTagBitStr = buffer_1.Buffer.from([tagBitStr]);\nconst bTagSequence = buffer_1.Buffer.from([tagSequence]);\nconst bTagOctStr = buffer_1.Buffer.from([tagOctStr]);\nconst encodeLength = (len) => {\n    if (len < 128)\n        return buffer_1.Buffer.from([len]);\n    const buffer = buffer_1.Buffer.alloc(5);\n    buffer.writeUInt32BE(len, 1);\n    let offset = 1;\n    while (buffer[offset] === 0)\n        offset++;\n    buffer[offset - 1] = 0x80 | (5 - offset);\n    return buffer.slice(offset - 1);\n};\nconst oids = new Map([\n    ['P-256', buffer_1.Buffer.from('06 08 2A 86 48 CE 3D 03 01 07'.replace(/ /g, ''), 'hex')],\n    ['secp256k1', buffer_1.Buffer.from('06 05 2B 81 04 00 0A'.replace(/ /g, ''), 'hex')],\n    ['P-384', buffer_1.Buffer.from('06 05 2B 81 04 00 22'.replace(/ /g, ''), 'hex')],\n    ['P-521', buffer_1.Buffer.from('06 05 2B 81 04 00 23'.replace(/ /g, ''), 'hex')],\n    ['ecPublicKey', buffer_1.Buffer.from('06 07 2A 86 48 CE 3D 02 01'.replace(/ /g, ''), 'hex')],\n    ['X25519', buffer_1.Buffer.from('06 03 2B 65 6E'.replace(/ /g, ''), 'hex')],\n    ['X448', buffer_1.Buffer.from('06 03 2B 65 6F'.replace(/ /g, ''), 'hex')],\n    ['Ed25519', buffer_1.Buffer.from('06 03 2B 65 70'.replace(/ /g, ''), 'hex')],\n    ['Ed448', buffer_1.Buffer.from('06 03 2B 65 71'.replace(/ /g, ''), 'hex')],\n]);\nclass DumbAsn1Encoder {\n    constructor() {\n        this.length = 0;\n        this.elements = [];\n    }\n    oidFor(oid) {\n        const bOid = oids.get(oid);\n        if (!bOid) {\n            throw new errors_js_1.JOSENotSupported('Invalid or unsupported OID');\n        }\n        this.elements.push(bOid);\n        this.length += bOid.length;\n    }\n    zero() {\n        this.elements.push(bTagInteger, buffer_1.Buffer.from([0x01]), bZero);\n        this.length += 3;\n    }\n    one() {\n        this.elements.push(bTagInteger, buffer_1.Buffer.from([0x01]), buffer_1.Buffer.from([0x01]));\n        this.length += 3;\n    }\n    unsignedInteger(integer) {\n        if (integer[0] & 0x80) {\n            const len = encodeLength(integer.length + 1);\n            this.elements.push(bTagInteger, len, bZero, integer);\n            this.length += 2 + len.length + integer.length;\n        }\n        else {\n            let i = 0;\n            while (integer[i] === 0 && (integer[i + 1] & 0x80) === 0)\n                i++;\n            const len = encodeLength(integer.length - i);\n            this.elements.push(bTagInteger, encodeLength(integer.length - i), integer.slice(i));\n            this.length += 1 + len.length + integer.length - i;\n        }\n    }\n    octStr(octStr) {\n        const len = encodeLength(octStr.length);\n        this.elements.push(bTagOctStr, encodeLength(octStr.length), octStr);\n        this.length += 1 + len.length + octStr.length;\n    }\n    bitStr(bitS) {\n        const len = encodeLength(bitS.length + 1);\n        this.elements.push(bTagBitStr, encodeLength(bitS.length + 1), bZero, bitS);\n        this.length += 1 + len.length + bitS.length + 1;\n    }\n    add(seq) {\n        this.elements.push(seq);\n        this.length += seq.length;\n    }\n    end(tag = bTagSequence) {\n        const len = encodeLength(this.length);\n        return buffer_1.Buffer.concat([tag, len, ...this.elements], 1 + len.length + this.length);\n    }\n}\nexports[\"default\"] = DumbAsn1Encoder;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvYXNuMV9zZXF1ZW5jZV9lbmNvZGVyLmpzIiwibWFwcGluZ3MiOiJBQUFhO0FBQ2IsOENBQTZDLEVBQUUsYUFBYSxFQUFDO0FBQzdELGlCQUFpQixtQkFBTyxDQUFDLHNCQUFRO0FBQ2pDLG9CQUFvQixtQkFBTyxDQUFDLDRHQUFtQjtBQUMvQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esa0JBQWUiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbm9kZV9tb2R1bGVzL2pvc2UvZGlzdC9ub2RlL2Nqcy9ydW50aW1lL2FzbjFfc2VxdWVuY2VfZW5jb2Rlci5qcz83OThkIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuY29uc3QgYnVmZmVyXzEgPSByZXF1aXJlKFwiYnVmZmVyXCIpO1xuY29uc3QgZXJyb3JzX2pzXzEgPSByZXF1aXJlKFwiLi4vdXRpbC9lcnJvcnMuanNcIik7XG5jb25zdCB0YWdJbnRlZ2VyID0gMHgwMjtcbmNvbnN0IHRhZ0JpdFN0ciA9IDB4MDM7XG5jb25zdCB0YWdPY3RTdHIgPSAweDA0O1xuY29uc3QgdGFnU2VxdWVuY2UgPSAweDMwO1xuY29uc3QgYlplcm8gPSBidWZmZXJfMS5CdWZmZXIuZnJvbShbMHgwMF0pO1xuY29uc3QgYlRhZ0ludGVnZXIgPSBidWZmZXJfMS5CdWZmZXIuZnJvbShbdGFnSW50ZWdlcl0pO1xuY29uc3QgYlRhZ0JpdFN0ciA9IGJ1ZmZlcl8xLkJ1ZmZlci5mcm9tKFt0YWdCaXRTdHJdKTtcbmNvbnN0IGJUYWdTZXF1ZW5jZSA9IGJ1ZmZlcl8xLkJ1ZmZlci5mcm9tKFt0YWdTZXF1ZW5jZV0pO1xuY29uc3QgYlRhZ09jdFN0ciA9IGJ1ZmZlcl8xLkJ1ZmZlci5mcm9tKFt0YWdPY3RTdHJdKTtcbmNvbnN0IGVuY29kZUxlbmd0aCA9IChsZW4pID0+IHtcbiAgICBpZiAobGVuIDwgMTI4KVxuICAgICAgICByZXR1cm4gYnVmZmVyXzEuQnVmZmVyLmZyb20oW2xlbl0pO1xuICAgIGNvbnN0IGJ1ZmZlciA9IGJ1ZmZlcl8xLkJ1ZmZlci5hbGxvYyg1KTtcbiAgICBidWZmZXIud3JpdGVVSW50MzJCRShsZW4sIDEpO1xuICAgIGxldCBvZmZzZXQgPSAxO1xuICAgIHdoaWxlIChidWZmZXJbb2Zmc2V0XSA9PT0gMClcbiAgICAgICAgb2Zmc2V0Kys7XG4gICAgYnVmZmVyW29mZnNldCAtIDFdID0gMHg4MCB8ICg1IC0gb2Zmc2V0KTtcbiAgICByZXR1cm4gYnVmZmVyLnNsaWNlKG9mZnNldCAtIDEpO1xufTtcbmNvbnN0IG9pZHMgPSBuZXcgTWFwKFtcbiAgICBbJ1AtMjU2JywgYnVmZmVyXzEuQnVmZmVyLmZyb20oJzA2IDA4IDJBIDg2IDQ4IENFIDNEIDAzIDAxIDA3Jy5yZXBsYWNlKC8gL2csICcnKSwgJ2hleCcpXSxcbiAgICBbJ3NlY3AyNTZrMScsIGJ1ZmZlcl8xLkJ1ZmZlci5mcm9tKCcwNiAwNSAyQiA4MSAwNCAwMCAwQScucmVwbGFjZSgvIC9nLCAnJyksICdoZXgnKV0sXG4gICAgWydQLTM4NCcsIGJ1ZmZlcl8xLkJ1ZmZlci5mcm9tKCcwNiAwNSAyQiA4MSAwNCAwMCAyMicucmVwbGFjZSgvIC9nLCAnJyksICdoZXgnKV0sXG4gICAgWydQLTUyMScsIGJ1ZmZlcl8xLkJ1ZmZlci5mcm9tKCcwNiAwNSAyQiA4MSAwNCAwMCAyMycucmVwbGFjZSgvIC9nLCAnJyksICdoZXgnKV0sXG4gICAgWydlY1B1YmxpY0tleScsIGJ1ZmZlcl8xLkJ1ZmZlci5mcm9tKCcwNiAwNyAyQSA4NiA0OCBDRSAzRCAwMiAwMScucmVwbGFjZSgvIC9nLCAnJyksICdoZXgnKV0sXG4gICAgWydYMjU1MTknLCBidWZmZXJfMS5CdWZmZXIuZnJvbSgnMDYgMDMgMkIgNjUgNkUnLnJlcGxhY2UoLyAvZywgJycpLCAnaGV4JyldLFxuICAgIFsnWDQ0OCcsIGJ1ZmZlcl8xLkJ1ZmZlci5mcm9tKCcwNiAwMyAyQiA2NSA2RicucmVwbGFjZSgvIC9nLCAnJyksICdoZXgnKV0sXG4gICAgWydFZDI1NTE5JywgYnVmZmVyXzEuQnVmZmVyLmZyb20oJzA2IDAzIDJCIDY1IDcwJy5yZXBsYWNlKC8gL2csICcnKSwgJ2hleCcpXSxcbiAgICBbJ0VkNDQ4JywgYnVmZmVyXzEuQnVmZmVyLmZyb20oJzA2IDAzIDJCIDY1IDcxJy5yZXBsYWNlKC8gL2csICcnKSwgJ2hleCcpXSxcbl0pO1xuY2xhc3MgRHVtYkFzbjFFbmNvZGVyIHtcbiAgICBjb25zdHJ1Y3RvcigpIHtcbiAgICAgICAgdGhpcy5sZW5ndGggPSAwO1xuICAgICAgICB0aGlzLmVsZW1lbnRzID0gW107XG4gICAgfVxuICAgIG9pZEZvcihvaWQpIHtcbiAgICAgICAgY29uc3QgYk9pZCA9IG9pZHMuZ2V0KG9pZCk7XG4gICAgICAgIGlmICghYk9pZCkge1xuICAgICAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpPU0VOb3RTdXBwb3J0ZWQoJ0ludmFsaWQgb3IgdW5zdXBwb3J0ZWQgT0lEJyk7XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5lbGVtZW50cy5wdXNoKGJPaWQpO1xuICAgICAgICB0aGlzLmxlbmd0aCArPSBiT2lkLmxlbmd0aDtcbiAgICB9XG4gICAgemVybygpIHtcbiAgICAgICAgdGhpcy5lbGVtZW50cy5wdXNoKGJUYWdJbnRlZ2VyLCBidWZmZXJfMS5CdWZmZXIuZnJvbShbMHgwMV0pLCBiWmVybyk7XG4gICAgICAgIHRoaXMubGVuZ3RoICs9IDM7XG4gICAgfVxuICAgIG9uZSgpIHtcbiAgICAgICAgdGhpcy5lbGVtZW50cy5wdXNoKGJUYWdJbnRlZ2VyLCBidWZmZXJfMS5CdWZmZXIuZnJvbShbMHgwMV0pLCBidWZmZXJfMS5CdWZmZXIuZnJvbShbMHgwMV0pKTtcbiAgICAgICAgdGhpcy5sZW5ndGggKz0gMztcbiAgICB9XG4gICAgdW5zaWduZWRJbnRlZ2VyKGludGVnZXIpIHtcbiAgICAgICAgaWYgKGludGVnZXJbMF0gJiAweDgwKSB7XG4gICAgICAgICAgICBjb25zdCBsZW4gPSBlbmNvZGVMZW5ndGgoaW50ZWdlci5sZW5ndGggKyAxKTtcbiAgICAgICAgICAgIHRoaXMuZWxlbWVudHMucHVzaChiVGFnSW50ZWdlciwgbGVuLCBiWmVybywgaW50ZWdlcik7XG4gICAgICAgICAgICB0aGlzLmxlbmd0aCArPSAyICsgbGVuLmxlbmd0aCArIGludGVnZXIubGVuZ3RoO1xuICAgICAgICB9XG4gICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgbGV0IGkgPSAwO1xuICAgICAgICAgICAgd2hpbGUgKGludGVnZXJbaV0gPT09IDAgJiYgKGludGVnZXJbaSArIDFdICYgMHg4MCkgPT09IDApXG4gICAgICAgICAgICAgICAgaSsrO1xuICAgICAgICAgICAgY29uc3QgbGVuID0gZW5jb2RlTGVuZ3RoKGludGVnZXIubGVuZ3RoIC0gaSk7XG4gICAgICAgICAgICB0aGlzLmVsZW1lbnRzLnB1c2goYlRhZ0ludGVnZXIsIGVuY29kZUxlbmd0aChpbnRlZ2VyLmxlbmd0aCAtIGkpLCBpbnRlZ2VyLnNsaWNlKGkpKTtcbiAgICAgICAgICAgIHRoaXMubGVuZ3RoICs9IDEgKyBsZW4ubGVuZ3RoICsgaW50ZWdlci5sZW5ndGggLSBpO1xuICAgICAgICB9XG4gICAgfVxuICAgIG9jdFN0cihvY3RTdHIpIHtcbiAgICAgICAgY29uc3QgbGVuID0gZW5jb2RlTGVuZ3RoKG9jdFN0ci5sZW5ndGgpO1xuICAgICAgICB0aGlzLmVsZW1lbnRzLnB1c2goYlRhZ09jdFN0ciwgZW5jb2RlTGVuZ3RoKG9jdFN0ci5sZW5ndGgpLCBvY3RTdHIpO1xuICAgICAgICB0aGlzLmxlbmd0aCArPSAxICsgbGVuLmxlbmd0aCArIG9jdFN0ci5sZW5ndGg7XG4gICAgfVxuICAgIGJpdFN0cihiaXRTKSB7XG4gICAgICAgIGNvbnN0IGxlbiA9IGVuY29kZUxlbmd0aChiaXRTLmxlbmd0aCArIDEpO1xuICAgICAgICB0aGlzLmVsZW1lbnRzLnB1c2goYlRhZ0JpdFN0ciwgZW5jb2RlTGVuZ3RoKGJpdFMubGVuZ3RoICsgMSksIGJaZXJvLCBiaXRTKTtcbiAgICAgICAgdGhpcy5sZW5ndGggKz0gMSArIGxlbi5sZW5ndGggKyBiaXRTLmxlbmd0aCArIDE7XG4gICAgfVxuICAgIGFkZChzZXEpIHtcbiAgICAgICAgdGhpcy5lbGVtZW50cy5wdXNoKHNlcSk7XG4gICAgICAgIHRoaXMubGVuZ3RoICs9IHNlcS5sZW5ndGg7XG4gICAgfVxuICAgIGVuZCh0YWcgPSBiVGFnU2VxdWVuY2UpIHtcbiAgICAgICAgY29uc3QgbGVuID0gZW5jb2RlTGVuZ3RoKHRoaXMubGVuZ3RoKTtcbiAgICAgICAgcmV0dXJuIGJ1ZmZlcl8xLkJ1ZmZlci5jb25jYXQoW3RhZywgbGVuLCAuLi50aGlzLmVsZW1lbnRzXSwgMSArIGxlbi5sZW5ndGggKyB0aGlzLmxlbmd0aCk7XG4gICAgfVxufVxuZXhwb3J0cy5kZWZhdWx0ID0gRHVtYkFzbjFFbmNvZGVyO1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/asn1_sequence_encoder.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.decode = exports.encode = exports.encodeBase64 = exports.decodeBase64 = void 0;\nconst buffer_1 = __webpack_require__(/*! buffer */ \"buffer\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nlet encode;\nfunction normalize(input) {\n    let encoded = input;\n    if (encoded instanceof Uint8Array) {\n        encoded = buffer_utils_js_1.decoder.decode(encoded);\n    }\n    return encoded;\n}\nif (buffer_1.Buffer.isEncoding('base64url')) {\n    exports.encode = encode = (input) => buffer_1.Buffer.from(input).toString('base64url');\n}\nelse {\n    exports.encode = encode = (input) => buffer_1.Buffer.from(input).toString('base64').replace(/=/g, '').replace(/\\+/g, '-').replace(/\\//g, '_');\n}\nconst decodeBase64 = (input) => buffer_1.Buffer.from(input, 'base64');\nexports.decodeBase64 = decodeBase64;\nconst encodeBase64 = (input) => buffer_1.Buffer.from(input).toString('base64');\nexports.encodeBase64 = encodeBase64;\nconst decode = (input) => buffer_1.Buffer.from(normalize(input), 'base64');\nexports.decode = decode;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/cbc_tag.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/cbc_tag.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nfunction cbcTag(aad, iv, ciphertext, macSize, macKey, keySize) {\n    const macData = (0, buffer_utils_js_1.concat)(aad, iv, ciphertext, (0, buffer_utils_js_1.uint64be)(aad.length << 3));\n    const hmac = (0, crypto_1.createHmac)(`sha${macSize}`, macKey);\n    hmac.update(macData);\n    return hmac.digest().slice(0, keySize >> 3);\n}\nexports[\"default\"] = cbcTag;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvY2JjX3RhZy5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxpQkFBaUIsbUJBQU8sQ0FBQyxzQkFBUTtBQUNqQywwQkFBMEIsbUJBQU8sQ0FBQyxzSEFBd0I7QUFDMUQ7QUFDQTtBQUNBLGdEQUFnRCxRQUFRO0FBQ3hEO0FBQ0E7QUFDQTtBQUNBLGtCQUFlIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L25vZGVfbW9kdWxlcy9qb3NlL2Rpc3Qvbm9kZS9janMvcnVudGltZS9jYmNfdGFnLmpzPzkxNzEiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG5jb25zdCBjcnlwdG9fMSA9IHJlcXVpcmUoXCJjcnlwdG9cIik7XG5jb25zdCBidWZmZXJfdXRpbHNfanNfMSA9IHJlcXVpcmUoXCIuLi9saWIvYnVmZmVyX3V0aWxzLmpzXCIpO1xuZnVuY3Rpb24gY2JjVGFnKGFhZCwgaXYsIGNpcGhlcnRleHQsIG1hY1NpemUsIG1hY0tleSwga2V5U2l6ZSkge1xuICAgIGNvbnN0IG1hY0RhdGEgPSAoMCwgYnVmZmVyX3V0aWxzX2pzXzEuY29uY2F0KShhYWQsIGl2LCBjaXBoZXJ0ZXh0LCAoMCwgYnVmZmVyX3V0aWxzX2pzXzEudWludDY0YmUpKGFhZC5sZW5ndGggPDwgMykpO1xuICAgIGNvbnN0IGhtYWMgPSAoMCwgY3J5cHRvXzEuY3JlYXRlSG1hYykoYHNoYSR7bWFjU2l6ZX1gLCBtYWNLZXkpO1xuICAgIGhtYWMudXBkYXRlKG1hY0RhdGEpO1xuICAgIHJldHVybiBobWFjLmRpZ2VzdCgpLnNsaWNlKDAsIGtleVNpemUgPj4gMyk7XG59XG5leHBvcnRzLmRlZmF1bHQgPSBjYmNUYWc7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/cbc_tag.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/check_cek_length.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/check_cek_length.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst is_key_object_js_1 = __webpack_require__(/*! ./is_key_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_object.js\");\nconst checkCekLength = (enc, cek) => {\n    let expected;\n    switch (enc) {\n        case 'A128CBC-HS256':\n        case 'A192CBC-HS384':\n        case 'A256CBC-HS512':\n            expected = parseInt(enc.slice(-3), 10);\n            break;\n        case 'A128GCM':\n        case 'A192GCM':\n        case 'A256GCM':\n            expected = parseInt(enc.slice(1, 4), 10);\n            break;\n        default:\n            throw new errors_js_1.JOSENotSupported(`Content Encryption Algorithm ${enc} is not supported either by JOSE or your javascript runtime`);\n    }\n    if (cek instanceof Uint8Array) {\n        const actual = cek.byteLength << 3;\n        if (actual !== expected) {\n            throw new errors_js_1.JWEInvalid(`Invalid Content Encryption Key length. Expected ${expected} bits, got ${actual} bits`);\n        }\n        return;\n    }\n    if ((0, is_key_object_js_1.default)(cek) && cek.type === 'secret') {\n        const actual = cek.symmetricKeySize << 3;\n        if (actual !== expected) {\n            throw new errors_js_1.JWEInvalid(`Invalid Content Encryption Key length. Expected ${expected} bits, got ${actual} bits`);\n        }\n        return;\n    }\n    throw new TypeError('Invalid Content Encryption Key type');\n};\nexports[\"default\"] = checkCekLength;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/check_cek_length.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/check_modulus_length.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/check_modulus_length.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.setModulusLength = exports.weakMap = void 0;\nexports.weakMap = new WeakMap();\nconst getLength = (buf, index) => {\n    let len = buf.readUInt8(1);\n    if ((len & 0x80) === 0) {\n        if (index === 0) {\n            return len;\n        }\n        return getLength(buf.subarray(2 + len), index - 1);\n    }\n    const num = len & 0x7f;\n    len = 0;\n    for (let i = 0; i < num; i++) {\n        len <<= 8;\n        const j = buf.readUInt8(2 + i);\n        len |= j;\n    }\n    if (index === 0) {\n        return len;\n    }\n    return getLength(buf.subarray(2 + len), index - 1);\n};\nconst getLengthOfSeqIndex = (sequence, index) => {\n    const len = sequence.readUInt8(1);\n    if ((len & 0x80) === 0) {\n        return getLength(sequence.subarray(2), index);\n    }\n    const num = len & 0x7f;\n    return getLength(sequence.subarray(2 + num), index);\n};\nconst getModulusLength = (key) => {\n    var _a, _b;\n    if (exports.weakMap.has(key)) {\n        return exports.weakMap.get(key);\n    }\n    const modulusLength = (_b = (_a = key.asymmetricKeyDetails) === null || _a === void 0 ? void 0 : _a.modulusLength) !== null && _b !== void 0 ? _b : (getLengthOfSeqIndex(key.export({ format: 'der', type: 'pkcs1' }), key.type === 'private' ? 1 : 0) -\n        1) <<\n        3;\n    exports.weakMap.set(key, modulusLength);\n    return modulusLength;\n};\nconst setModulusLength = (keyObject, modulusLength) => {\n    exports.weakMap.set(keyObject, modulusLength);\n};\nexports.setModulusLength = setModulusLength;\nexports[\"default\"] = (key, alg) => {\n    if (getModulusLength(key) < 2048) {\n        throw new TypeError(`${alg} requires key modulusLength to be 2048 bits or larger`);\n    }\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/check_modulus_length.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/ciphers.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/ciphers.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nlet ciphers;\nexports[\"default\"] = (algorithm) => {\n    ciphers || (ciphers = new Set((0, crypto_1.getCiphers)()));\n    return ciphers.has(algorithm);\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvY2lwaGVycy5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxpQkFBaUIsbUJBQU8sQ0FBQyxzQkFBUTtBQUNqQztBQUNBLGtCQUFlO0FBQ2Y7QUFDQTtBQUNBIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L25vZGVfbW9kdWxlcy9qb3NlL2Rpc3Qvbm9kZS9janMvcnVudGltZS9jaXBoZXJzLmpzP2YxYmQiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG5jb25zdCBjcnlwdG9fMSA9IHJlcXVpcmUoXCJjcnlwdG9cIik7XG5sZXQgY2lwaGVycztcbmV4cG9ydHMuZGVmYXVsdCA9IChhbGdvcml0aG0pID0+IHtcbiAgICBjaXBoZXJzIHx8IChjaXBoZXJzID0gbmV3IFNldCgoMCwgY3J5cHRvXzEuZ2V0Q2lwaGVycykoKSkpO1xuICAgIHJldHVybiBjaXBoZXJzLmhhcyhhbGdvcml0aG0pO1xufTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/ciphers.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/decrypt.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/decrypt.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst check_iv_length_js_1 = __webpack_require__(/*! ../lib/check_iv_length.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_iv_length.js\");\nconst check_cek_length_js_1 = __webpack_require__(/*! ./check_cek_length.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/check_cek_length.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst timing_safe_equal_js_1 = __webpack_require__(/*! ./timing_safe_equal.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/timing_safe_equal.js\");\nconst cbc_tag_js_1 = __webpack_require__(/*! ./cbc_tag.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/cbc_tag.js\");\nconst webcrypto_js_1 = __webpack_require__(/*! ./webcrypto.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/webcrypto.js\");\nconst crypto_key_js_1 = __webpack_require__(/*! ../lib/crypto_key.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/crypto_key.js\");\nconst is_key_object_js_1 = __webpack_require__(/*! ./is_key_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_object.js\");\nconst invalid_key_input_js_1 = __webpack_require__(/*! ../lib/invalid_key_input.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/invalid_key_input.js\");\nconst ciphers_js_1 = __webpack_require__(/*! ./ciphers.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/ciphers.js\");\nconst is_key_like_js_1 = __webpack_require__(/*! ./is_key_like.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_like.js\");\nfunction cbcDecrypt(enc, cek, ciphertext, iv, tag, aad) {\n    const keySize = parseInt(enc.slice(1, 4), 10);\n    if ((0, is_key_object_js_1.default)(cek)) {\n        cek = cek.export();\n    }\n    const encKey = cek.subarray(keySize >> 3);\n    const macKey = cek.subarray(0, keySize >> 3);\n    const macSize = parseInt(enc.slice(-3), 10);\n    const algorithm = `aes-${keySize}-cbc`;\n    if (!(0, ciphers_js_1.default)(algorithm)) {\n        throw new errors_js_1.JOSENotSupported(`alg ${enc} is not supported by your javascript runtime`);\n    }\n    const expectedTag = (0, cbc_tag_js_1.default)(aad, iv, ciphertext, macSize, macKey, keySize);\n    let macCheckPassed;\n    try {\n        macCheckPassed = (0, timing_safe_equal_js_1.default)(tag, expectedTag);\n    }\n    catch {\n    }\n    if (!macCheckPassed) {\n        throw new errors_js_1.JWEDecryptionFailed();\n    }\n    let plaintext;\n    try {\n        const decipher = (0, crypto_1.createDecipheriv)(algorithm, encKey, iv);\n        plaintext = (0, buffer_utils_js_1.concat)(decipher.update(ciphertext), decipher.final());\n    }\n    catch {\n    }\n    if (!plaintext) {\n        throw new errors_js_1.JWEDecryptionFailed();\n    }\n    return plaintext;\n}\nfunction gcmDecrypt(enc, cek, ciphertext, iv, tag, aad) {\n    const keySize = parseInt(enc.slice(1, 4), 10);\n    const algorithm = `aes-${keySize}-gcm`;\n    if (!(0, ciphers_js_1.default)(algorithm)) {\n        throw new errors_js_1.JOSENotSupported(`alg ${enc} is not supported by your javascript runtime`);\n    }\n    try {\n        const decipher = (0, crypto_1.createDecipheriv)(algorithm, cek, iv, { authTagLength: 16 });\n        decipher.setAuthTag(tag);\n        if (aad.byteLength) {\n            decipher.setAAD(aad, { plaintextLength: ciphertext.length });\n        }\n        const plaintext = decipher.update(ciphertext);\n        decipher.final();\n        return plaintext;\n    }\n    catch {\n        throw new errors_js_1.JWEDecryptionFailed();\n    }\n}\nconst decrypt = (enc, cek, ciphertext, iv, tag, aad) => {\n    let key;\n    if ((0, webcrypto_js_1.isCryptoKey)(cek)) {\n        (0, crypto_key_js_1.checkEncCryptoKey)(cek, enc, 'decrypt');\n        key = crypto_1.KeyObject.from(cek);\n    }\n    else if (cek instanceof Uint8Array || (0, is_key_object_js_1.default)(cek)) {\n        key = cek;\n    }\n    else {\n        throw new TypeError((0, invalid_key_input_js_1.default)(cek, ...is_key_like_js_1.types, 'Uint8Array'));\n    }\n    (0, check_cek_length_js_1.default)(enc, key);\n    (0, check_iv_length_js_1.default)(enc, iv);\n    switch (enc) {\n        case 'A128CBC-HS256':\n        case 'A192CBC-HS384':\n        case 'A256CBC-HS512':\n            return cbcDecrypt(enc, key, ciphertext, iv, tag, aad);\n        case 'A128GCM':\n        case 'A192GCM':\n        case 'A256GCM':\n            return gcmDecrypt(enc, key, ciphertext, iv, tag, aad);\n        default:\n            throw new errors_js_1.JOSENotSupported('Unsupported JWE Content Encryption Algorithm');\n    }\n};\nexports[\"default\"] = decrypt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/decrypt.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/digest.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/digest.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst digest = (algorithm, data) => (0, crypto_1.createHash)(algorithm).update(data).digest();\nexports[\"default\"] = digest;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvZGlnZXN0LmpzIiwibWFwcGluZ3MiOiJBQUFhO0FBQ2IsOENBQTZDLEVBQUUsYUFBYSxFQUFDO0FBQzdELGlCQUFpQixtQkFBTyxDQUFDLHNCQUFRO0FBQ2pDO0FBQ0Esa0JBQWUiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbm9kZV9tb2R1bGVzL2pvc2UvZGlzdC9ub2RlL2Nqcy9ydW50aW1lL2RpZ2VzdC5qcz85MDVhIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuY29uc3QgY3J5cHRvXzEgPSByZXF1aXJlKFwiY3J5cHRvXCIpO1xuY29uc3QgZGlnZXN0ID0gKGFsZ29yaXRobSwgZGF0YSkgPT4gKDAsIGNyeXB0b18xLmNyZWF0ZUhhc2gpKGFsZ29yaXRobSkudXBkYXRlKGRhdGEpLmRpZ2VzdCgpO1xuZXhwb3J0cy5kZWZhdWx0ID0gZGlnZXN0O1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/digest.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/dsa_digest.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/dsa_digest.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nfunction dsaDigest(alg) {\n    switch (alg) {\n        case 'PS256':\n        case 'RS256':\n        case 'ES256':\n        case 'ES256K':\n            return 'sha256';\n        case 'PS384':\n        case 'RS384':\n        case 'ES384':\n            return 'sha384';\n        case 'PS512':\n        case 'RS512':\n        case 'ES512':\n            return 'sha512';\n        case 'EdDSA':\n            return undefined;\n        default:\n            throw new errors_js_1.JOSENotSupported(`alg ${alg} is not supported either by JOSE or your javascript runtime`);\n    }\n}\nexports[\"default\"] = dsaDigest;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvZHNhX2RpZ2VzdC5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxvQkFBb0IsbUJBQU8sQ0FBQyw0R0FBbUI7QUFDL0M7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsMERBQTBELEtBQUs7QUFDL0Q7QUFDQTtBQUNBLGtCQUFlIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L25vZGVfbW9kdWxlcy9qb3NlL2Rpc3Qvbm9kZS9janMvcnVudGltZS9kc2FfZGlnZXN0LmpzPzIzOGQiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG5jb25zdCBlcnJvcnNfanNfMSA9IHJlcXVpcmUoXCIuLi91dGlsL2Vycm9ycy5qc1wiKTtcbmZ1bmN0aW9uIGRzYURpZ2VzdChhbGcpIHtcbiAgICBzd2l0Y2ggKGFsZykge1xuICAgICAgICBjYXNlICdQUzI1Nic6XG4gICAgICAgIGNhc2UgJ1JTMjU2JzpcbiAgICAgICAgY2FzZSAnRVMyNTYnOlxuICAgICAgICBjYXNlICdFUzI1NksnOlxuICAgICAgICAgICAgcmV0dXJuICdzaGEyNTYnO1xuICAgICAgICBjYXNlICdQUzM4NCc6XG4gICAgICAgIGNhc2UgJ1JTMzg0JzpcbiAgICAgICAgY2FzZSAnRVMzODQnOlxuICAgICAgICAgICAgcmV0dXJuICdzaGEzODQnO1xuICAgICAgICBjYXNlICdQUzUxMic6XG4gICAgICAgIGNhc2UgJ1JTNTEyJzpcbiAgICAgICAgY2FzZSAnRVM1MTInOlxuICAgICAgICAgICAgcmV0dXJuICdzaGE1MTInO1xuICAgICAgICBjYXNlICdFZERTQSc6XG4gICAgICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgICBkZWZhdWx0OlxuICAgICAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpPU0VOb3RTdXBwb3J0ZWQoYGFsZyAke2FsZ30gaXMgbm90IHN1cHBvcnRlZCBlaXRoZXIgYnkgSk9TRSBvciB5b3VyIGphdmFzY3JpcHQgcnVudGltZWApO1xuICAgIH1cbn1cbmV4cG9ydHMuZGVmYXVsdCA9IGRzYURpZ2VzdDtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/dsa_digest.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/ecdhes.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/ecdhes.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.ecdhAllowed = exports.generateEpk = exports.deriveKey = void 0;\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst util_1 = __webpack_require__(/*! util */ \"util\");\nconst get_named_curve_js_1 = __webpack_require__(/*! ./get_named_curve.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/get_named_curve.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst webcrypto_js_1 = __webpack_require__(/*! ./webcrypto.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/webcrypto.js\");\nconst crypto_key_js_1 = __webpack_require__(/*! ../lib/crypto_key.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/crypto_key.js\");\nconst is_key_object_js_1 = __webpack_require__(/*! ./is_key_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_object.js\");\nconst invalid_key_input_js_1 = __webpack_require__(/*! ../lib/invalid_key_input.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/invalid_key_input.js\");\nconst is_key_like_js_1 = __webpack_require__(/*! ./is_key_like.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_like.js\");\nconst generateKeyPair = (0, util_1.promisify)(crypto_1.generateKeyPair);\nasync function deriveKey(publicKee, privateKee, algorithm, keyLength, apu = new Uint8Array(0), apv = new Uint8Array(0)) {\n    let publicKey;\n    if ((0, webcrypto_js_1.isCryptoKey)(publicKee)) {\n        (0, crypto_key_js_1.checkEncCryptoKey)(publicKee, 'ECDH');\n        publicKey = crypto_1.KeyObject.from(publicKee);\n    }\n    else if ((0, is_key_object_js_1.default)(publicKee)) {\n        publicKey = publicKee;\n    }\n    else {\n        throw new TypeError((0, invalid_key_input_js_1.default)(publicKee, ...is_key_like_js_1.types));\n    }\n    let privateKey;\n    if ((0, webcrypto_js_1.isCryptoKey)(privateKee)) {\n        (0, crypto_key_js_1.checkEncCryptoKey)(privateKee, 'ECDH', 'deriveBits');\n        privateKey = crypto_1.KeyObject.from(privateKee);\n    }\n    else if ((0, is_key_object_js_1.default)(privateKee)) {\n        privateKey = privateKee;\n    }\n    else {\n        throw new TypeError((0, invalid_key_input_js_1.default)(privateKee, ...is_key_like_js_1.types));\n    }\n    const value = (0, buffer_utils_js_1.concat)((0, buffer_utils_js_1.lengthAndInput)(buffer_utils_js_1.encoder.encode(algorithm)), (0, buffer_utils_js_1.lengthAndInput)(apu), (0, buffer_utils_js_1.lengthAndInput)(apv), (0, buffer_utils_js_1.uint32be)(keyLength));\n    const sharedSecret = (0, crypto_1.diffieHellman)({ privateKey, publicKey });\n    return (0, buffer_utils_js_1.concatKdf)(sharedSecret, keyLength, value);\n}\nexports.deriveKey = deriveKey;\nasync function generateEpk(kee) {\n    let key;\n    if ((0, webcrypto_js_1.isCryptoKey)(kee)) {\n        key = crypto_1.KeyObject.from(kee);\n    }\n    else if ((0, is_key_object_js_1.default)(kee)) {\n        key = kee;\n    }\n    else {\n        throw new TypeError((0, invalid_key_input_js_1.default)(kee, ...is_key_like_js_1.types));\n    }\n    switch (key.asymmetricKeyType) {\n        case 'x25519':\n            return generateKeyPair('x25519');\n        case 'x448': {\n            return generateKeyPair('x448');\n        }\n        case 'ec': {\n            const namedCurve = (0, get_named_curve_js_1.default)(key);\n            return generateKeyPair('ec', { namedCurve });\n        }\n        default:\n            throw new errors_js_1.JOSENotSupported('Invalid or unsupported EPK');\n    }\n}\nexports.generateEpk = generateEpk;\nconst ecdhAllowed = (key) => ['P-256', 'P-384', 'P-521', 'X25519', 'X448'].includes((0, get_named_curve_js_1.default)(key));\nexports.ecdhAllowed = ecdhAllowed;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvZWNkaGVzLmpzIiwibWFwcGluZ3MiOiJBQUFhO0FBQ2IsOENBQTZDLEVBQUUsYUFBYSxFQUFDO0FBQzdELG1CQUFtQixHQUFHLG1CQUFtQixHQUFHLGlCQUFpQjtBQUM3RCxpQkFBaUIsbUJBQU8sQ0FBQyxzQkFBUTtBQUNqQyxlQUFlLG1CQUFPLENBQUMsa0JBQU07QUFDN0IsNkJBQTZCLG1CQUFPLENBQUMsMkhBQXNCO0FBQzNELDBCQUEwQixtQkFBTyxDQUFDLHNIQUF3QjtBQUMxRCxvQkFBb0IsbUJBQU8sQ0FBQyw0R0FBbUI7QUFDL0MsdUJBQXVCLG1CQUFPLENBQUMsK0dBQWdCO0FBQy9DLHdCQUF3QixtQkFBTyxDQUFDLGtIQUFzQjtBQUN0RCwyQkFBMkIsbUJBQU8sQ0FBQyx1SEFBb0I7QUFDdkQsK0JBQStCLG1CQUFPLENBQUMsZ0lBQTZCO0FBQ3BFLHlCQUF5QixtQkFBTyxDQUFDLG1IQUFrQjtBQUNuRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHVEQUF1RCx1QkFBdUI7QUFDOUU7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLDJDQUEyQyxZQUFZO0FBQ3ZEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxtQkFBbUI7QUFDbkI7QUFDQSxtQkFBbUIiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbm9kZV9tb2R1bGVzL2pvc2UvZGlzdC9ub2RlL2Nqcy9ydW50aW1lL2VjZGhlcy5qcz8wY2I1Il0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZXhwb3J0cy5lY2RoQWxsb3dlZCA9IGV4cG9ydHMuZ2VuZXJhdGVFcGsgPSBleHBvcnRzLmRlcml2ZUtleSA9IHZvaWQgMDtcbmNvbnN0IGNyeXB0b18xID0gcmVxdWlyZShcImNyeXB0b1wiKTtcbmNvbnN0IHV0aWxfMSA9IHJlcXVpcmUoXCJ1dGlsXCIpO1xuY29uc3QgZ2V0X25hbWVkX2N1cnZlX2pzXzEgPSByZXF1aXJlKFwiLi9nZXRfbmFtZWRfY3VydmUuanNcIik7XG5jb25zdCBidWZmZXJfdXRpbHNfanNfMSA9IHJlcXVpcmUoXCIuLi9saWIvYnVmZmVyX3V0aWxzLmpzXCIpO1xuY29uc3QgZXJyb3JzX2pzXzEgPSByZXF1aXJlKFwiLi4vdXRpbC9lcnJvcnMuanNcIik7XG5jb25zdCB3ZWJjcnlwdG9fanNfMSA9IHJlcXVpcmUoXCIuL3dlYmNyeXB0by5qc1wiKTtcbmNvbnN0IGNyeXB0b19rZXlfanNfMSA9IHJlcXVpcmUoXCIuLi9saWIvY3J5cHRvX2tleS5qc1wiKTtcbmNvbnN0IGlzX2tleV9vYmplY3RfanNfMSA9IHJlcXVpcmUoXCIuL2lzX2tleV9vYmplY3QuanNcIik7XG5jb25zdCBpbnZhbGlkX2tleV9pbnB1dF9qc18xID0gcmVxdWlyZShcIi4uL2xpYi9pbnZhbGlkX2tleV9pbnB1dC5qc1wiKTtcbmNvbnN0IGlzX2tleV9saWtlX2pzXzEgPSByZXF1aXJlKFwiLi9pc19rZXlfbGlrZS5qc1wiKTtcbmNvbnN0IGdlbmVyYXRlS2V5UGFpciA9ICgwLCB1dGlsXzEucHJvbWlzaWZ5KShjcnlwdG9fMS5nZW5lcmF0ZUtleVBhaXIpO1xuYXN5bmMgZnVuY3Rpb24gZGVyaXZlS2V5KHB1YmxpY0tlZSwgcHJpdmF0ZUtlZSwgYWxnb3JpdGhtLCBrZXlMZW5ndGgsIGFwdSA9IG5ldyBVaW50OEFycmF5KDApLCBhcHYgPSBuZXcgVWludDhBcnJheSgwKSkge1xuICAgIGxldCBwdWJsaWNLZXk7XG4gICAgaWYgKCgwLCB3ZWJjcnlwdG9fanNfMS5pc0NyeXB0b0tleSkocHVibGljS2VlKSkge1xuICAgICAgICAoMCwgY3J5cHRvX2tleV9qc18xLmNoZWNrRW5jQ3J5cHRvS2V5KShwdWJsaWNLZWUsICdFQ0RIJyk7XG4gICAgICAgIHB1YmxpY0tleSA9IGNyeXB0b18xLktleU9iamVjdC5mcm9tKHB1YmxpY0tlZSk7XG4gICAgfVxuICAgIGVsc2UgaWYgKCgwLCBpc19rZXlfb2JqZWN0X2pzXzEuZGVmYXVsdCkocHVibGljS2VlKSkge1xuICAgICAgICBwdWJsaWNLZXkgPSBwdWJsaWNLZWU7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCgwLCBpbnZhbGlkX2tleV9pbnB1dF9qc18xLmRlZmF1bHQpKHB1YmxpY0tlZSwgLi4uaXNfa2V5X2xpa2VfanNfMS50eXBlcykpO1xuICAgIH1cbiAgICBsZXQgcHJpdmF0ZUtleTtcbiAgICBpZiAoKDAsIHdlYmNyeXB0b19qc18xLmlzQ3J5cHRvS2V5KShwcml2YXRlS2VlKSkge1xuICAgICAgICAoMCwgY3J5cHRvX2tleV9qc18xLmNoZWNrRW5jQ3J5cHRvS2V5KShwcml2YXRlS2VlLCAnRUNESCcsICdkZXJpdmVCaXRzJyk7XG4gICAgICAgIHByaXZhdGVLZXkgPSBjcnlwdG9fMS5LZXlPYmplY3QuZnJvbShwcml2YXRlS2VlKTtcbiAgICB9XG4gICAgZWxzZSBpZiAoKDAsIGlzX2tleV9vYmplY3RfanNfMS5kZWZhdWx0KShwcml2YXRlS2VlKSkge1xuICAgICAgICBwcml2YXRlS2V5ID0gcHJpdmF0ZUtlZTtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoKDAsIGludmFsaWRfa2V5X2lucHV0X2pzXzEuZGVmYXVsdCkocHJpdmF0ZUtlZSwgLi4uaXNfa2V5X2xpa2VfanNfMS50eXBlcykpO1xuICAgIH1cbiAgICBjb25zdCB2YWx1ZSA9ICgwLCBidWZmZXJfdXRpbHNfanNfMS5jb25jYXQpKCgwLCBidWZmZXJfdXRpbHNfanNfMS5sZW5ndGhBbmRJbnB1dCkoYnVmZmVyX3V0aWxzX2pzXzEuZW5jb2Rlci5lbmNvZGUoYWxnb3JpdGhtKSksICgwLCBidWZmZXJfdXRpbHNfanNfMS5sZW5ndGhBbmRJbnB1dCkoYXB1KSwgKDAsIGJ1ZmZlcl91dGlsc19qc18xLmxlbmd0aEFuZElucHV0KShhcHYpLCAoMCwgYnVmZmVyX3V0aWxzX2pzXzEudWludDMyYmUpKGtleUxlbmd0aCkpO1xuICAgIGNvbnN0IHNoYXJlZFNlY3JldCA9ICgwLCBjcnlwdG9fMS5kaWZmaWVIZWxsbWFuKSh7IHByaXZhdGVLZXksIHB1YmxpY0tleSB9KTtcbiAgICByZXR1cm4gKDAsIGJ1ZmZlcl91dGlsc19qc18xLmNvbmNhdEtkZikoc2hhcmVkU2VjcmV0LCBrZXlMZW5ndGgsIHZhbHVlKTtcbn1cbmV4cG9ydHMuZGVyaXZlS2V5ID0gZGVyaXZlS2V5O1xuYXN5bmMgZnVuY3Rpb24gZ2VuZXJhdGVFcGsoa2VlKSB7XG4gICAgbGV0IGtleTtcbiAgICBpZiAoKDAsIHdlYmNyeXB0b19qc18xLmlzQ3J5cHRvS2V5KShrZWUpKSB7XG4gICAgICAgIGtleSA9IGNyeXB0b18xLktleU9iamVjdC5mcm9tKGtlZSk7XG4gICAgfVxuICAgIGVsc2UgaWYgKCgwLCBpc19rZXlfb2JqZWN0X2pzXzEuZGVmYXVsdCkoa2VlKSkge1xuICAgICAgICBrZXkgPSBrZWU7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCgwLCBpbnZhbGlkX2tleV9pbnB1dF9qc18xLmRlZmF1bHQpKGtlZSwgLi4uaXNfa2V5X2xpa2VfanNfMS50eXBlcykpO1xuICAgIH1cbiAgICBzd2l0Y2ggKGtleS5hc3ltbWV0cmljS2V5VHlwZSkge1xuICAgICAgICBjYXNlICd4MjU1MTknOlxuICAgICAgICAgICAgcmV0dXJuIGdlbmVyYXRlS2V5UGFpcigneDI1NTE5Jyk7XG4gICAgICAgIGNhc2UgJ3g0NDgnOiB7XG4gICAgICAgICAgICByZXR1cm4gZ2VuZXJhdGVLZXlQYWlyKCd4NDQ4Jyk7XG4gICAgICAgIH1cbiAgICAgICAgY2FzZSAnZWMnOiB7XG4gICAgICAgICAgICBjb25zdCBuYW1lZEN1cnZlID0gKDAsIGdldF9uYW1lZF9jdXJ2ZV9qc18xLmRlZmF1bHQpKGtleSk7XG4gICAgICAgICAgICByZXR1cm4gZ2VuZXJhdGVLZXlQYWlyKCdlYycsIHsgbmFtZWRDdXJ2ZSB9KTtcbiAgICAgICAgfVxuICAgICAgICBkZWZhdWx0OlxuICAgICAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpPU0VOb3RTdXBwb3J0ZWQoJ0ludmFsaWQgb3IgdW5zdXBwb3J0ZWQgRVBLJyk7XG4gICAgfVxufVxuZXhwb3J0cy5nZW5lcmF0ZUVwayA9IGdlbmVyYXRlRXBrO1xuY29uc3QgZWNkaEFsbG93ZWQgPSAoa2V5KSA9PiBbJ1AtMjU2JywgJ1AtMzg0JywgJ1AtNTIxJywgJ1gyNTUxOScsICdYNDQ4J10uaW5jbHVkZXMoKDAsIGdldF9uYW1lZF9jdXJ2ZV9qc18xLmRlZmF1bHQpKGtleSkpO1xuZXhwb3J0cy5lY2RoQWxsb3dlZCA9IGVjZGhBbGxvd2VkO1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/ecdhes.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/encrypt.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/encrypt.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst check_iv_length_js_1 = __webpack_require__(/*! ../lib/check_iv_length.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_iv_length.js\");\nconst check_cek_length_js_1 = __webpack_require__(/*! ./check_cek_length.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/check_cek_length.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst cbc_tag_js_1 = __webpack_require__(/*! ./cbc_tag.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/cbc_tag.js\");\nconst webcrypto_js_1 = __webpack_require__(/*! ./webcrypto.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/webcrypto.js\");\nconst crypto_key_js_1 = __webpack_require__(/*! ../lib/crypto_key.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/crypto_key.js\");\nconst is_key_object_js_1 = __webpack_require__(/*! ./is_key_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_object.js\");\nconst invalid_key_input_js_1 = __webpack_require__(/*! ../lib/invalid_key_input.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/invalid_key_input.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst ciphers_js_1 = __webpack_require__(/*! ./ciphers.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/ciphers.js\");\nconst is_key_like_js_1 = __webpack_require__(/*! ./is_key_like.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_like.js\");\nfunction cbcEncrypt(enc, plaintext, cek, iv, aad) {\n    const keySize = parseInt(enc.slice(1, 4), 10);\n    if ((0, is_key_object_js_1.default)(cek)) {\n        cek = cek.export();\n    }\n    const encKey = cek.subarray(keySize >> 3);\n    const macKey = cek.subarray(0, keySize >> 3);\n    const algorithm = `aes-${keySize}-cbc`;\n    if (!(0, ciphers_js_1.default)(algorithm)) {\n        throw new errors_js_1.JOSENotSupported(`alg ${enc} is not supported by your javascript runtime`);\n    }\n    const cipher = (0, crypto_1.createCipheriv)(algorithm, encKey, iv);\n    const ciphertext = (0, buffer_utils_js_1.concat)(cipher.update(plaintext), cipher.final());\n    const macSize = parseInt(enc.slice(-3), 10);\n    const tag = (0, cbc_tag_js_1.default)(aad, iv, ciphertext, macSize, macKey, keySize);\n    return { ciphertext, tag };\n}\nfunction gcmEncrypt(enc, plaintext, cek, iv, aad) {\n    const keySize = parseInt(enc.slice(1, 4), 10);\n    const algorithm = `aes-${keySize}-gcm`;\n    if (!(0, ciphers_js_1.default)(algorithm)) {\n        throw new errors_js_1.JOSENotSupported(`alg ${enc} is not supported by your javascript runtime`);\n    }\n    const cipher = (0, crypto_1.createCipheriv)(algorithm, cek, iv, { authTagLength: 16 });\n    if (aad.byteLength) {\n        cipher.setAAD(aad, { plaintextLength: plaintext.length });\n    }\n    const ciphertext = cipher.update(plaintext);\n    cipher.final();\n    const tag = cipher.getAuthTag();\n    return { ciphertext, tag };\n}\nconst encrypt = (enc, plaintext, cek, iv, aad) => {\n    let key;\n    if ((0, webcrypto_js_1.isCryptoKey)(cek)) {\n        (0, crypto_key_js_1.checkEncCryptoKey)(cek, enc, 'encrypt');\n        key = crypto_1.KeyObject.from(cek);\n    }\n    else if (cek instanceof Uint8Array || (0, is_key_object_js_1.default)(cek)) {\n        key = cek;\n    }\n    else {\n        throw new TypeError((0, invalid_key_input_js_1.default)(cek, ...is_key_like_js_1.types, 'Uint8Array'));\n    }\n    (0, check_cek_length_js_1.default)(enc, key);\n    (0, check_iv_length_js_1.default)(enc, iv);\n    switch (enc) {\n        case 'A128CBC-HS256':\n        case 'A192CBC-HS384':\n        case 'A256CBC-HS512':\n            return cbcEncrypt(enc, plaintext, key, iv, aad);\n        case 'A128GCM':\n        case 'A192GCM':\n        case 'A256GCM':\n            return gcmEncrypt(enc, plaintext, key, iv, aad);\n        default:\n            throw new errors_js_1.JOSENotSupported('Unsupported JWE Content Encryption Algorithm');\n    }\n};\nexports[\"default\"] = encrypt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/encrypt.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/fetch_jwks.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/fetch_jwks.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst http = __webpack_require__(/*! http */ \"http\");\nconst https = __webpack_require__(/*! https */ \"https\");\nconst events_1 = __webpack_require__(/*! events */ \"events\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst fetchJwks = async (url, timeout, options) => {\n    let get;\n    switch (url.protocol) {\n        case 'https:':\n            get = https.get;\n            break;\n        case 'http:':\n            get = http.get;\n            break;\n        default:\n            throw new TypeError('Unsupported URL protocol.');\n    }\n    const { agent, headers } = options;\n    const req = get(url.href, {\n        agent,\n        timeout,\n        headers,\n    });\n    const [response] = (await Promise.race([(0, events_1.once)(req, 'response'), (0, events_1.once)(req, 'timeout')]));\n    if (!response) {\n        req.destroy();\n        throw new errors_js_1.JWKSTimeout();\n    }\n    if (response.statusCode !== 200) {\n        throw new errors_js_1.JOSEError('Expected 200 OK from the JSON Web Key Set HTTP response');\n    }\n    const parts = [];\n    for await (const part of response) {\n        parts.push(part);\n    }\n    try {\n        return JSON.parse(buffer_utils_js_1.decoder.decode((0, buffer_utils_js_1.concat)(...parts)));\n    }\n    catch {\n        throw new errors_js_1.JOSEError('Failed to parse the JSON Web Key Set HTTP response as JSON');\n    }\n};\nexports[\"default\"] = fetchJwks;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/fetch_jwks.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/flags.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/flags.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.jwkImport = exports.jwkExport = exports.rsaPssParams = exports.oneShotCallback = void 0;\nconst [major, minor] = process.versions.node.split('.').map((str) => parseInt(str, 10));\nexports.oneShotCallback = major >= 16 || (major === 15 && minor >= 13);\nexports.rsaPssParams = !('electron' in process.versions) && (major >= 17 || (major === 16 && minor >= 9));\nexports.jwkExport = major >= 16 || (major === 15 && minor >= 9);\nexports.jwkImport = major >= 16 || (major === 15 && minor >= 12);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvZmxhZ3MuanMiLCJtYXBwaW5ncyI6IkFBQWE7QUFDYiw4Q0FBNkMsRUFBRSxhQUFhLEVBQUM7QUFDN0QsaUJBQWlCLEdBQUcsaUJBQWlCLEdBQUcsb0JBQW9CLEdBQUcsdUJBQXVCO0FBQ3RGO0FBQ0EsdUJBQXVCO0FBQ3ZCLG9CQUFvQjtBQUNwQixpQkFBaUI7QUFDakIsaUJBQWlCIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L25vZGVfbW9kdWxlcy9qb3NlL2Rpc3Qvbm9kZS9janMvcnVudGltZS9mbGFncy5qcz8wZGM4Il0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZXhwb3J0cy5qd2tJbXBvcnQgPSBleHBvcnRzLmp3a0V4cG9ydCA9IGV4cG9ydHMucnNhUHNzUGFyYW1zID0gZXhwb3J0cy5vbmVTaG90Q2FsbGJhY2sgPSB2b2lkIDA7XG5jb25zdCBbbWFqb3IsIG1pbm9yXSA9IHByb2Nlc3MudmVyc2lvbnMubm9kZS5zcGxpdCgnLicpLm1hcCgoc3RyKSA9PiBwYXJzZUludChzdHIsIDEwKSk7XG5leHBvcnRzLm9uZVNob3RDYWxsYmFjayA9IG1ham9yID49IDE2IHx8IChtYWpvciA9PT0gMTUgJiYgbWlub3IgPj0gMTMpO1xuZXhwb3J0cy5yc2FQc3NQYXJhbXMgPSAhKCdlbGVjdHJvbicgaW4gcHJvY2Vzcy52ZXJzaW9ucykgJiYgKG1ham9yID49IDE3IHx8IChtYWpvciA9PT0gMTYgJiYgbWlub3IgPj0gOSkpO1xuZXhwb3J0cy5qd2tFeHBvcnQgPSBtYWpvciA+PSAxNiB8fCAobWFqb3IgPT09IDE1ICYmIG1pbm9yID49IDkpO1xuZXhwb3J0cy5qd2tJbXBvcnQgPSBtYWpvciA+PSAxNiB8fCAobWFqb3IgPT09IDE1ICYmIG1pbm9yID49IDEyKTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/flags.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/generate.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/generate.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.generateKeyPair = exports.generateSecret = void 0;\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst util_1 = __webpack_require__(/*! util */ \"util\");\nconst random_js_1 = __webpack_require__(/*! ./random.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/random.js\");\nconst check_modulus_length_js_1 = __webpack_require__(/*! ./check_modulus_length.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/check_modulus_length.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst generate = (0, util_1.promisify)(crypto_1.generateKeyPair);\nasync function generateSecret(alg, options) {\n    let length;\n    switch (alg) {\n        case 'HS256':\n        case 'HS384':\n        case 'HS512':\n        case 'A128CBC-HS256':\n        case 'A192CBC-HS384':\n        case 'A256CBC-HS512':\n            length = parseInt(alg.slice(-3), 10);\n            break;\n        case 'A128KW':\n        case 'A192KW':\n        case 'A256KW':\n        case 'A128GCMKW':\n        case 'A192GCMKW':\n        case 'A256GCMKW':\n        case 'A128GCM':\n        case 'A192GCM':\n        case 'A256GCM':\n            length = parseInt(alg.slice(1, 4), 10);\n            break;\n        default:\n            throw new errors_js_1.JOSENotSupported('Invalid or unsupported JWK \"alg\" (Algorithm) Parameter value');\n    }\n    return (0, crypto_1.createSecretKey)((0, random_js_1.default)(new Uint8Array(length >> 3)));\n}\nexports.generateSecret = generateSecret;\nasync function generateKeyPair(alg, options) {\n    var _a, _b;\n    switch (alg) {\n        case 'RS256':\n        case 'RS384':\n        case 'RS512':\n        case 'PS256':\n        case 'PS384':\n        case 'PS512':\n        case 'RSA-OAEP':\n        case 'RSA-OAEP-256':\n        case 'RSA-OAEP-384':\n        case 'RSA-OAEP-512':\n        case 'RSA1_5': {\n            const modulusLength = (_a = options === null || options === void 0 ? void 0 : options.modulusLength) !== null && _a !== void 0 ? _a : 2048;\n            if (typeof modulusLength !== 'number' || modulusLength < 2048) {\n                throw new errors_js_1.JOSENotSupported('Invalid or unsupported modulusLength option provided, 2048 bits or larger keys must be used');\n            }\n            const keypair = await generate('rsa', {\n                modulusLength,\n                publicExponent: 0x10001,\n            });\n            (0, check_modulus_length_js_1.setModulusLength)(keypair.privateKey, modulusLength);\n            (0, check_modulus_length_js_1.setModulusLength)(keypair.publicKey, modulusLength);\n            return keypair;\n        }\n        case 'ES256':\n            return generate('ec', { namedCurve: 'P-256' });\n        case 'ES256K':\n            return generate('ec', { namedCurve: 'secp256k1' });\n        case 'ES384':\n            return generate('ec', { namedCurve: 'P-384' });\n        case 'ES512':\n            return generate('ec', { namedCurve: 'P-521' });\n        case 'EdDSA': {\n            switch (options === null || options === void 0 ? void 0 : options.crv) {\n                case undefined:\n                case 'Ed25519':\n                    return generate('ed25519');\n                case 'Ed448':\n                    return generate('ed448');\n                default:\n                    throw new errors_js_1.JOSENotSupported('Invalid or unsupported crv option provided, supported values are Ed25519 and Ed448');\n            }\n        }\n        case 'ECDH-ES':\n        case 'ECDH-ES+A128KW':\n        case 'ECDH-ES+A192KW':\n        case 'ECDH-ES+A256KW':\n            const crv = (_b = options === null || options === void 0 ? void 0 : options.crv) !== null && _b !== void 0 ? _b : 'P-256';\n            switch (crv) {\n                case undefined:\n                case 'P-256':\n                case 'P-384':\n                case 'P-521':\n                    return generate('ec', { namedCurve: crv });\n                case 'X25519':\n                    return generate('x25519');\n                case 'X448':\n                    return generate('x448');\n                default:\n                    throw new errors_js_1.JOSENotSupported('Invalid or unsupported crv option provided, supported values are P-256, P-384, P-521, X25519, and X448');\n            }\n        default:\n            throw new errors_js_1.JOSENotSupported('Invalid or unsupported JWK \"alg\" (Algorithm) Parameter value');\n    }\n}\nexports.generateKeyPair = generateKeyPair;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/generate.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/get_named_curve.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/get_named_curve.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.setCurve = exports.weakMap = void 0;\nconst buffer_1 = __webpack_require__(/*! buffer */ \"buffer\");\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst webcrypto_js_1 = __webpack_require__(/*! ./webcrypto.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/webcrypto.js\");\nconst is_key_object_js_1 = __webpack_require__(/*! ./is_key_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_object.js\");\nconst invalid_key_input_js_1 = __webpack_require__(/*! ../lib/invalid_key_input.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/invalid_key_input.js\");\nconst is_key_like_js_1 = __webpack_require__(/*! ./is_key_like.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_like.js\");\nconst p256 = buffer_1.Buffer.from([42, 134, 72, 206, 61, 3, 1, 7]);\nconst p384 = buffer_1.Buffer.from([43, 129, 4, 0, 34]);\nconst p521 = buffer_1.Buffer.from([43, 129, 4, 0, 35]);\nconst secp256k1 = buffer_1.Buffer.from([43, 129, 4, 0, 10]);\nexports.weakMap = new WeakMap();\nconst namedCurveToJOSE = (namedCurve) => {\n    switch (namedCurve) {\n        case 'prime256v1':\n            return 'P-256';\n        case 'secp384r1':\n            return 'P-384';\n        case 'secp521r1':\n            return 'P-521';\n        case 'secp256k1':\n            return 'secp256k1';\n        default:\n            throw new errors_js_1.JOSENotSupported('Unsupported key curve for this operation');\n    }\n};\nconst getNamedCurve = (kee, raw) => {\n    var _a;\n    let key;\n    if ((0, webcrypto_js_1.isCryptoKey)(kee)) {\n        key = crypto_1.KeyObject.from(kee);\n    }\n    else if ((0, is_key_object_js_1.default)(kee)) {\n        key = kee;\n    }\n    else {\n        throw new TypeError((0, invalid_key_input_js_1.default)(kee, ...is_key_like_js_1.types));\n    }\n    if (key.type === 'secret') {\n        throw new TypeError('only \"private\" or \"public\" type keys can be used for this operation');\n    }\n    switch (key.asymmetricKeyType) {\n        case 'ed25519':\n        case 'ed448':\n            return `Ed${key.asymmetricKeyType.slice(2)}`;\n        case 'x25519':\n        case 'x448':\n            return `X${key.asymmetricKeyType.slice(1)}`;\n        case 'ec': {\n            if (exports.weakMap.has(key)) {\n                return exports.weakMap.get(key);\n            }\n            let namedCurve = (_a = key.asymmetricKeyDetails) === null || _a === void 0 ? void 0 : _a.namedCurve;\n            if (!namedCurve && key.type === 'private') {\n                namedCurve = getNamedCurve((0, crypto_1.createPublicKey)(key), true);\n            }\n            else if (!namedCurve) {\n                const buf = key.export({ format: 'der', type: 'spki' });\n                const i = buf[1] < 128 ? 14 : 15;\n                const len = buf[i];\n                const curveOid = buf.slice(i + 1, i + 1 + len);\n                if (curveOid.equals(p256)) {\n                    namedCurve = 'prime256v1';\n                }\n                else if (curveOid.equals(p384)) {\n                    namedCurve = 'secp384r1';\n                }\n                else if (curveOid.equals(p521)) {\n                    namedCurve = 'secp521r1';\n                }\n                else if (curveOid.equals(secp256k1)) {\n                    namedCurve = 'secp256k1';\n                }\n                else {\n                    throw new errors_js_1.JOSENotSupported('Unsupported key curve for this operation');\n                }\n            }\n            if (raw)\n                return namedCurve;\n            const curve = namedCurveToJOSE(namedCurve);\n            exports.weakMap.set(key, curve);\n            return curve;\n        }\n        default:\n            throw new TypeError('Invalid asymmetric key type for this operation');\n    }\n};\nfunction setCurve(keyObject, curve) {\n    exports.weakMap.set(keyObject, curve);\n}\nexports.setCurve = setCurve;\nexports[\"default\"] = getNamedCurve;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/get_named_curve.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/get_sign_verify_key.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/get_sign_verify_key.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst webcrypto_js_1 = __webpack_require__(/*! ./webcrypto.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/webcrypto.js\");\nconst crypto_key_js_1 = __webpack_require__(/*! ../lib/crypto_key.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/crypto_key.js\");\nconst invalid_key_input_js_1 = __webpack_require__(/*! ../lib/invalid_key_input.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/invalid_key_input.js\");\nconst is_key_like_js_1 = __webpack_require__(/*! ./is_key_like.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_like.js\");\nfunction getSignVerifyKey(alg, key, usage) {\n    if (key instanceof Uint8Array) {\n        if (!alg.startsWith('HS')) {\n            throw new TypeError((0, invalid_key_input_js_1.default)(key, ...is_key_like_js_1.types));\n        }\n        return (0, crypto_1.createSecretKey)(key);\n    }\n    if (key instanceof crypto_1.KeyObject) {\n        return key;\n    }\n    if ((0, webcrypto_js_1.isCryptoKey)(key)) {\n        (0, crypto_key_js_1.checkSigCryptoKey)(key, alg, usage);\n        return crypto_1.KeyObject.from(key);\n    }\n    throw new TypeError((0, invalid_key_input_js_1.default)(key, ...is_key_like_js_1.types, 'Uint8Array'));\n}\nexports[\"default\"] = getSignVerifyKey;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvZ2V0X3NpZ25fdmVyaWZ5X2tleS5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxpQkFBaUIsbUJBQU8sQ0FBQyxzQkFBUTtBQUNqQyx1QkFBdUIsbUJBQU8sQ0FBQywrR0FBZ0I7QUFDL0Msd0JBQXdCLG1CQUFPLENBQUMsa0hBQXNCO0FBQ3RELCtCQUErQixtQkFBTyxDQUFDLGdJQUE2QjtBQUNwRSx5QkFBeUIsbUJBQU8sQ0FBQyxtSEFBa0I7QUFDbkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBZSIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvZ2V0X3NpZ25fdmVyaWZ5X2tleS5qcz8wMDhiIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuY29uc3QgY3J5cHRvXzEgPSByZXF1aXJlKFwiY3J5cHRvXCIpO1xuY29uc3Qgd2ViY3J5cHRvX2pzXzEgPSByZXF1aXJlKFwiLi93ZWJjcnlwdG8uanNcIik7XG5jb25zdCBjcnlwdG9fa2V5X2pzXzEgPSByZXF1aXJlKFwiLi4vbGliL2NyeXB0b19rZXkuanNcIik7XG5jb25zdCBpbnZhbGlkX2tleV9pbnB1dF9qc18xID0gcmVxdWlyZShcIi4uL2xpYi9pbnZhbGlkX2tleV9pbnB1dC5qc1wiKTtcbmNvbnN0IGlzX2tleV9saWtlX2pzXzEgPSByZXF1aXJlKFwiLi9pc19rZXlfbGlrZS5qc1wiKTtcbmZ1bmN0aW9uIGdldFNpZ25WZXJpZnlLZXkoYWxnLCBrZXksIHVzYWdlKSB7XG4gICAgaWYgKGtleSBpbnN0YW5jZW9mIFVpbnQ4QXJyYXkpIHtcbiAgICAgICAgaWYgKCFhbGcuc3RhcnRzV2l0aCgnSFMnKSkge1xuICAgICAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcigoMCwgaW52YWxpZF9rZXlfaW5wdXRfanNfMS5kZWZhdWx0KShrZXksIC4uLmlzX2tleV9saWtlX2pzXzEudHlwZXMpKTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gKDAsIGNyeXB0b18xLmNyZWF0ZVNlY3JldEtleSkoa2V5KTtcbiAgICB9XG4gICAgaWYgKGtleSBpbnN0YW5jZW9mIGNyeXB0b18xLktleU9iamVjdCkge1xuICAgICAgICByZXR1cm4ga2V5O1xuICAgIH1cbiAgICBpZiAoKDAsIHdlYmNyeXB0b19qc18xLmlzQ3J5cHRvS2V5KShrZXkpKSB7XG4gICAgICAgICgwLCBjcnlwdG9fa2V5X2pzXzEuY2hlY2tTaWdDcnlwdG9LZXkpKGtleSwgYWxnLCB1c2FnZSk7XG4gICAgICAgIHJldHVybiBjcnlwdG9fMS5LZXlPYmplY3QuZnJvbShrZXkpO1xuICAgIH1cbiAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCgwLCBpbnZhbGlkX2tleV9pbnB1dF9qc18xLmRlZmF1bHQpKGtleSwgLi4uaXNfa2V5X2xpa2VfanNfMS50eXBlcywgJ1VpbnQ4QXJyYXknKSk7XG59XG5leHBvcnRzLmRlZmF1bHQgPSBnZXRTaWduVmVyaWZ5S2V5O1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/get_sign_verify_key.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/hmac_digest.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/hmac_digest.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nfunction hmacDigest(alg) {\n    switch (alg) {\n        case 'HS256':\n            return 'sha256';\n        case 'HS384':\n            return 'sha384';\n        case 'HS512':\n            return 'sha512';\n        default:\n            throw new errors_js_1.JOSENotSupported(`alg ${alg} is not supported either by JOSE or your javascript runtime`);\n    }\n}\nexports[\"default\"] = hmacDigest;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvaG1hY19kaWdlc3QuanMiLCJtYXBwaW5ncyI6IkFBQWE7QUFDYiw4Q0FBNkMsRUFBRSxhQUFhLEVBQUM7QUFDN0Qsb0JBQW9CLG1CQUFPLENBQUMsNEdBQW1CO0FBQy9DO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLDBEQUEwRCxLQUFLO0FBQy9EO0FBQ0E7QUFDQSxrQkFBZSIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvaG1hY19kaWdlc3QuanM/MTI5YiJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbmNvbnN0IGVycm9yc19qc18xID0gcmVxdWlyZShcIi4uL3V0aWwvZXJyb3JzLmpzXCIpO1xuZnVuY3Rpb24gaG1hY0RpZ2VzdChhbGcpIHtcbiAgICBzd2l0Y2ggKGFsZykge1xuICAgICAgICBjYXNlICdIUzI1Nic6XG4gICAgICAgICAgICByZXR1cm4gJ3NoYTI1Nic7XG4gICAgICAgIGNhc2UgJ0hTMzg0JzpcbiAgICAgICAgICAgIHJldHVybiAnc2hhMzg0JztcbiAgICAgICAgY2FzZSAnSFM1MTInOlxuICAgICAgICAgICAgcmV0dXJuICdzaGE1MTInO1xuICAgICAgICBkZWZhdWx0OlxuICAgICAgICAgICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpPU0VOb3RTdXBwb3J0ZWQoYGFsZyAke2FsZ30gaXMgbm90IHN1cHBvcnRlZCBlaXRoZXIgYnkgSk9TRSBvciB5b3VyIGphdmFzY3JpcHQgcnVudGltZWApO1xuICAgIH1cbn1cbmV4cG9ydHMuZGVmYXVsdCA9IGhtYWNEaWdlc3Q7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/hmac_digest.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_like.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_like.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.types = void 0;\nconst webcrypto_js_1 = __webpack_require__(/*! ./webcrypto.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/webcrypto.js\");\nconst is_key_object_js_1 = __webpack_require__(/*! ./is_key_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_object.js\");\nexports[\"default\"] = (key) => (0, is_key_object_js_1.default)(key) || (0, webcrypto_js_1.isCryptoKey)(key);\nconst types = ['KeyObject'];\nexports.types = types;\nif (globalThis.CryptoKey || (webcrypto_js_1.default === null || webcrypto_js_1.default === void 0 ? void 0 : webcrypto_js_1.default.CryptoKey)) {\n    types.push('CryptoKey');\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvaXNfa2V5X2xpa2UuanMiLCJtYXBwaW5ncyI6IkFBQWE7QUFDYiw4Q0FBNkMsRUFBRSxhQUFhLEVBQUM7QUFDN0QsYUFBYTtBQUNiLHVCQUF1QixtQkFBTyxDQUFDLCtHQUFnQjtBQUMvQywyQkFBMkIsbUJBQU8sQ0FBQyx1SEFBb0I7QUFDdkQsa0JBQWU7QUFDZjtBQUNBLGFBQWE7QUFDYjtBQUNBO0FBQ0EiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbm9kZV9tb2R1bGVzL2pvc2UvZGlzdC9ub2RlL2Nqcy9ydW50aW1lL2lzX2tleV9saWtlLmpzP2U1ZTgiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG5leHBvcnRzLnR5cGVzID0gdm9pZCAwO1xuY29uc3Qgd2ViY3J5cHRvX2pzXzEgPSByZXF1aXJlKFwiLi93ZWJjcnlwdG8uanNcIik7XG5jb25zdCBpc19rZXlfb2JqZWN0X2pzXzEgPSByZXF1aXJlKFwiLi9pc19rZXlfb2JqZWN0LmpzXCIpO1xuZXhwb3J0cy5kZWZhdWx0ID0gKGtleSkgPT4gKDAsIGlzX2tleV9vYmplY3RfanNfMS5kZWZhdWx0KShrZXkpIHx8ICgwLCB3ZWJjcnlwdG9fanNfMS5pc0NyeXB0b0tleSkoa2V5KTtcbmNvbnN0IHR5cGVzID0gWydLZXlPYmplY3QnXTtcbmV4cG9ydHMudHlwZXMgPSB0eXBlcztcbmlmIChnbG9iYWxUaGlzLkNyeXB0b0tleSB8fCAod2ViY3J5cHRvX2pzXzEuZGVmYXVsdCA9PT0gbnVsbCB8fCB3ZWJjcnlwdG9fanNfMS5kZWZhdWx0ID09PSB2b2lkIDAgPyB2b2lkIDAgOiB3ZWJjcnlwdG9fanNfMS5kZWZhdWx0LkNyeXB0b0tleSkpIHtcbiAgICB0eXBlcy5wdXNoKCdDcnlwdG9LZXknKTtcbn1cbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_like.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_object.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_object.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst util = __webpack_require__(/*! util */ \"util\");\nexports[\"default\"] = util.types.isKeyObject\n    ? (obj) => util.types.isKeyObject(obj)\n    : (obj) => obj != null && obj instanceof crypto_1.KeyObject;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvaXNfa2V5X29iamVjdC5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxpQkFBaUIsbUJBQU8sQ0FBQyxzQkFBUTtBQUNqQyxhQUFhLG1CQUFPLENBQUMsa0JBQU07QUFDM0Isa0JBQWU7QUFDZjtBQUNBIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L25vZGVfbW9kdWxlcy9qb3NlL2Rpc3Qvbm9kZS9janMvcnVudGltZS9pc19rZXlfb2JqZWN0LmpzPzMzNmMiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG5jb25zdCBjcnlwdG9fMSA9IHJlcXVpcmUoXCJjcnlwdG9cIik7XG5jb25zdCB1dGlsID0gcmVxdWlyZShcInV0aWxcIik7XG5leHBvcnRzLmRlZmF1bHQgPSB1dGlsLnR5cGVzLmlzS2V5T2JqZWN0XG4gICAgPyAob2JqKSA9PiB1dGlsLnR5cGVzLmlzS2V5T2JqZWN0KG9iailcbiAgICA6IChvYmopID0+IG9iaiAhPSBudWxsICYmIG9iaiBpbnN0YW5jZW9mIGNyeXB0b18xLktleU9iamVjdDtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_object.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/jwk_to_key.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/jwk_to_key.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst buffer_1 = __webpack_require__(/*! buffer */ \"buffer\");\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst base64url_js_1 = __webpack_require__(/*! ./base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst get_named_curve_js_1 = __webpack_require__(/*! ./get_named_curve.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/get_named_curve.js\");\nconst check_modulus_length_js_1 = __webpack_require__(/*! ./check_modulus_length.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/check_modulus_length.js\");\nconst asn1_sequence_encoder_js_1 = __webpack_require__(/*! ./asn1_sequence_encoder.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/asn1_sequence_encoder.js\");\nconst flags_js_1 = __webpack_require__(/*! ./flags.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/flags.js\");\nconst parse = (jwk) => {\n    if (flags_js_1.jwkImport && jwk.kty !== 'oct') {\n        return jwk.d\n            ? (0, crypto_1.createPrivateKey)({ format: 'jwk', key: jwk })\n            : (0, crypto_1.createPublicKey)({ format: 'jwk', key: jwk });\n    }\n    switch (jwk.kty) {\n        case 'oct': {\n            return (0, crypto_1.createSecretKey)((0, base64url_js_1.decode)(jwk.k));\n        }\n        case 'RSA': {\n            const enc = new asn1_sequence_encoder_js_1.default();\n            const isPrivate = jwk.d !== undefined;\n            const modulus = buffer_1.Buffer.from(jwk.n, 'base64');\n            const exponent = buffer_1.Buffer.from(jwk.e, 'base64');\n            if (isPrivate) {\n                enc.zero();\n                enc.unsignedInteger(modulus);\n                enc.unsignedInteger(exponent);\n                enc.unsignedInteger(buffer_1.Buffer.from(jwk.d, 'base64'));\n                enc.unsignedInteger(buffer_1.Buffer.from(jwk.p, 'base64'));\n                enc.unsignedInteger(buffer_1.Buffer.from(jwk.q, 'base64'));\n                enc.unsignedInteger(buffer_1.Buffer.from(jwk.dp, 'base64'));\n                enc.unsignedInteger(buffer_1.Buffer.from(jwk.dq, 'base64'));\n                enc.unsignedInteger(buffer_1.Buffer.from(jwk.qi, 'base64'));\n            }\n            else {\n                enc.unsignedInteger(modulus);\n                enc.unsignedInteger(exponent);\n            }\n            const der = enc.end();\n            const createInput = {\n                key: der,\n                format: 'der',\n                type: 'pkcs1',\n            };\n            const keyObject = isPrivate ? (0, crypto_1.createPrivateKey)(createInput) : (0, crypto_1.createPublicKey)(createInput);\n            (0, check_modulus_length_js_1.setModulusLength)(keyObject, modulus.length << 3);\n            return keyObject;\n        }\n        case 'EC': {\n            const enc = new asn1_sequence_encoder_js_1.default();\n            const isPrivate = jwk.d !== undefined;\n            const pub = buffer_1.Buffer.concat([\n                buffer_1.Buffer.alloc(1, 4),\n                buffer_1.Buffer.from(jwk.x, 'base64'),\n                buffer_1.Buffer.from(jwk.y, 'base64'),\n            ]);\n            if (isPrivate) {\n                enc.zero();\n                const enc$1 = new asn1_sequence_encoder_js_1.default();\n                enc$1.oidFor('ecPublicKey');\n                enc$1.oidFor(jwk.crv);\n                enc.add(enc$1.end());\n                const enc$2 = new asn1_sequence_encoder_js_1.default();\n                enc$2.one();\n                enc$2.octStr(buffer_1.Buffer.from(jwk.d, 'base64'));\n                const enc$3 = new asn1_sequence_encoder_js_1.default();\n                enc$3.bitStr(pub);\n                const f2 = enc$3.end(buffer_1.Buffer.from([0xa1]));\n                enc$2.add(f2);\n                const f = enc$2.end();\n                const enc$4 = new asn1_sequence_encoder_js_1.default();\n                enc$4.add(f);\n                const f3 = enc$4.end(buffer_1.Buffer.from([0x04]));\n                enc.add(f3);\n                const der = enc.end();\n                const keyObject = (0, crypto_1.createPrivateKey)({ key: der, format: 'der', type: 'pkcs8' });\n                (0, get_named_curve_js_1.setCurve)(keyObject, jwk.crv);\n                return keyObject;\n            }\n            const enc$1 = new asn1_sequence_encoder_js_1.default();\n            enc$1.oidFor('ecPublicKey');\n            enc$1.oidFor(jwk.crv);\n            enc.add(enc$1.end());\n            enc.bitStr(pub);\n            const der = enc.end();\n            const keyObject = (0, crypto_1.createPublicKey)({ key: der, format: 'der', type: 'spki' });\n            (0, get_named_curve_js_1.setCurve)(keyObject, jwk.crv);\n            return keyObject;\n        }\n        case 'OKP': {\n            const enc = new asn1_sequence_encoder_js_1.default();\n            const isPrivate = jwk.d !== undefined;\n            if (isPrivate) {\n                enc.zero();\n                const enc$1 = new asn1_sequence_encoder_js_1.default();\n                enc$1.oidFor(jwk.crv);\n                enc.add(enc$1.end());\n                const enc$2 = new asn1_sequence_encoder_js_1.default();\n                enc$2.octStr(buffer_1.Buffer.from(jwk.d, 'base64'));\n                const f = enc$2.end(buffer_1.Buffer.from([0x04]));\n                enc.add(f);\n                const der = enc.end();\n                return (0, crypto_1.createPrivateKey)({ key: der, format: 'der', type: 'pkcs8' });\n            }\n            const enc$1 = new asn1_sequence_encoder_js_1.default();\n            enc$1.oidFor(jwk.crv);\n            enc.add(enc$1.end());\n            enc.bitStr(buffer_1.Buffer.from(jwk.x, 'base64'));\n            const der = enc.end();\n            return (0, crypto_1.createPublicKey)({ key: der, format: 'der', type: 'spki' });\n        }\n        default:\n            throw new errors_js_1.JOSENotSupported('Invalid or unsupported JWK \"kty\" (Key Type) Parameter value');\n    }\n};\nexports[\"default\"] = parse;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/jwk_to_key.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/key_to_jwk.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/key_to_jwk.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst base64url_js_1 = __webpack_require__(/*! ./base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nconst asn1_sequence_decoder_js_1 = __webpack_require__(/*! ./asn1_sequence_decoder.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/asn1_sequence_decoder.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst get_named_curve_js_1 = __webpack_require__(/*! ./get_named_curve.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/get_named_curve.js\");\nconst webcrypto_js_1 = __webpack_require__(/*! ./webcrypto.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/webcrypto.js\");\nconst is_key_object_js_1 = __webpack_require__(/*! ./is_key_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_object.js\");\nconst invalid_key_input_js_1 = __webpack_require__(/*! ../lib/invalid_key_input.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/invalid_key_input.js\");\nconst is_key_like_js_1 = __webpack_require__(/*! ./is_key_like.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_like.js\");\nconst flags_js_1 = __webpack_require__(/*! ./flags.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/flags.js\");\nconst keyToJWK = (key) => {\n    let keyObject;\n    if ((0, webcrypto_js_1.isCryptoKey)(key)) {\n        if (!key.extractable) {\n            throw new TypeError('CryptoKey is not extractable');\n        }\n        keyObject = crypto_1.KeyObject.from(key);\n    }\n    else if ((0, is_key_object_js_1.default)(key)) {\n        keyObject = key;\n    }\n    else if (key instanceof Uint8Array) {\n        return {\n            kty: 'oct',\n            k: (0, base64url_js_1.encode)(key),\n        };\n    }\n    else {\n        throw new TypeError((0, invalid_key_input_js_1.default)(key, ...is_key_like_js_1.types, 'Uint8Array'));\n    }\n    if (flags_js_1.jwkExport) {\n        if (keyObject.type !== 'secret' &&\n            !['rsa', 'ec', 'ed25519', 'x25519', 'ed448', 'x448'].includes(keyObject.asymmetricKeyType)) {\n            throw new errors_js_1.JOSENotSupported('Unsupported key asymmetricKeyType');\n        }\n        return keyObject.export({ format: 'jwk' });\n    }\n    switch (keyObject.type) {\n        case 'secret':\n            return {\n                kty: 'oct',\n                k: (0, base64url_js_1.encode)(keyObject.export()),\n            };\n        case 'private':\n        case 'public': {\n            switch (keyObject.asymmetricKeyType) {\n                case 'rsa': {\n                    const der = keyObject.export({ format: 'der', type: 'pkcs1' });\n                    const dec = new asn1_sequence_decoder_js_1.default(der);\n                    if (keyObject.type === 'private') {\n                        dec.unsignedInteger();\n                    }\n                    const n = (0, base64url_js_1.encode)(dec.unsignedInteger());\n                    const e = (0, base64url_js_1.encode)(dec.unsignedInteger());\n                    let jwk;\n                    if (keyObject.type === 'private') {\n                        jwk = {\n                            d: (0, base64url_js_1.encode)(dec.unsignedInteger()),\n                            p: (0, base64url_js_1.encode)(dec.unsignedInteger()),\n                            q: (0, base64url_js_1.encode)(dec.unsignedInteger()),\n                            dp: (0, base64url_js_1.encode)(dec.unsignedInteger()),\n                            dq: (0, base64url_js_1.encode)(dec.unsignedInteger()),\n                            qi: (0, base64url_js_1.encode)(dec.unsignedInteger()),\n                        };\n                    }\n                    dec.end();\n                    return { kty: 'RSA', n, e, ...jwk };\n                }\n                case 'ec': {\n                    const crv = (0, get_named_curve_js_1.default)(keyObject);\n                    let len;\n                    let offset;\n                    let correction;\n                    switch (crv) {\n                        case 'secp256k1':\n                            len = 64;\n                            offset = 31 + 2;\n                            correction = -1;\n                            break;\n                        case 'P-256':\n                            len = 64;\n                            offset = 34 + 2;\n                            correction = -1;\n                            break;\n                        case 'P-384':\n                            len = 96;\n                            offset = 33 + 2;\n                            correction = -3;\n                            break;\n                        case 'P-521':\n                            len = 132;\n                            offset = 33 + 2;\n                            correction = -3;\n                            break;\n                        default:\n                            throw new errors_js_1.JOSENotSupported('Unsupported curve');\n                    }\n                    if (keyObject.type === 'public') {\n                        const der = keyObject.export({ type: 'spki', format: 'der' });\n                        return {\n                            kty: 'EC',\n                            crv,\n                            x: (0, base64url_js_1.encode)(der.subarray(-len, -len / 2)),\n                            y: (0, base64url_js_1.encode)(der.subarray(-len / 2)),\n                        };\n                    }\n                    const der = keyObject.export({ type: 'pkcs8', format: 'der' });\n                    if (der.length < 100) {\n                        offset += correction;\n                    }\n                    return {\n                        ...keyToJWK((0, crypto_1.createPublicKey)(keyObject)),\n                        d: (0, base64url_js_1.encode)(der.subarray(offset, offset + len / 2)),\n                    };\n                }\n                case 'ed25519':\n                case 'x25519': {\n                    const crv = (0, get_named_curve_js_1.default)(keyObject);\n                    if (keyObject.type === 'public') {\n                        const der = keyObject.export({ type: 'spki', format: 'der' });\n                        return {\n                            kty: 'OKP',\n                            crv,\n                            x: (0, base64url_js_1.encode)(der.subarray(-32)),\n                        };\n                    }\n                    const der = keyObject.export({ type: 'pkcs8', format: 'der' });\n                    return {\n                        ...keyToJWK((0, crypto_1.createPublicKey)(keyObject)),\n                        d: (0, base64url_js_1.encode)(der.subarray(-32)),\n                    };\n                }\n                case 'ed448':\n                case 'x448': {\n                    const crv = (0, get_named_curve_js_1.default)(keyObject);\n                    if (keyObject.type === 'public') {\n                        const der = keyObject.export({ type: 'spki', format: 'der' });\n                        return {\n                            kty: 'OKP',\n                            crv,\n                            x: (0, base64url_js_1.encode)(der.subarray(crv === 'Ed448' ? -57 : -56)),\n                        };\n                    }\n                    const der = keyObject.export({ type: 'pkcs8', format: 'der' });\n                    return {\n                        ...keyToJWK((0, crypto_1.createPublicKey)(keyObject)),\n                        d: (0, base64url_js_1.encode)(der.subarray(crv === 'Ed448' ? -57 : -56)),\n                    };\n                }\n                default:\n                    throw new errors_js_1.JOSENotSupported('Unsupported key asymmetricKeyType');\n            }\n        }\n        default:\n            throw new errors_js_1.JOSENotSupported('Unsupported key type');\n    }\n};\nexports[\"default\"] = keyToJWK;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/key_to_jwk.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/node_key.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/node_key.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst get_named_curve_js_1 = __webpack_require__(/*! ./get_named_curve.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/get_named_curve.js\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst check_modulus_length_js_1 = __webpack_require__(/*! ./check_modulus_length.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/check_modulus_length.js\");\nconst flags_js_1 = __webpack_require__(/*! ./flags.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/flags.js\");\nconst PSS = {\n    padding: crypto_1.constants.RSA_PKCS1_PSS_PADDING,\n    saltLength: crypto_1.constants.RSA_PSS_SALTLEN_DIGEST,\n};\nconst ecCurveAlgMap = new Map([\n    ['ES256', 'P-256'],\n    ['ES256K', 'secp256k1'],\n    ['ES384', 'P-384'],\n    ['ES512', 'P-521'],\n]);\nfunction keyForCrypto(alg, key) {\n    switch (alg) {\n        case 'EdDSA':\n            if (!['ed25519', 'ed448'].includes(key.asymmetricKeyType)) {\n                throw new TypeError('Invalid key for this operation, its asymmetricKeyType must be ed25519 or ed448');\n            }\n            return key;\n        case 'RS256':\n        case 'RS384':\n        case 'RS512':\n            if (key.asymmetricKeyType !== 'rsa') {\n                throw new TypeError('Invalid key for this operation, its asymmetricKeyType must be rsa');\n            }\n            (0, check_modulus_length_js_1.default)(key, alg);\n            return key;\n        case flags_js_1.rsaPssParams && 'PS256':\n        case flags_js_1.rsaPssParams && 'PS384':\n        case flags_js_1.rsaPssParams && 'PS512':\n            if (key.asymmetricKeyType === 'rsa-pss') {\n                const { hashAlgorithm, mgf1HashAlgorithm, saltLength } = key.asymmetricKeyDetails;\n                const length = parseInt(alg.slice(-3), 10);\n                if (hashAlgorithm !== undefined &&\n                    (hashAlgorithm !== `sha${length}` || mgf1HashAlgorithm !== hashAlgorithm)) {\n                    throw new TypeError(`Invalid key for this operation, its RSA-PSS parameters do not meet the requirements of \"alg\" ${alg}`);\n                }\n                if (saltLength !== undefined && saltLength > length >> 3) {\n                    throw new TypeError(`Invalid key for this operation, its RSA-PSS parameter saltLength does not meet the requirements of \"alg\" ${alg}`);\n                }\n            }\n            else if (key.asymmetricKeyType !== 'rsa') {\n                throw new TypeError('Invalid key for this operation, its asymmetricKeyType must be rsa or rsa-pss');\n            }\n            (0, check_modulus_length_js_1.default)(key, alg);\n            return { key, ...PSS };\n        case !flags_js_1.rsaPssParams && 'PS256':\n        case !flags_js_1.rsaPssParams && 'PS384':\n        case !flags_js_1.rsaPssParams && 'PS512':\n            if (key.asymmetricKeyType !== 'rsa') {\n                throw new TypeError('Invalid key for this operation, its asymmetricKeyType must be rsa');\n            }\n            (0, check_modulus_length_js_1.default)(key, alg);\n            return { key, ...PSS };\n        case 'ES256':\n        case 'ES256K':\n        case 'ES384':\n        case 'ES512': {\n            if (key.asymmetricKeyType !== 'ec') {\n                throw new TypeError('Invalid key for this operation, its asymmetricKeyType must be ec');\n            }\n            const actual = (0, get_named_curve_js_1.default)(key);\n            const expected = ecCurveAlgMap.get(alg);\n            if (actual !== expected) {\n                throw new TypeError(`Invalid key curve for the algorithm, its curve must be ${expected}, got ${actual}`);\n            }\n            return { dsaEncoding: 'ieee-p1363', key };\n        }\n        default:\n            throw new errors_js_1.JOSENotSupported(`alg ${alg} is not supported either by JOSE or your javascript runtime`);\n    }\n}\nexports[\"default\"] = keyForCrypto;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/node_key.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/pbes2kw.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/pbes2kw.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.decrypt = exports.encrypt = void 0;\nconst util_1 = __webpack_require__(/*! util */ \"util\");\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst random_js_1 = __webpack_require__(/*! ./random.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/random.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst base64url_js_1 = __webpack_require__(/*! ./base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nconst aeskw_js_1 = __webpack_require__(/*! ./aeskw.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/aeskw.js\");\nconst check_p2s_js_1 = __webpack_require__(/*! ../lib/check_p2s.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/check_p2s.js\");\nconst webcrypto_js_1 = __webpack_require__(/*! ./webcrypto.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/webcrypto.js\");\nconst crypto_key_js_1 = __webpack_require__(/*! ../lib/crypto_key.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/crypto_key.js\");\nconst is_key_object_js_1 = __webpack_require__(/*! ./is_key_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_object.js\");\nconst invalid_key_input_js_1 = __webpack_require__(/*! ../lib/invalid_key_input.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/invalid_key_input.js\");\nconst is_key_like_js_1 = __webpack_require__(/*! ./is_key_like.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_like.js\");\nconst pbkdf2 = (0, util_1.promisify)(crypto_1.pbkdf2);\nfunction getPassword(key, alg) {\n    if ((0, is_key_object_js_1.default)(key)) {\n        return key.export();\n    }\n    if (key instanceof Uint8Array) {\n        return key;\n    }\n    if ((0, webcrypto_js_1.isCryptoKey)(key)) {\n        (0, crypto_key_js_1.checkEncCryptoKey)(key, alg, 'deriveBits', 'deriveKey');\n        return crypto_1.KeyObject.from(key).export();\n    }\n    throw new TypeError((0, invalid_key_input_js_1.default)(key, ...is_key_like_js_1.types, 'Uint8Array'));\n}\nconst encrypt = async (alg, key, cek, p2c = 2048, p2s = (0, random_js_1.default)(new Uint8Array(16))) => {\n    (0, check_p2s_js_1.default)(p2s);\n    const salt = (0, buffer_utils_js_1.p2s)(alg, p2s);\n    const keylen = parseInt(alg.slice(13, 16), 10) >> 3;\n    const password = getPassword(key, alg);\n    const derivedKey = await pbkdf2(password, salt, p2c, keylen, `sha${alg.slice(8, 11)}`);\n    const encryptedKey = await (0, aeskw_js_1.wrap)(alg.slice(-6), derivedKey, cek);\n    return { encryptedKey, p2c, p2s: (0, base64url_js_1.encode)(p2s) };\n};\nexports.encrypt = encrypt;\nconst decrypt = async (alg, key, encryptedKey, p2c, p2s) => {\n    (0, check_p2s_js_1.default)(p2s);\n    const salt = (0, buffer_utils_js_1.p2s)(alg, p2s);\n    const keylen = parseInt(alg.slice(13, 16), 10) >> 3;\n    const password = getPassword(key, alg);\n    const derivedKey = await pbkdf2(password, salt, p2c, keylen, `sha${alg.slice(8, 11)}`);\n    return (0, aeskw_js_1.unwrap)(alg.slice(-6), derivedKey, encryptedKey);\n};\nexports.decrypt = decrypt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/pbes2kw.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/random.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/random.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports[\"default\"] = void 0;\nvar crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nObject.defineProperty(exports, \"default\", ({ enumerable: true, get: function () { return crypto_1.randomFillSync; } }));\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvcmFuZG9tLmpzIiwibWFwcGluZ3MiOiJBQUFhO0FBQ2IsOENBQTZDLEVBQUUsYUFBYSxFQUFDO0FBQzdELGtCQUFlO0FBQ2YsZUFBZSxtQkFBTyxDQUFDLHNCQUFRO0FBQy9CLDJDQUEwQyxFQUFFLHFDQUFxQyxtQ0FBbUMsRUFBQyIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvcmFuZG9tLmpzPzg4MTkiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG5leHBvcnRzLmRlZmF1bHQgPSB2b2lkIDA7XG52YXIgY3J5cHRvXzEgPSByZXF1aXJlKFwiY3J5cHRvXCIpO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiZGVmYXVsdFwiLCB7IGVudW1lcmFibGU6IHRydWUsIGdldDogZnVuY3Rpb24gKCkgeyByZXR1cm4gY3J5cHRvXzEucmFuZG9tRmlsbFN5bmM7IH0gfSk7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/random.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/rsaes.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/rsaes.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.decrypt = exports.encrypt = void 0;\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst check_modulus_length_js_1 = __webpack_require__(/*! ./check_modulus_length.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/check_modulus_length.js\");\nconst webcrypto_js_1 = __webpack_require__(/*! ./webcrypto.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/webcrypto.js\");\nconst crypto_key_js_1 = __webpack_require__(/*! ../lib/crypto_key.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/crypto_key.js\");\nconst is_key_object_js_1 = __webpack_require__(/*! ./is_key_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_object.js\");\nconst invalid_key_input_js_1 = __webpack_require__(/*! ../lib/invalid_key_input.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/invalid_key_input.js\");\nconst is_key_like_js_1 = __webpack_require__(/*! ./is_key_like.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/is_key_like.js\");\nconst checkKey = (key, alg) => {\n    if (key.asymmetricKeyType !== 'rsa') {\n        throw new TypeError('Invalid key for this operation, its asymmetricKeyType must be rsa');\n    }\n    (0, check_modulus_length_js_1.default)(key, alg);\n};\nconst resolvePadding = (alg) => {\n    switch (alg) {\n        case 'RSA-OAEP':\n        case 'RSA-OAEP-256':\n        case 'RSA-OAEP-384':\n        case 'RSA-OAEP-512':\n            return crypto_1.constants.RSA_PKCS1_OAEP_PADDING;\n        case 'RSA1_5':\n            return crypto_1.constants.RSA_PKCS1_PADDING;\n        default:\n            return undefined;\n    }\n};\nconst resolveOaepHash = (alg) => {\n    switch (alg) {\n        case 'RSA-OAEP':\n            return 'sha1';\n        case 'RSA-OAEP-256':\n            return 'sha256';\n        case 'RSA-OAEP-384':\n            return 'sha384';\n        case 'RSA-OAEP-512':\n            return 'sha512';\n        default:\n            return undefined;\n    }\n};\nfunction ensureKeyObject(key, alg, ...usages) {\n    if ((0, is_key_object_js_1.default)(key)) {\n        return key;\n    }\n    if ((0, webcrypto_js_1.isCryptoKey)(key)) {\n        (0, crypto_key_js_1.checkEncCryptoKey)(key, alg, ...usages);\n        return crypto_1.KeyObject.from(key);\n    }\n    throw new TypeError((0, invalid_key_input_js_1.default)(key, ...is_key_like_js_1.types));\n}\nconst encrypt = (alg, key, cek) => {\n    const padding = resolvePadding(alg);\n    const oaepHash = resolveOaepHash(alg);\n    const keyObject = ensureKeyObject(key, alg, 'wrapKey', 'encrypt');\n    checkKey(keyObject, alg);\n    return (0, crypto_1.publicEncrypt)({ key: keyObject, oaepHash, padding }, cek);\n};\nexports.encrypt = encrypt;\nconst decrypt = (alg, key, encryptedKey) => {\n    const padding = resolvePadding(alg);\n    const oaepHash = resolveOaepHash(alg);\n    const keyObject = ensureKeyObject(key, alg, 'unwrapKey', 'decrypt');\n    checkKey(keyObject, alg);\n    return (0, crypto_1.privateDecrypt)({ key: keyObject, oaepHash, padding }, encryptedKey);\n};\nexports.decrypt = decrypt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/rsaes.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/runtime.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/runtime.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports[\"default\"] = 'node:crypto';\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvcnVudGltZS5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxrQkFBZSIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvcnVudGltZS5qcz9mZTNiIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZXhwb3J0cy5kZWZhdWx0ID0gJ25vZGU6Y3J5cHRvJztcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/runtime.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/sign.js":
/*!************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/sign.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst crypto = __webpack_require__(/*! crypto */ \"crypto\");\nconst util_1 = __webpack_require__(/*! util */ \"util\");\nconst dsa_digest_js_1 = __webpack_require__(/*! ./dsa_digest.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/dsa_digest.js\");\nconst hmac_digest_js_1 = __webpack_require__(/*! ./hmac_digest.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/hmac_digest.js\");\nconst node_key_js_1 = __webpack_require__(/*! ./node_key.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/node_key.js\");\nconst get_sign_verify_key_js_1 = __webpack_require__(/*! ./get_sign_verify_key.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/get_sign_verify_key.js\");\nlet oneShotSign;\nif (crypto.sign.length > 3) {\n    oneShotSign = (0, util_1.promisify)(crypto.sign);\n}\nelse {\n    oneShotSign = crypto.sign;\n}\nconst sign = async (alg, key, data) => {\n    const keyObject = (0, get_sign_verify_key_js_1.default)(alg, key, 'sign');\n    if (alg.startsWith('HS')) {\n        const hmac = crypto.createHmac((0, hmac_digest_js_1.default)(alg), keyObject);\n        hmac.update(data);\n        return hmac.digest();\n    }\n    return oneShotSign((0, dsa_digest_js_1.default)(alg), data, (0, node_key_js_1.default)(alg, keyObject));\n};\nexports[\"default\"] = sign;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/sign.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/timing_safe_equal.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/timing_safe_equal.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst crypto_1 = __webpack_require__(/*! crypto */ \"crypto\");\nconst timingSafeEqual = crypto_1.timingSafeEqual;\nexports[\"default\"] = timingSafeEqual;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvdGltaW5nX3NhZmVfZXF1YWwuanMiLCJtYXBwaW5ncyI6IkFBQWE7QUFDYiw4Q0FBNkMsRUFBRSxhQUFhLEVBQUM7QUFDN0QsaUJBQWlCLG1CQUFPLENBQUMsc0JBQVE7QUFDakM7QUFDQSxrQkFBZSIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvdGltaW5nX3NhZmVfZXF1YWwuanM/MDEzNyJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbmNvbnN0IGNyeXB0b18xID0gcmVxdWlyZShcImNyeXB0b1wiKTtcbmNvbnN0IHRpbWluZ1NhZmVFcXVhbCA9IGNyeXB0b18xLnRpbWluZ1NhZmVFcXVhbDtcbmV4cG9ydHMuZGVmYXVsdCA9IHRpbWluZ1NhZmVFcXVhbDtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/timing_safe_equal.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/verify.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/verify.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst crypto = __webpack_require__(/*! crypto */ \"crypto\");\nconst util_1 = __webpack_require__(/*! util */ \"util\");\nconst dsa_digest_js_1 = __webpack_require__(/*! ./dsa_digest.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/dsa_digest.js\");\nconst node_key_js_1 = __webpack_require__(/*! ./node_key.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/node_key.js\");\nconst sign_js_1 = __webpack_require__(/*! ./sign.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/sign.js\");\nconst get_sign_verify_key_js_1 = __webpack_require__(/*! ./get_sign_verify_key.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/get_sign_verify_key.js\");\nconst flags_js_1 = __webpack_require__(/*! ./flags.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/flags.js\");\nlet oneShotVerify;\nif (crypto.verify.length > 4 && flags_js_1.oneShotCallback) {\n    oneShotVerify = (0, util_1.promisify)(crypto.verify);\n}\nelse {\n    oneShotVerify = crypto.verify;\n}\nconst verify = async (alg, key, signature, data) => {\n    const keyObject = (0, get_sign_verify_key_js_1.default)(alg, key, 'verify');\n    if (alg.startsWith('HS')) {\n        const expected = await (0, sign_js_1.default)(alg, keyObject, data);\n        const actual = signature;\n        try {\n            return crypto.timingSafeEqual(actual, expected);\n        }\n        catch {\n            return false;\n        }\n    }\n    const algorithm = (0, dsa_digest_js_1.default)(alg);\n    const keyInput = (0, node_key_js_1.default)(alg, keyObject);\n    try {\n        return await oneShotVerify(algorithm, data, keyInput, signature);\n    }\n    catch {\n        return false;\n    }\n};\nexports[\"default\"] = verify;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/verify.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/webcrypto.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/webcrypto.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.isCryptoKey = void 0;\nconst crypto = __webpack_require__(/*! crypto */ \"crypto\");\nconst util = __webpack_require__(/*! util */ \"util\");\nconst webcrypto = crypto.webcrypto;\nexports[\"default\"] = webcrypto;\nexports.isCryptoKey = util.types.isCryptoKey\n    ? (key) => util.types.isCryptoKey(key)\n    :\n        (key) => false;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvd2ViY3J5cHRvLmpzIiwibWFwcGluZ3MiOiJBQUFhO0FBQ2IsOENBQTZDLEVBQUUsYUFBYSxFQUFDO0FBQzdELG1CQUFtQjtBQUNuQixlQUFlLG1CQUFPLENBQUMsc0JBQVE7QUFDL0IsYUFBYSxtQkFBTyxDQUFDLGtCQUFNO0FBQzNCO0FBQ0Esa0JBQWU7QUFDZixtQkFBbUI7QUFDbkI7QUFDQTtBQUNBIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L25vZGVfbW9kdWxlcy9qb3NlL2Rpc3Qvbm9kZS9janMvcnVudGltZS93ZWJjcnlwdG8uanM/MjcxOCJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbmV4cG9ydHMuaXNDcnlwdG9LZXkgPSB2b2lkIDA7XG5jb25zdCBjcnlwdG8gPSByZXF1aXJlKFwiY3J5cHRvXCIpO1xuY29uc3QgdXRpbCA9IHJlcXVpcmUoXCJ1dGlsXCIpO1xuY29uc3Qgd2ViY3J5cHRvID0gY3J5cHRvLndlYmNyeXB0bztcbmV4cG9ydHMuZGVmYXVsdCA9IHdlYmNyeXB0bztcbmV4cG9ydHMuaXNDcnlwdG9LZXkgPSB1dGlsLnR5cGVzLmlzQ3J5cHRvS2V5XG4gICAgPyAoa2V5KSA9PiB1dGlsLnR5cGVzLmlzQ3J5cHRvS2V5KGtleSlcbiAgICA6XG4gICAgICAgIChrZXkpID0+IGZhbHNlO1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/webcrypto.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/zlib.js":
/*!************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/zlib.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.deflate = exports.inflate = void 0;\nconst util_1 = __webpack_require__(/*! util */ \"util\");\nconst zlib_1 = __webpack_require__(/*! zlib */ \"zlib\");\nconst errors_js_1 = __webpack_require__(/*! ../util/errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nconst inflateRaw = (0, util_1.promisify)(zlib_1.inflateRaw);\nconst deflateRaw = (0, util_1.promisify)(zlib_1.deflateRaw);\nconst inflate = (input) => inflateRaw(input, { maxOutputLength: 250000 }).catch(() => {\n    throw new errors_js_1.JWEDecompressionFailed();\n});\nexports.inflate = inflate;\nconst deflate = (input) => deflateRaw(input);\nexports.deflate = deflate;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3J1bnRpbWUvemxpYi5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxlQUFlLEdBQUcsZUFBZTtBQUNqQyxlQUFlLG1CQUFPLENBQUMsa0JBQU07QUFDN0IsZUFBZSxtQkFBTyxDQUFDLGtCQUFNO0FBQzdCLG9CQUFvQixtQkFBTyxDQUFDLDRHQUFtQjtBQUMvQztBQUNBO0FBQ0EsK0NBQStDLHlCQUF5QjtBQUN4RTtBQUNBLENBQUM7QUFDRCxlQUFlO0FBQ2Y7QUFDQSxlQUFlIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbWFuYWdlbWVudC1jb21tYW5kLWNlbnRlci8uL25vZGVfbW9kdWxlcy9vcGVuaWQtY2xpZW50L25vZGVfbW9kdWxlcy9qb3NlL2Rpc3Qvbm9kZS9janMvcnVudGltZS96bGliLmpzPzQ0OTgiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG5leHBvcnRzLmRlZmxhdGUgPSBleHBvcnRzLmluZmxhdGUgPSB2b2lkIDA7XG5jb25zdCB1dGlsXzEgPSByZXF1aXJlKFwidXRpbFwiKTtcbmNvbnN0IHpsaWJfMSA9IHJlcXVpcmUoXCJ6bGliXCIpO1xuY29uc3QgZXJyb3JzX2pzXzEgPSByZXF1aXJlKFwiLi4vdXRpbC9lcnJvcnMuanNcIik7XG5jb25zdCBpbmZsYXRlUmF3ID0gKDAsIHV0aWxfMS5wcm9taXNpZnkpKHpsaWJfMS5pbmZsYXRlUmF3KTtcbmNvbnN0IGRlZmxhdGVSYXcgPSAoMCwgdXRpbF8xLnByb21pc2lmeSkoemxpYl8xLmRlZmxhdGVSYXcpO1xuY29uc3QgaW5mbGF0ZSA9IChpbnB1dCkgPT4gaW5mbGF0ZVJhdyhpbnB1dCwgeyBtYXhPdXRwdXRMZW5ndGg6IDI1MDAwMCB9KS5jYXRjaCgoKSA9PiB7XG4gICAgdGhyb3cgbmV3IGVycm9yc19qc18xLkpXRURlY29tcHJlc3Npb25GYWlsZWQoKTtcbn0pO1xuZXhwb3J0cy5pbmZsYXRlID0gaW5mbGF0ZTtcbmNvbnN0IGRlZmxhdGUgPSAoaW5wdXQpID0+IGRlZmxhdGVSYXcoaW5wdXQpO1xuZXhwb3J0cy5kZWZsYXRlID0gZGVmbGF0ZTtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/zlib.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/base64url.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/base64url.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.decode = exports.encode = void 0;\nconst base64url = __webpack_require__(/*! ../runtime/base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/base64url.js\");\nexports.encode = base64url.encode;\nexports.decode = base64url.decode;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3V0aWwvYmFzZTY0dXJsLmpzIiwibWFwcGluZ3MiOiJBQUFhO0FBQ2IsOENBQTZDLEVBQUUsYUFBYSxFQUFDO0FBQzdELGNBQWMsR0FBRyxjQUFjO0FBQy9CLGtCQUFrQixtQkFBTyxDQUFDLHdIQUF5QjtBQUNuRCxjQUFjO0FBQ2QsY0FBYyIsInNvdXJjZXMiOlsid2VicGFjazovL21hbmFnZW1lbnQtY29tbWFuZC1jZW50ZXIvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3V0aWwvYmFzZTY0dXJsLmpzPzk1ZjMiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG5leHBvcnRzLmRlY29kZSA9IGV4cG9ydHMuZW5jb2RlID0gdm9pZCAwO1xuY29uc3QgYmFzZTY0dXJsID0gcmVxdWlyZShcIi4uL3J1bnRpbWUvYmFzZTY0dXJsLmpzXCIpO1xuZXhwb3J0cy5lbmNvZGUgPSBiYXNlNjR1cmwuZW5jb2RlO1xuZXhwb3J0cy5kZWNvZGUgPSBiYXNlNjR1cmwuZGVjb2RlO1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/base64url.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/decode_jwt.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/decode_jwt.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.decodeJwt = void 0;\nconst base64url_js_1 = __webpack_require__(/*! ./base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/base64url.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst is_object_js_1 = __webpack_require__(/*! ../lib/is_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js\");\nconst errors_js_1 = __webpack_require__(/*! ./errors.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\");\nfunction decodeJwt(jwt) {\n    if (typeof jwt !== 'string')\n        throw new errors_js_1.JWTInvalid('JWTs must use Compact JWS serialization, JWT must be a string');\n    const { 1: payload, length } = jwt.split('.');\n    if (length === 5)\n        throw new errors_js_1.JWTInvalid('Only JWTs using Compact JWS serialization can be decoded');\n    if (length !== 3)\n        throw new errors_js_1.JWTInvalid('Invalid JWT');\n    if (!payload)\n        throw new errors_js_1.JWTInvalid('JWTs must contain a payload');\n    let decoded;\n    try {\n        decoded = (0, base64url_js_1.decode)(payload);\n    }\n    catch {\n        throw new errors_js_1.JWTInvalid('Failed to base64url decode the payload');\n    }\n    let result;\n    try {\n        result = JSON.parse(buffer_utils_js_1.decoder.decode(decoded));\n    }\n    catch {\n        throw new errors_js_1.JWTInvalid('Failed to parse the decoded payload as JSON');\n    }\n    if (!(0, is_object_js_1.default)(result))\n        throw new errors_js_1.JWTInvalid('Invalid JWT Claims Set');\n    return result;\n}\nexports.decodeJwt = decodeJwt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/decode_jwt.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/decode_protected_header.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/decode_protected_header.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.decodeProtectedHeader = void 0;\nconst base64url_js_1 = __webpack_require__(/*! ./base64url.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/base64url.js\");\nconst buffer_utils_js_1 = __webpack_require__(/*! ../lib/buffer_utils.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/buffer_utils.js\");\nconst is_object_js_1 = __webpack_require__(/*! ../lib/is_object.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/lib/is_object.js\");\nfunction decodeProtectedHeader(token) {\n    let protectedB64u;\n    if (typeof token === 'string') {\n        const parts = token.split('.');\n        if (parts.length === 3 || parts.length === 5) {\n            ;\n            [protectedB64u] = parts;\n        }\n    }\n    else if (typeof token === 'object' && token) {\n        if ('protected' in token) {\n            protectedB64u = token.protected;\n        }\n        else {\n            throw new TypeError('Token does not contain a Protected Header');\n        }\n    }\n    try {\n        if (typeof protectedB64u !== 'string' || !protectedB64u) {\n            throw new Error();\n        }\n        const result = JSON.parse(buffer_utils_js_1.decoder.decode((0, base64url_js_1.decode)(protectedB64u)));\n        if (!(0, is_object_js_1.default)(result)) {\n            throw new Error();\n        }\n        return result;\n    }\n    catch {\n        throw new TypeError('Invalid Token or Protected Header formatting');\n    }\n}\nexports.decodeProtectedHeader = decodeProtectedHeader;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/decode_protected_header.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.JWSSignatureVerificationFailed = exports.JWKSTimeout = exports.JWKSMultipleMatchingKeys = exports.JWKSNoMatchingKey = exports.JWKSInvalid = exports.JWKInvalid = exports.JWTInvalid = exports.JWSInvalid = exports.JWEInvalid = exports.JWEDecompressionFailed = exports.JWEDecryptionFailed = exports.JOSENotSupported = exports.JOSEAlgNotAllowed = exports.JWTExpired = exports.JWTClaimValidationFailed = exports.JOSEError = void 0;\nclass JOSEError extends Error {\n    static get code() {\n        return 'ERR_JOSE_GENERIC';\n    }\n    constructor(message) {\n        var _a;\n        super(message);\n        this.code = 'ERR_JOSE_GENERIC';\n        this.name = this.constructor.name;\n        (_a = Error.captureStackTrace) === null || _a === void 0 ? void 0 : _a.call(Error, this, this.constructor);\n    }\n}\nexports.JOSEError = JOSEError;\nclass JWTClaimValidationFailed extends JOSEError {\n    static get code() {\n        return 'ERR_JWT_CLAIM_VALIDATION_FAILED';\n    }\n    constructor(message, claim = 'unspecified', reason = 'unspecified') {\n        super(message);\n        this.code = 'ERR_JWT_CLAIM_VALIDATION_FAILED';\n        this.claim = claim;\n        this.reason = reason;\n    }\n}\nexports.JWTClaimValidationFailed = JWTClaimValidationFailed;\nclass JWTExpired extends JOSEError {\n    static get code() {\n        return 'ERR_JWT_EXPIRED';\n    }\n    constructor(message, claim = 'unspecified', reason = 'unspecified') {\n        super(message);\n        this.code = 'ERR_JWT_EXPIRED';\n        this.claim = claim;\n        this.reason = reason;\n    }\n}\nexports.JWTExpired = JWTExpired;\nclass JOSEAlgNotAllowed extends JOSEError {\n    constructor() {\n        super(...arguments);\n        this.code = 'ERR_JOSE_ALG_NOT_ALLOWED';\n    }\n    static get code() {\n        return 'ERR_JOSE_ALG_NOT_ALLOWED';\n    }\n}\nexports.JOSEAlgNotAllowed = JOSEAlgNotAllowed;\nclass JOSENotSupported extends JOSEError {\n    constructor() {\n        super(...arguments);\n        this.code = 'ERR_JOSE_NOT_SUPPORTED';\n    }\n    static get code() {\n        return 'ERR_JOSE_NOT_SUPPORTED';\n    }\n}\nexports.JOSENotSupported = JOSENotSupported;\nclass JWEDecryptionFailed extends JOSEError {\n    constructor() {\n        super(...arguments);\n        this.code = 'ERR_JWE_DECRYPTION_FAILED';\n        this.message = 'decryption operation failed';\n    }\n    static get code() {\n        return 'ERR_JWE_DECRYPTION_FAILED';\n    }\n}\nexports.JWEDecryptionFailed = JWEDecryptionFailed;\nclass JWEDecompressionFailed extends JOSEError {\n    constructor() {\n        super(...arguments);\n        this.code = 'ERR_JWE_DECOMPRESSION_FAILED';\n        this.message = 'decompression operation failed';\n    }\n    static get code() {\n        return 'ERR_JWE_DECOMPRESSION_FAILED';\n    }\n}\nexports.JWEDecompressionFailed = JWEDecompressionFailed;\nclass JWEInvalid extends JOSEError {\n    constructor() {\n        super(...arguments);\n        this.code = 'ERR_JWE_INVALID';\n    }\n    static get code() {\n        return 'ERR_JWE_INVALID';\n    }\n}\nexports.JWEInvalid = JWEInvalid;\nclass JWSInvalid extends JOSEError {\n    constructor() {\n        super(...arguments);\n        this.code = 'ERR_JWS_INVALID';\n    }\n    static get code() {\n        return 'ERR_JWS_INVALID';\n    }\n}\nexports.JWSInvalid = JWSInvalid;\nclass JWTInvalid extends JOSEError {\n    constructor() {\n        super(...arguments);\n        this.code = 'ERR_JWT_INVALID';\n    }\n    static get code() {\n        return 'ERR_JWT_INVALID';\n    }\n}\nexports.JWTInvalid = JWTInvalid;\nclass JWKInvalid extends JOSEError {\n    constructor() {\n        super(...arguments);\n        this.code = 'ERR_JWK_INVALID';\n    }\n    static get code() {\n        return 'ERR_JWK_INVALID';\n    }\n}\nexports.JWKInvalid = JWKInvalid;\nclass JWKSInvalid extends JOSEError {\n    constructor() {\n        super(...arguments);\n        this.code = 'ERR_JWKS_INVALID';\n    }\n    static get code() {\n        return 'ERR_JWKS_INVALID';\n    }\n}\nexports.JWKSInvalid = JWKSInvalid;\nclass JWKSNoMatchingKey extends JOSEError {\n    constructor() {\n        super(...arguments);\n        this.code = 'ERR_JWKS_NO_MATCHING_KEY';\n        this.message = 'no applicable key found in the JSON Web Key Set';\n    }\n    static get code() {\n        return 'ERR_JWKS_NO_MATCHING_KEY';\n    }\n}\nexports.JWKSNoMatchingKey = JWKSNoMatchingKey;\nclass JWKSMultipleMatchingKeys extends JOSEError {\n    constructor() {\n        super(...arguments);\n        this.code = 'ERR_JWKS_MULTIPLE_MATCHING_KEYS';\n        this.message = 'multiple matching keys found in the JSON Web Key Set';\n    }\n    static get code() {\n        return 'ERR_JWKS_MULTIPLE_MATCHING_KEYS';\n    }\n}\nexports.JWKSMultipleMatchingKeys = JWKSMultipleMatchingKeys;\nSymbol.asyncIterator;\nclass JWKSTimeout extends JOSEError {\n    constructor() {\n        super(...arguments);\n        this.code = 'ERR_JWKS_TIMEOUT';\n        this.message = 'request timed out';\n    }\n    static get code() {\n        return 'ERR_JWKS_TIMEOUT';\n    }\n}\nexports.JWKSTimeout = JWKSTimeout;\nclass JWSSignatureVerificationFailed extends JOSEError {\n    constructor() {\n        super(...arguments);\n        this.code = 'ERR_JWS_SIGNATURE_VERIFICATION_FAILED';\n        this.message = 'signature verification failed';\n    }\n    static get code() {\n        return 'ERR_JWS_SIGNATURE_VERIFICATION_FAILED';\n    }\n}\nexports.JWSSignatureVerificationFailed = JWSSignatureVerificationFailed;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/errors.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/runtime.js":
/*!************************************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/runtime.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst runtime_js_1 = __webpack_require__(/*! ../runtime/runtime.js */ \"(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/runtime/runtime.js\");\nexports[\"default\"] = runtime_js_1.default;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvb3BlbmlkLWNsaWVudC9ub2RlX21vZHVsZXMvam9zZS9kaXN0L25vZGUvY2pzL3V0aWwvcnVudGltZS5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxxQkFBcUIsbUJBQU8sQ0FBQyxvSEFBdUI7QUFDcEQsa0JBQWUiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tYW5hZ2VtZW50LWNvbW1hbmQtY2VudGVyLy4vbm9kZV9tb2R1bGVzL29wZW5pZC1jbGllbnQvbm9kZV9tb2R1bGVzL2pvc2UvZGlzdC9ub2RlL2Nqcy91dGlsL3J1bnRpbWUuanM/ZGZmYiJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbmNvbnN0IHJ1bnRpbWVfanNfMSA9IHJlcXVpcmUoXCIuLi9ydW50aW1lL3J1bnRpbWUuanNcIik7XG5leHBvcnRzLmRlZmF1bHQgPSBydW50aW1lX2pzXzEuZGVmYXVsdDtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/jose/dist/node/cjs/util/runtime.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/lru-cache/index.js":
/*!********************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/lru-cache/index.js ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
eval("\n\n// A linked list to keep track of recently-used-ness\nconst Yallist = __webpack_require__(/*! yallist */ \"(ssr)/./node_modules/openid-client/node_modules/yallist/yallist.js\")\n\nconst MAX = Symbol('max')\nconst LENGTH = Symbol('length')\nconst LENGTH_CALCULATOR = Symbol('lengthCalculator')\nconst ALLOW_STALE = Symbol('allowStale')\nconst MAX_AGE = Symbol('maxAge')\nconst DISPOSE = Symbol('dispose')\nconst NO_DISPOSE_ON_SET = Symbol('noDisposeOnSet')\nconst LRU_LIST = Symbol('lruList')\nconst CACHE = Symbol('cache')\nconst UPDATE_AGE_ON_GET = Symbol('updateAgeOnGet')\n\nconst naiveLength = () => 1\n\n// lruList is a yallist where the head is the youngest\n// item, and the tail is the oldest.  the list contains the Hit\n// objects as the entries.\n// Each Hit object has a reference to its Yallist.Node.  This\n// never changes.\n//\n// cache is a Map (or PseudoMap) that matches the keys to\n// the Yallist.Node object.\nclass LRUCache {\n  constructor (options) {\n    if (typeof options === 'number')\n      options = { max: options }\n\n    if (!options)\n      options = {}\n\n    if (options.max && (typeof options.max !== 'number' || options.max < 0))\n      throw new TypeError('max must be a non-negative number')\n    // Kind of weird to have a default max of Infinity, but oh well.\n    const max = this[MAX] = options.max || Infinity\n\n    const lc = options.length || naiveLength\n    this[LENGTH_CALCULATOR] = (typeof lc !== 'function') ? naiveLength : lc\n    this[ALLOW_STALE] = options.stale || false\n    if (options.maxAge && typeof options.maxAge !== 'number')\n      throw new TypeError('maxAge must be a number')\n    this[MAX_AGE] = options.maxAge || 0\n    this[DISPOSE] = options.dispose\n    this[NO_DISPOSE_ON_SET] = options.noDisposeOnSet || false\n    this[UPDATE_AGE_ON_GET] = options.updateAgeOnGet || false\n    this.reset()\n  }\n\n  // resize the cache when the max changes.\n  set max (mL) {\n    if (typeof mL !== 'number' || mL < 0)\n      throw new TypeError('max must be a non-negative number')\n\n    this[MAX] = mL || Infinity\n    trim(this)\n  }\n  get max () {\n    return this[MAX]\n  }\n\n  set allowStale (allowStale) {\n    this[ALLOW_STALE] = !!allowStale\n  }\n  get allowStale () {\n    return this[ALLOW_STALE]\n  }\n\n  set maxAge (mA) {\n    if (typeof mA !== 'number')\n      throw new TypeError('maxAge must be a non-negative number')\n\n    this[MAX_AGE] = mA\n    trim(this)\n  }\n  get maxAge () {\n    return this[MAX_AGE]\n  }\n\n  // resize the cache when the lengthCalculator changes.\n  set lengthCalculator (lC) {\n    if (typeof lC !== 'function')\n      lC = naiveLength\n\n    if (lC !== this[LENGTH_CALCULATOR]) {\n      this[LENGTH_CALCULATOR] = lC\n      this[LENGTH] = 0\n      this[LRU_LIST].forEach(hit => {\n        hit.length = this[LENGTH_CALCULATOR](hit.value, hit.key)\n        this[LENGTH] += hit.length\n      })\n    }\n    trim(this)\n  }\n  get lengthCalculator () { return this[LENGTH_CALCULATOR] }\n\n  get length () { return this[LENGTH] }\n  get itemCount () { return this[LRU_LIST].length }\n\n  rforEach (fn, thisp) {\n    thisp = thisp || this\n    for (let walker = this[LRU_LIST].tail; walker !== null;) {\n      const prev = walker.prev\n      forEachStep(this, fn, walker, thisp)\n      walker = prev\n    }\n  }\n\n  forEach (fn, thisp) {\n    thisp = thisp || this\n    for (let walker = this[LRU_LIST].head; walker !== null;) {\n      const next = walker.next\n      forEachStep(this, fn, walker, thisp)\n      walker = next\n    }\n  }\n\n  keys () {\n    return this[LRU_LIST].toArray().map(k => k.key)\n  }\n\n  values () {\n    return this[LRU_LIST].toArray().map(k => k.value)\n  }\n\n  reset () {\n    if (this[DISPOSE] &&\n        this[LRU_LIST] &&\n        this[LRU_LIST].length) {\n      this[LRU_LIST].forEach(hit => this[DISPOSE](hit.key, hit.value))\n    }\n\n    this[CACHE] = new Map() // hash of items by key\n    this[LRU_LIST] = new Yallist() // list of items in order of use recency\n    this[LENGTH] = 0 // length of items in the list\n  }\n\n  dump () {\n    return this[LRU_LIST].map(hit =>\n      isStale(this, hit) ? false : {\n        k: hit.key,\n        v: hit.value,\n        e: hit.now + (hit.maxAge || 0)\n      }).toArray().filter(h => h)\n  }\n\n  dumpLru () {\n    return this[LRU_LIST]\n  }\n\n  set (key, value, maxAge) {\n    maxAge = maxAge || this[MAX_AGE]\n\n    if (maxAge && typeof maxAge !== 'number')\n      throw new TypeError('maxAge must be a number')\n\n    const now = maxAge ? Date.now() : 0\n    const len = this[LENGTH_CALCULATOR](value, key)\n\n    if (this[CACHE].has(key)) {\n      if (len > this[MAX]) {\n        del(this, this[CACHE].get(key))\n        return false\n      }\n\n      const node = this[CACHE].get(key)\n      const item = node.value\n\n      // dispose of the old one before overwriting\n      // split out into 2 ifs for better coverage tracking\n      if (this[DISPOSE]) {\n        if (!this[NO_DISPOSE_ON_SET])\n          this[DISPOSE](key, item.value)\n      }\n\n      item.now = now\n      item.maxAge = maxAge\n      item.value = value\n      this[LENGTH] += len - item.length\n      item.length = len\n      this.get(key)\n      trim(this)\n      return true\n    }\n\n    const hit = new Entry(key, value, len, now, maxAge)\n\n    // oversized objects fall out of cache automatically.\n    if (hit.length > this[MAX]) {\n      if (this[DISPOSE])\n        this[DISPOSE](key, value)\n\n      return false\n    }\n\n    this[LENGTH] += hit.length\n    this[LRU_LIST].unshift(hit)\n    this[CACHE].set(key, this[LRU_LIST].head)\n    trim(this)\n    return true\n  }\n\n  has (key) {\n    if (!this[CACHE].has(key)) return false\n    const hit = this[CACHE].get(key).value\n    return !isStale(this, hit)\n  }\n\n  get (key) {\n    return get(this, key, true)\n  }\n\n  peek (key) {\n    return get(this, key, false)\n  }\n\n  pop () {\n    const node = this[LRU_LIST].tail\n    if (!node)\n      return null\n\n    del(this, node)\n    return node.value\n  }\n\n  del (key) {\n    del(this, this[CACHE].get(key))\n  }\n\n  load (arr) {\n    // reset the cache\n    this.reset()\n\n    const now = Date.now()\n    // A previous serialized cache has the most recent items first\n    for (let l = arr.length - 1; l >= 0; l--) {\n      const hit = arr[l]\n      const expiresAt = hit.e || 0\n      if (expiresAt === 0)\n        // the item was created without expiration in a non aged cache\n        this.set(hit.k, hit.v)\n      else {\n        const maxAge = expiresAt - now\n        // dont add already expired items\n        if (maxAge > 0) {\n          this.set(hit.k, hit.v, maxAge)\n        }\n      }\n    }\n  }\n\n  prune () {\n    this[CACHE].forEach((value, key) => get(this, key, false))\n  }\n}\n\nconst get = (self, key, doUse) => {\n  const node = self[CACHE].get(key)\n  if (node) {\n    const hit = node.value\n    if (isStale(self, hit)) {\n      del(self, node)\n      if (!self[ALLOW_STALE])\n        return undefined\n    } else {\n      if (doUse) {\n        if (self[UPDATE_AGE_ON_GET])\n          node.value.now = Date.now()\n        self[LRU_LIST].unshiftNode(node)\n      }\n    }\n    return hit.value\n  }\n}\n\nconst isStale = (self, hit) => {\n  if (!hit || (!hit.maxAge && !self[MAX_AGE]))\n    return false\n\n  const diff = Date.now() - hit.now\n  return hit.maxAge ? diff > hit.maxAge\n    : self[MAX_AGE] && (diff > self[MAX_AGE])\n}\n\nconst trim = self => {\n  if (self[LENGTH] > self[MAX]) {\n    for (let walker = self[LRU_LIST].tail;\n      self[LENGTH] > self[MAX] && walker !== null;) {\n      // We know that we're about to delete this one, and also\n      // what the next least recently used key will be, so just\n      // go ahead and set it now.\n      const prev = walker.prev\n      del(self, walker)\n      walker = prev\n    }\n  }\n}\n\nconst del = (self, node) => {\n  if (node) {\n    const hit = node.value\n    if (self[DISPOSE])\n      self[DISPOSE](hit.key, hit.value)\n\n    self[LENGTH] -= hit.length\n    self[CACHE].delete(hit.key)\n    self[LRU_LIST].removeNode(node)\n  }\n}\n\nclass Entry {\n  constructor (key, value, length, now, maxAge) {\n    this.key = key\n    this.value = value\n    this.length = length\n    this.now = now\n    this.maxAge = maxAge || 0\n  }\n}\n\nconst forEachStep = (self, fn, node, thisp) => {\n  let hit = node.value\n  if (isStale(self, hit)) {\n    del(self, node)\n    if (!self[ALLOW_STALE])\n      hit = undefined\n  }\n  if (hit)\n    fn.call(thisp, hit.value, hit.key, self)\n}\n\nmodule.exports = LRUCache\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/openid-client/node_modules/lru-cache/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/openid-client/node_modules/object-hash/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/openid-client/node_modules/object-hash/index.js ***!
  \**********************************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";
eval("\n\nvar crypto = __webpack_require__(/*! crypto */ \"crypto\");\n\n/**\n * Exported function\n *\n * Options:\n *\n *  - `algorithm` hash algo to be used by this instance: *'sha1', 'md5'\n *  - `excludeValues` {true|*false} hash object keys, values ignored\n *  - `encoding` hash encoding, supports 'buffer', '*hex', 'binary', 'base64'\n *  - `ignoreUnknown` {true|*false} ignore unknown object types\n *  - `replacer` optional function that replaces values before hashing\n *  - `respectFunctionProperties` {*true|false} consider function properties when hashing\n *  - `respectFunctionNames` {*true|false} consider 'name' property of functions for hashing\n *  - `respectType` {*true|false} Respect special properties (prototype, constructor)\n *    when hashing to distinguish between types\n *  - `unorderedArrays` {true|*false} Sort all arrays before hashing\n *  - `unorderedSets` {*true|false} Sort `Set` and `Map` instances before hashing\n *  * = default\n *\n * @param {object} object value to hash\n * @param {object} options hashing options\n * @return {string} hash value\n * @api public\n */\nexports = module.exports = objectHash;\n\nfunction objectHash(object, options){\n  options = applyDefaults(object, options);\n\n  return hash(object, options);\n}\n\n/**\n * Exported sugar methods\n *\n * @param {object} object value to hash\n * @return {string} hash value\n * @api public\n */\nexports.sha1 = function(object){\n  return objectHash(object);\n};\nexports.keys = function(object){\n  return objectHash(object, {excludeValues: true, algorithm: 'sha1', encoding: 'hex'});\n};\nexports.MD5 = function(object){\n  return objectHash(object, {algorithm: 'md5', encoding: 'hex'});\n};\nexports.keysMD5 = function(object){\n  return objectHash(object, {algorithm: 'md5', encoding: 'hex', excludeValues: true});\n};\n\n// Internals\nvar hashes = crypto.getHashes ? crypto.getHashes().slice() : ['sha1', 'md5'];\nhashes.push('passthrough');\nvar encodings = ['buffer', 'hex', 'binary', 'base64'];\n\nfunction applyDefaults(object, sourceOptions){\n  sourceOptions = sourceOptions || {};\n\n  // create a copy rather than mutating\n  var options = {};\n  options.algorithm = sourceOptions.algorithm || 'sha1';\n  options.encoding = sourceOptions.encoding || 'hex';\n  options.excludeValues = sourceOptions.excludeValues ? true : false;\n  options.algorithm = options.algorithm.toLowerCase();\n  options.encoding = options.encoding.toLowerCase();\n  options.ignoreUnknown = sourceOptions.ignoreUnknown !== true ? false : true; // default to false\n  options.respectType = sourceOptions.respectType === false ? false : true; // default to true\n  options.respectFunctionNames = sourceOptions.respectFunctionNames === false ? false : true;\n  options.respectFunctionProperties = sourceOptions.respectFunctionProperties === false ? false : true;\n  options.unorderedArrays = sourceOptions.unorderedArrays !== true ? false : true; // default to false\n  options.unorderedSets = sourceOptions.unorderedSets === false ? false : true; // default to false\n  options.unorderedObjects = sourceOptions.unorderedObjects === false ? false : true; // default to true\n  options.replacer = sourceOptions.replacer || undefined;\n  options.excludeKeys = sourceOptions.excludeKeys || undefined;\n\n  if(typeof object === 'undefined') {\n    throw new Error('Object argument required.');\n  }\n\n  // if there is a case-insensitive match in the hashes list, accept it\n  // (i.e. SHA256 for sha256)\n  for (var i = 0; i < hashes.length; ++i) {\n    if (hashes[i].toLowerCase() === options.algorithm.toLowerCase()) {\n      options.algorithm = hashes[i];\n    }\n  }\n\n  if(hashes.indexOf(options.algorithm) === -1){\n    throw new Error('Algorithm \"' + options.algorithm + '\"  not supported. ' +\n      'supported values: ' + hashes.join(', '));\n  }\n\n  if(encodings.indexOf(options.encoding) === -1 &&\n     options.algorithm !== 'passthrough'){\n    throw new Error('Encoding \"' + options.encoding + '\"  not supported. ' +\n      'supported values: ' + encodings.join(', '));\n  }\n\n  return options;\n}\n\n/** Check if the given function is a native function */\nfunction isNativeFunction(f) {\n  if ((typeof f) !== 'function') {\n    return false;\n  }\n  var exp = /^function\\s+\\w*\\s*\\(\\s*\\)\\s*{\\s+\\[native code\\]\\s+}$/i;\n  return exp.exec(Function.prototype.toString.call(f)) != null;\n}\n\nfunction hash(object, options) {\n  var hashingStream;\n\n  if (options.algorithm !== 'passthrough') {\n    hashingStream = crypto.createHash(options.algorithm);\n  } else {\n    hashingStream = new PassThrough();\n  }\n\n  if (typeof hashingStream.write === 'undefined') {\n    hashingStream.write = hashingStream.update;\n    hashingStream.end   = hashingStream.update;\n  }\n\n  var hasher = typeHasher(options, hashingStream);\n  hasher.dispatch(object);\n  if (!hashingStream.update) {\n    hashingStream.end('');\n  }\n\n  if (hashingStream.digest) {\n    return hashingStream.digest(options.encoding === 'buffer' ? undefined : options.encoding);\n  }\n\n  var buf = hashingStream.read();\n  if (options.encoding === 'buffer') {\n    return buf;\n  }\n\n  return buf.toString(options.encoding);\n}\n\n/**\n * Expose streaming API\n *\n * @param {object} object  Value to serialize\n * @param {object} options  Options, as for hash()\n * @param {object} stream  A stream to write the serializiation to\n * @api public\n */\nexports.writeToStream = function(object, options, stream) {\n  if (typeof stream === 'undefined') {\n    stream = options;\n    options = {};\n  }\n\n  options = applyDefaults(object, options);\n\n  return typeHasher(options, stream).dispatch(object);\n};\n\nfunction typeHasher(options, writeTo, context){\n  context = context || [];\n  var write = function(str) {\n    if (writeTo.update) {\n      return writeTo.update(str, 'utf8');\n    } else {\n      return writeTo.write(str, 'utf8');\n    }\n  };\n\n  return {\n    dispatch: function(value){\n      if (options.replacer) {\n        value = options.replacer(value);\n      }\n\n      var type = typeof value;\n      if (value === null) {\n        type = 'null';\n      }\n\n      //console.log(\"[DEBUG] Dispatch: \", value, \"->\", type, \" -> \", \"_\" + type);\n\n      return this['_' + type](value);\n    },\n    _object: function(object) {\n      var pattern = (/\\[object (.*)\\]/i);\n      var objString = Object.prototype.toString.call(object);\n      var objType = pattern.exec(objString);\n      if (!objType) { // object type did not match [object ...]\n        objType = 'unknown:[' + objString + ']';\n      } else {\n        objType = objType[1]; // take only the class name\n      }\n\n      objType = objType.toLowerCase();\n\n      var objectNumber = null;\n\n      if ((objectNumber = context.indexOf(object)) >= 0) {\n        return this.dispatch('[CIRCULAR:' + objectNumber + ']');\n      } else {\n        context.push(object);\n      }\n\n      if (typeof Buffer !== 'undefined' && Buffer.isBuffer && Buffer.isBuffer(object)) {\n        write('buffer:');\n        return write(object);\n      }\n\n      if(objType !== 'object' && objType !== 'function' && objType !== 'asyncfunction') {\n        if(this['_' + objType]) {\n          this['_' + objType](object);\n        } else if (options.ignoreUnknown) {\n          return write('[' + objType + ']');\n        } else {\n          throw new Error('Unknown object type \"' + objType + '\"');\n        }\n      }else{\n        var keys = Object.keys(object);\n        if (options.unorderedObjects) {\n          keys = keys.sort();\n        }\n        // Make sure to incorporate special properties, so\n        // Types with different prototypes will produce\n        // a different hash and objects derived from\n        // different functions (`new Foo`, `new Bar`) will\n        // produce different hashes.\n        // We never do this for native functions since some\n        // seem to break because of that.\n        if (options.respectType !== false && !isNativeFunction(object)) {\n          keys.splice(0, 0, 'prototype', '__proto__', 'constructor');\n        }\n\n        if (options.excludeKeys) {\n          keys = keys.filter(function(key) { return !options.excludeKeys(key); });\n        }\n\n        write('object:' + keys.length + ':');\n        var self = this;\n        return keys.forEach(function(key){\n          self.dispatch(key);\n          write(':');\n          if(!options.excludeValues) {\n            self.dispatch(object[key]);\n          }\n          write(',');\n        });\n      }\n    },\n    _array: function(arr, unordered){\n      unordered = typeof unordered !== 'undefined' ? unordered :\n        options.unorderedArrays !== false; // default to options.unorderedArrays\n\n      var self = this;\n      write('array:' + arr.length + ':');\n      if (!unordered || arr.length <= 1) {\n        return arr.forEach(function(entry) {\n          return self.dispatch(entry);\n        });\n      }\n\n      // the unordered case is a little more complicated:\n      // since there is no canonical ordering on objects,\n      // i.e. {a:1} < {a:2} and {a:1} > {a:2} are both false,\n      // we first serialize each entry using a PassThrough stream\n      // before sorting.\n      // also: we can’t use the same context array for all entries\n      // since the order of hashing should *not* matter. instead,\n      // we keep track of the additions to a copy of the context array\n      // and add all of them to the global context array when we’re done\n      var contextAdditions = [];\n      var entries = arr.map(function(entry) {\n        var strm = new PassThrough();\n        var localContext = context.slice(); // make copy\n        var hasher = typeHasher(options, strm, localContext);\n        hasher.dispatch(entry);\n        // take only what was added to localContext and append it to contextAdditions\n        contextAdditions = contextAdditions.concat(localContext.slice(context.length));\n        return strm.read().toString();\n      });\n      context = context.concat(contextAdditions);\n      entries.sort();\n      return this._array(entries, false);\n    },\n    _date: function(date){\n      return write('date:' + date.toJSON());\n    },\n    _symbol: function(sym){\n      return write('symbol:' + sym.toString());\n    },\n    _error: function(err){\n      return write('error:' + err.toString());\n    },\n    _boolean: function(bool){\n      return write('bool:' + bool.toString());\n    },\n    _string: function(string){\n      write('string:' + string.length + ':');\n      write(string.toString());\n    },\n    _function: function(fn){\n      write('fn:');\n      if (isNativeFunction(fn)) {\n        this.dispatch('[native]');\n      } else {\n        this.dispatch(fn.toString());\n      }\n\n      if (options.respectFunctionNames !== false) {\n        // Make sure we can still distinguish native functions\n        // by their name, otherwise String and Function will\n        // have the same hash\n        this.dispatch(\"function-name:\" + String(fn.name));\n      }\n\n      if (options.respectFunctionProperties) {\n        this._object(fn);\n      }\n    },\n    _number: function(number){\n      return write('number:' + number.toString());\n    },\n    _xml: function(xml){\n      return write('xml:' + xml.toString());\n    },\n    _null: function() {\n      return write('Null');\n    },\n    _undefined: function() {\n      return write('Undefined');\n    },\n    _regexp: function(regex){\n      return write('regex:' + regex.toString());\n    },\n    _uint8array: function(arr){\n      write('uint8array:');\n      return this.dispatch(Array.prototype.slice.call(arr));\n    },\n    _uint8clampedarray: function(arr){\n      write('uint8clampedarray:');\n      return this.dispatch(Array.prototype.slice.call(arr));\n    },\n    _int8array: function(arr){\n      write('uint8array:');\n      return this.dispatch(Array.prototype.slice.call(arr));\n    },\n    _uint16array: function(arr){\n      write('uint16array:');\n      return this.dispatch(Array.prototype.slice.call(arr));\n    },\n    _int16array: function(arr){\n      write('uint16array:');\n      return this.dispatch(Array.prototype.slice.call(arr));\n    },\n    _uint32array: function(arr){\n      write('uint32array:');\n      return this.dispatch(Array.prototype.slice.call(arr));\n    },\n    _int32array: f